/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowDocumentContext {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    public final String projectKey;
    public final SerializedProject serializedProject;
    private ProjectFlowGraph projectFlowGraph;
    private List<GraphNode> sortedGraphNodes;
    public final DSSAuthCtx user;
    public Locale reportLocale = Locale.getDefault();
    private final Map<String, SerializedDataset> serializedDatasetsCache = new HashMap<String, SerializedDataset>();
    private final Map<SerializedRecipe, String> recipePayloadsCache = new HashMap<SerializedRecipe, String>();

    public FlowDocumentContext(SerializedProject serializedProject, DSSAuthCtx user) {
        SpringUtils.getInstance().autowire((Object)this);
        this.serializedProject = serializedProject;
        this.projectKey = serializedProject.projectKey;
        this.user = user;
    }

    public ProjectFlowGraph getProjectFlowGraph() throws PlaceholderExpectedException {
        this.buildProjectFlowGraphIfNeeded();
        return this.projectFlowGraph;
    }

    public <T extends GraphNode> List<T> getSortedFlowNodes(Class<T> clazzFilter) throws PlaceholderExpectedException {
        this.buildSortedGraphNodesIfNeeded();
        return this.sortedGraphNodes.stream().filter(clazzFilter::isInstance).map(node -> node).collect(Collectors.toList());
    }

    private void buildProjectFlowGraphIfNeeded() throws PlaceholderExpectedException {
        if (this.projectFlowGraph == null) {
            try (Transaction t = this.transactionService.beginRead();){
                ProjectFlowGraph graph = new ProjectFlowGraph();
                graph.buildForProjectUnsafe(this.projectKey, true, true);
                this.projectFlowGraph = graph;
            }
            catch (IOException e) {
                throw PlaceholderExpectedException.createWithLog("Error while trying to read project configuration", e);
            }
        }
    }

    private void buildSortedGraphNodesIfNeeded() throws PlaceholderExpectedException {
        if (this.sortedGraphNodes != null) {
            return;
        }
        ArrayList<GraphNode> allNodes = new ArrayList<GraphNode>();
        allNodes.addAll(this.getProjectFlowGraph().listComputables());
        allNodes.addAll(this.getProjectFlowGraph().listRunnables());
        ArrayList<GraphNode> isolatedNodes = new ArrayList<GraphNode>();
        HashSet<GraphNode> unexploredNodes = new HashSet<GraphNode>();
        this.sortedGraphNodes = new ArrayList<GraphNode>();
        for (GraphNode node : allNodes) {
            if (FlowGraph.isSink(node) && FlowGraph.isSource(node)) {
                isolatedNodes.add(node);
                continue;
            }
            unexploredNodes.add(node);
        }
        LinkedList<GraphNode> exploreCandidates = new LinkedList<GraphNode>();
        Optional<GraphNode> nextSinkToExplore = this.findNextSinkToExplore(unexploredNodes, exploreCandidates);
        while (nextSinkToExplore.isPresent()) {
            this.readAllPredecessors(nextSinkToExplore.get(), unexploredNodes, this.sortedGraphNodes, exploreCandidates);
            nextSinkToExplore = this.findNextSinkToExplore(unexploredNodes, exploreCandidates);
        }
        this.sortedGraphNodes.addAll(isolatedNodes);
    }

    private void readAllPredecessors(GraphNode from, Set<GraphNode> availableNodes, List<GraphNode> output, LinkedList<GraphNode> exploreCandidates) {
        if (availableNodes.contains(from)) {
            availableNodes.remove(from);
            for (GraphNode graphNode : from.getPredecessors()) {
                this.readAllPredecessors(graphNode, availableNodes, output, exploreCandidates);
            }
            output.add(from);
        }
        exploreCandidates.addAll(from.getSuccessors().stream().filter(availableNodes::contains).collect(Collectors.toList()));
    }

    private Optional<GraphNode> findNextSinkToExplore(Set<GraphNode> unexploredNodes, LinkedList<GraphNode> exploreCandidates) {
        GraphNode exploreCandidate = null;
        while (!exploreCandidates.isEmpty() && !unexploredNodes.contains(exploreCandidate = exploreCandidates.removeLast())) {
        }
        if (exploreCandidate != null) {
            return Optional.of((GraphNode)this.findAnySink((GraphNode)exploreCandidate, new HashSet<GraphNode>(), unexploredNodes).first);
        }
        return unexploredNodes.stream().findFirst().map(node -> (GraphNode)this.findAnySink((GraphNode)node, new HashSet<GraphNode>(), (Set<GraphNode>)unexploredNodes).first);
    }

    private Pair<GraphNode, Boolean> findAnySink(GraphNode from, Set<GraphNode> seen, Set<GraphNode> unexploredNodes) {
        if (FlowGraph.isSink(from)) {
            return new Pair((Object)from, (Object)true);
        }
        seen.add(from);
        Pair<GraphNode, Boolean> found = null;
        for (GraphNode graphNode : from.getSuccessors()) {
            if (seen.contains(graphNode) || !unexploredNodes.contains(graphNode)) continue;
            found = this.findAnySink(graphNode, seen, unexploredNodes);
            if (!Boolean.TRUE.equals(found.second)) continue;
            return found;
        }
        if (found == null) {
            return new Pair((Object)from, (Object)false);
        }
        return found;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<SerializedDataset> getSerializedDatasets(Collection<FlowDataset> flowDatasets) throws PlaceholderExpectedException {
        List notInCacheYet = flowDatasets.stream().filter(flowDataset -> !this.serializedDatasetsCache.containsKey(flowDataset.getFullName())).collect(Collectors.toList());
        if (notInCacheYet.isEmpty()) return flowDatasets.stream().map(flowDataset -> this.serializedDatasetsCache.get(flowDataset.getFullName())).collect(Collectors.toList());
        try (Transaction t = this.transactionService.beginRead();){
            for (FlowDataset flowDataset2 : notInCacheYet) {
                try {
                    this.serializedDatasetsCache.put(flowDataset2.getFullName(), flowDataset2.getSerializedMandatoryUnsafe(this.datasetsDAO));
                }
                catch (IOException e) {
                    throw PlaceholderExpectedException.createWithLog("Error while trying to read the configuration for the dataset " + flowDataset2.getFullName(), e);
                    return flowDatasets.stream().map(flowDataset -> this.serializedDatasetsCache.get(flowDataset.getFullName())).collect(Collectors.toList());
                }
            }
        }
    }

    private String getPayload(SerializedRecipe recipe) throws PlaceholderExpectedException {
        String string;
        block9: {
            Transaction ignored = this.transactionService.beginRead();
            try {
                String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
                if (payload == null) {
                    throw new PlaceholderExpectedException("Recipe " + recipe.getDisplayName() + " has no payload");
                }
                string = payload;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw PlaceholderExpectedException.createWithLog("Error while reading payload of recipe " + recipe.getDisplayName(), e);
                }
            }
            ignored.close();
        }
        return string;
    }

    public String getCachedPayload(SerializedRecipe recipe) throws PlaceholderExpectedException {
        if (!this.recipePayloadsCache.containsKey(recipe)) {
            this.recipePayloadsCache.put(recipe, this.getPayload(recipe));
        }
        return this.recipePayloadsCache.get(recipe);
    }

    public <T> T getCachedPayloadAs(SerializedRecipe recipe, Class<T> recipeType, RecipeMeta meta) throws PlaceholderExpectedException {
        if (meta.getType().equals(recipe.type)) {
            return (T)JSON.parse((String)this.getCachedPayload(recipe), recipeType);
        }
        throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.getDisplayName() + " (" + recipe.type + "). Expected type:" + meta.getType());
    }
}

