/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.DataRelationshipFullDesc;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;

public abstract class DataRelationshipPlaceHolder
implements FlowPlaceholder.TextPlaceholder<DataRelationshipFullDesc> {
    @Override
    public Class<DataRelationshipFullDesc> getInputType() {
        return DataRelationshipFullDesc.class;
    }

    private static PlaceholderOutput.Text getTimeIndexOutput(AutoFeatureGenerationRecipePayloadParams.InputDesc virtualInput) throws PlaceholderExpectedException {
        String timeIndexString = virtualInput != null ? virtualInput.timeIndexColumn : "";
        return PlaceholderOutputFactory.makeTextOutputMaybeNull(timeIndexString);
    }

    private static PlaceholderOutput.Text participantIndexOutput(int virtualIndex) throws PlaceholderExpectedException {
        String placeholderString = virtualIndex == 0 ? "primary" : Integer.toString(virtualIndex);
        return new PlaceholderOutput.Text(placeholderString);
    }

    public static class RightParticipantIndex
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            return DataRelationshipPlaceHolder.participantIndexOutput(relationship.rightVirtualInputIndex());
        }
    }

    public static class LeftParticipantIndex
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            return DataRelationshipPlaceHolder.participantIndexOutput(relationship.leftVirtualInputIndex());
        }
    }

    public static class LeftTimeIndex
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            return DataRelationshipPlaceHolder.getTimeIndexOutput(relationship.leftVirtualInput);
        }
    }

    public static class RightTimeIndex
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            return DataRelationshipPlaceHolder.getTimeIndexOutput(relationship.rightVirtualInput);
        }
    }

    public static class Type
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            String typeString = "";
            if (relationship.relationshipDesc != null && relationship.relationshipDesc.type != null) {
                typeString = relationship.relationshipDesc.type.name().toLowerCase().replace('_', '-');
            }
            return new PlaceholderOutput.Text(typeString);
        }
    }

    public static class RightName
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeTextOutputMaybeNull(relationship.nameRight);
        }
    }

    public static class LeftName
    extends DataRelationshipPlaceHolder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, DataRelationshipFullDesc relationship) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeTextOutputMaybeNull(relationship.nameLeft);
        }
    }
}

