/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.taggable;

import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class TaggableProjectNamePlaceholder<T extends TaggableObjectsService.TaggableObject>
extends FlowPlaceholder.VariableInputTextPlaceholder<T> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;

    public TaggableProjectNamePlaceholder(Class<T> declaredClass) {
        super(declaredClass);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext context, T taggable) throws PlaceholderExpectedException {
        PlaceholderOutput.Text text;
        block9: {
            if (context.projectKey.equals(((TaggableObjectsService.TaggableObject)taggable).getProjectKey())) {
                return new PlaceholderOutput.Text(context.serializedProject.getDisplayName());
            }
            Transaction ignored = this.transactionService.beginRead();
            try {
                text = new PlaceholderOutput.Text(this.projectsService.getMandatoryUnsafe(((TaggableObjectsService.TaggableObject)taggable).getProjectKey()).getDisplayName());
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw PlaceholderExpectedException.createWithLog("Cannot retrieve project " + ((TaggableObjectsService.TaggableObject)taggable).getProjectKey(), e);
                }
            }
            ignored.close();
        }
        return text;
    }
}

