/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docportal;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.kernel.master.JobTaskQueue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectLibsChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PythonDocPortalService {
    public static final String PROJECT_SCOPE = "project";
    public static final String GLOBAL_SCOPE = "global";
    public static final String GLOBAL_SHARED_CODE = "GLOBAL";
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    private final JobTaskQueue<Void> taskQueue = new JobTaskQueue("dku.docportal.json-indexer.thread-", 1, 10000);
    private final Map<String, ProjectKeyWithName> projectsWithLibs = new ConcurrentHashMap<String, ProjectKeyWithName>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.docportal");

    @PostConstruct
    public void postConstruct() {
        if (!FeatureFlags.isEnabled((String)"docportal")) {
            return;
        }
        this.pubSub.subscribe("backend-started", backendStartedEvent -> {
            if (this.generalSettingsDAO.getUnsafeAutoTXN().autogeneratedDocumentationEnabled) {
                this.generateAllDocumentation();
            }
            this.pubSub.subscribe("general-settings-changed", this::onGlobalSettingsChangedEvent);
            this.pubSub.subscribe("object-change", this::onTaggableObjectChangedEvent);
            this.pubSub.subscribe("project-libs-changed", this::onProjectLibsChangedEvent);
            this.pubSub.subscribe("global-shared-libs-changed", this::onGlobalLibsChangedEvent);
        });
    }

    private void onGlobalSettingsChangedEvent(DSSEvent evt) {
        GeneralSettingsChangedEvent ev = (GeneralSettingsChangedEvent)evt;
        if (ev.newSettings.autogeneratedDocumentationEnabled && !ev.previousSettings.autogeneratedDocumentationEnabled) {
            this.generateAllDocumentation();
        } else if (ev.previousSettings.autogeneratedDocumentationEnabled && !ev.newSettings.autogeneratedDocumentationEnabled) {
            this.taskQueue.submit(() -> {
                logger.info((Object)"settings disabled, delete whole auto-generated documentation");
                this.deleteAllDoc();
                this.pubSub.publish((DSSEvent)new DocPortalDocumentationGeneratedEvent(true, new ArrayList<DocPortalPackagesToIndex>()));
                return null;
            });
        }
    }

    private void onTaggableObjectChangedEvent(DSSEvent evt) throws IOException {
        if (!this.generalSettingsDAO.getUnsafeAutoTXN().autogeneratedDocumentationEnabled) {
            return;
        }
        TaggableObjectChangedEvent ev = (TaggableObjectChangedEvent)evt;
        if (ev.isProjectDeletion && ev.objectType == ITaggingService.TaggableType.PROJECT) {
            String projectKey = ev.getProjectKey();
            this.taskQueue.submit(() -> {
                this.deleteDoc(projectKey, PROJECT_SCOPE);
                this.pubSub.publish((DSSEvent)new DocPortalDocumentationProjectDeletedEvent(projectKey));
                return null;
            });
            return;
        }
        SerializedProject sp = this.projectsService.getMandatoryUnsafe_AutoTXN(ev.projectKey);
        if (ev.libDocumentationChanged || PythonDocPortalService.isEventGitRelated(ev)) {
            String projectKey = ev.getProjectKey();
            if (sp.settings.autogeneratedDocumentationEnabled) {
                this.taskQueue.submit(() -> {
                    this.reindexProjectLibs(projectKey, sp.getDisplayName());
                    return null;
                });
            } else {
                this.taskQueue.submit(() -> {
                    this.deleteDoc(projectKey, PROJECT_SCOPE);
                    this.pubSub.publish((DSSEvent)new DocPortalDocumentationProjectDeletedEvent(projectKey));
                    return null;
                });
            }
        }
    }

    private void onProjectLibsChangedEvent(DSSEvent evt) throws IOException {
        if (!this.generalSettingsDAO.getUnsafeAutoTXN().autogeneratedDocumentationEnabled) {
            return;
        }
        ProjectLibsChangedEvent ev = (ProjectLibsChangedEvent)evt;
        String projectKey = ev.getProjectKey();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe_AutoTXN(projectKey);
        if (!sp.settings.autogeneratedDocumentationEnabled) {
            return;
        }
        this.taskQueue.submit(() -> {
            this.reindexProjectLibs(projectKey, sp.getDisplayName());
            return null;
        });
    }

    private void onGlobalLibsChangedEvent(DSSEvent evt) throws IOException {
        if (!this.generalSettingsDAO.getUnsafeAutoTXN().autogeneratedDocumentationEnabled) {
            return;
        }
        this.taskQueue.submit(() -> {
            this.deleteDoc(GLOBAL_SHARED_CODE, GLOBAL_SCOPE);
            DocPortalPackagesToIndex packageToIndex = this.prepareGlobalLibsDocumentation();
            if (packageToIndex != null && this.generateDocumentation(packageToIndex, null)) {
                DocPortalDocumentationGeneratedEvent event = new DocPortalDocumentationGeneratedEvent(false, Collections.singletonList(packageToIndex));
                this.pubSub.publish((DSSEvent)event);
            }
            return null;
        });
    }

    public static boolean isEventGitRelated(TaggableObjectChangedEvent evt) {
        return switch (evt.action) {
            case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_PULL, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_REVERT, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_RESET, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_MERGE -> true;
            default -> false;
        };
    }

    private void generateAllDocumentation() {
        this.taskQueue.submit(() -> {
            logger.info((Object)"generate + index whole documentation");
            this.deleteAllDoc();
            ArrayList<DocPortalPackagesToIndex> generatedDocs = new ArrayList<DocPortalPackagesToIndex>();
            List<DocPortalPackagesToIndex> packagesToIndex = this.listProjectPythonLibraries();
            for (DocPortalPackagesToIndex packageToIndex : packagesToIndex) {
                if (!this.generateDocumentation(packageToIndex, null)) continue;
                generatedDocs.add(packageToIndex);
            }
            DocPortalPackagesToIndex globalLibs = this.prepareGlobalLibsDocumentation();
            if (globalLibs != null && this.generateDocumentation(globalLibs, null)) {
                generatedDocs.add(globalLibs);
            }
            if (DKUApp.getParams().getBoolParam("dku.docportal.dataikupythonapi.enabled", true)) {
                DocPortalPackagesToIndex dataikuApiLib;
                List<String> exclusionList;
                DocPortalPackagesToIndex dataikuLib = this.prepareDataikuLibsDocumentation();
                if (this.generateDocumentation(dataikuLib, exclusionList = List.of("apinode", "base.dku_pickle", "bigframes", "cluster.server", "code_env_resources", "code_studio", "connector", "container", "continuous", "core.image_loader", "core.vector_stores.pinecone_v2_vector_store", "customformat", "customstep", "customtrigger", "customui", "dbconnect", "deployer", "doctor", "dsscli", "eda", "exporter", "external_ml", "fsprovider", "huggingface", "llm.agent_tools.server", "llm.agent_tools.mcp", "llm.agent_tools.vector_store_query_tool_server", "llm.evaluation", "llm.docextraction", "llm.finetuning", "llm.pii", "llm.python.tools_using", "llm.rag", "metric", "modelevaluation", "notebook", "project_standards", "recipe", "runnables", "scenario", "snowpark", "spark", "sql", "udf", "vendor", "webapps"))) {
                    generatedDocs.add(dataikuLib);
                }
                if (this.generateDocumentation(dataikuApiLib = this.prepareDataikuApiLibsDocumentation(), null)) {
                    generatedDocs.add(dataikuApiLib);
                }
            }
            logger.info((Object)"done generating json for whole documentation");
            this.pubSub.publish((DSSEvent)new DocPortalDocumentationGeneratedEvent(true, generatedDocs));
            return null;
        });
    }

    private void reindexProjectLibs(String projectKey, String projectName) throws IOException {
        this.deleteDoc(projectKey, PROJECT_SCOPE);
        DocPortalPackagesToIndex packageToIndex = this.prepareProjectLibsDocumentation(projectKey, projectName);
        if (packageToIndex != null && this.generateDocumentation(packageToIndex, null)) {
            DocPortalDocumentationGeneratedEvent event = new DocPortalDocumentationGeneratedEvent(false, Collections.singletonList(packageToIndex));
            this.pubSub.publish((DSSEvent)event);
        }
    }

    private List<DocPortalPackagesToIndex> listProjectPythonLibraries() {
        ArrayList<DocPortalPackagesToIndex> packagesToIndex = new ArrayList<DocPortalPackagesToIndex>();
        HashMap<String, String> projectKeyToName = new HashMap<String, String>();
        try {
            String projectKey;
            HashMap<String, ProjectLibPathHelper.ProjectLibsPaths> allProjectLibs = new HashMap<String, ProjectLibPathHelper.ProjectLibsPaths>();
            try (Transaction t = this.transactionService.beginRead();){
                for (SerializedProject project : this.projectsService.listAllUnsafe()) {
                    try {
                        if (!project.settings.autogeneratedDocumentationEnabled) continue;
                        projectKey = project.projectKey;
                        ProjectLibPathHelper.ProjectLibsPaths paths = ProjectLibPathHelper.prepareLocalProjectPathsWithoutCopy(projectKey);
                        allProjectLibs.put(projectKey, paths);
                        projectKeyToName.put(projectKey, project.getDisplayName());
                    }
                    catch (DKUSecurityException | IOException e) {
                        logger.error((Object)("Error fetching library paths for " + project.projectKey), e);
                    }
                }
            }
            for (Map.Entry entry : allProjectLibs.entrySet()) {
                ProjectLibPathHelper.ProjectLibsPaths paths = (ProjectLibPathHelper.ProjectLibsPaths)entry.getValue();
                if (!this.hasPythonLib(paths.pythonPath)) continue;
                projectKey = (String)entry.getKey();
                packagesToIndex.add(this.prepareProjectLibsDocumentation(projectKey, (String)projectKeyToName.get(projectKey)));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error generating documentation", (Throwable)e);
        }
        return packagesToIndex.stream().filter(Objects::nonNull).toList();
    }

    private void deleteAllDoc() {
        try {
            this.projectsWithLibs.clear();
            DKUFileUtils.deleteDirectory((File)DKUApp.getFile((String)"docportal"));
        }
        catch (Exception e) {
            logger.warn((Object)"Error when deleting docportal directory", (Throwable)e);
        }
    }

    private void deleteDoc(String projectKey, String scope) throws IOException {
        if (PROJECT_SCOPE.equalsIgnoreCase(scope)) {
            this.projectsWithLibs.remove(projectKey);
        }
        DKUFileUtils.deleteDirectory((File)this.getOutputPath(projectKey, scope));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocPortalPackagesToIndex prepareProjectLibsDocumentation(String projectKey, String projectName) {
        try {
            File fromPath;
            ProjectLibPathHelper.ProjectLibsPaths paths;
            try (Transaction t = this.transactionService.beginRead();){
                paths = ProjectLibPathHelper.prepareLocalProjectPathsWithoutCopy(projectKey);
                if (!this.hasPythonLib(paths.pythonPath)) {
                    DocPortalPackagesToIndex docPortalPackagesToIndex = null;
                    return docPortalPackagesToIndex;
                }
                RelFile libFolder = ProjectLibPathHelper.getProjectLibRootPath(projectKey);
                fromPath = t.resolve(libFolder);
            }
            this.projectsWithLibs.put(projectKey, new ProjectKeyWithName(projectKey, projectName));
            return new DocPortalPackagesToIndex(projectKey, paths.pythonPath, PackageScope.PROJECT, fromPath.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error((Object)("Error listing project lib paths for " + projectKey), (Throwable)e);
            return null;
        }
    }

    private DocPortalPackagesToIndex prepareGlobalLibsDocumentation() {
        File globalLibPath = ProjectLibPathHelper.getGlobalLibPath();
        List<String> paths = Collections.singletonList(globalLibPath.getAbsolutePath());
        if (this.hasPythonLib(paths)) {
            return new DocPortalPackagesToIndex(GLOBAL_SHARED_CODE, paths, PackageScope.GLOBAL, globalLibPath.getAbsolutePath());
        }
        return null;
    }

    private DocPortalPackagesToIndex prepareDataikuLibsDocumentation() {
        File dataikuLibPath = ProjectLibPathHelper.getDataikuLibPath();
        return new DocPortalPackagesToIndex("dataiku", Collections.singletonList(dataikuLibPath.getAbsolutePath()), PackageScope.GLOBAL, dataikuLibPath.getAbsolutePath());
    }

    private DocPortalPackagesToIndex prepareDataikuApiLibsDocumentation() {
        File dataikuLibPath = ProjectLibPathHelper.getDataikuApiLibPath();
        return new DocPortalPackagesToIndex("dataikuapi", Collections.singletonList(dataikuLibPath.getAbsolutePath()), PackageScope.GLOBAL, dataikuLibPath.getAbsolutePath());
    }

    private boolean hasPythonLib(List<String> paths) {
        for (String path : paths) {
            try {
                File f = new File(path);
                if (DKUFileUtils.recursiveListFiles((File)f, pathname -> pathname.isFile() && pathname.getName().toLowerCase().endsWith(".py")).isEmpty()) continue;
                return true;
            }
            catch (IOException e) {
                logger.warn((Object)("Error listing python files. Ignoring " + path), (Throwable)e);
            }
        }
        return false;
    }

    private boolean generateDocumentation(DocPortalPackagesToIndex packagesToIndex, List<String> exclusionList) {
        String what = packagesToIndex.projectKey;
        try {
            logger.info((Object)("Starting documentation generation for " + what));
            File output = this.getOutputPath(packagesToIndex.projectKey, packagesToIndex.packageScope.toString());
            int maxPythonFileSizeParsed = DKUApp.getParams().getIntParam("dku.docportal.pythonFile.maxSizeKB", Integer.valueOf(10000));
            DKUFileUtils.mkdirsParent((File)output);
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(System.getenv("DKUPYTHONBIN"));
            cmd.add(System.getenv("DKUINSTALLDIR") + "/resources/docportal/generate_python_doc.py");
            cmd.add(output.getAbsolutePath());
            cmd.add("--input-paths");
            cmd.addAll(packagesToIndex.libPaths);
            cmd.add("--max-file-size");
            cmd.add(String.valueOf(maxPythonFileSizeParsed));
            if (StringUtils.isNotBlank((CharSequence)packagesToIndex.rootPath)) {
                cmd.add("--from-dir");
                cmd.add(packagesToIndex.rootPath);
            }
            if (exclusionList != null && !exclusionList.isEmpty()) {
                cmd.add("--exclude");
                cmd.addAll(exclusionList);
            }
            ProcessBuilder pb = new ProcessBuilder(cmd);
            DKUtils.execAndLogThrows((ProcessBuilder)pb, (String)"dku.docportal.json-indexer.python-process");
            logger.info((Object)("Done documentation generation for " + what));
            return true;
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)("Error generating documentation for " + what), (Throwable)e);
            return false;
        }
    }

    private Package getPackage(File file) throws IOException {
        int maxJsonFileSizeInKB = DKUApp.getParams().getIntParam("dku.docportal.generatedFile.maxSizeKB", Integer.valueOf(10000));
        long fileSizeInKB = file.length() / 1000L;
        if (fileSizeInKB < (long)maxJsonFileSizeInKB) {
            return (Package)JSON.parseFile((File)file, Package.class);
        }
        String filePathRelativeToHome = file.getAbsolutePath().substring(DKUApp.getBaseFolder().length() + 1);
        String warningMessage = "File " + filePathRelativeToHome + " size of " + fileSizeInKB + "KB. Max authorized is: " + maxJsonFileSizeInKB + "KB";
        String name = FilenameUtils.removeExtension((String)file.getName());
        logger.warn((Object)("Docportal JSON file size exceeded: " + warningMessage));
        DocumentationError documentationError = new DocumentationError();
        documentationError.message = warningMessage;
        documentationError.title = "Package documentation size exceeded";
        Package pack = new Package();
        pack.name = name;
        pack.documentationError = documentationError;
        pack.modules = List.of();
        return pack;
    }

    public Package getProjectPythonDoc(String projectKey, String packageName, String scope) throws IOException {
        String fileName = StringUtils.isEmpty((CharSequence)packageName) ? projectKey + ".json" : "packages/" + packageName + ".json";
        File file = DKUApp.getFile((File)this.getOutputPath(projectKey, scope), (String[])new String[]{fileName});
        if (!file.exists()) {
            return null;
        }
        return this.getPackage(file);
    }

    public List<ProjectKeyWithName> listProjectsWithLibs(AuthCtx u) throws DKUSecurityException {
        ArrayList<ProjectKeyWithName> projects = new ArrayList<ProjectKeyWithName>();
        try (Transaction tr = this.transactionService.retrieveOrBeginRead();){
            for (ProjectKeyWithName projectKeyWithName : this.projectsWithLibs.values()) {
                if (!this.permissionsService.hasProjectPrivilege(u, projectKeyWithName.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                projects.add(projectKeyWithName);
            }
        }
        return projects;
    }

    public List<ProjectKeyWithName> listProjectsUsableByProject(AuthCtx u, String projectKey) throws DKUSecurityException, IOException {
        DSSGitModel.ExternalLibraries el;
        try (Transaction tr = this.transactionService.retrieveOrBeginRead();){
            el = (DSSGitModel.ExternalLibraries)tr.readObjectDefault(new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"}), DSSGitModel.ExternalLibraries.class);
        }
        List<String> foreignProjectKeys = el.getNonNullLibrariesFromProjects();
        return ((Stream)this.listProjectsWithLibs(u).stream().parallel()).filter(project -> foreignProjectKeys.contains(project.projectKey)).map(p -> new ProjectKeyWithName(p.projectKey, p.name)).toList();
    }

    public List<String> listPackages(String projectKey, String scope) {
        File outputPath = this.getOutputPath(projectKey, scope);
        List<String> packages = new ArrayList<String>();
        File file = DKUApp.getFile((File)outputPath, (String[])new String[]{"packages"});
        if (file.exists()) {
            packages = Arrays.stream(Objects.requireNonNull(file.listFiles())).map(File::getName).map(FilenameUtils::getBaseName).toList();
        }
        return packages;
    }

    public File getOutputPath(String projectKey, String scope) {
        if (GLOBAL_SCOPE.equalsIgnoreCase(scope)) {
            return DKUApp.getFile((String[])new String[]{"docportal", GLOBAL_SCOPE, projectKey});
        }
        return DKUApp.getFile((String[])new String[]{"docportal", "projects", projectKey});
    }

    public record DocPortalPackagesToIndex(String projectKey, List<String> libPaths, PackageScope packageScope, String rootPath) {
    }

    public static class DocPortalDocumentationGeneratedEvent
    extends BackendEvent {
        public static final String NAME = "docportal-documentation-generated";
        public final List<DocPortalPackagesToIndex> packagesToIndex;
        public boolean clearAllPreviousDocuments;

        public DocPortalDocumentationGeneratedEvent(boolean clearAllPreviousDocuments, List<DocPortalPackagesToIndex> packagesToIndex) {
            this.clearAllPreviousDocuments = clearAllPreviousDocuments;
            this.packagesToIndex = packagesToIndex;
        }

        public String getName() {
            return NAME;
        }
    }

    @UIModel
    public static class ProjectKeyWithName {
        public String projectKey;
        public String name;

        public ProjectKeyWithName() {
        }

        public ProjectKeyWithName(String projectKey, String name) {
            this.projectKey = projectKey;
            this.name = name;
        }
    }

    public static enum PackageScope {
        PROJECT(false),
        GLOBAL(false);

        public final boolean asPackage;

        private PackageScope(boolean asPackage) {
            this.asPackage = asPackage;
        }
    }

    @UIModel
    public static class Package {
        public String name;
        public String importPath;
        public List<Module> modules;
        public DocumentationError documentationError;
    }

    public static class DocumentationError {
        public String message;
        public String title;
    }

    public static class DocPortalDocumentationProjectDeletedEvent
    extends BackendEvent {
        public static final String NAME = "docportal-documentation-project-deleted";
        public final String projectKey;

        public DocPortalDocumentationProjectDeletedEvent(String projectKey) {
            this.projectKey = projectKey;
        }

        public String getName() {
            return NAME;
        }
    }

    public static class Param {
        public String name;
        public String type;
    }

    public static class Function {
        public String name;
        public String docstring;
        public List<Param> params;
    }

    public static class Class {
        public String name;
        public String docstring;
        public List<String> bases;
        public List<Param> params;
        public List<Class> classes;
        public List<Function> functions;
    }

    public static class Module {
        public String name;
        public String docstring;
        public String importPath;
        public List<Class> classes;
        public List<Function> functions;
        public DocumentationError documentationError;
        public String filePath;
    }
}

