/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.documenttemplating;

import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.documenttemplating.DocumentTemplatingInput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingOutput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingServerAPI;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;

public class DocumentTemplatingServer
extends LLMRelatedPoolablePythonServer
implements DocumentTemplatingServerAPI {
    protected final DSSAuthCtx authCtx;
    protected final String projectKey;
    protected final String envName;
    public String containerConfName;
    private static final Logger logger = Logger.getLogger((String)"dku.documenttemplating");

    public DocumentTemplatingServer(AuthCtx authCtx, String projectKey, CodeEnvSelection codeEnvSelection, String containerConfName) {
        super("dku.documenttemplating", "doctpl-" + projectKey + "-" + SecretKeyGenerator.generateSmall());
        this.authCtx = (DSSAuthCtx)authCtx;
        this.projectKey = projectKey;
        this.containerConfName = containerConfName;
        try {
            this.envName = new CodeEnvSelector().selectForPythonRecipe(projectKey, codeEnvSelection);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<DocumentTemplatingOutput> renderAsync(DocumentTemplatingInput config) {
        RenderCommand req = new RenderCommand();
        req.config = config;
        return this.kernel.getLink().getAsyncLink().asyncStreamRequest((Object)req, DocumentTemplatingOutput.class).last().doOnNext(output -> logger.info((Object)"Document rendering completed")).toFuture();
    }

    public void init(boolean devKernel, boolean devMode, File logBaseDir) throws Exception {
        this.kernel = SimplePythonKernelFactory.prepareKernel(this.authCtx, this.projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, this.envName, "dataiku.documenttemplating.document_templating_server", false, this.containerConfName, this.kernelId);
        StartCommand command = new StartCommand();
        this.setLogsWithRotation(logBaseDir, devKernel, devMode);
        this.kernel.start();
        logger.info((Object)"Sending start command to document templating server");
        this.kernel.getLink().getAsyncLink().request((Object)command, JsonElement.class);
    }

    @Override
    public SmartLogTail getKernelLog() {
        return this.kernel.getSmartLogTailBuilder().get();
    }

    public static class RenderCommand {
        public final String type = "render";
        public DocumentTemplatingInput config;
    }

    public static class StartCommand {
        public final String type = "start";
    }
}

