/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.documenttemplating;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.docextraction.PDFConverterService;
import com.dataiku.dip.docextraction.PdfConverter;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.documenttemplating.DocumentTemplatingInput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingOutput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingServerAPI;
import com.dataiku.dip.documenttemplating.DocumentTemplatingServerPool;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentTemplatingService {
    @Autowired
    private DocumentTemplatingServerPool serverPool;
    @Autowired
    private PDFConverterService pdfConversionService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.documenttemplating");

    public DocumentTemplatingOutput render(AuthCtx authCtx, String projectKey, DocumentTemplatingInput input) throws Exception {
        logger.infoV("Processing document templating request, templateType=%s, outputFormat=%s", new Object[]{input.templateType, input.outputFormat});
        if (input.templateType == DocumentTemplatingInput.TemplateType.CEL_EXPANSION || input.templateType == DocumentTemplatingInput.TemplateType.JINJA) {
            if (input.outputFormat == DocumentTemplatingInput.OutputFormat.PDF) {
                throw new NotImplementedException();
            }
            if (input.outputFormat == DocumentTemplatingInput.OutputFormat.DOCX) {
                throw new NotImplementedException();
            }
        }
        if (input.templateType == DocumentTemplatingInput.TemplateType.DOCX_JINJA && input.outputFormat == DocumentTemplatingInput.OutputFormat.TEXT) {
            throw new NotImplementedException();
        }
        if (input.templateType == DocumentTemplatingInput.TemplateType.DOCX_JINJA && input.outputFormat == DocumentTemplatingInput.OutputFormat.PDF) {
            return this.renderDocxToPdf(authCtx, projectKey, input);
        }
        return this.renderUsingServer(authCtx, projectKey, input);
    }

    private DocumentTemplatingOutput renderUsingServer(AuthCtx authCtx, String projectKey, DocumentTemplatingInput input) throws Exception {
        String envName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.DOCUMENT_TEMPLATING_CODE_ENV);
        String containerConfName = new ContainerExecConfigSelector().selectName_autoTXN(projectKey, null, WorkloadType.USER_CODE);
        try (DocumentTemplatingServerAPI serverAPI = this.serverPool.getServerAPI((DSSAuthCtx)authCtx, projectKey, envName, containerConfName);){
            logger.info((Object)"Rendering document template");
            DocumentTemplatingOutput output = (DocumentTemplatingOutput)DKUCompletableFuture.collectResponse(serverAPI.renderAsync(input));
            logger.info((Object)"Document template rendered successfully");
            DocumentTemplatingOutput documentTemplatingOutput = output;
            return documentTemplatingOutput;
        }
    }

    private DocumentTemplatingOutput renderDocxToPdf(AuthCtx authCtx, String projectKey, DocumentTemplatingInput input) throws Exception {
        logger.info((Object)"Rendering DOCX_JINJA to PDF by first rendering to DOCX then converting to PDF");
        DocumentTemplatingInput inputWithDocxOutput = (DocumentTemplatingInput)JSON.deepCopy((Object)input);
        inputWithDocxOutput.outputFormat = DocumentTemplatingInput.OutputFormat.DOCX;
        inputWithDocxOutput.destinationRef = new InputRefs.InlineDocumentRef();
        DocumentTemplatingOutput docxOutput = this.renderUsingServer(authCtx, projectKey, inputWithDocxOutput);
        if (docxOutput == null || docxOutput.documentRef == null) {
            throw new Exception("Document templating output is empty for DOCX_JINJA render");
        }
        assert (docxOutput.documentRef instanceof InputRefs.InlineDocumentRef);
        byte[] docxBytes = Base64.getDecoder().decode(((InputRefs.InlineDocumentRef)docxOutput.documentRef).content);
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"document-templating", (String)"render", (boolean)true);){
            File docxFile = new File((File)tmpDir, "rendered.docx");
            Files.write(docxFile.toPath(), docxBytes, new OpenOption[0]);
            PdfConverter.LibreOfficeExecutionResults executionResults = this.pdfConversionService.convertFileToPDFWithLibreOffice(docxFile.getAbsolutePath(), tmpDir.getAbsolutePath(), docxFile.getName(), authCtx, projectKey);
            if (!executionResults.ok) {
                Throwable error = executionResults.error != null ? executionResults.error : new Exception("LibreOffice conversion failed");
                throw new Exception("Failed to convert DOCX to PDF", error);
            }
            Path outputPDFLocalPath = executionResults.outputFile.toPath();
            DocumentTemplatingOutput output = new DocumentTemplatingOutput();
            InputRefs.DocumentRef documentRef = input.destinationRef;
            if (documentRef instanceof InputRefs.ManagedFolderDocumentRef) {
                ManagedFolder mf;
                InputRefs.ManagedFolderDocumentRef mfDestinationRef = (InputRefs.ManagedFolderDocumentRef)documentRef;
                try (Transaction t = this.transactionService.beginRead();){
                    AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, mfDestinationRef.managedFolderId);
                    mf = this.managedFoldersService.getMandatoryUnsafe(managedFolderLoc);
                }
                try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
                    handler.getProvider();
                    try (InputStream in = Files.newInputStream(outputPDFLocalPath, new OpenOption[0]);
                         OutputStream out = handler.getOutputStream(mfDestinationRef.filePath);){
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                }
                output.documentRef = input.destinationRef;
            } else if (input.destinationRef instanceof InputRefs.InlineDocumentRef) {
                try (InputStream in = Files.newInputStream(outputPDFLocalPath, new OpenOption[0]);
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    try (OutputStream base64Out = Base64.getEncoder().wrap(baos);){
                        ByteStreams.copy((InputStream)in, (OutputStream)base64Out);
                    }
                    String encodedPdf = baos.toString(StandardCharsets.UTF_8);
                    output.documentRef = new InputRefs.InlineDocumentRef(encodedPdf, InputRefs.InlineDocumentRef.ContentType.BASE64_BYTES);
                }
            }
            if (output.documentRef != null) {
                output.documentRef.mimeType = "application/pdf";
            }
            DocumentTemplatingOutput documentTemplatingOutput = output;
            return documentTemplatingOutput;
        }
    }
}

