/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.caching;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.transformers.Flattener;
import com.dataiku.dip.eda.compute.computations.transformers.TransformedComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.NoStreamingComputationResultSession;
import com.dataiku.dip.eda.compute.engine.WrappedComputationResultSession;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CachedRunner
implements ComputationRunner {
    private final ComputationRunner baseRunner;
    private final Cache<Computation, ComputationResult> cache;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.cache");

    public CachedRunner(Cache<Computation, ComputationResult> cache, ComputationRunner baseRunner) {
        this.baseRunner = baseRunner;
        this.cache = cache;
    }

    private TransformedComputation wrapIntoMultiComputation(TransformedComputation input) {
        Computation original = input.computation;
        if (original.isMulti()) {
            return input;
        }
        return new TransformedComputation(new MultiComputation(original)){

            @Override
            public ComputationResult reconstruct(ComputationResult result) {
                if (result.isAvailable()) {
                    return result.asMulti().get(0);
                }
                return result;
            }
        }.compose(input);
    }

    @Override
    public ComputationResultSession computeAndOpenSession(Computation computation) throws Exception {
        TransformedComputation flattenedRepresentation = this.wrapIntoMultiComputation(new Flattener().transform(computation));
        List<Computation> flattenedComputations = flattenedRepresentation.computation.asMulti().computations;
        ArrayList<ComputationResult> flattenedResults = new ArrayList<ComputationResult>();
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Looking for results in memory cache", (double)flattenedComputations.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ArrayList<Computation> toCompute = new ArrayList<Computation>();
            int nbComputationsServedFromCache = 0;
            int nbComputationsTotal = flattenedComputations.size();
            Stopwatch stopwatch = Stopwatch.createStarted();
            for (Computation params : flattenedRepresentation.computation.asMulti().computations) {
                ComputationResult cachedResult = (ComputationResult)((Object)this.cache.getIfPresent((Object)params));
                flattenedResults.add(cachedResult);
                if (cachedResult == null) {
                    toCompute.add(params);
                } else {
                    ++nbComputationsServedFromCache;
                }
                FutureProgress.incrementState((double)1.0);
            }
            FutureProgress.popState();
            logger.info((Object)("Serving " + nbComputationsServedFromCache + "/" + nbComputationsTotal + " computation(s) from cache (cache lookup took " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            ComputationResultSession session = null;
            if (!toCompute.isEmpty()) {
                session = this.baseRunner.computeAndOpenSession(new MultiComputation(toCompute));
                ComputationResult remainingResults = session.getComputationResult();
                if (remainingResults.isAvailable()) {
                    int remainingIdx = 0;
                    for (int flattenedIdx = 0; flattenedIdx < flattenedResults.size(); ++flattenedIdx) {
                        boolean putInCache;
                        ComputationResult currentResult = (ComputationResult)((Object)flattenedResults.get(flattenedIdx));
                        if (currentResult != null) continue;
                        ComputationResult remainingResult = remainingResults.asMulti().get(remainingIdx);
                        Computation remainingParam = (Computation)((Object)toCompute.get(remainingIdx));
                        flattenedResults.set(flattenedIdx, remainingResult);
                        boolean bl = putInCache = !remainingResult.isAtLeastPartiallyNotComputed() && !remainingResult.includesDataStreams();
                        if (putInCache) {
                            this.cache.put((Object)remainingParam, (Object)remainingResult);
                        }
                        ++remainingIdx;
                    }
                } else {
                    for (int flattenedIdx = 0; flattenedIdx < flattenedResults.size(); ++flattenedIdx) {
                        if (flattenedResults.get(flattenedIdx) != null) continue;
                        flattenedResults.set(flattenedIdx, remainingResults);
                    }
                }
            }
            ComputationResult reconstructedResults = flattenedRepresentation.reconstruct(new MultiComputation.MultiComputationResult(flattenedResults));
            if (session == null) {
                NoStreamingComputationResultSession noStreamingComputationResultSession = new NoStreamingComputationResultSession(reconstructedResults);
                return noStreamingComputationResultSession;
            }
            WrappedComputationResultSession wrappedComputationResultSession = new WrappedComputationResultSession(session, reconstructedResults);
            return wrappedComputationResultSession;
        }
    }

    @Override
    public boolean isAlive() {
        return this.baseRunner.isAlive();
    }

    @Override
    public void close() throws Exception {
        this.baseRunner.close();
    }

    public String toString() {
        return super.toString() + " using runner " + this.baseRunner.toString() + " and cache " + this.cache.toString();
    }
}

