/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.engine;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.engine.SmoothlyClosableRunner;

public class SmoothlyClosableComputationRunner
extends SmoothlyClosableRunner<ComputationRunner>
implements ComputationRunner {
    public SmoothlyClosableComputationRunner(ComputationRunner runner) {
        super(runner);
    }

    @Override
    public boolean isAlive() {
        return this.runner != null && ((ComputationRunner)this.runner).isAlive();
    }

    @Override
    public ComputationResultSession computeAndOpenSession(Computation computation) throws Exception {
        ComputationResultSession session;
        this.incRefCount();
        try {
            session = ((ComputationRunner)this.runner).computeAndOpenSession(computation);
        }
        catch (Exception e) {
            this.decRefCount();
            throw e;
        }
        return new RefCountAwareComputationResultSession(session);
    }

    private class RefCountAwareComputationResultSession
    implements ComputationResultSession {
        ComputationResultSession delegate;

        RefCountAwareComputationResultSession(ComputationResultSession delegate) {
            this.delegate = delegate;
        }

        @Override
        public ComputationResult getComputationResult() {
            return this.delegate.getComputationResult();
        }

        @Override
        public ComputationResultDataStreamer getDataStreamer() {
            return this.delegate.getDataStreamer();
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
            SmoothlyClosableComputationRunner.this.decRefCount();
        }
    }
}

