/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.sampling;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.eda.compute.caching.ComputeResultCachingService;
import com.dataiku.dip.eda.compute.caching.KernelCachingService;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SampleManager;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import com.dataiku.dss.shadelib.com.google.gson.JsonSyntaxException;
import com.dataiku.dss.shadelib.com.google.gson.reflect.TypeToken;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SampleMappingService {
    @Autowired
    SampleManager sampleManager;
    @Autowired
    ComputeResultCachingService resultCachingService;
    @Autowired
    KernelCachingService kernelCachingService;
    private static final TypeToken<Map<TaggableObjectsService.TaggableObjectRef, MappingValue>> mappingTypeToken = new TypeToken<Map<TaggableObjectsService.TaggableObjectRef, MappingValue>>(){};
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.samples");

    private synchronized void removeSample(Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping, TaggableObjectsService.TaggableObjectRef mp, MappingValue mpv) throws IOException {
        String sampleId;
        String string = sampleId = null != mpv ? mpv.sampleId : null;
        if (null == sampleId) {
            logger.warnV("Sample associated to %s not found in usage map", new Object[]{mp.toString()});
            return;
        }
        this.resultCachingService.removeForSampleId(sampleId);
        this.kernelCachingService.invalidate(sampleId);
        mapping.remove(mp);
        logger.infoV("Sample associated to %s removed from usage map", new Object[]{mp.toString()});
        Sample sample = this.sampleManager.findSample(sampleId);
        if (null == sample) {
            logger.warnV("Sample id %s not found in disk cache", new Object[]{sampleId});
            return;
        }
        this.sampleManager.deleteSample(sample);
        logger.infoV("Sample %s associated to %s removed from disk cache", new Object[]{sampleId, mp.toString()});
    }

    public synchronized void removeDatasetSamples(AnyLoc datasetLoc) throws IOException {
        ArrayList<Map.Entry<TaggableObjectsService.TaggableObjectRef, MappingValue>> toRemove = new ArrayList<Map.Entry<TaggableObjectsService.TaggableObjectRef, MappingValue>>();
        Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping = this.readSampleMapping();
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, MappingValue> entry : mapping.entrySet()) {
            AnyLoc curSampleDatasetLoc = Sample.getDatasetLocFromSampleId(entry.getValue().sampleId);
            if (!curSampleDatasetLoc.equals(datasetLoc)) continue;
            toRemove.add(entry);
        }
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, MappingValue> cur : toRemove) {
            this.removeSample(mapping, cur.getKey(), cur.getValue());
        }
        this.saveSampleMapping(mapping);
    }

    public synchronized void setAssociatedSample(TaggableObjectsService.TaggableObjectRef mp, Sample sample) throws IOException {
        logger.infoV("Associating sample %s to %s", new Object[]{sample.id, mp.toString()});
        Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping = this.readSampleMapping();
        MappingValue mpv = mapping.get(mp);
        if (null != mpv) {
            logger.infoV("Sample %s if already associated to %s. Removing it.", new Object[]{mpv.sampleId, mp.toString()});
            this.removeSample(mapping, mp, mpv);
        }
        mapping.put(mp, new MappingValue(sample.getId()));
        logger.infoV("Associating sample %s with mapping key %s", new Object[]{sample.id, mp.toString()});
        this.saveSampleMapping(mapping);
    }

    public synchronized void removeSample(TaggableObjectsService.TaggableObjectRef key) throws IOException {
        Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping = this.readSampleMapping();
        MappingValue mpv = mapping.get(key);
        if (null != mpv) {
            logger.infoV("Removing sample associated to %s.", new Object[]{key.toString()});
            this.removeSample(mapping, key, mpv);
        } else {
            logger.infoV("No sample associated to %s. So, not removing it.", new Object[]{key.toString()});
        }
    }

    public synchronized Sample getAssociatedSample(TaggableObjectsService.TaggableObjectRef mp) throws IOException {
        Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping = this.readSampleMapping();
        MappingValue mpv = mapping.get(mp);
        String sampleId = null != mpv ? mpv.sampleId : null;
        logger.infoV("Sample found with key %s : %s", new Object[]{mp.toString(), sampleId});
        if (null != mpv) {
            mpv.lastAccess = new Date().getTime();
            mapping.put(mp, mpv);
            this.saveSampleMapping(mapping);
        }
        return this.sampleManager.findSample(sampleId);
    }

    private Map<TaggableObjectsService.TaggableObjectRef, MappingValue> readSampleMapping() throws IOException {
        File mappingFile = this.getMappingFile();
        logger.traceV("Reading sample mapping file %s", new Object[]{mappingFile.getAbsolutePath()});
        Map mapping = null;
        if (mappingFile.isFile()) {
            try {
                mapping = (Map)this.getGson().fromJson(FileUtils.readFileToString((File)this.getMappingFile(), (String)"utf8"), mappingTypeToken.getType());
            }
            catch (JsonSyntaxException e) {
                logger.errorV((Throwable)e, "Error reading EDA sample mapping file %s. Ignoring it. It will be overwritten.", new Object[]{mappingFile.getAbsolutePath()});
            }
        }
        if (mapping == null) {
            mapping = Maps.newHashMap();
        }
        return mapping;
    }

    private void saveSampleMapping(Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping) throws IOException {
        File mappingFile = this.getMappingFile();
        logger.traceV("Saving sample mapping file %s", new Object[]{mappingFile.getAbsolutePath()});
        DKUFileUtils.writeFileUTF8((File)mappingFile, (String)this.getGson().toJson(mapping));
    }

    private File getMappingFile() {
        return ApplicationConfigurator.getFile((String[])new String[]{"caches", "eda", "worksheet-samples.json"});
    }

    private Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
    }

    public synchronized void purgeSamples(long maxLastAccessDays) throws IOException {
        logger.infoV("Purging EDA samples not accessed for %d days from cache", new Object[]{maxLastAccessDays});
        Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping = this.readSampleMapping();
        long now = new Date().getTime();
        boolean modified = false;
        for (Map.Entry entry : Lists.newArrayList(mapping.entrySet())) {
            String sampleId = ((MappingValue)entry.getValue()).sampleId;
            logger.infoV("Checking sample %s associated to %s with last access time %s", new Object[]{sampleId, entry.getKey(), ((MappingValue)entry.getValue()).lastAccess});
            long days = (now - ((MappingValue)entry.getValue()).lastAccess) / 86400000L;
            if (days < maxLastAccessDays) continue;
            logger.infoV("Purging sample %s, not accessed for too long.", new Object[]{sampleId});
            this.removeSample(mapping, (TaggableObjectsService.TaggableObjectRef)entry.getKey(), (MappingValue)entry.getValue());
            modified = true;
        }
        if (modified) {
            this.saveSampleMapping(mapping);
        } else {
            logger.info((Object)"No sample purged.");
        }
    }

    public synchronized void setLastAccessesToEpoch() throws IOException {
        logger.infoV("Using debug method to set lastAccess date of all samples to 0", new Object[0]);
        Map<TaggableObjectsService.TaggableObjectRef, MappingValue> mapping = this.readSampleMapping();
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, MappingValue> entry : mapping.entrySet()) {
            entry.getValue().lastAccess = 0L;
        }
        this.saveSampleMapping(mapping);
    }

    public static class MappingValue {
        String sampleId;
        Long lastAccess;

        public MappingValue(String sampleId) {
            this.sampleId = sampleId;
            this.lastAccess = new Date().getTime();
        }
    }
}

