/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets;

import com.dataiku.dip.eda.compute.ComputeService;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.worksheets.queries.InteractiveQuery;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.google.common.base.Stopwatch;
import com.google.gson.reflect.TypeToken;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InteractiveQueryService {
    @Autowired
    ComputeService computeService;
    @Autowired
    FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.query.compute");

    public FutureResponse<InteractiveQuery.InteractiveQueryResult> runInteractiveQueryInFuture(final AuthCtx authCtx, final Sample sample, final InteractiveQuery queryParams) throws Exception {
        return this.futureService.runFuture(new SimpleFutureThread<InteractiveQuery.InteractiveQueryResult>(authCtx){

            public FuturePayload getPayload() {
                FuturePayload fp = FuturePayload.newSimple((String)"statistics_interactive_query", (String)("Interactive statistics query (" + JSON.getType((Object)((Object)queryParams))));
                AnyLoc datasetLoc = sample.getDatasetLoc();
                fp.targets.add(new FuturePayload.FuturePayloadTarget(datasetLoc.getProjectKey(), datasetLoc.getId(), datasetLoc.getId(), ITaggingService.TaggableType.DATASET.name()));
                return fp;
            }

            @Override
            protected InteractiveQuery.InteractiveQueryResult compute() throws Exception {
                return InteractiveQueryService.this.runInteractiveQuery_NT(authCtx, sample, queryParams);
            }
        }, 0L, new TypeToken<FutureResponse<InteractiveQuery.InteractiveQueryResult>>(){});
    }

    public InteractiveQuery.InteractiveQueryResult runInteractiveQuery_NT(AuthCtx authCtx, Sample sample, InteractiveQuery queryParams) throws Exception {
        InteractiveQuery.InteractiveQueryResult result;
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)"Started running interactive query...");
        NullChecker.checkObject((Object)((Object)queryParams));
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (ComputationRunner runner = this.computeService.getCachedSampleRunner(authCtx, sample);){
            result = queryParams.run(sample.schema, runner);
        }
        NullChecker.checkObject((Object)result);
        logger.info((Object)("Query executed in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return result;
    }
}

