/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.univariate_header;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.CountDistinct;
import com.dataiku.dip.eda.compute.computations.univariate.Kurtosis;
import com.dataiku.dip.eda.compute.computations.univariate.Max;
import com.dataiku.dip.eda.compute.computations.univariate.Mean;
import com.dataiku.dip.eda.compute.computations.univariate.Min;
import com.dataiku.dip.eda.compute.computations.univariate.Quantiles;
import com.dataiku.dip.eda.compute.computations.univariate.Sem;
import com.dataiku.dip.eda.compute.computations.univariate.Skewness;
import com.dataiku.dip.eda.compute.computations.univariate.StdDev;
import com.dataiku.dip.eda.compute.computations.univariate.Sum;
import com.dataiku.dip.eda.compute.computations.univariate.Variance;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.IntervalFilter;
import com.dataiku.dip.eda.compute.filtering.MissingValueFilter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.common.SummaryStats;
import com.dataiku.dip.eda.worksheets.cards.fragments.CountCompleteFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class UnivariateSummaryStatsBuilder {
    Variable column;
    double confidenceLevel;
    boolean showConfidenceInterval;
    StatsToCompute compute;

    public UnivariateSummaryStatsBuilder(Variable column, double confidenceLevel, boolean showConfidenceInterval, StatsToCompute compute) {
        this.column = column;
        this.confidenceLevel = confidenceLevel;
        this.showConfidenceInterval = showConfidenceInterval;
        this.compute = compute;
    }

    private SummaryStats.ComputableStat makeTotalCount(String flagName) {
        return new SummaryStats.ComputableStat<Count, Count.CountResult>(flagName, "N values"){

            @Override
            public Count getComputationPlan() {
                return new Count();
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Count.CountResult result) {
                return this.intResult(result.count);
            }

            @Override
            public String getStatType() {
                return "COUNT_ALL";
            }
        };
    }

    private SummaryStats.ComputableStat makeMean(String flagName) {
        return new SummaryStats.ComputableStat<Mean, Mean.MeanResult>(flagName, "Mean"){

            @Override
            public Mean getComputationPlan() {
                return new Mean(UnivariateSummaryStatsBuilder.this.column.name, UnivariateSummaryStatsBuilder.this.showConfidenceInterval ? Double.valueOf(UnivariateSummaryStatsBuilder.this.confidenceLevel) : null);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Mean.MeanResult result) {
                return this.floatResultWithInterval(result.value, result.lower, result.upper);
            }

            @Override
            public boolean supportsConfidenceInterval() {
                return true;
            }
        };
    }

    private SummaryStats.ComputableStat makeMode(String flagName) {
        return new SummaryStats.ComputableStat<GroupedComputation, GroupedComputation.GroupedComputationResult>(flagName, "Mode"){

            @Override
            public GroupedComputation getComputationPlan() {
                return new GroupedComputation(new Count(), new AnumGrouping(UnivariateSummaryStatsBuilder.this.column.name, 2, false));
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                List<Filter> values = result.groups.asAnum().listFilters();
                if (values.size() == 0) {
                    return this.resultWithFilters(new Filter[0]);
                }
                Filter firstValue = values.get(0);
                if (values.size() == 1) {
                    return this.resultWithFilters(new Filter[]{firstValue});
                }
                long count1 = result.results.get((int)0).as(Count.CountResult.class).count;
                long count2 = result.results.get((int)1).as(Count.CountResult.class).count;
                if (count1 == count2) {
                    SummaryStats.ComputedStat stat = this.resultWithFilters(new Filter[]{firstValue});
                    stat.warning = "There is more than one mode";
                    return stat;
                }
                return this.resultWithFilters(new Filter[]{firstValue});
            }
        };
    }

    private SummaryStats.ComputableStat makeIQR(String flagName) {
        return new SummaryStats.ComputableStat<Quantiles, Quantiles.QuantilesResult>(flagName, "IQR"){

            @Override
            public Quantiles getComputationPlan() {
                return new Quantiles(UnivariateSummaryStatsBuilder.this.column.name, (List<Double>)ImmutableList.of((Object)0.25, (Object)0.75));
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Quantiles.QuantilesResult result) {
                return this.floatResult(result.getMand((double)0.75).quantile - result.getMand((double)0.25).quantile);
            }
        };
    }

    private SummaryStats.ComputableStat makeMedian(String flagName) {
        return new SummaryStats.ComputableStat<Quantiles, Quantiles.QuantilesResult>(flagName, "Median"){

            @Override
            public Quantiles getComputationPlan() {
                if (UnivariateSummaryStatsBuilder.this.showConfidenceInterval) {
                    return new Quantiles(UnivariateSummaryStatsBuilder.this.column.name, (List<Double>)ImmutableList.of((Object)0.5), UnivariateSummaryStatsBuilder.this.confidenceLevel);
                }
                return new Quantiles(UnivariateSummaryStatsBuilder.this.column.name, (List<Double>)ImmutableList.of((Object)0.5), null);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Quantiles.QuantilesResult result) {
                Quantiles.QuantileDesc median = result.getMand(0.5);
                return this.floatResultWithInterval(median.quantile, median.lower, median.upper);
            }

            @Override
            public boolean supportsConfidenceInterval() {
                return true;
            }
        };
    }

    private SummaryStats.ComputableStat makeVariance(String flagName) {
        return new SummaryStats.ComputableStat<Variance, Variance.VarianceResult>(flagName, "Variance", "Variance (unbiased)"){

            @Override
            public Variance getComputationPlan() {
                return new Variance(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Variance.VarianceResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeSkewness(String flagName) {
        return new SummaryStats.ComputableStat<Skewness, Skewness.SkewnessResult>(flagName, "Skewness"){

            @Override
            public Skewness getComputationPlan() {
                return new Skewness(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Skewness.SkewnessResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeZero(String flagName, final boolean ratio, final boolean nonZero) {
        String label = (ratio ? "Proportion" : "N") + " " + (nonZero ? "Non" : "") + " Zero";
        return new SummaryStats.ComputableStat<GroupedComputation, GroupedComputation.GroupedComputationResult>(flagName, label){

            @Override
            public GroupedComputation getComputationPlan() {
                return new GroupedComputation(new Count(), new UnionGrouping(new SubsetGrouping(new NotFilter(new MissingValueFilter(UnivariateSummaryStatsBuilder.this.column.name))), new SubsetGrouping(new IntervalFilter(UnivariateSummaryStatsBuilder.this.column.name, 0.0, 0.0, IntervalFilter.ClosedMode.BOTH))));
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                long totalCount = result.results.get((int)0).as(Count.CountResult.class).count;
                long count = result.results.get((int)1).as(Count.CountResult.class).count;
                if (nonZero) {
                    count = totalCount - count;
                }
                if (ratio) {
                    return this.floatResult(count > 0L ? (double)count / (double)totalCount : 0.0);
                }
                return this.intResult(count);
            }

            @Override
            public String getStatType() {
                return (ratio ? "FREQUENCY" : "COUNT") + "_" + (nonZero ? "NON_" : "") + " ZERO";
            }
        };
    }

    private SummaryStats.ComputableStat makeSem(String flagName) {
        return new SummaryStats.ComputableStat<Sem, Sem.SemResult>(flagName, "Sem", "Standard Error of the Mean"){

            @Override
            public Sem getComputationPlan() {
                return new Sem(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Sem.SemResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeKurtosis(String flagName) {
        return new SummaryStats.ComputableStat<Kurtosis, Kurtosis.KurtosisResult>(flagName, "Kurtosis"){

            @Override
            public Kurtosis getComputationPlan() {
                return new Kurtosis(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Kurtosis.KurtosisResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeStd(String flagName) {
        return new SummaryStats.ComputableStat<StdDev, StdDev.StdDevResult>(flagName, "Std Dev", "Standard deviation"){

            @Override
            public StdDev getComputationPlan() {
                return new StdDev(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(StdDev.StdDevResult result) {
                return this.floatResult(result.value);
            }

            @Override
            public String getStatType() {
                return "STD_DEV";
            }
        };
    }

    private SummaryStats.ComputableStat makeSum(String flagName) {
        return new SummaryStats.ComputableStat<Sum, Sum.SumResult>(flagName, "Sum"){

            @Override
            public Sum getComputationPlan() {
                return new Sum(UnivariateSummaryStatsBuilder.this.column.name, UnivariateSummaryStatsBuilder.this.showConfidenceInterval ? Double.valueOf(UnivariateSummaryStatsBuilder.this.confidenceLevel) : null);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Sum.SumResult result) {
                return this.floatResultWithInterval(result.value, result.lower, result.upper);
            }

            @Override
            public boolean supportsConfidenceInterval() {
                return true;
            }
        };
    }

    private SummaryStats.ComputableStat makeCountDistinct(String flagName) {
        return new SummaryStats.ComputableStat<CountDistinct, CountDistinct.CountDistinctResult>(flagName, "N distinct"){

            @Override
            public CountDistinct getComputationPlan() {
                return new CountDistinct(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(CountDistinct.CountDistinctResult result) {
                return this.intResult(result.count);
            }

            @Override
            public String getStatType() {
                return "COUNT_DISTINCT";
            }
        };
    }

    private SummaryStats.ComputableStat makeMax(String flagName) {
        return new SummaryStats.ComputableStat<Max, Max.MaxResult>(flagName, "Max"){

            @Override
            public Max getComputationPlan() {
                return new Max(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Max.MaxResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeMin(String flagName) {
        return new SummaryStats.ComputableStat<Min, Min.MinResult>(flagName, "Min"){

            @Override
            public Min getComputationPlan() {
                return new Min(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(Min.MinResult result) {
                return this.floatResult(result.value);
            }
        };
    }

    private SummaryStats.ComputableStat makeRange(String flagName) {
        return new SummaryStats.ComputableStat<MultiComputation, MultiComputation.MultiComputationResult>(flagName, "Range"){

            @Override
            public MultiComputation getComputationPlan() {
                return new MultiComputation(new Min(UnivariateSummaryStatsBuilder.this.column.name), new Max(UnivariateSummaryStatsBuilder.this.column.name));
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                double minVal = result.get((int)0).as(Min.MinResult.class).value;
                double maxVal = result.get((int)1).as(Max.MaxResult.class).value;
                return this.floatResult(maxVal - minVal);
            }
        };
    }

    private SummaryStats.ComputableStat makeCountEmpty(String flagName, final boolean nonEmpty) {
        String label = nonEmpty ? "N non empty" : "N empty";
        return new SummaryStats.ComputableStat<GroupedComputation, GroupedComputation.GroupedComputationResult>(flagName, label){

            @Override
            public GroupedComputation getComputationPlan() {
                return new GroupedComputation(new Count(), new UnionGrouping(SubsetGrouping.all(), new SubsetGrouping(AnumFilter.single(UnivariateSummaryStatsBuilder.this.column.name, ""))));
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                long countAll = result.results.get((int)0).as(Count.CountResult.class).count;
                long count = result.results.get((int)1).as(Count.CountResult.class).count;
                if (nonEmpty) {
                    count = countAll - count;
                }
                return this.intResult(count);
            }

            @Override
            public String getStatType() {
                return nonEmpty ? "COUNT_NON_EMPTY" : "COUNT_EMPTY";
            }
        };
    }

    private SummaryStats.ComputableStat makeCountComplete(String flagName) {
        return new SummaryStats.ComputableStat<Computation, AvailableResult>(flagName, "N finite", "Count of records where " + this.column.name + " is not missing"){

            @Override
            public Computation getComputationPlan() {
                return CountCompleteFragment.getComputationPlan(UnivariateSummaryStatsBuilder.this.column.name);
            }

            @Override
            public SummaryStats.ComputedStat buildFromFullyAvailableResult(AvailableResult result) {
                long count = CountCompleteFragment.buildResult(result);
                return this.intResult(count);
            }

            @Override
            public String getStatType() {
                return "COUNT_FINITE";
            }
        };
    }

    public SummaryStats buildSummaryStats() {
        SummaryStats summaryStats = new SummaryStats();
        if (this.compute.totalCount) {
            summaryStats.addStat(this.makeTotalCount("totalCount"));
        }
        if (this.compute.distinctCount) {
            summaryStats.addStat(this.makeCountDistinct("distinctCount"));
        }
        if (this.column.isContinuous()) {
            if (this.compute.completeCount) {
                summaryStats.addStat(this.makeCountComplete("completeCount"));
            }
            if (this.compute.zeroCount) {
                summaryStats.addStat(this.makeZero("zeroCount", false, false));
            }
            if (this.compute.zeroRatio) {
                summaryStats.addStat(this.makeZero("zeroRatio", true, false));
            }
            if (this.compute.nonZeroRatio) {
                summaryStats.addStat(this.makeZero("nonZeroRatio", true, true));
            }
            if (this.compute.mean) {
                summaryStats.addStat(this.makeMean("mean"));
            }
            if (this.compute.sum) {
                summaryStats.addStat(this.makeSum("sum"));
            }
            if (this.compute.median) {
                summaryStats.addStat(this.makeMedian("median"));
            }
            if (this.compute.std) {
                summaryStats.addStat(this.makeStd("std"));
            }
            if (this.compute.iqr) {
                summaryStats.addStat(this.makeIQR("iqr"));
            }
            if (this.compute.variance) {
                summaryStats.addStat(this.makeVariance("variance"));
            }
            if (this.compute.skewness) {
                summaryStats.addStat(this.makeSkewness("skewness"));
            }
            if (this.compute.kurtosis) {
                summaryStats.addStat(this.makeKurtosis("kurtosis"));
            }
            if (this.compute.sem) {
                summaryStats.addStat(this.makeSem("sem"));
            }
            if (this.compute.min) {
                summaryStats.addStat(this.makeMin("min"));
            }
            if (this.compute.max) {
                summaryStats.addStat(this.makeMax("max"));
            }
            if (this.compute.range) {
                summaryStats.addStat(this.makeRange("range"));
            }
        }
        if (this.column.isCategorical()) {
            if (this.compute.mode) {
                summaryStats.addStat(this.makeMode("mode"));
            }
            if (this.compute.nbEmpty) {
                summaryStats.addStat(this.makeCountEmpty("nbEmpty", false));
            }
            if (this.compute.nbNonEmpty) {
                summaryStats.addStat(this.makeCountEmpty("nbNonEmpty", true));
            }
        }
        return summaryStats;
    }

    @UIModel
    public static class StatsToCompute {
        boolean totalCount = true;
        boolean mean = true;
        boolean sum = false;
        boolean median = true;
        boolean std = true;
        boolean variance = false;
        boolean skewness = false;
        boolean kurtosis = false;
        boolean sem = false;
        boolean completeCount = true;
        boolean nbEmpty = true;
        boolean zeroCount = false;
        boolean zeroRatio = false;
        boolean nonZeroRatio = false;
        boolean iqr = false;
        boolean distinctCount = true;
        boolean nbNonEmpty = false;
        boolean min = true;
        boolean max = true;
        boolean range = false;
        boolean mode = true;

        public StatsToCompute forContinuous() {
            this.mode = false;
            this.nbNonEmpty = false;
            this.nbEmpty = false;
            return this;
        }

        public StatsToCompute forCategorical() {
            this.mean = false;
            this.sum = false;
            this.median = false;
            this.std = false;
            this.variance = false;
            this.skewness = false;
            this.kurtosis = false;
            this.sem = false;
            this.completeCount = false;
            this.zeroCount = false;
            this.zeroRatio = false;
            this.nonZeroRatio = false;
            this.iqr = false;
            this.min = false;
            this.max = false;
            this.range = false;
            return this;
        }
    }
}

