/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.enterpriseassetlibrary;

import com.dataiku.dip.enterpriseassetlibrary.UIEnterpriseAssetCollection;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@UIModel
public class EnterpriseAssetCollection
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    @Nonnull
    public String id;
    @Nonnull
    public String displayName;
    @Nonnull
    public String color = "#FFD23F";
    @Nonnull
    public List<BasePermissions.PermissionItem> permissions = new ArrayList<BasePermissions.PermissionItem>();
    @JSON.FileTransient
    public boolean allowCollectionDeletion;
    @JSON.FileTransient
    public boolean allowCollectionUpdate;

    public EnterpriseAssetCollection(UIEnterpriseAssetCollection.CreationInfo creationInfo) {
        this(creationInfo, SecretKeyGenerator.generate((int)8));
        this.allowCollectionDeletion = true;
        this.allowCollectionUpdate = true;
    }

    public EnterpriseAssetCollection(UIEnterpriseAssetCollection.CreationInfo creationInfo, @Nonnull String collectionId) {
        this.id = collectionId;
        this.displayName = creationInfo.displayName;
        this.color = creationInfo.color;
        this.description = creationInfo.description;
        this.permissions = creationInfo.permissions;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.ENTERPRISE_ASSET_COLLECTION;
    }

    @Override
    public String getProjectKey() {
        return null;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    public UIEnterpriseAssetCollection.MetadataInfo getMetadata() {
        return new UIEnterpriseAssetCollection.MetadataInfo(this.displayName, this.color, this.description, this.tags);
    }

    @Override
    public void setProjectKey(String projectKey) {
    }

    @Override
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }
}

