/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.enterpriseassetlibrary;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetCollection;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetLibraryCodes;
import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetLibraryDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAsset;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseProject;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePrompt;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePromptTemplate;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedEnterpriseAssetLibraryDAO
implements EnterpriseAssetLibraryDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.enterpriseassetlibrary.dao");

    @Override
    public Map<String, EnterpriseProject> listProjects(String collectionId, boolean unsafe) throws IOException {
        RelFile projectsFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionProjectsMetadataFile(collectionId);
        return this.getDefinitions(unsafe, collectionId, projectsFile, EnterpriseProject.class, "projects");
    }

    @Override
    public Map<String, EnterprisePrompt> listPrompts(String collectionId, boolean unsafe) throws IOException {
        RelFile promptsFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionPromptsMetadataFile(collectionId);
        return this.getDefinitions(unsafe, collectionId, promptsFile, EnterprisePrompt.class, "prompts");
    }

    @Override
    public Map<String, EnterprisePromptTemplate> listPromptTemplates(String collectionId, boolean unsafe) throws IOException {
        RelFile promptTemplatesFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionPromptTemplatesMetadataFile(collectionId);
        return this.getDefinitions(unsafe, collectionId, promptTemplatesFile, EnterprisePromptTemplate.class, "prompt-templates");
    }

    @Override
    public void publishProject(String collectionId, EnterpriseProject project) throws IOException {
        RelFile projectsFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionProjectsMetadataFile(collectionId);
        this.publishProject(project, projectsFile);
        this.saveProjectDefinitionToFile(collectionId, project);
    }

    @Override
    public void deleteProject(String collectionId, String projectId) throws IOException, CodedException {
        RelFile projectsFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionProjectsMetadataFile(collectionId);
        this.deleteProject(collectionId, projectId, projectsFile);
    }

    @Override
    public void publishPrompt(String collectionId, EnterprisePrompt prompt) throws IOException {
        RelFile promptsFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionPromptsMetadataFile(collectionId);
        this.publishPrompt(prompt, promptsFile);
        this.savePromptDefinitionToFile(collectionId, prompt);
    }

    @Override
    public void publishPromptTemplate(String collectionId, EnterprisePromptTemplate prompt) throws IOException {
        RelFile promptTemplatesFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionPromptTemplatesMetadataFile(collectionId);
        this.publishPromptTemplate(prompt, promptTemplatesFile);
        this.savePromptTemplateDefinitionToFile(collectionId, prompt);
    }

    @Override
    public void deletePrompt(String collectionId, String promptId) throws IOException, CodedException {
        RelFile promptsFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionPromptsMetadataFile(collectionId);
        this.deletePrompt(collectionId, promptId, promptsFile);
    }

    @Override
    public void deletePromptTemplate(String collectionId, String promptId) throws IOException, CodedException {
        RelFile promptTemplatesFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionPromptTemplatesMetadataFile(collectionId);
        this.deletePromptTemplate(collectionId, promptId, promptTemplatesFile);
    }

    @Override
    public void saveCollection(EnterpriseAssetCollection collection) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(FilesBasedEnterpriseAssetLibraryDAO.getCollectionMetadataFile(collection.getId()), (Object)collection);
    }

    @Override
    public EnterpriseAssetCollection getCollectionOrNull(String collectionId, boolean unsafe) throws IOException {
        RelFile f = FilesBasedEnterpriseAssetLibraryDAO.getCollectionMetadataFile(collectionId);
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(f)) {
            return null;
        }
        EnterpriseAssetCollection collection = unsafe ? (EnterpriseAssetCollection)t.readObjectUnsafe(f, EnterpriseAssetCollection.class) : (EnterpriseAssetCollection)t.readObject(f, EnterpriseAssetCollection.class);
        collection.id = collectionId;
        collection.allowCollectionDeletion = true;
        collection.allowCollectionUpdate = true;
        return collection;
    }

    @Override
    public void deleteCollection(String collectionId) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(FilesBasedEnterpriseAssetLibraryDAO.getCollectionFolder(collectionId));
    }

    @Override
    public List<EnterpriseAssetCollection> listCollections(boolean unsafe) throws IOException {
        ArrayList<EnterpriseAssetCollection> collections = new ArrayList<EnterpriseAssetCollection>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory("enterprise_asset_library")) {
            return collections;
        }
        for (RelFile rf : t.listFiles("enterprise_asset_library")) {
            RelFile jsonFile;
            if (!t.isDirectory(rf) || !t.isFile(jsonFile = FilesBasedEnterpriseAssetLibraryDAO.getCollectionMetadataFile(rf.getLeafName()))) continue;
            collections.add(this.getCollectionOrNull(rf.getLeafName(), unsafe));
        }
        return collections;
    }

    void publishPrompt(EnterprisePrompt prompt, RelFile promptsFile) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(promptsFile);
        latestVersionsById.put(prompt.id, prompt.getVersion());
        t.writeObject(promptsFile, latestVersionsById);
    }

    void publishPromptTemplate(EnterprisePromptTemplate promptTemplate, RelFile promptTemplatesFile) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(promptTemplatesFile);
        latestVersionsById.put(promptTemplate.id, promptTemplate.getVersion());
        t.writeObject(promptTemplatesFile, latestVersionsById);
    }

    void deletePrompt(String collectionId, String promptId, RelFile promptsFile) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(promptsFile);
        if (latestVersionsById.remove(promptId) == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, "Prompt with id " + promptId + " not found");
        }
        t.writeObject(promptsFile, latestVersionsById);
        t.deleteDirectory(new RelFile(new String[]{"enterprise_asset_library", collectionId, "prompts", promptId}));
    }

    void deletePromptTemplate(String collectionId, String promptTemplateId, RelFile promptTemplatesFile) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(promptTemplatesFile);
        if (latestVersionsById.remove(promptTemplateId) == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, "Prompt template with id " + promptTemplateId + " not found");
        }
        t.writeObject(promptTemplatesFile, latestVersionsById);
        t.deleteDirectory(new RelFile(new String[]{"enterprise_asset_library", collectionId, "prompt-templates", promptTemplateId}));
    }

    void deleteProject(String collectionId, String projectId, RelFile projectsFile) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(projectsFile);
        if (latestVersionsById.remove(projectId) == null) {
            throw new CodedException((InfoMessage.MessageCode)EnterpriseAssetLibraryCodes.ERR_ENTERPRISE_ASSET_NOT_FOUND, "Project with id " + projectId + " not found");
        }
        t.writeObject(projectsFile, latestVersionsById);
        t.deleteDirectory(new RelFile(new String[]{"enterprise_asset_library", collectionId, "projects", projectId}));
    }

    @VisibleForTesting
    void publishProject(EnterpriseProject project, RelFile projectsFile) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(projectsFile);
        latestVersionsById.put(project.id, project.version);
        t.writeObject(projectsFile, latestVersionsById);
    }

    @VisibleForTesting
    <T extends EnterpriseAsset> Map<String, T> getDefinitions(boolean unsafe, String collectionId, RelFile assetsFile, Class<T> assetType, String assetsFolder) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        Map<String, String> latestVersionsById = this.getLatestAssetVersionsById(assetsFile);
        LinkedHashMap<String, EnterpriseAsset> dataMap = new LinkedHashMap<String, EnterpriseAsset>();
        for (Map.Entry<String, String> entry : latestVersionsById.entrySet()) {
            RelFile assetDefinitionFile = new RelFile(new String[]{"enterprise_asset_library", collectionId, assetsFolder, entry.getKey(), entry.getValue() + ".json"});
            if (!t.exists(assetDefinitionFile)) {
                logger.error((Object)("Could not find the Enterprise Asset definition file with the path: " + assetDefinitionFile.getFullPath()));
                continue;
            }
            EnterpriseAsset assetDefinition = unsafe ? (EnterpriseAsset)t.readObjectUnsafe(assetDefinitionFile, assetType) : (EnterpriseAsset)t.readObject(assetDefinitionFile, assetType);
            if (assetDefinition == null) continue;
            dataMap.put(assetDefinition.getId(), assetDefinition);
        }
        return dataMap;
    }

    private Map<String, String> getLatestAssetVersionsById(RelFile assetsFile) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(assetsFile)) {
            return new LinkedHashMap<String, String>();
        }
        Map data = (Map)t.readObjectUnsafe(assetsFile, LinkedHashMap.class);
        if (data == null) {
            return new LinkedHashMap<String, String>();
        }
        return data;
    }

    @VisibleForTesting
    void saveProjectDefinitionToFile(String collectionId, EnterpriseProject project) throws IOException {
        DKUFileUtils.mkdirs((File)DKUApp.getFile((String[])new String[]{"config", "enterprise_asset_library", collectionId, "projects", project.id}));
        RelFile projectDefinitionFile = new RelFile(new String[]{"enterprise_asset_library", collectionId, "projects", project.id, project.version + ".json"});
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(projectDefinitionFile, (Object)project);
    }

    @VisibleForTesting
    void savePromptDefinitionToFile(String collectionId, EnterprisePrompt prompt) throws IOException {
        DKUFileUtils.mkdirs((File)DKUApp.getFile((String[])new String[]{"config", "enterprise_asset_library", collectionId, "prompts", prompt.id}));
        RelFile projectDefinitionFile = new RelFile(new String[]{"enterprise_asset_library", collectionId, "prompts", prompt.id, prompt.getVersion() + ".json"});
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(projectDefinitionFile, (Object)prompt);
    }

    @VisibleForTesting
    void savePromptTemplateDefinitionToFile(String collectionId, EnterprisePromptTemplate prompt) throws IOException {
        DKUFileUtils.mkdirs((File)DKUApp.getFile((String[])new String[]{"config", "enterprise_asset_library", collectionId, "prompt-templates", prompt.id}));
        RelFile promptDefinitionFile = new RelFile(new String[]{"enterprise_asset_library", collectionId, "prompt-templates", prompt.id, prompt.getVersion() + ".json"});
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(promptDefinitionFile, (Object)prompt);
    }

    private static RelFile getCollectionFolder(String collectionId) {
        return new RelFile(new String[]{"enterprise_asset_library", collectionId});
    }

    private static RelFile getCollectionMetadataFile(String collectionId) {
        return new RelFile(FilesBasedEnterpriseAssetLibraryDAO.getCollectionFolder(collectionId), new String[]{"collection.json"});
    }

    private static RelFile getCollectionProjectsMetadataFile(String collectionId) {
        return new RelFile(FilesBasedEnterpriseAssetLibraryDAO.getCollectionFolder(collectionId), new String[]{"projects.json"});
    }

    private static RelFile getCollectionPromptsMetadataFile(String collectionId) {
        return new RelFile(FilesBasedEnterpriseAssetLibraryDAO.getCollectionFolder(collectionId), new String[]{"prompts.json"});
    }

    private static RelFile getCollectionPromptTemplatesMetadataFile(String collectionId) {
        return new RelFile(FilesBasedEnterpriseAssetLibraryDAO.getCollectionFolder(collectionId), new String[]{"prompt-templates.json"});
    }
}

