/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking;

import com.dataiku.dip.experimenttracking.ExperimentTag;
import com.dataiku.dss.shadelib.org.mlflow.api.proto.Service;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@UIModel
public class Experiment {
    public String id;
    public String name;
    public String artifactLocation;
    public long lastUpdateTime;
    public long creationTime;
    public List<ExperimentTag> tags = new ArrayList<ExperimentTag>();
    public String lifecycleStage;

    public Service.Experiment toMLflowExperiment() {
        Service.Experiment.Builder mlflowExperimentBuilder = Service.Experiment.newBuilder();
        mlflowExperimentBuilder.setExperimentId(this.id);
        mlflowExperimentBuilder.setName(this.name);
        mlflowExperimentBuilder.setArtifactLocation(this.artifactLocation);
        mlflowExperimentBuilder.setLastUpdateTime(this.lastUpdateTime);
        mlflowExperimentBuilder.setCreationTime(this.creationTime);
        mlflowExperimentBuilder.setLifecycleStage(this.lifecycleStage);
        mlflowExperimentBuilder.addAllTags((Iterable)this.tags.stream().map(ExperimentTag::toMLflowExperimentTag).collect(Collectors.toList()));
        return mlflowExperimentBuilder.build();
    }

    public static List<Service.Experiment> toMLflowExperiments(List<Experiment> experiments) {
        return experiments.stream().map(Experiment::toMLflowExperiment).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Experiment)) {
            return false;
        }
        Experiment that = (Experiment)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

