/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.export.CustomLoadedExporter;
import java.util.HashMap;
import java.util.Map;

public class CustomExportersRegistry {
    private static final Map<String, CustomLoadedExporter<?>> exporters = new HashMap();

    public static synchronized void register(CustomLoadedExporter<?> exporter) {
        exporters.put(exporter.getType(), exporter);
    }

    public static synchronized void deregister(String exporterType) {
        exporters.remove(exporterType);
    }

    public static synchronized CustomLoadedExporter<?> getExporter(String exporterType) {
        if (!exporters.containsKey(exporterType)) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType("exporter", exporterType);
        }
        return exporters.get(exporterType);
    }

    public static IPluginifiedMeta getMeta(String exporterType) {
        return CustomExportersRegistry.getExporter(exporterType).getPluginifiedMeta();
    }
}

