/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.CustomJavaExporterDesc;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.LoadedJavaExporter;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.plugin.CustomExporter;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.security.AuthCtx;
import com.google.gson.JsonObject;
import java.io.File;
import org.apache.log4j.Logger;

public class CustomJavaExportOutput
implements ExportOutput {
    private final AuthCtx authCtx;
    private final String projectKey;
    protected final JsonObject config;
    protected final LoadedJavaExporter loaded;
    protected final CustomJavaExportersService customJavaExporterService;
    private CustomExporter exporter;
    private static Logger logger = Logger.getLogger((String)"dip.javaexporter.output");

    public CustomJavaExportOutput(AuthCtx authCtx, String projectKey, JsonObject config, LoadedJavaExporter loaded, CustomJavaExportersService customJavaExporterService) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.customJavaExporterService = customJavaExporterService;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        logger.info((Object)("Initialize exporter " + ((CustomJavaExporterDesc)this.loaded.getDesc()).exporterClass));
        ClassLoader classLoader = this.customJavaExporterService.getClassloader(this.loaded.getType());
        this.exporter = (CustomExporter)new PluginClazzLoader(classLoader).loadClazz(((CustomJavaExporterDesc)this.loaded.getDesc()).exporterClass);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customJavaExporterService.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        this.exporter.initialize(expandedPluginSettings.config, expandedPluginSettings.pluginConfig, schema, cf, this.getDestinationFile());
    }

    protected File getDestinationFile() {
        return null;
    }

    @Override
    public void stream(RowInputStream stream) throws Exception {
        if (this.exporter != null) {
            this.exporter.stream(stream);
        }
    }

    @Override
    public long getWrittenBytes() throws Exception {
        return this.exporter != null ? this.exporter.getWrittenBytes() : 0L;
    }

    @Override
    public void close() {
        if (this.exporter != null) {
            this.exporter.close();
            this.exporter = null;
        }
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) {
    }
}

