/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractKubernetesExpositionHandler
implements ExpositionHandler {
    protected final AuthCtx authCtx;
    protected final String projectKey;
    protected final ContainerExecRuntimeConfig containerConfig;
    protected final ExposedEndpointConsumer endpointConsumer;
    protected String namePrefix;
    protected String executionId;
    protected File tmpDir;
    protected int exposedPort;
    protected String exposedService;
    protected Map<String, String> annotations;
    protected Map<String, String> labels;
    protected Map<String, String> selectors;
    protected String propertiesPrefix;
    protected List<SimpleKeyValue> properties;
    protected String publishedServiceId;
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    AbstractKubernetesExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, ExposedEndpointConsumer endpointConsumer) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.containerConfig = containerConfig;
        this.endpointConsumer = endpointConsumer;
    }

    @Override
    public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
        Exposables.KubernetesExposable kubernetesExposable = (Exposables.KubernetesExposable)exposable;
        this.namePrefix = kubernetesExposable.getNamePrefix();
        this.executionId = kubernetesExposable.getExecutionId();
        this.tmpDir = kubernetesExposable.getTmpDir();
        this.exposedPort = kubernetesExposable.getContainerizedPort();
        this.exposedService = kubernetesExposable.getExposedService();
        this.annotations = kubernetesExposable.getAnnotations();
        this.labels = kubernetesExposable.getLabels();
        this.selectors = kubernetesExposable.getSelectors();
        this.propertiesPrefix = kubernetesExposable.getPropertiesPrefix();
        this.properties = kubernetesExposable.getProperties();
        this.publishedServiceId = kubernetesExposable.getExposedServiceId();
    }

    public static String getIngressHost(JsonObject obj) {
        JsonArray ingressArr;
        if (obj.has("status") && obj.getAsJsonObject("status").has("loadBalancer") && obj.getAsJsonObject("status").getAsJsonObject("loadBalancer").has("ingress") && (ingressArr = obj.getAsJsonObject("status").getAsJsonObject("loadBalancer").getAsJsonArray("ingress")).size() > 0) {
            JsonObject ingressObj = ingressArr.get(0).getAsJsonObject();
            if (ingressObj.has("ip")) {
                return ingressObj.get("ip").getAsString();
            }
            if (ingressObj.has("hostname")) {
                return ingressObj.get("hostname").getAsString();
            }
        }
        return null;
    }

    public static String getClusterIP(JsonObject obj) {
        if (obj.has("spec") && obj.getAsJsonObject("spec").has("clusterIP") && !obj.getAsJsonObject("spec").get("clusterIP").isJsonNull()) {
            return obj.getAsJsonObject("spec").get("clusterIP").getAsString();
        }
        return null;
    }

    public static Integer getServicePort(JsonObject obj) {
        JsonObject portsObj;
        JsonArray portsArr;
        if (obj.has("spec") && obj.getAsJsonObject("spec").has("ports") && (portsArr = obj.getAsJsonObject("spec").getAsJsonArray("ports")).size() > 0 && (portsObj = portsArr.get(0).getAsJsonObject()).has("port")) {
            return portsObj.get("port").getAsInt();
        }
        return null;
    }

    public static Integer getNodePort(JsonObject obj) {
        JsonObject portsObj;
        JsonArray portsArr;
        if (obj.has("spec") && obj.getAsJsonObject("spec").has("ports") && (portsArr = obj.getAsJsonObject("spec").getAsJsonArray("ports")).size() > 0 && (portsObj = portsArr.get(0).getAsJsonObject()).has("nodePort")) {
            return portsObj.get("nodePort").getAsInt();
        }
        return null;
    }

    public static Map<String, String> getNodesInternalIPs(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, File tmpDir, DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        ProcessBuilder pollServiceProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "nodes", "-o", "json"));
        pollServiceProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
        pollServiceProcessBuilder.directory(tmpDir);
        logger.info((Object)("Get node IPs " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command())));
        expositionLog.handle("Poll LB " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command()), false);
        RegularProcess pollServiceProcess = new RegularProcess(pollServiceProcessBuilder, tmpDir);
        pollServiceProcess.start();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer pollServiceEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext("[nodeport] ").withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        pollServiceEoc.start(pollServiceProcess.getInputStream(), pollServiceProcess.getErrorStream(), null);
        int rv = pollServiceProcess.waitFor();
        if (rv != 0) {
            throw new Exception("Unable to get nodeIPs of cluster");
        }
        pollServiceEoc.finish();
        JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Service JSON: " + JSON.prettyLog((Object)obj)));
        }
        HashMap ips = Maps.newHashMap();
        if (obj.has("items")) {
            JsonArray nodesArr = obj.getAsJsonArray("items");
            for (int i = 0; i < nodesArr.size(); ++i) {
                JsonObject nodeElt = nodesArr.get(i).getAsJsonObject();
                String name = null;
                if (nodeElt.has("metadata") && nodeElt.getAsJsonObject("metadata").has("name") && !nodeElt.getAsJsonObject("metadata").get("name").isJsonNull()) {
                    name = nodeElt.getAsJsonObject("metadata").getAsJsonPrimitive("name").getAsString();
                }
                if (name == null || !nodeElt.has("status") || !nodeElt.getAsJsonObject("status").has("addresses")) continue;
                JsonArray addressesArr = nodeElt.getAsJsonObject("status").getAsJsonArray("addresses");
                for (int j = 0; j < addressesArr.size(); ++j) {
                    JsonObject addressObj = addressesArr.get(j).getAsJsonObject();
                    if (!addressObj.has("type") || addressObj.get("type").isJsonNull() || !"InternalIP".equals(addressObj.getAsJsonPrimitive("type").getAsString()) || !addressObj.has("address") || addressObj.get("address").isJsonNull()) continue;
                    ips.put(name, addressObj.getAsJsonPrimitive("address").getAsString());
                }
            }
        }
        return ips;
    }

    public static List<ExposedEndpointConsumer.ExposedEndpoint> inferExposedEndpoints(AuthCtx authCtx, String projectKey, String expositionType, JsonObject obj, DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder, ContainerExecRuntimeConfig containerConfig, File tmpDir, String scheme, String servicePath) throws Exception {
        ArrayList l = Lists.newArrayList();
        if (obj == null) {
            return l;
        }
        if (!obj.has("spec") || !obj.getAsJsonObject("spec").has("type") || obj.getAsJsonObject("spec").getAsJsonPrimitive("type").isJsonNull()) {
            return l;
        }
        String type = obj.getAsJsonObject("spec").getAsJsonPrimitive("type").getAsString();
        switch (type.toLowerCase()) {
            case "clusterip": {
                String host = AbstractKubernetesExpositionHandler.getClusterIP(obj);
                Integer port = AbstractKubernetesExpositionHandler.getServicePort(obj);
                if (host == null || port == null) break;
                l.add(new ExposedEndpointConsumer.ExposedEndpoint(expositionType, null, scheme, host, port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.CLUSTER));
                break;
            }
            case "nodeport": {
                Integer nodePort = AbstractKubernetesExpositionHandler.getNodePort(obj);
                if (nodePort == null) break;
                for (Map.Entry<String, String> e : AbstractKubernetesExpositionHandler.getNodesInternalIPs(authCtx, projectKey, containerConfig, tmpDir, expositionLog, smartLogTailBuilder).entrySet()) {
                    l.add(new ExposedEndpointConsumer.ExposedEndpoint(expositionType, e.getKey(), scheme, e.getValue(), nodePort, null, ExposedEndpointConsumer.ExposedEndpointAvailability.CLUSTER));
                }
                break;
            }
            case "ingress": {
                String ingressHost = AbstractKubernetesExpositionHandler.getIngressHost(obj);
                Integer ingressPort = AbstractKubernetesExpositionHandler.getServicePort(obj);
                if (ingressPort == null) {
                    ingressPort = 80;
                }
                if (ingressHost == null) break;
                String cleanServicePath = StringUtils.defaultIfBlank((String)servicePath, (String)"");
                if (cleanServicePath.startsWith("/")) {
                    cleanServicePath = cleanServicePath.substring(1);
                }
                if (cleanServicePath.endsWith("/")) {
                    cleanServicePath = cleanServicePath.substring(0, cleanServicePath.length() - 1);
                }
                l.add(new ExposedEndpointConsumer.ExposedEndpoint(expositionType, null, scheme, ingressHost, ingressPort, cleanServicePath, ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC));
                break;
            }
            case "loadbalancer": {
                String lbHost = AbstractKubernetesExpositionHandler.getIngressHost(obj);
                Integer lbPort = AbstractKubernetesExpositionHandler.getServicePort(obj);
                if (lbHost == null || lbPort == null) break;
                l.add(new ExposedEndpointConsumer.ExposedEndpoint(expositionType, null, scheme, lbHost, lbPort, null, ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC));
                break;
            }
        }
        return l;
    }

    public static JsonObject describeService(AuthCtx authCtx, String projectKey, DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder, ContainerExecRuntimeConfig containerConfig, File tmpDir, String serviceId, String logPrefix) throws IOException, InterruptedException, Exception {
        ProcessBuilder pollServiceProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "service", serviceId, "-o", "json"));
        pollServiceProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
        pollServiceProcessBuilder.directory(tmpDir);
        logger.info((Object)("Poll service status " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command())));
        expositionLog.handle("Poll yaml " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command()), false);
        RegularProcess pollServiceProcess = new RegularProcess(pollServiceProcessBuilder, tmpDir);
        pollServiceProcess.start();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer pollServiceEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext(logPrefix).withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        pollServiceEoc.start(pollServiceProcess.getInputStream(), pollServiceProcess.getErrorStream(), null);
        int rv = pollServiceProcess.waitFor();
        if (rv != 0) {
            throw new Exception("Unable to get status of service " + serviceId);
        }
        pollServiceEoc.finish();
        JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Service JSON: " + JSON.prettyLog((Object)obj)));
        }
        return obj;
    }

    public static JsonObject describeIngress(AuthCtx authCtx, String projectKey, DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder, ContainerExecRuntimeConfig containerConfig, File tmpDir, String ingressId, String logPrefix) throws IOException, InterruptedException, Exception {
        ProcessBuilder pollIngressProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(authCtx, projectKey, containerConfig, false, "get", "ingress", ingressId, "-o", "json"));
        pollIngressProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(containerConfig));
        pollIngressProcessBuilder.directory(tmpDir);
        logger.info((Object)("Poll ingress status " + Joiner.on((String)" ").join(pollIngressProcessBuilder.command())));
        RegularProcess pollIngressProcess = new RegularProcess(pollIngressProcessBuilder, tmpDir);
        pollIngressProcess.start();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer pollIngressEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext("[ig] ").withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        pollIngressEoc.start(pollIngressProcess.getInputStream(), pollIngressProcess.getErrorStream(), null);
        int rv = pollIngressProcess.waitFor();
        if (rv != 0) {
            throw new Exception("Unable to get status of ingress " + ingressId);
        }
        pollIngressEoc.finish();
        JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Ingress JSON: " + JSON.prettyLog((Object)obj)));
        }
        return obj;
    }
}

