/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionAdapter;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ExpositionRegistry {
    private static final Map<String, ExpositionMeta> metas = new HashMap<String, ExpositionMeta>();

    private ExpositionRegistry() {
    }

    public static synchronized void register(ExpositionMeta meta) {
        metas.put(meta.getType(), meta);
        ExpositionAdapter.registerType(meta.getType(), meta.getParamsClass());
    }

    public static synchronized void deregister(String type) {
        metas.remove(type);
    }

    public static ExpositionMeta getMeta(Exposition exposition) {
        return ExpositionRegistry.getMeta(exposition.type);
    }

    public static synchronized ExpositionMeta getMeta(String type) {
        ExpositionMeta meta = metas.get(type);
        if (meta == null) {
            throw ErrorContext.iaef((String)"Web app exposition type does not exist: '%s'.", (Object)type, (Object[])new Object[0]);
        }
        return meta;
    }

    public static synchronized Collection<ExpositionMeta> getAllMeta() {
        return new ArrayList<ExpositionMeta>(metas.values());
    }
}

