/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractIngressExposition;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GKEIngressExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "gke_ingress";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return GKEIngressExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ParamDesc affinity = new ParamDesc();
            affinity.type = ParamDesc.Type.SELECT;
            affinity.name = "affinity";
            affinity.label = "Affinity";
            affinity.defaultValue = "NONE";
            affinity.selectChoices = Lists.newArrayList();
            affinity.selectChoices.add(new ParamDesc.SelectChoice().withLabel("None").withValue(Affinity.NONE.name()));
            affinity.selectChoices.add(new ParamDesc.SelectChoice().withLabel("Client IP").withValue(Affinity.CLIENT_IP.name()));
            affinity.selectChoices.add(new ParamDesc.SelectChoice().withLabel("Generated cookie").withValue(Affinity.GENERATED_COOKIE.name()));
            ParamDesc tlsTermination = new ParamDesc();
            tlsTermination.type = ParamDesc.Type.BOOLEAN;
            tlsTermination.name = "tlsTermination";
            tlsTermination.label = "TLS termination";
            ParamDesc tlsSecretName = new ParamDesc();
            tlsSecretName.type = ParamDesc.Type.STRING;
            tlsSecretName.name = "secretName";
            tlsSecretName.label = "Certificate secret";
            tlsSecretName.description = "Name of a certificate secret in the cluster";
            ParamDesc tlsKeyPath = new ParamDesc();
            tlsKeyPath.type = ParamDesc.Type.STRING;
            tlsKeyPath.name = "keyPath";
            tlsKeyPath.label = "TLS key path";
            tlsKeyPath.description = "Path to a TLS key on the server filesystem";
            ParamDesc tlsCrtPath = new ParamDesc();
            tlsCrtPath.type = ParamDesc.Type.STRING;
            tlsCrtPath.name = "crtPath";
            tlsCrtPath.label = "TLS cert path";
            tlsCrtPath.description = "Path to a TLS cert on the server filesystem.";
            ParamDesc tlsCertHosts = new ParamDesc();
            tlsCertHosts.type = ParamDesc.Type.OBJECT_LIST;
            tlsCertHosts.name = "tlsCertHosts";
            tlsCertHosts.label = "Certificates";
            tlsCertHosts.visibilityCondition = "model.tlsTermination";
            tlsCertHosts.subParams = Lists.newArrayList((Object[])new ParamDesc[]{tlsSecretName, tlsKeyPath, tlsCrtPath});
            ExpositionDesc desc = AbstractIngressExposition.getDesc();
            return desc.withType(this.getType()).withMeta(new DkuComponentMetadata("Ingress (GKE)", "Ingress on a NodePort service (GKE)", null, null)).withParam(affinity).withParam(tlsTermination).withParam(tlsCertHosts);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 600000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES && "gke".equalsIgnoreCase(containerConfig.getProperty("cloud.provider", ""));
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            GKEIngressExpositionParams params = exposition.getParamsAs(GKEIngressExpositionParams.class);
            return new GKEIngressExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
            GKEIngressExpositionParams params = exposition.getParamsAs(GKEIngressExpositionParams.class);
            params.expandParametersInPlace(vc);
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    private static class GKEIngressExpositionHandler
    extends AbstractIngressExposition.AbstractIngressExpositionHandler<GKEIngressExpositionParams> {
        GKEIngressExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, GKEIngressExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        protected String expositionType() {
            return META.getType();
        }

        @Override
        protected List<String> getExtra(Map<String, String> serviceAnnotations, Map<String, String> ingressAnnotations) throws IOException {
            if (!ingressAnnotations.containsKey("kubernetes.io/ingress.class")) {
                ingressAnnotations.put("kubernetes.io/ingress.class", "gce");
            }
            if (((GKEIngressExpositionParams)this.params).affinity != Affinity.NONE) {
                serviceAnnotations.put("beta.cloud.google.com/backend-config", String.format("'{\"ports\": {\"%d\":\"%s-backend-" + this.executionId + "\"}}'", this.exposedPort, this.namePrefix));
                File backendFile = new File(this.tmpDir, "backend_" + this.executionId + ".yaml");
                ArrayList snippetLines = Lists.newArrayList();
                snippetLines.add("  timeoutSec: 40");
                snippetLines.add("  connectionDraining:");
                snippetLines.add("    drainingTimeoutSec: 60");
                snippetLines.add("  sessionAffinity:");
                switch (((GKEIngressExpositionParams)this.params).affinity) {
                    case GENERATED_COOKIE: {
                        snippetLines.add("    affinityType: \"GENERATED_COOKIE\"");
                        snippetLines.add("    affinityCookieTtlSec: 50");
                        break;
                    }
                    case CLIENT_IP: {
                        snippetLines.add("    affinityType: \"CLIENT_IP\"");
                        break;
                    }
                    default: {
                        throw new Error("unreachable");
                    }
                }
                String backendDesc = KubernetesExecUtils.getBackendConfigConf(this.namePrefix, this.executionId, Joiner.on((String)"\n").join((Iterable)snippetLines), this.labels, this.annotations);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("backend=\n" + backendDesc));
                }
                DKUFileUtils.writeFileUTF8((File)backendFile, (String)backendDesc);
                return Lists.newArrayList((Object[])new String[]{"-f", backendFile.getAbsolutePath()});
            }
            return Lists.newArrayList();
        }

        @Override
        protected String getIngressClassNameSpec() {
            return null;
        }

        @Override
        protected void checkServiceStartFailure(DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            SmartLogTail logTail = smartLogTailBuilder.get();
            Pattern missingHttpLoadBalancingPattern = Pattern.compile(".*no matches for kind \"BackendConfig\" in version \"cloud.google.com/v1beta1\".*", 2);
            for (String line : logTail.getLines()) {
                if (!missingHttpLoadBalancingPattern.matcher(line).matches()) continue;
                throw new Exception("Cluster was started without HTTP load balancing addon, cannot use GKE-enabled ingress");
            }
        }

        @Override
        protected String getServicePath() {
            return "";
        }

        @Override
        protected String getPublicServicePath() {
            return "";
        }

        @Override
        protected List<String> getIngressTLS(List<KubernetesExecUtils.IngressTLS> tls) throws IOException {
            ArrayList files = Lists.newArrayList();
            int i = 0;
            for (AbstractIngressExposition.TLSCertHost certHost : ((GKEIngressExpositionParams)this.params).tlsCertHosts) {
                Object tlsSecretName;
                if (StringUtils.isBlank((String)certHost.secretName)) {
                    if (StringUtils.isBlank((String)certHost.crtPath)) {
                        throw new IllegalArgumentException("Cert path not defined");
                    }
                    if (!new File(certHost.crtPath).exists()) {
                        throw new IllegalArgumentException("No file exists at the defined cert path");
                    }
                    if (StringUtils.isBlank((String)certHost.keyPath)) {
                        throw new IllegalArgumentException("Key path not defined");
                    }
                    if (!new File(certHost.keyPath).exists()) {
                        throw new IllegalArgumentException("No file exists at the defined key path");
                    }
                    tlsSecretName = "tls-ingress-" + i + "-" + this.executionId;
                    File secretFile = new File(this.tmpDir, "secret_tls_" + i + "_" + this.executionId + ".yaml");
                    String secretDesc = KubernetesExecUtils.getTlsSecretConf((String)tlsSecretName, certHost.keyPath, certHost.crtPath);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("secret_" + i + "=\n" + secretDesc));
                    }
                    DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
                    files.add("-f");
                    files.add(secretFile.getAbsolutePath());
                } else {
                    tlsSecretName = certHost.secretName;
                }
                tls.add(new KubernetesExecUtils.IngressTLS((String)tlsSecretName, null));
                ++i;
            }
            return files;
        }
    }

    public static class GKEIngressExpositionParams
    extends AbstractIngressExposition.AbstractIngressExpositionParams {
        public Affinity affinity = Affinity.NONE;

        @Override
        public String getScheme() {
            return "http";
        }

        @Override
        public int getPort() {
            return 80;
        }

        @Override
        public String getForcedUrl() {
            return null;
        }

        @Override
        public String getHostForDSS() {
            return null;
        }

        @Override
        public List<String> getExtraHosts() {
            return Lists.newArrayList();
        }
    }

    public static enum Affinity {
        NONE,
        CLIENT_IP,
        GENERATED_COOKIE;

    }
}

