/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractKubernetesExpositionHandler;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.exposition.PortForwardUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.AbstractIsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class PortForwardExposition {
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private static BackOffStrategy BACKOFF_STRATEGY = null;
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "port_forward";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return PortForwardExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            return new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Port forwarding", "Forward to each pod using kubectl", null, null));
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 60000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            return new PortForwardExpositionHandler(authCtx, projectKey, containerConfig, endpointConsumer);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.k8s.pfexpose");

    private static class PortForwardExpositionHandler
    extends AbstractKubernetesExpositionHandler
    implements PortForwardUtils.ExpositionLoggingCallbacks {
        private int port;
        private DKUtils.LineSubscriptionAttacher expositionLog;
        private PodsPortForwarderThread podsPortForwarderThread;
        private DKUtils.SmartLogTailBuilder smartLogTailBuilder;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private boolean closed;
        private BackOffStrategy.BackOffNoException backOff;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PortForwardExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, endpointConsumer);
            Class<PortForwardExposition> clazz = PortForwardExposition.class;
            synchronized (PortForwardExposition.class) {
                if (BACKOFF_STRATEGY == null) {
                    BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)DKUApp.getParams().getIntParam("dku.k8s.pf.monitor.initialPollDelayMS", Integer.valueOf(8000)), (int)DKUApp.getParams().getIntParam("dku.k8s.pf.monitor.maxPollDelayMS", Integer.valueOf(30000)), (double)DKUApp.getParams().getDoubleParam("dku.k8s.pf.monitor.pollDelayMultiplier", 1.04));
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                this.backOff = BACKOFF_STRATEGY.buildNoException();
                return;
            }
        }

        private File getStatusFile() {
            return new File(this.tmpDir, "port-forward-" + this.exposedPort + "-status.json");
        }

        private File getStartFile() {
            return new File(this.tmpDir, "port-forward-" + this.exposedPort + "-start.json");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void cleanup() {
            this.closed = true;
            if (this.podsPortForwarderThread != null) {
                this.podsPortForwarderThread.kill();
                return;
            }
            HashSet<Integer> pids = new HashSet<Integer>();
            Object object = PortForwardExposition.class;
            synchronized (PortForwardExposition.class) {
                try {
                    FileUtils.write((File)this.getStartFile(), (CharSequence)Long.toString(-1L));
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to write thread stop flag", (Throwable)e);
                }
                try {
                    ExpositionHandler.ExpositionStatus status = (ExpositionHandler.ExpositionStatus)JSON.parseFile((File)this.getStatusFile(), ExpositionHandler.ExpositionStatus.class);
                    if (status.raw != null) {
                        for (String objectId : status.raw.keySet()) {
                            pids.add(status.raw.getAsJsonPrimitive(objectId).getAsInt());
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to read old status", (Throwable)e);
                }
                object = pids.iterator();
                while (object.hasNext()) {
                    int pid = (Integer)object.next();
                    logger.info((Object)("Kill old port-forward (if still present) " + pid));
                    DKUtils.evilKill((int)pid);
                }
                return;
            }
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            this.expositionLog = expositionLog;
            this.smartLogTailBuilder = smartLogTailBuilder;
            this.status = new ExpositionHandler.ExpositionStatus();
            this.status.isHealthy = true;
            this.podsPortForwarderThread = new PodsPortForwarderThread(KubernetesExecUtils.getPodName(this.executionId), this.endpointConsumer, this.status);
            this.podsPortForwarderThread.start();
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            if (this.closed) {
                return new ExpositionHandler.ExpositionStatus();
            }
            if (this.status != null && this.podsPortForwarderThread != null) {
                return this.status;
            }
            Class<PortForwardExposition> clazz = PortForwardExposition.class;
            synchronized (PortForwardExposition.class) {
                File f = this.getStatusFile();
                if (f.exists()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (ExpositionHandler.ExpositionStatus)JSON.parseFile((File)f, ExpositionHandler.ExpositionStatus.class);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new ExpositionHandler.ExpositionStatus();
            }
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), "${K8S_POD_NAME}", null, null, this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
        }

        @Override
        public void logLine(String line) {
            logger.info((Object)line);
            String lineWithTimestampAndContext = "[" + dateFormat.format(Instant.now()) + "] [pf-" + this.exposedPort + "] " + line;
            if (this.expositionLog != null) {
                try {
                    this.expositionLog.handle(lineWithTimestampAndContext, false);
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to log to rotating file", (Throwable)e);
                }
            }
            if (this.smartLogTailBuilder != null) {
                this.smartLogTailBuilder.appendLine(lineWithTimestampAndContext);
            }
        }

        @Override
        public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder() {
            return this.smartLogTailBuilder;
        }

        @Override
        public DKUtils.LineSubscriptionAttacher getExpositionLog() {
            return this.expositionLog;
        }

        private class PodsPortForwarderThread
        extends Thread
        implements PortForwardUtils.SinglePortForwardListener {
            private final Map<String, PodPortForwarderThread> pods = Maps.newConcurrentMap();
            private final String deploymentId;
            private volatile boolean keepLooping = true;
            private final Object portForwardingChange = new Object();
            private final ExposedEndpointConsumer endpointConsumer;
            private final Map<String, Integer> ports = Maps.newHashMap();
            private final ExpositionHandler.ExpositionStatus status;

            public PodsPortForwarderThread(String deploymentId, ExposedEndpointConsumer endpointConsumer, ExpositionHandler.ExpositionStatus status) {
                this.deploymentId = deploymentId;
                this.endpointConsumer = endpointConsumer;
                this.status = status;
                this.setName("K8SPFForwarder-" + PortForwardExpositionHandler.this.executionId + "-" + this.getId());
            }

            public void kill() {
                this.keepLooping = false;
                this.interrupt();
            }

            @Override
            public boolean objectIsKnown(String objectId) {
                return this.pods.containsKey(objectId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forward(String podId, int port) throws Exception {
                logger.info((Object)("Forwarding of " + podId + " on " + port + " started"));
                this.ports.put(podId, port);
                ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), podId, null, null, port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
                this.endpointConsumer.registerPort(endpoint);
                this.status.endpoints.add(endpoint);
                Class<PortForwardExposition> clazz = PortForwardExposition.class;
                synchronized (PortForwardExposition.class) {
                    JSON.prettyToFile((Object)this.status, (File)PortForwardExpositionHandler.this.getStatusFile());
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unforward(String podId, Integer port) throws Exception {
                Integer removed = this.ports.remove(podId);
                logger.info((Object)("Forwarding of " + podId + " on " + removed + " stopped"));
                this.endpointConsumer.deregisterPort(new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), podId, null, null, removed == null ? -1 : removed, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL));
                ArrayList endpointsToRemove = Lists.newArrayList();
                for (ExposedEndpointConsumer.ExposedEndpoint endpoint : this.status.endpoints) {
                    if (!StringUtils.equals((String)podId, (String)endpoint.id)) continue;
                    endpointsToRemove.add(endpoint);
                }
                this.status.endpoints.removeAll(endpointsToRemove);
                if (this.status.raw != null && this.status.raw.has(podId)) {
                    this.status.raw.remove(podId);
                }
                Class<PortForwardExposition> clazz = PortForwardExposition.class;
                synchronized (PortForwardExposition.class) {
                    JSON.prettyToFile((Object)this.status, (File)PortForwardExpositionHandler.this.getStatusFile());
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForwardPid(String podId, int pid) throws IOException {
                if (this.status.raw == null) {
                    this.status.raw = new JsonObject();
                }
                this.status.raw.addProperty(podId, (Number)pid);
                Class<PortForwardExposition> clazz = PortForwardExposition.class;
                synchronized (PortForwardExposition.class) {
                    JSON.prettyToFile((Object)this.status, (File)PortForwardExpositionHandler.this.getStatusFile());
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyChange() {
                Object object = this.portForwardingChange;
                synchronized (object) {
                    this.portForwardingChange.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                PortForwardExpositionHandler.this.logLine("Start forwarding port for pods in deployment " + this.deploymentId);
                threadStart = System.currentTimeMillis();
                var3_2 = PortForwardExposition.class;
                // MONITORENTER : com.dataiku.dip.exposition.PortForwardExposition.class
                try {
                    FileUtils.write((File)PortForwardExpositionHandler.this.getStartFile(), (CharSequence)Long.toString(threadStart), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    PortForwardExposition.logger.error((Object)"Failed to write thread start flag", (Throwable)e);
                    // MONITOREXIT : var3_2
                    return;
                }
                hasSeenDeployment = false;
                startDeploymentWait = System.currentTimeMillis();
                cliSelectors = PortForwardExpositionHandler.this.selectors.entrySet().stream().map((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$run$0(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).collect(Collectors.toList());
                cliSelector = Joiner.on((String)",").join(cliSelectors);
                try {
                    while (this.keepLooping || !hasSeenDeployment) {
                        var8_8 = PortForwardExposition.class;
                        // MONITORENTER : com.dataiku.dip.exposition.PortForwardExposition.class
                        try {
                            var9_11 = Long.parseLong(FileUtils.readFileToString((File)PortForwardExpositionHandler.this.getStartFile(), (Charset)StandardCharsets.UTF_8));
                            if (var9_11 != threadStart) {
                                PortForwardExposition.logger.info((Object)"Port forwarder was replaced by another version, stopping current");
                                this.keepLooping = false;
                                // MONITOREXIT : var8_8
                                break;
                            }
                        }
                        catch (IOException var9_12) {
                            PortForwardExposition.logger.error((Object)"Failed to read thread start flag", (Throwable)var9_12);
                            // MONITOREXIT : var8_8
                            var10_16 = this.pods.entrySet().iterator();
                            while (var10_16.hasNext() != false) {
                                e = var10_16.next();
                                try {
                                    e.getValue().kill();
                                }
                                catch (Throwable t) {
                                    PortForwardExposition.logger.error((Object)"Failed to kill port forward thread", t);
                                }
                            }
                            return;
                        }
                        try {
                            listPodsProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(PortForwardExpositionHandler.this.authCtx, PortForwardExpositionHandler.this.projectKey, PortForwardExpositionHandler.this.containerConfig, false, new String[]{"get", "pods", "-o", "json", "-l", cliSelector}));
                            listPodsProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(PortForwardExpositionHandler.this.containerConfig));
                            listPodsProcessBuilder.directory(PortForwardExpositionHandler.this.tmpDir);
                            PortForwardExpositionHandler.this.logLine("Listing pods: " + Joiner.on((String)" ").join(listPodsProcessBuilder.command()));
                            var9_13 = new RegularProcess(listPodsProcessBuilder, PortForwardExpositionHandler.this.tmpDir);
                            var9_13.setChattiness(AbstractIsolableProcess.Chattiness.SILENT);
                            var9_13.start();
                            outputCollector = new DKUtils.ByteCollectingSubscription();
                            listPodsEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext("[pf-" + PortForwardExpositionHandler.this.exposedPort + "] ").withOutputConsumer((DKUtils.ExecSubscription)outputCollector).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(PortForwardExposition.logger, Level.WARN)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(PortForwardExpositionHandler.this.smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)PortForwardExpositionHandler.this.expositionLog);
                            listPodsEoc.start(var9_13.getInputStream(), var9_13.getErrorStream(), null);
                            rv = var9_13.waitFor();
                            if (rv != 0) {
                                if (hasSeenDeployment != false) throw new Exception("Unable to get status of deployment " + this.deploymentId);
                                if (System.currentTimeMillis() - startDeploymentWait <= 10000L) continue;
                                throw new Exception("Unable to get status of deployment " + this.deploymentId);
                            }
                            hasSeenDeployment = true;
                            listPodsEoc.finish();
                            obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
                            PortForwardExposition.logger.trace((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$1(com.google.gson.JsonObject ), ()Ljava/lang/Object;)((JsonObject)obj));
                            podStatuses = KubernetesExecUtils.getPodStatusesCount(obj);
                            podIds = Sets.newHashSet(podStatuses.getRunningPods());
                            PortForwardExpositionHandler.this.logLine("Pod running list is " + JSON.log((Object)podIds));
                            existing = Sets.newHashSet(this.pods.keySet());
                            deadPods = Sets.difference((Set)existing, (Set)podIds);
                            newPods = Sets.difference((Set)podIds, (Set)existing);
                            for (String pod : deadPods) {
                                PortForwardExpositionHandler.this.logLine("Pod " + pod + " died");
                                t = this.pods.remove(pod);
                                t.kill();
                            }
                            for (String pod : newPods) {
                                PortForwardExpositionHandler.this.logLine("Pod " + pod + " arrived");
                                t = new PodPortForwarderThread(pod, this.portForwardingChange, this);
                                t.start();
                                this.pods.put(pod, t);
                            }
                        }
                        catch (Exception e) {
                            PortForwardExposition.logger.warn((Object)"Port forwarding setup failed", (Throwable)e);
                        }
                        try {
                            e = this.portForwardingChange;
                            // MONITORENTER : e
                            var9_14 = PortForwardExpositionHandler.this.backOff.nextBackOffMillis();
                            if (var9_14 < 0L) {
                                PortForwardExposition.logger.warn((Object)"Maximum waiting time reached for Port forwarder, stopping current");
                                this.keepLooping = false;
                                // MONITOREXIT : e
                                break;
                            }
                            PortForwardExposition.logger.info((Object)("Will wait " + var9_14 + " ms"));
                            this.portForwardingChange.wait(var9_14);
                            // MONITOREXIT : e
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            PortForwardExposition.logger.warn((Object)"Interrupted in port forwarder setup loop (wait)", (Throwable)e);
                        }
                    }
                    var8_8 = this.pods.entrySet().iterator();
                    ** GOTO lbl106
                }
                catch (Throwable var23_30) {
                    block33: {
                        break block33;
lbl106:
                        // 3 sources

                        while (var8_8.hasNext() != false) {
                            var9_15 = (Map.Entry)var8_8.next();
                            try {
                                ((PodPortForwarderThread)var9_15.getValue()).kill();
                            }
                            catch (Throwable t) {
                                PortForwardExposition.logger.error((Object)"Failed to kill port forward thread", t);
                            }
                        }
                        return;
                    }
                    var24_31 = this.pods.entrySet().iterator();
                    while (var24_31.hasNext() != false) {
                        e = var24_31.next();
                        try {
                            e.getValue().kill();
                        }
                        catch (Throwable t) {
                            PortForwardExposition.logger.error((Object)"Failed to kill port forward thread", t);
                        }
                    }
                    throw var23_30;
                }
            }

            private static /* synthetic */ Object lambda$run$1(JsonObject obj) {
                return "Pods JSON: " + JSON.prettyLog((Object)obj);
            }

            private static /* synthetic */ String lambda$run$0(Map.Entry entry) {
                return String.format("%s=%s", entry.getKey(), entry.getValue());
            }
        }

        private class PodPortForwarderThread
        extends PortForwardUtils.SinglePortForwarderThread {
            public PodPortForwarderThread(String podId, Object portForwardingChange, PodsPortForwarderThread parent) {
                super(PortForwardExpositionHandler.this.executionId, podId, PortForwardExpositionHandler.this.tmpDir, parent, PortForwardExpositionHandler.this, parent.deploymentId);
            }

            @Override
            protected int getTargetPort() {
                return PortForwardExpositionHandler.this.exposedPort;
            }

            @Override
            protected String getObjectDesc() {
                return "pod " + this.objectId;
            }

            @Override
            protected int getForwardPort() throws IOException {
                return DKUNetUtils.findUnusedPort();
            }

            @Override
            protected ProcessBuilder getKubectlProcessBuilder(int forwardPort) throws IOException, InterruptedException {
                ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(PortForwardExpositionHandler.this.authCtx, PortForwardExpositionHandler.this.projectKey, PortForwardExpositionHandler.this.containerConfig, false, "port-forward", "pods/" + this.objectId, Integer.toString(forwardPort) + ":" + Integer.toString(PortForwardExpositionHandler.this.exposedPort)));
                pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(PortForwardExpositionHandler.this.containerConfig));
                return pb;
            }
        }
    }

    public static class PortForwardExpositionParams
    implements ExpositionParams {
    }
}

