/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras;

import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksExperiment;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModel;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkFutureThreads;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.GCPProject;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class ExternalInfrasService {
    public FutureResponse<List<ExternalInfraEndpoint>> listSageMakerEndpointSummaries(AuthCtx authCtx, String project, String region, String connection) throws Exception {
        return SageMakerUtils.startListEndpoints_NT((DSSAuthCtx)authCtx, project, connection, region, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    public FutureResponse<List<ExternalInfraEndpoint>> listAzureMLEndpoints(AuthCtx authCtx, String authConnectionName, String project, String workspace, String resourceGroup, String subscription) throws Exception {
        return AzureMLUtils.startListEndpoints_NT((DSSAuthCtx)authCtx, authConnectionName, project, workspace, resourceGroup, subscription, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    public FutureResponse<List<ExternalInfraEndpoint>> listVertexAIEndpoints(AuthCtx authCtx, String project, String region, String connectionName) throws Exception {
        return VertexAIUtils.startListEndpoints_NT((DSSAuthCtx)authCtx, project, region, connectionName);
    }

    public FutureResponse<List<GCPProject>> listVertexAIProjects(AuthCtx authCtx, String connection) throws Exception {
        return VertexAIUtils.startListProjects_NT((DSSAuthCtx)authCtx, connection);
    }

    public FutureResponse<GCPProject> getVertexAIProject(AuthCtx authCtx, String projectId, String connection) throws Exception {
        return VertexAIUtils.startGetProject_NT((DSSAuthCtx)authCtx, projectId, connection);
    }

    public FutureResponse<List<DatabricksRegisteredModelVersion>> listDatabricksRegisteredModelVersions(AuthCtx authCtx, String connectionName, String modelName, boolean useUnityCatalog) throws Exception {
        return DatabricksUtils.startListRegisteredModelVersions_NT((DSSAuthCtx)authCtx, connectionName, modelName, useUnityCatalog, List.of());
    }

    public FutureResponse<List<DatabricksRegisteredModel>> listDatabricksRegisteredModels(AuthCtx authCtx, String connectionName, boolean useUnityCatalog) throws Exception {
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable(authCtx, connectionName);
        return DatabricksUtils.startListRegisteredModels_NT((DSSAuthCtx)authCtx, connection, useUnityCatalog, List.of());
    }

    public FutureResponse<List<ExternalInfraEndpoint>> listDatabricksEndpoints(AuthCtx authCtx, String connectionName) throws Exception {
        return DatabricksUtils.startListEndpoints_NT((DSSAuthCtx)authCtx, connectionName, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    public FutureResponse<List<DatabricksExperiment>> listDatabricksExperiments(AuthCtx authCtx, String connectionName) throws Exception {
        return DatabricksUtils.startListExperiments_NT((DSSAuthCtx)authCtx, connectionName, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }

    public FutureResponse<List<ExternalInfraEndpoint>> listSnowparkEndpoints(AuthCtx authCtx, @Nonnull String connectionName, @Nonnull String database, @Nonnull String schema) throws Exception {
        SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connectionName);
        if (connection == null) {
            throw ErrorContext.icef((String)"Connection '%s' not found.", (Object)connectionName, (Object[])new Object[0]);
        }
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        SnowparkFutureThreads.EndpointsListing endpointsListingFutureThread = new SnowparkFutureThreads.EndpointsListing((DSSAuthCtx)authCtx, connection, database, schema);
        return futureService.runFuture(endpointsListingFutureThread, 0L, new TypeToken<FutureResponse<List<ExternalInfraEndpoint>>>(){});
    }
}

