/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.databricks;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksExperiment;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServedEntity;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksWorkspaceDirectoryObject;
import com.dataiku.dip.externalinfras.databricks.http.get.DatabricksExperimentMetadataResponse;
import com.dataiku.dip.externalinfras.databricks.http.get.DatabricksListWorkspaceDirectoryResponse;
import com.dataiku.dip.externalinfras.databricks.http.patch.DatabricksUpdateServingEndpointTagsRequest;
import com.dataiku.dip.externalinfras.databricks.http.post.DatabricksCreateServingEndpointRequest;
import com.dataiku.dip.externalinfras.databricks.http.post.DatabricksInvokeServingEndpointRequest;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPatch;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicHeader;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatabricksHTTPClient
implements AutoCloseable {
    static final String DATABRICKS_API_BASE_2_0 = "/api/2.0";
    static final String SERVING_ENDPOINTS = "/api/2.0/serving-endpoints";
    static final String SERVING_ENDPOINTS_CONFIG = "/api/2.0/serving-endpoints/%s/config";
    static final String SERVING_ENDPOINTS_TAGS = "/api/2.0/serving-endpoints/%s/tags";
    static final String LIST_EXPERIMENTS = "/api/2.0/mlflow/experiments/list";
    static final String GET_EXPERIMENT_BY_NAME = "/api/2.0/mlflow/experiments/get-by-name";
    static final String DELETE_EXPERIMENT_RUN = "/api/2.0/mlflow/runs/delete";
    static final String GET_ENDPOINT_METRICS = "/api/2.0/serving-endpoints/%s/metrics";
    static final String REGISTRY_MODEL_VERSION_DELETE = "/api/2.0/mlflow/model-versions/delete";
    static final String LIST_WORKSPACE_OBJECTS = "/api/2.0/workspace/list";
    static final String GET_WORKSPACE_OBJECT = "/api/2.0/workspace/get-status";
    static final String DATABRICKS_API_BASE_2_1 = "/api/2.1";
    static final String UNITY_CATALOG_MODELS = "/api/2.1/unity-catalog/models/%s/versions/%s";
    static final String INVOKE_ENDPOINT = "/serving-endpoints/%s/invocations";
    final String host;
    final CloseableHttpClient httpClient;
    private final PoolingHttpClientConnectionManager cm;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.databricks.client");

    public DatabricksHTTPClient(String host, ProxySettings proxySettings, String credentials, int connectTimeout, int socketTimeout) {
        this.host = host;
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (HttpClientBuilder)builder);
        this.cm = new PoolingHttpClientConnectionManager();
        this.cm.setMaxTotal(10);
        this.cm.setDefaultMaxPerRoute(10);
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        builder.setDefaultRequestConfig(rc);
        builder.addInterceptorFirst(DatabricksUtils.getRateLimitingHttpInterceptor());
        BasicHeader header = new BasicHeader("Authorization", String.format("Bearer %s", credentials));
        ArrayList headers = Lists.newArrayList((Object[])new Header[]{header});
        builder.setDefaultHeaders((Collection)headers);
        builder.setConnectionManager((HttpClientConnectionManager)this.cm);
        this.httpClient = builder.build();
    }

    @Override
    public void close() {
        try {
            logger.infoV("Closing Databricks HttpClient and connection pool manager.", new Object[0]);
            this.httpClient.close();
            this.cm.close();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to close Databricks HttpClient: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    @Nullable
    public DatabricksWorkspaceDirectoryObject getWorkspaceObject(@Nonnull String objectPath) throws IOException, URISyntaxException {
        URI uri = new URIBuilder(new URI(this.host + GET_WORKSPACE_OBJECT)).setParameter("path", objectPath).build();
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(uri));){
            DatabricksWorkspaceDirectoryObject databricksWorkspaceDirectoryObject = this.handleJSONResp(uri.toString(), (HttpResponse)resp, new TypeToken<DatabricksWorkspaceDirectoryObject>(){}, true);
            return databricksWorkspaceDirectoryObject;
        }
    }

    @Nonnull
    public List<DatabricksWorkspaceDirectoryObject> listWorkspaceObjects(@Nonnull String targetDirectoryPath) throws IOException, URISyntaxException {
        URI uri = new URIBuilder(new URI(this.host + LIST_WORKSPACE_OBJECTS)).setParameter("path", targetDirectoryPath).build();
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(uri));){
            List<DatabricksWorkspaceDirectoryObject> objects = this.handleJSONResp((String)uri.toString(), (HttpResponse)resp, new TypeToken<DatabricksListWorkspaceDirectoryResponse>(){}).objects;
            List<DatabricksWorkspaceDirectoryObject> list = objects.stream().sorted().collect(Collectors.toList());
            return list;
        }
    }

    @Nonnull
    public List<DatabricksServingEndpoint> listServingEndpoints() throws IOException, URISyntaxException {
        URI servingEndpointsList = new URI(this.host + SERVING_ENDPOINTS);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(servingEndpointsList));){
            List<DatabricksServingEndpoint> list = this.handleJSONResp((String)servingEndpointsList.toString(), (HttpResponse)resp, new TypeToken<DatabricksServingEndpointList>(){}).endpoints;
            return list;
        }
    }

    @Nonnull
    public DatabricksServingEndpointDetails createServingEndpoint(String name, DatabricksServedEntity servedEntity, List<SimpleKeyValue> tags) throws IOException, URISyntaxException {
        URI servingEndpointsCreate = new URI(this.host + SERVING_ENDPOINTS);
        HttpPost req = new HttpPost(servingEndpointsCreate);
        DatabricksCreateServingEndpointRequest body = new DatabricksCreateServingEndpointRequest(name, servedEntity, tags);
        HttpEntity httpEntity = JSON.toHttpEntity((Object)body);
        req.setEntity(httpEntity);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            DatabricksServingEndpointDetails databricksServingEndpointDetails = this.handleJSONResp(servingEndpointsCreate.toString(), (HttpResponse)resp, new TypeToken<DatabricksServingEndpointDetails>(){});
            return databricksServingEndpointDetails;
        }
    }

    @Nonnull
    public DatabricksServingEndpointDetails updateServingEndpointConfig(String endpointName, DatabricksServedEntity servedEntity) throws IOException, URISyntaxException {
        URI servingEndpointsUpdate = new URI(this.host + String.format(SERVING_ENDPOINTS_CONFIG, endpointName));
        HttpPut req = new HttpPut(servingEndpointsUpdate);
        DatabricksCreateServingEndpointRequest.Config body = new DatabricksCreateServingEndpointRequest.Config(servedEntity);
        HttpEntity httpEntity = JSON.toHttpEntity((Object)body);
        req.setEntity(httpEntity);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            DatabricksServingEndpointDetails databricksServingEndpointDetails = this.handleJSONResp(servingEndpointsUpdate.toString(), (HttpResponse)resp, new TypeToken<DatabricksServingEndpointDetails>(){});
            return databricksServingEndpointDetails;
        }
    }

    @Nonnull
    public JsonElement updateServingEndpointTags(String endpointName, DatabricksUpdateServingEndpointTagsRequest tagsRequest) throws IOException, URISyntaxException {
        URI servingEndpointsUpdate = new URI(this.host + String.format(SERVING_ENDPOINTS_TAGS, endpointName));
        HttpPatch req = new HttpPatch(servingEndpointsUpdate);
        HttpEntity httpEntity = JSON.toHttpEntity((Object)tagsRequest);
        req.setEntity(httpEntity);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            JsonElement jsonElement = this.handleJSONResp(servingEndpointsUpdate.toString(), (HttpResponse)resp, new TypeToken<JsonElement>(){});
            return jsonElement;
        }
    }

    public void deleteServingEndpoint(@Nonnull String name) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.host + SERVING_ENDPOINTS);
        List pathSegments = uriBuilder.getPathSegments();
        pathSegments.add(name);
        URI servingEndpointDelete = uriBuilder.setPathSegments(pathSegments).build();
        HttpDelete req = new HttpDelete(servingEndpointDelete);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            this.handleJSONResp(servingEndpointDelete.toString(), (HttpResponse)resp, new TypeToken<Object>(){}, true);
        }
    }

    @Nonnull
    public JsonObject invokeServingEndpoint(String name, DatabricksInvokeServingEndpointRequest request) throws URISyntaxException, IOException {
        URI invokeServingEndpoint = new URI(this.host + String.format(INVOKE_ENDPOINT, name));
        HttpPost req = new HttpPost(invokeServingEndpoint);
        HttpEntity httpEntity = JSON.toHttpEntity((Object)request);
        req.setEntity(httpEntity);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            JsonObject jsonObject = this.handleJSONResp(invokeServingEndpoint.toString(), (HttpResponse)resp, new TypeToken<JsonObject>(){});
            return jsonObject;
        }
    }

    public String getEndpointMonitoringMetrics(String endpointName) throws URISyntaxException, IOException {
        URI endpointMetrics = new URI(this.host + String.format(GET_ENDPOINT_METRICS, endpointName));
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(endpointMetrics));){
            String string = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Nullable
    public DatabricksExperimentMetadataResponse getExperimentByName(String experimentName) throws URISyntaxException, IOException {
        URI getExperimentByName = new URIBuilder(new URI(this.host + GET_EXPERIMENT_BY_NAME)).setParameter("experiment_name", experimentName).build();
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(getExperimentByName));){
            DatabricksExperimentMetadataResponse databricksExperimentMetadataResponse = this.handleJSONResp(getExperimentByName.toString(), (HttpResponse)resp, new TypeToken<DatabricksExperimentMetadataResponse>(){}, true);
            return databricksExperimentMetadataResponse;
        }
    }

    public void deleteExperimentRun(String runId) throws URISyntaxException, IOException {
        URI getExperimentByName = new URI(this.host + DELETE_EXPERIMENT_RUN);
        HttpPost request = new HttpPost(getExperimentByName);
        JsonObject body = new JsonObject();
        body.addProperty("run_id", runId);
        HttpEntity httpEntity = JSON.toHttpEntity((Object)body);
        request.setEntity(httpEntity);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)request);){
            this.handleJSONResp(getExperimentByName.toString(), (HttpResponse)resp, new TypeToken<Object>(){}, true);
        }
    }

    @Nonnull
    public List<DatabricksExperiment> listExperiments() throws IOException, URISyntaxException {
        ArrayList<DatabricksExperiment> ret = new ArrayList<DatabricksExperiment>();
        String nextToken = null;
        int currentPage = 0;
        int MAX_PAGES = 10;
        do {
            ++currentPage;
            URIBuilder uriBuilder = new URIBuilder(new URI(this.host + LIST_EXPERIMENTS));
            if (StringUtils.isNotBlank(nextToken)) {
                logger.traceV("Requesting next experiment page with token %s. Current page is %d (starting from 1)", new Object[]{nextToken, currentPage});
                uriBuilder.addParameter("page_token", nextToken);
            }
            URI experimentsListURI = uriBuilder.build();
            try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(experimentsListURI));){
                DatabricksExperimentList parsedResp = this.handleJSONResp(experimentsListURI.toString(), (HttpResponse)resp, new TypeToken<DatabricksExperimentList>(){});
                ret.addAll(parsedResp.experiments);
                nextToken = parsedResp.nextPageToken;
            }
        } while (StringUtils.isNotBlank((String)nextToken) && currentPage < 10);
        if (currentPage >= 10 && StringUtils.isNotBlank((String)nextToken)) {
            logger.warnV("Hit max page limit %d when listing experiments", new Object[]{10});
        }
        return ret;
    }

    @Nullable
    public DatabricksServingEndpointDetails getServingEndpointDetails(String name) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.host + SERVING_ENDPOINTS);
        List pathSegments = uriBuilder.getPathSegments();
        pathSegments.add(name);
        URI servingEndpointDetails = uriBuilder.setPathSegments(pathSegments).build();
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)new HttpGet(servingEndpointDetails));){
            DatabricksServingEndpointDetails databricksServingEndpointDetails = this.handleJSONResp(servingEndpointDetails.toString(), (HttpResponse)resp, new TypeToken<DatabricksServingEndpointDetails>(){}, true);
            return databricksServingEndpointDetails;
        }
    }

    public void deleteModelVersionInUnityCatalog(String name, String version) throws IOException, URISyntaxException {
        URI modelVersionDelete = new URI(this.host + String.format(UNITY_CATALOG_MODELS, name, version));
        HttpDelete req = new HttpDelete(modelVersionDelete);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            this.handleJSONResp(modelVersionDelete.toString(), (HttpResponse)resp, new TypeToken<Object>(){}, true);
        }
    }

    public void deleteModelVersionInRegistry(String name, String version) throws IOException, URISyntaxException {
        URI modelVersionDelete = new URIBuilder(new URI(this.host + REGISTRY_MODEL_VERSION_DELETE)).setParameter("name", name).setParameter("version", version).build();
        HttpDelete req = new HttpDelete(modelVersionDelete);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
            this.handleJSONResp(modelVersionDelete.toString(), (HttpResponse)resp, new TypeToken<Object>(){}, true);
        }
    }

    private <T> T handleJSONResp(String requestURI, HttpResponse resp, @Nonnull TypeToken<T> typeToken) throws IOException {
        return this.handleJSONResp(requestURI, resp, typeToken, false);
    }

    @Nullable
    private <T> T handleJSONResp(String requestURI, HttpResponse resp, @Nonnull TypeToken<T> typeToken, boolean handleNotFound) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        String ret = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        logger.debugV("Queried %s. Got reply: %s", new Object[]{requestURI, ret});
        if (code == 200 || code == 201) {
            try {
                return (T)JSON.parse((String)ret, typeToken);
            }
            catch (Exception e) {
                logger.error((Object)("Error while parsing the response '" + ret + "' when querying " + requestURI), (Throwable)e);
                throw e;
            }
        }
        if (handleNotFound && code == 404) {
            logger.warn((Object)("Received Not Found response message when querying " + requestURI + ", httpcode: " + code));
            return null;
        }
        logger.error((Object)("Received error when querying " + requestURI + " httpcode " + code));
        logger.error((Object)("Body " + ret));
        throw new IOException(String.format("Method '%s' failed with code '%s' and content %s", requestURI, code, ret));
    }

    private static class DatabricksServingEndpointList {
        @Nonnull
        public List<DatabricksServingEndpoint> endpoints = new ArrayList<DatabricksServingEndpoint>();

        private DatabricksServingEndpointList() {
        }
    }

    private static class DatabricksExperimentList {
        @Nonnull
        public List<DatabricksExperiment> experiments = new ArrayList<DatabricksExperiment>();
        @SerializedName(value="next_page_token")
        public String nextPageToken;

        private DatabricksExperimentList() {
        }
    }
}

