/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.databricks.datamodel;

import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.StringUtils;

public class DatabricksServedEntityHead {
    public String name;
    @SerializedName(value="entity_name")
    public String entityName;
    @SerializedName(value="entity_version")
    public String entityVersion;
    @SerializedName(value="external_model")
    public DatabricksExternalModelHead externalModel;
    @SerializedName(value="foundation_model")
    public DatabricksFoundationModelHead foundationModel;

    public boolean isExternalModel() {
        return null != this.externalModel;
    }

    public boolean isFoundationModel() {
        return null != this.foundationModel;
    }

    public boolean isClassicalModel() {
        return StringUtils.isNotBlank((String)this.entityName);
    }

    public DatabricksServedModelType getModelType() {
        if (this.isExternalModel()) {
            return DatabricksServedModelType.EXTERNAL_MODEL;
        }
        if (this.isFoundationModel()) {
            return DatabricksServedModelType.FOUNDATION_MODEL;
        }
        if (this.isClassicalModel()) {
            return DatabricksServedModelType.CLASSICAL_MODEL;
        }
        return DatabricksServedModelType.UNKNOWN;
    }

    public static class DatabricksExternalModelHead {
        public String provider;
        public String name;
    }

    public static class DatabricksFoundationModelHead {
        public String name;
        @SerializedName(value="display_name")
        public String displayName;
        public String docs;
        public String description;
    }

    public static enum DatabricksServedModelType {
        FOUNDATION_MODEL,
        EXTERNAL_MODEL,
        CLASSICAL_MODEL,
        UNKNOWN;

    }
}

