/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.pivot.frontend.color.Color;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TableColoringHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.coloring");

    public static <T> ColorFormat<T> computeCellColorFormat(Row row, String columnName, String value, ColumnFactory cf, TableColoring coloring, ColorFormatFactory<T> cff, ColoringDefinition.ColoringGroup coloringGroup, TableColoringService coloringService, MemTable table) {
        ColoringDefinition.ColumnRules columnRules;
        if (coloring == null || columnName == null) {
            return null;
        }
        List filterDescs = null;
        List colorScaleSample = null;
        if (coloring.scheme == ColoringDefinition.TableColoringScheme.COLORING_GROUPS) {
            if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.RULES) {
                if (coloringGroup.scope == ColoringDefinition.ColoringGroupScope.COLUMNS) {
                    filterDescs = coloringGroup.rulesGroup.getBasedOnColumnFilterDescs(columnName);
                } else if (coloringGroup.scope == ColoringDefinition.ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN) {
                    filterDescs = coloringGroup.rulesGroup.getBasedOnColumnFilterDescs(coloringGroup.basedOnColumnName);
                }
            } else if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.COLOR_SCALE && coloringGroup.colorScaleDef != null) {
                if (coloringGroup.scope == ColoringDefinition.ColoringGroupScope.COLUMNS && coloringGroup.targetedColumnNames != null && coloringGroup.targetedColumnNames.size() > 1) {
                    return null;
                }
                colorScaleSample = coloringGroup.colorScaleDef.sample;
            }
        } else if (coloring.individualColumnsRules != null && (columnRules = (ColoringDefinition.ColumnRules)coloring.individualColumnsRules.stream().filter(r -> columnName.equals(r.column) && r.rulesDesc != null && !r.rulesDesc.isEmpty() && ((FilterDesc)r.rulesDesc.get((int)0)).enabled).findFirst().orElse(null)) != null) {
            filterDescs = columnRules.rulesDesc;
        }
        if (filterDescs != null) {
            FilterDesc filterDesc;
            List<Expression> expressions = TableColoringHelper.buildExpressions(filterDescs, cf);
            int matchedRuleIndex = TableColoringHelper.findFirstMatchingRule(expressions, row);
            if (matchedRuleIndex != -1 && (filterDesc = (FilterDesc)filterDescs.get(matchedRuleIndex)) != null && filterDesc.uiData != null && filterDesc.uiData.color != null) {
                switch (filterDesc.uiData.color.styleClass) {
                    case "shaker-color-rule--red-background": {
                        return cff.createCellFormat(null, "#F0B8BF");
                    }
                    case "shaker-color-rule--orange-background": {
                        return cff.createCellFormat(null, "#F9C69B");
                    }
                    case "shaker-color-rule--green-background": {
                        return cff.createCellFormat(null, "#A5D6A7");
                    }
                    case "shaker-color-rule--red-text": {
                        return cff.createCellFormat("#F44336", null);
                    }
                    case "shaker-color-rule--orange-text": {
                        return cff.createCellFormat("#F28C38", null);
                    }
                    case "shaker-color-rule--green-text": {
                        return cff.createCellFormat("#29AF5D", null);
                    }
                    case "shaker-color-rule--custom": {
                        return cff.createCellFormat(filterDesc.uiData.color.styleCustomFontColor, filterDesc.uiData.color.styleCustomBackgroundColor);
                    }
                }
                return null;
            }
        } else if (colorScaleSample != null && table != null) {
            MemColumn column = table.getColumn(columnName);
            if (column == null) {
                return null;
            }
            int maxColoredBins = colorScaleSample.size() > 0 ? colorScaleSample.size() : 11;
            float binFloat = coloringService.getColorBin(coloring.valueColoringMode, column, value, maxColoredBins);
            int bin = (int)binFloat;
            if (bin > 0 && bin <= colorScaleSample.size()) {
                if (column.analysisForColoring != null && bin < colorScaleSample.size()) {
                    String backgroundColor = Color.getLerpRGB((String)colorScaleSample.get(bin - 1), (String)colorScaleSample.get(bin), binFloat - (float)bin);
                    return cff.createCellFormat(Color.getFontContrastColor(backgroundColor), backgroundColor);
                }
                String backgroundColor = (String)colorScaleSample.get(bin - 1);
                return cff.createCellFormat(Color.getFontContrastColor(backgroundColor), backgroundColor);
            }
            if (bin == -3) {
                return cff.createCellFormat("#666666", "#DEDEDE");
            }
            if (bin == -1) {
                return cff.createCellFormat("#666666", "#DDDDDD");
            }
        }
        return null;
    }

    public static List<Expression> buildExpressions(List<FilterDesc> filterDescs, ColumnFactory cf) {
        return filterDescs.stream().map(filter -> {
            try {
                String grel = FilterDescUtils.translateAstToGrel(filter);
                Expression expr = new Expression(grel);
                expr.setColumnFactory(cf);
                return expr;
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse rule");
                return null;
            }
        }).collect(Collectors.toList());
    }

    public static int findFirstMatchingRule(List<Expression> expressions, Row row) {
        for (int exprIndex = 0; exprIndex < expressions.size(); ++exprIndex) {
            Expression expr = expressions.get(exprIndex);
            if (expr == null) continue;
            try {
                Object res = expr.evaluate(row);
                if (!(res instanceof Boolean) || !Boolean.TRUE.equals(res)) continue;
                return exprIndex;
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to apply rule");
            }
        }
        return -1;
    }

    public static interface ColorFormatFactory<T> {
        public ColorFormat<T> createCellFormat(@Nullable String var1, @Nullable String var2);
    }

    public static abstract class ColorFormat<T> {
        @Nullable
        public final T textColor;
        @Nullable
        public final T backgroundColor;
        private final int hashCode;

        public ColorFormat(@Nullable T textColor, @Nullable T backgroundColor) {
            this.textColor = textColor;
            this.backgroundColor = backgroundColor;
            this.hashCode = Objects.hash(textColor, backgroundColor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColorFormat that = (ColorFormat)o;
            return Objects.equals(this.textColor, that.textColor) && Objects.equals(this.backgroundColor, that.backgroundColor);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

