/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;

public class AvroReusableRow
extends Encoder {
    private static final Action WRITE_NULL_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeNull();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeNull()");
        }
    };
    private static final Action WRITE_TRUE_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeBoolean(true);
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeBoolean(true)");
        }
    };
    private static final Action WRITE_FALSE_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeBoolean(false);
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeBoolean(false)");
        }
    };
    private static final Action WRITE_ARRAY_START_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeArrayStart();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeArrayStart()");
        }
    };
    private static final Action WRITE_START_ITEM_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.startItem();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("startItem()");
        }
    };
    private static final Action WRITE_ARRAY_END_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeArrayEnd();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeArrayEnd()");
        }
    };
    private static final Action WRITE_MAP_START_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeMapStart();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeMapStart()");
        }
    };
    private static final Action WRITE_MAP_END_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.writeMapEnd();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("writeMapEnd()");
        }
    };
    private static final Action FLUSH_ACTION = new Action(){

        @Override
        public void runOn(Encoder encoder) throws IOException {
            encoder.flush();
        }

        @Override
        public void logOn(StringBuilder sb) {
            sb.append("flush()");
        }
    };
    private List<Action> actionQueue = new ArrayList<Action>();

    public void replay(Encoder encoder) throws IOException {
        for (Action action : this.actionQueue) {
            action.runOn(encoder);
        }
    }

    public void clear() {
        this.actionQueue.clear();
    }

    public void writeNull() throws IOException {
        this.actionQueue.add(WRITE_NULL_ACTION);
    }

    public void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.actionQueue.add(WRITE_TRUE_ACTION);
        } else {
            this.actionQueue.add(WRITE_FALSE_ACTION);
        }
    }

    public void writeInt(final int i) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeInt(i);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeInt(" + i + ")");
            }
        });
    }

    public void writeLong(final long l) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeLong(l);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeLong(" + l + ")");
            }
        });
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (Action action : this.actionQueue) {
            action.logOn(sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void writeFloat(final float v) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeFloat(v);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeFloat(" + v + ")");
            }
        });
    }

    public void writeDouble(final double v) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeDouble(v);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeDouble(" + v + ")");
            }
        });
    }

    public void writeString(final Utf8 utf8) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeString(utf8);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeString(" + utf8.toString() + ")");
            }
        });
    }

    public void writeBytes(final ByteBuffer byteBuffer) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeBytes(byteBuffer);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeBytes(ByteBuffer ...)");
            }
        });
    }

    public void writeBytes(final byte[] bytes, final int i, final int i2) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeBytes(bytes, i, i2);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeBytes(bytes...)");
            }
        });
    }

    public void writeFixed(final byte[] bytes, final int i, final int i2) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeFixed(bytes, i, i2);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeFixed(...)");
            }
        });
    }

    public void writeEnum(final int i) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeEnum(i);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeEnum(" + i + ")");
            }
        });
    }

    public void writeArrayStart() throws IOException {
        this.actionQueue.add(WRITE_ARRAY_START_ACTION);
    }

    public void setItemCount(final long l) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.setItemCount(l);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("setItemCount(" + l + ")");
            }
        });
    }

    public void startItem() throws IOException {
        this.actionQueue.add(WRITE_START_ITEM_ACTION);
    }

    public void writeArrayEnd() throws IOException {
        this.actionQueue.add(WRITE_ARRAY_END_ACTION);
    }

    public void writeMapStart() throws IOException {
        this.actionQueue.add(WRITE_MAP_START_ACTION);
    }

    public void writeMapEnd() throws IOException {
        this.actionQueue.add(WRITE_MAP_END_ACTION);
    }

    public void writeIndex(final int i) throws IOException {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(Encoder encoder) throws IOException {
                encoder.writeIndex(i);
            }

            @Override
            public void logOn(StringBuilder sb) {
                sb.append("writeIndex(" + i + ")");
            }
        });
    }

    public void flush() throws IOException {
        this.actionQueue.add(FLUSH_ACTION);
    }

    public static interface Action {
        public void runOn(Encoder var1) throws IOException;

        public void logOn(StringBuilder var1);
    }
}

