/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.export.ExportOption;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatMeta;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaFormatsService
extends CustomJavaElementService<CustomJavaFormatDesc, LoadedJavaFormat> {
    @Override
    public String getFolderName() {
        return "java-formats";
    }

    @Override
    public String getPrefix() {
        return "jformat";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "jformat_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomJavaFormatDesc> getDescClass() {
        return CustomJavaFormatDesc.class;
    }

    @Override
    public Class<LoadedJavaFormat> getLoadedDescClass() {
        return LoadedJavaFormat.class;
    }

    @Override
    protected void removeElement(LoadedJavaFormat loaded) {
        FormatFactory.deregisterFormatType(loaded.getType());
    }

    @Override
    protected LoadedJavaFormat load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedJavaFormat loaded = new LoadedJavaFormat(elementType, pluginId, elementId, (CustomJavaFormatDesc)JSON.parseFile((File)file, CustomJavaFormatDesc.class));
        FormatFactory.registerFormatType(new CustomJavaFormatMeta(loaded, this));
        return loaded;
    }

    @Override
    protected String getCodeExtension(LoadedJavaFormat desc) {
        return ".java";
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomJavaFormatDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomJavaFormatsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.formatClass)) {
                    this.withFatal("Java plugin formats require a \"formatClass\" field.");
                }
                if (desc.exportOptions != null) {
                    for (ExportOption o : desc.exportOptions) {
                        if (o == null) {
                            this.withWarning("Null export option. Check there is no trailing comma.");
                            continue;
                        }
                        if (!StringUtils.isBlank((String)o.id)) continue;
                        this.withFatal("Export option has no id.");
                    }
                }
                return this.messages;
            }
        }.validate();
    }
}

