/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.formats.custom.CustomFormatPythonKernel;
import com.dataiku.dip.formats.custom.CustomFormatSchemaProvider;
import com.dataiku.dip.formats.custom.CustomPythonFormatExtractor;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.input.stream.DecodedInputStreamFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

public class CustomPythonFormatWithSchemaExtractor
extends CustomPythonFormatExtractor
implements CustomFormatSchemaProvider {
    private static Logger logger = Logger.getLogger((String)"dku.formats.custom.python.input.with_schema");

    public CustomPythonFormatWithSchemaExtractor(AuthCtx authCtx, String projectKey, JsonObject config, LoadedPythonFormat loaded, CustomPythonFormatsService service) {
        super(authCtx, projectKey, config, loaded, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema detectSchema(StreamsInputSplit split) throws Exception {
        EnrichedInputStream stream;
        Schema schema = null;
        while (schema == null && (stream = split.nextStream()) != null) {
            InputStream rawStream;
            if (stream.isArchive()) {
                ArchiveInputStream archiveStream = stream.archiveContent();
                try {
                    ArchiveEntry entry;
                    while (schema == null && (entry = archiveStream.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        logger.info((Object)("  Start archive stream entry : " + stream.desc() + "/" + entry.getName() + " size= " + entry.getSize()));
                        if (FSDatasetUtils.isBadFile(entry.getName())) continue;
                        this.rc.setFile(stream.desc() + "/" + entry.getName());
                        schema = this.doExtractSchema((InputStream)new CloseShieldInputStream((InputStream)archiveStream));
                    }
                    continue;
                }
                finally {
                    if (archiveStream != null) {
                        archiveStream.close();
                    }
                    continue;
                }
            }
            if (stream.getCompression() == EnrichedInputStream.Compression.GZIP || stream.getCompression() == EnrichedInputStream.Compression.BZIP2 || stream.getCompression() == EnrichedInputStream.Compression.SNAPPY || stream.getCompression() == EnrichedInputStream.Compression.DEFLATE || stream.getCompression() == EnrichedInputStream.Compression.LZO) {
                InputStream decompressedStream;
                rawStream = stream.rawHeadStream(this.limit != null ? this.limit.maxBytes : -1L);
                try {
                    decompressedStream = new DecodedInputStreamFactory().addDecoding(stream.getCompression(), rawStream);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly((InputStream)rawStream);
                    throw e;
                }
                try {
                    this.rc.setFile(stream.desc());
                    schema = this.doExtractSchema(decompressedStream);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)decompressedStream);
                    continue;
                }
            }
            if (stream.getCompression() == EnrichedInputStream.Compression.NONE) {
                rawStream = stream.rawHeadStream(this.limit != null ? this.limit.maxBytes : -1L);
                logger.info((Object)("Start uncompressed stream : " + stream.desc()));
                try {
                    this.rc.setFile(stream.desc());
                    schema = this.doExtractSchema(rawStream);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)rawStream);
                    continue;
                }
            }
            throw new NotImplementedException();
        }
        return schema;
    }

    protected Schema doExtractSchema(InputStream is) throws Exception {
        String secret = SecretKeyGenerator.generate((int)16);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        this.link = new SingleCommandKernelLink(secret, dssPortRange);
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.loaded.ownerPluginId);
        this.kernel = new CustomFormatPythonKernel(this.authCtx, this.link, this.service.getResourceFolder(this.loaded.getType()), this.service.getLibFolder(this.loaded.getType()), this.projectKey, envName);
        this.kernel.start();
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.service.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        String code = this.service.getCode(this.loaded.getType());
        try {
            Schema detected = (Schema)this.link.execute((Object)new CustomFormatPythonKernel.PythonCommand("schema", code, this.schema, expandedPluginSettings.config, expandedPluginSettings.pluginConfig), (InputStream)new BufferedInputStream(is, 0x100000), Schema.class, "Failed to detect schema");
            if (detected.columns.size() == 1 && "__dku_empty_schema__".equals(((SchemaColumn)detected.columns.get(0)).getName())) {
                Schema schema = null;
                return schema;
            }
            Schema schema = detected;
            return schema;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        finally {
            logger.info((Object)"Cleaning up python worker");
            this.link.close();
            this.kernel.killWithoutMercy();
        }
    }
}

