/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.formats.custom.CustomFormatPythonKernel;
import com.dataiku.dip.formats.custom.CustomPythonFormatDesc;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomPythonOutputFormatter
implements OutputFormatter {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final CSVOutputFormatter formatter;
    private final JsonObject config;
    private final LoadedPythonFormat loaded;
    private final CustomPythonFormatsService service;
    private SingleCommandKernelLink link;
    private CustomFormatPythonKernel kernel;
    private OutputStream csvOutputStream;
    private Schema schema;
    private SingleCommandKernelLink.IOCallable<Void> commandResult;
    private static Logger logger = Logger.getLogger((String)"dku.formats.custom.output");

    public CustomPythonOutputFormatter(AuthCtx authCtx, String projectKey, JsonObject config, LoadedPythonFormat loaded, CustomPythonFormatsService service) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.service = service;
        this.formatter = this.getCsvWriter();
    }

    private CSVOutputFormatter getCsvWriter() {
        CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
        config.setSeparatorStr(",");
        config.parseHeaderRow = false;
        config.normalizeBooleans = false;
        return new CSVOutputFormatter(config);
    }

    public String getExtension() {
        if (((CustomPythonFormatDesc)this.loaded.getDesc()).mime != null && StringUtils.isNotBlank((String)((CustomPythonFormatDesc)this.loaded.getDesc()).mime.extension)) {
            return ((CustomPythonFormatDesc)this.loaded.getDesc()).mime.extension;
        }
        return ".bin";
    }

    public void header(ColumnFactory cf, OutputStream os) throws Exception {
        String secret = SecretKeyGenerator.generate((int)16);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        this.link = new SingleCommandKernelLink(secret, dssPortRange);
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.loaded.ownerPluginId);
        this.kernel = new CustomFormatPythonKernel(this.authCtx, this.link, this.service.getResourceFolder(this.loaded.getType()), this.service.getLibFolder(this.loaded.getType()), this.projectKey, envName);
        this.kernel.start();
        PipedInputStream pis = new PipedInputStream(0x100000);
        this.csvOutputStream = new PipedOutputStream(pis);
        this.formatter.header(cf, this.csvOutputStream);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.service.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        String code = this.service.getCode(this.loaded.getType());
        try {
            this.commandResult = this.link.executeStreamAsync((Object)new CustomFormatPythonKernel.PythonCommand("write", code, this.schema, expandedPluginSettings.config, expandedPluginSettings.pluginConfig), (InputStream)pis, os);
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (IOException e) {
            throw new SocketBlockLinkIOException("Failed to start formatting", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel);
        }
        logger.info((Object)"Python worker started");
    }

    public void format(Row row, ColumnFactory cf, OutputStream os) throws Exception {
        try {
            this.formatter.format(row, cf, this.csvOutputStream);
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (IOException e) {
            throw new SocketBlockLinkIOException("Failed to format row", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void footer(ColumnFactory cf, OutputStream os) throws Exception {
        block11: {
            try {
                this.formatter.footer(cf, this.csvOutputStream);
                logger.info((Object)"Python worker closing");
                if (this.commandResult != null) {
                    try {
                        this.commandResult.call();
                    }
                    catch (Throwable throwable) {
                        SecretProtectedKernelLink.AcknowledgeResponse ack = this.link.acknowledgeLastCall((DSSKernelBase)this.kernel, null, "Failed during remote write");
                        logger.info((Object)("Wrote " + ack.count + " records"));
                        throw throwable;
                    }
                    SecretProtectedKernelLink.AcknowledgeResponse ack = this.link.acknowledgeLastCall((DSSKernelBase)this.kernel, null, "Failed during remote write");
                    logger.info((Object)("Wrote " + ack.count + " records"));
                    break block11;
                }
                logger.info((Object)"Python streaming not started, nothing to clean");
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail((IDSSKernelBase)this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
            catch (IOException e) {
                throw new SocketBlockLinkIOException("Failed to finish formatting", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel);
            }
            finally {
                logger.info((Object)"Cleaning up python worker");
                if (this.link != null) {
                    this.link.close();
                    this.link = null;
                }
                if (this.kernel != null) {
                    this.kernel.killWithoutMercy();
                    this.kernel = null;
                }
            }
        }
    }

    public void cancel(OutputStream os) throws Exception {
        logger.info((Object)"Aborting python worker");
        if (this.link != null) {
            this.link.close();
            this.link = null;
        }
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(false);
            this.kernel = null;
        }
    }

    public void setOutputSchema(Schema schema) {
        this.formatter.setOutputSchema(schema);
        this.schema = schema;
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.formatter.setWarningsContext(warningsContext);
    }
}

