/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.KeyValueList;
import com.dataiku.dip.coremodel.ParamsWithEncryptedFields;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.FormatConfigException;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.IFormatConfig;
import com.dataiku.dip.formats.excel.ExcelFilesAnalyzer;
import com.dataiku.dip.formats.excel.ExcelOutputFormatter;
import com.dataiku.dip.formats.excel.model.ExcelWorkbook;
import com.dataiku.dip.formats.excel.model.range.ExcelRange;
import com.dataiku.dip.formats.excel.model.range.SheetBasedExcelRange;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.SchemaTweakingExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.com.google.common.collect.BoundType;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.com.google.common.collect.Range;
import com.dataiku.dss.shadelib.com.google.common.collect.Streams;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class ExcelFormatExtractor
extends ArchiveCapableFormatExtractor
implements SchemaTweakingExtractor {
    public static final String SHEETS_COLUMN_DEFAULT = "Sheet Name";
    private static final Pattern RANGE_PATTERN = Pattern.compile("^\\s*(?<lower>\\d*)\\s*-\\s*(?<upper>\\d*)\\s*$");
    public static final FormatMeta<ExcelFormatExtractor, Config> META = new FormatMeta<ExcelFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "excel";
        }

        @Override
        public String getLabel() {
            return "Excel";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.intP("skipRowsBeforeHeader", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SKIP_FIRST_LINES.LABEL", "Skip first lines"), null), ParamDesc.booleanP("parseHeaderRow", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.PARSE_NEXT_LINE_AS_HEADERS.LABEL", "Parse next line as column headers"), null), ParamDesc.intP("skipRowsAfterHeader", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SKIP_NEXT_LINES.LABEL", "Skip next lines"), null), ParamDesc.booleanP("preserveNumberFormatting", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.PRESERVE_NUMBERS_FORMATTING.LABEL", "Preserve numbers formatting"), null), ParamDesc.booleanP("parseDatesToISO", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.PARSE_DATES_TO_ISO.LABEL", "Parse dates to ISO"), this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.PARSE_DATES_TO_ISO.DESCRIPTION", "This option will generate new columns with the suffix \"_iso\". It is strongly advised not to rename the generated ISO columns of the dataset.")), ParamDesc.timezone("assumedTz", this.translate("FORMATS.AlteryxDBFormatConfig.assumedTz", "Assumed time zone"), this.translate("FORMATS.AlteryxDBFormatConfig.assumedTz.TOOLTIP", "When reading Date or Date/Time fields as DSS datetime with tz, timezone to assign to this timezone-less data.")), ParamDesc.booleanP("removeThousandsSeparators", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.REMOVE_THOUSANDS_SEPARATORS.LABEL", "Remove thousands separators"), null), ParamDesc.booleanP("sheetsToColumn", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SHEETS_TO_COLUMN.LABEL", "Add the sheet name as an output column"), null), ParamDesc.password("password", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.PASSWORD.LABEL", "Password"), this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.PASSWORD.DESCRIPTION", "Password to decrypt the Excel file")), ParamDesc.advancedSelect("sheetSelectionMode", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SHEET_SELECTION_MODE.LABEL", "Sheet selection mode"), null, SheetSelectionMode.class), ParamDesc.string("sheets", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SHEETS.LABEL", "Sheet selection"), null), ParamDesc.string("sheetPattern", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SHEET_PATTERN.LABEL", "Sheet RegExp Pattern"), null), ParamDesc.string("sheetRange", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.SHEET_RANGE.LABEL", "Sheet Ranges"), null), ParamDesc.string("cellRange", this.translate("DATASET_FORMAT_TYPE.EXCEL.PARAMS.CELL_RANGE.LABEL", "Cell Range"), "Excel like range: 'A1:C3'. Note: filling this field will disable the Skip first and next lines options.")};
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            Config c2 = (Config)params;
            Config decryptedConfig = new Config(c2);
            decryptedConfig.decryptFields((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class));
            return new ExcelFormatExtractor(decryptedConfig);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            Config c2 = (Config)params;
            Config decryptedConfig = new Config(c2);
            decryptedConfig.decryptFields((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class));
            return new ExcelOutputFormatter(decryptedConfig.rowOverflowStrategy, decryptedConfig.cellOverflowStrategy, decryptedConfig.invalidCellStrategy, decryptedConfig.outputSheetName, decryptedConfig.password);
        }
    };
    private List<?> sheets = null;
    private Pattern compiledSheetPattern = null;
    private List<Range<Integer>> sheetRangeList = null;
    private final Config config;
    private final ZoneId timezoneId;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.format.excel");

    public ExcelFormatExtractor(Config config) {
        Preconditions.checkState((boolean)PoiUtils.isInitialized(), (Object)"POI not initialized");
        if (config.passwordRequired && config.password == null) {
            throw new IllegalStateException("Password is required to read this Excel file");
        }
        if ("".equals(KeyValueList.get(config.customProperties, "xls.ignoreRecordLimit"))) {
            throw new IllegalStateException(String.format("This Excel file is corrupted or too large. If you trust it, set custom property %s to true or contact support to remove this protection.", "xls.ignoreRecordLimit"));
        }
        this.config = config;
        this.timezoneId = StringUtils.isBlank((CharSequence)config.assumedTz) ? TimeZone.getDefault().toZoneId() : TimeZone.getTimeZone(config.assumedTz).toZoneId();
        switch (config.sheetSelectionMode) {
            case NAMES: {
                if (config.sheets != null && config.sheets.startsWith("*")) {
                    this.sheets = Lists.newArrayList((Object[])config.sheets.substring(1).split("\n"));
                    break;
                }
                this.sheets = Params.getFromCSVIntList((String)config.sheets, (String)"0", (String)",");
                break;
            }
            case PATTERN: {
                if (Strings.isNullOrEmpty((String)config.sheetPattern)) {
                    throw new IllegalArgumentException("Sheet matching pattern is absent");
                }
                try {
                    this.compiledSheetPattern = Pattern.compile(config.sheetPattern);
                    break;
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException("Sheet matching regex pattern is invalid: " + config.sheetPattern);
                }
            }
            case RANGES: {
                if (Strings.isNullOrEmpty((String)config.sheetRanges)) {
                    throw new IllegalArgumentException("Index/ranges list is absent");
                }
                this.sheetRangeList = ExcelFormatExtractor.parseSheetRanges(config.sheetRanges);
                if (!this.sheetRangeList.isEmpty()) break;
                throw new IllegalArgumentException("Index/ranges list is empty: " + config.sheetRanges);
            }
            case ALL: {
                break;
            }
            default: {
                logger.warn((Object)String.format("unknown sheet selection mode %s", this.config.sheetSelectionMode));
            }
        }
    }

    private static List<Range<Integer>> parseSheetRanges(String sheetRanges) {
        String[] ranges = sheetRanges.split(",");
        return Arrays.stream(ranges).map(ExcelFormatExtractor::parseSheetRange).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Range<Integer> parseSheetRange(String rangeString) {
        if (Strings.isNullOrEmpty((String)rangeString)) {
            return null;
        }
        try {
            if (rangeString.contains("-")) {
                return ExcelFormatExtractor.parseTrueSheetRange(rangeString);
            }
            int valueInt = Integer.parseInt(rangeString.trim());
            if (valueInt <= 0) {
                throw new IllegalArgumentException("Sheet indices/ranges are not valid - 0 or negative value: " + rangeString);
            }
            return Range.closed((Comparable)Integer.valueOf(valueInt), (Comparable)Integer.valueOf(valueInt));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Sheet indices/ranges are not parsable: " + rangeString);
        }
    }

    private static Range<Integer> parseTrueSheetRange(String rangeString) throws NumberFormatException {
        Integer lowerInt = null;
        Integer upperInt = null;
        Matcher rangeMatcher = RANGE_PATTERN.matcher(rangeString);
        if (rangeMatcher.matches() && rangeString.length() > 1) {
            String upper;
            String lower = rangeMatcher.group("lower");
            if (!lower.isEmpty()) {
                lowerInt = Integer.parseInt(lower);
            }
            if (!(upper = rangeMatcher.group("upper")).isEmpty()) {
                upperInt = Integer.parseInt(upper);
            }
        } else {
            throw new IllegalArgumentException("Sheet indices/ranges are invalid: " + rangeString);
        }
        if (lowerInt != null && lowerInt == 0 || upperInt != null && upperInt == 0) {
            throw new IllegalArgumentException("Sheet indices/ranges are invalid - range containing 0: " + rangeString);
        }
        if (lowerInt != null && upperInt != null && lowerInt > upperInt) {
            throw new IllegalArgumentException("Sheet indices/ranges are invalid - range inverted: " + rangeString);
        }
        if (lowerInt == null && upperInt == null) {
            throw new IllegalArgumentException("Sheet indices/ranges are invalid: " + rangeString);
        }
        if (lowerInt == null) {
            return Range.upTo((Comparable)upperInt, (BoundType)BoundType.CLOSED);
        }
        if (upperInt == null) {
            return Range.downTo((Comparable)lowerInt, (BoundType)BoundType.CLOSED);
        }
        return Range.closed((Comparable)lowerInt, (Comparable)upperInt);
    }

    @Override
    public void setLimit(ExtractionLimit limit) {
        this.limit = new ExtractionLimit(limit.maxRecords);
    }

    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        long streamRecords = 0L;
        InputStream is = isn.getInputStream();
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Excel starting to process one stream: %s", JSON.log((Object)this.redactedConfig())));
        }
        Column sheetNameCol = null;
        if (this.config.sheetsToColumn) {
            sheetNameCol = this.createSheetNamesColumnAtStart(cf);
        }
        SheetBasedExcelRange configRange = null;
        if (this.config.cellRange != null) {
            configRange = SheetBasedExcelRange.from(this.config.cellRange);
        }
        List<String> schemaColumnsForFileColumns = this.getSchemaColumnsForFileColumns();
        try (ExcelWorkbook wb = ExcelFilesAnalyzer.readWorkbook(is, this.config.password, new CustomProperties(this.config.customProperties));){
            for (ExcelWorkbook.Sheet sheet : this.listSheetsToImport(wb)) {
                int headerRowId;
                ExcelRange range = configRange != null ? configRange.getRange(sheet.getSheetName()) : null;
                ArrayList<Column> columns = new ArrayList();
                StringTransmogrifier columnTransmogrifier = new StringTransmogrifier();
                int firstDataRow = 0;
                if (this.config.parseHeaderRow) {
                    firstDataRow = 1;
                }
                if (range != null) {
                    int firstRow = range.getFirstRow();
                    if (firstRow == -1) {
                        firstRow = 0;
                    }
                    headerRowId = firstRow;
                    firstDataRow += firstRow;
                } else {
                    headerRowId = this.config.skipRowsBeforeHeader;
                    firstDataRow += this.config.skipRowsAfterHeader + this.config.skipRowsBeforeHeader;
                }
                for (ExcelWorkbook.Row excelRow : sheet) {
                    int excelRowIdx = excelRow.getRowNum();
                    if (this.config.parseHeaderRow && excelRowIdx < headerRowId) {
                        logger.trace(() -> String.format("Skipping row before header %d", excelRowIdx));
                        continue;
                    }
                    if (this.config.parseHeaderRow && excelRowIdx == headerRowId) {
                        columns = this.getHeaderFromRow(excelRow, cf, sheetNameCol, columnTransmogrifier, schemaColumnsForFileColumns, range);
                        continue;
                    }
                    if (excelRowIdx < firstDataRow) {
                        logger.trace(() -> String.format("Skipping row before data %d", excelRowIdx));
                        continue;
                    }
                    if (range != null && !range.containsRow(excelRowIdx)) {
                        logger.trace(() -> String.format("Skipping row %d outside of range [%d:%d]", excelRowIdx, range.getFirstRow(), range.getLastRow()));
                        continue;
                    }
                    if (!observer.checkLimit(streamRecords)) {
                        boolean bl = false;
                        return bl;
                    }
                    Row dipRow = this.getValuesFromRow(columns, excelRow, cf, rf, columnTransmogrifier, schemaColumnsForFileColumns, range);
                    if (sheetNameCol != null) {
                        dipRow.put(sheetNameCol, sheet.getSheetName());
                    }
                    isn.fillRowContext(dipRow.getRowContext());
                    dipRow.getRowContext().sourceRecord = streamRecords + 1L;
                    out.emitRow(dipRow);
                    if (++streamRecords % 500L != 0L) continue;
                    observer.onInterval(streamRecords);
                }
            }
        }
        observer.onEnd(streamRecords);
        return true;
    }

    private Column createSheetNamesColumnAtStart(ColumnFactory cf) {
        SchemaColumn firstColumn;
        String sheetsColumnName = SHEETS_COLUMN_DEFAULT;
        if (this.schema != null && this.config.useExistingFirstColumnForSheets() && (firstColumn = (SchemaColumn)this.schema.getColumns().get(0)) != null) {
            sheetsColumnName = firstColumn.getName();
        }
        Column sheetNameCol = cf.column(sheetsColumnName);
        cf.moveAtStart(sheetsColumnName);
        return sheetNameCol;
    }

    private void addColumnForAbsentHeading(List<Column> columns, ColumnFactory cf, List<String> schemaColumns, StringTransmogrifier columnTransmogrifier) {
        if (columns.size() < schemaColumns.size()) {
            columns.add(cf.column(schemaColumns.get(columns.size())));
        } else {
            columns.add(cf.column(columnTransmogrifier.transmogrify("col_" + columns.size())));
        }
    }

    private List<Column> getHeaderFromRow(ExcelWorkbook.Row excelRow, ColumnFactory cf, Column sheetNamesColumn, StringTransmogrifier columnTransmogrifier, List<String> schemaColumns, ExcelRange range) {
        ArrayList<Column> columns = new ArrayList<Column>();
        logger.debug((Object)String.format("Parsing header row: %d", excelRow.getRowNum()));
        for (ExcelWorkbook.Cell excelCell : excelRow) {
            if (range != null && !range.containsColumn(excelCell.getColumnIndex())) {
                logger.trace(() -> String.format("Skipping header cell (%d, %d)", excelCell.getRowIndex(), excelCell.getColumnIndex()));
                continue;
            }
            String cellValue = this.getCellValue(excelCell, null);
            int colIndex = excelCell.getColumnIndex();
            if (!(range != null && range.hasWholeColumnSubrange() || columns.size() >= colIndex)) {
                int gapSize = colIndex - columns.size();
                while (columns.size() < colIndex) {
                    this.addColumnForAbsentHeading(columns, cf, schemaColumns, columnTransmogrifier);
                }
                logger.trace(() -> String.format("%d columns added for gap before header row from index 0 to %d", gapSize, colIndex));
            }
            if (StringUtils.isBlank((CharSequence)cellValue)) {
                this.addColumnForAbsentHeading(columns, cf, schemaColumns, columnTransmogrifier);
                continue;
            }
            cellValue = cellValue.trim();
            if (colIndex < schemaColumns.size() && !schemaColumns.get(colIndex).equals(cellValue) && !schemaColumns.get(colIndex).endsWith("_iso")) {
                columns.add(cf.column(schemaColumns.get(colIndex)));
                continue;
            }
            String colNameToInsert = columnTransmogrifier.transmogrify(cellValue);
            if (sheetNamesColumn != null && colNameToInsert.equals(sheetNamesColumn.getName())) {
                String newSheetColumnName = columnTransmogrifier.transmogrify(sheetNamesColumn.getName());
                sheetNamesColumn.setName(newSheetColumnName);
            }
            columns.add(cf.column(colNameToInsert));
        }
        return columns;
    }

    private List<String> getSchemaColumnsForFileColumns() {
        ArrayList<String> schemaColumns = new ArrayList<String>();
        if (this.schema != null) {
            for (int i = 0; i < this.schema.getColumns().size(); ++i) {
                SchemaColumn col;
                if (i == 0 && this.config.useExistingFirstColumnForSheets() || (col = (SchemaColumn)this.schema.getColumns().get(i)).getName().endsWith("_iso")) continue;
                schemaColumns.add(col.getName());
            }
        }
        return schemaColumns;
    }

    private static String calculateSheetsNameColumnName(Schema schema) {
        if (schema != null) {
            StringTransmogrifier sheetColumnTransmogrifier = new StringTransmogrifier();
            for (SchemaColumn col : schema.getColumns()) {
                sheetColumnTransmogrifier.transmogrify(col.getName());
            }
            return sheetColumnTransmogrifier.transmogrify(SHEETS_COLUMN_DEFAULT);
        }
        return SHEETS_COLUMN_DEFAULT;
    }

    private Row getValuesFromRow(List<Column> columns, ExcelWorkbook.Row excelRow, ColumnFactory cf, RowFactory rf, StringTransmogrifier columnTransmogrifier, List<String> schemaColumns, ExcelRange range) {
        Row dipRow = rf.row();
        if (range != null && !range.containsRow(excelRow.getRowNum())) {
            logger.trace(() -> String.format("Skipping whole row number %d because because no range includes it", excelRow.getRowNum()));
            return dipRow;
        }
        for (ExcelWorkbook.Cell excelCell : excelRow) {
            if (range != null && !range.containsColumn(excelCell.getColumnIndex())) {
                logger.trace(() -> String.format("Skipping cell (%d, %d) because cell does not exist in range", excelCell.getRowIndex(), excelCell.getColumnIndex()));
                continue;
            }
            if (range != null && !range.containsCell(excelCell.getRowIndex(), excelCell.getColumnIndex())) {
                logger.trace(() -> String.format("Skipping cell (%d, %d) outside of range", excelCell.getRowIndex(), excelCell.getColumnIndex()));
                continue;
            }
            int colIndex = excelCell.getColumnIndex();
            if (range != null && range.hasWholeColumnSubrange()) {
                int columnGap = range.getColumnGapFromStart(colIndex);
                colIndex -= range.getFirstColumn();
                colIndex -= columnGap;
            }
            if (range != null) {
                for (int i = columns.size(); i <= colIndex; ++i) {
                    this.addColumnForAbsentHeading(columns, cf, schemaColumns, columnTransmogrifier);
                }
            } else {
                int gapSize = colIndex - columns.size() + 1;
                for (int i = 0; i < gapSize; ++i) {
                    this.addColumnForAbsentHeading(columns, cf, schemaColumns, columnTransmogrifier);
                }
                logger.trace(() -> String.format("%d columns added to fill the gap when parsing cell (%d, %d)", gapSize, excelCell.getRowIndex(), excelCell.getColumnIndex()));
            }
            Column dipCol = columns.get(colIndex);
            SchemaColumn sc = this.schema != null ? this.schema.getColumn(dipCol.getName()) : null;
            String dipVal = this.getCellValue(excelCell, sc);
            if (dipVal != null) {
                dipRow.put(dipCol, dipVal);
            }
            if (!this.config.parseDatesToISO || !excelCell.cellContainsDate()) continue;
            Column isoCol = cf.columnAfter(dipCol.getName(), dipCol.getName() + "_iso");
            dipRow.put(isoCol, excelCell.getFormattedValueAsDateISO(this.timezoneId));
        }
        return dipRow;
    }

    private String getCellValue(ExcelWorkbook.Cell cell, SchemaColumn sc) {
        if (cell == null) {
            return null;
        }
        Type dssType = sc == null ? null : sc.getType();
        return cell.getFormattedValue(dssType, this.timezoneId, this.config.preserveNumberFormatting);
    }

    private List<ExcelWorkbook.Sheet> listSheetsToImport(ExcelWorkbook wb) {
        switch (this.config.sheetSelectionMode) {
            case NAMES: {
                return this.listSheetsForNamesMode(wb);
            }
            case ALL: {
                return Streams.stream((Iterable)wb).collect(Collectors.toList());
            }
            case RANGES: {
                return this.listSheetsForRanges(wb);
            }
            case PATTERN: {
                if (this.compiledSheetPattern != null) {
                    return Streams.stream((Iterable)wb).filter(sheet -> this.compiledSheetPattern.matcher(sheet.getSheetName()).find()).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }
        }
        logger.error((Object)String.format("Unknown sheet selection mode %s - no sheets will be included", this.config.sheetSelectionMode));
        return Collections.emptyList();
    }

    private List<ExcelWorkbook.Sheet> listSheetsForRanges(ExcelWorkbook wb) {
        if (this.sheetRangeList == null) {
            return Collections.emptyList();
        }
        TreeSet<Integer> sortedSheetsIndexSet = new TreeSet<Integer>();
        for (Range<Integer> range : this.sheetRangeList) {
            int lowerBound = range.hasLowerBound() && (Integer)range.lowerEndpoint() > 0 ? (Integer)range.lowerEndpoint() : 1;
            int upperBound = range.hasUpperBound() && (Integer)range.upperEndpoint() <= wb.getNumberOfSheets() ? ((Integer)range.upperEndpoint()).intValue() : wb.getNumberOfSheets();
            int start = lowerBound - 1;
            int end = upperBound - 1;
            for (int i = start; i <= end; ++i) {
                sortedSheetsIndexSet.add(i);
            }
        }
        return sortedSheetsIndexSet.stream().map(wb::getSheetAt).collect(Collectors.toList());
    }

    private List<ExcelWorkbook.Sheet> listSheetsForNamesMode(ExcelWorkbook wb) {
        ArrayList<ExcelWorkbook.Sheet> sheetsSelected = new ArrayList<ExcelWorkbook.Sheet>();
        if (this.sheets == null) {
            logger.warn((Object)"Sheets variable unexpectedly null");
            return sheetsSelected;
        }
        for (Object item : this.sheets) {
            int sheetIndex;
            if (item instanceof String) {
                String sheetName = (String)item;
                sheetIndex = wb.getSheetIndex(sheetName);
                if (sheetIndex < 0) {
                    logger.warn((Object)String.format("Unable to find sheet '%s'. Skipping it.", sheetName));
                    continue;
                }
                sheetsSelected.add(wb.getSheet(sheetName));
                continue;
            }
            if (!(item instanceof Integer)) continue;
            sheetIndex = (Integer)item;
            if (sheetIndex < 0 || sheetIndex >= wb.getNumberOfSheets()) {
                logger.warn((Object)String.format("Unable to find sheet at index '%d'. Skipping it.", sheetIndex));
                continue;
            }
            sheetsSelected.add(wb.getSheetAt(sheetIndex));
        }
        return sheetsSelected;
    }

    @Override
    public Schema preTreatBeforeSchemaComparison(Schema userModifiedSchema) {
        Schema schemaToReturn = userModifiedSchema;
        if (this.config.addSheetsColumn()) {
            String newSheetColumnName = ExcelFormatExtractor.calculateSheetsNameColumnName(userModifiedSchema);
            schemaToReturn = new Schema(userModifiedSchema);
            SchemaColumn sheetNamesColumn = new SchemaColumn(newSheetColumnName, Type.STRING);
            schemaToReturn.columns.add(0, sheetNamesColumn);
        }
        if (this.config.removeSheetsColumn()) {
            schemaToReturn = new Schema(userModifiedSchema);
            schemaToReturn.columns.remove(0);
        }
        return schemaToReturn;
    }

    private Config redactedConfig() {
        Config redactedConfig = (Config)JSON.deepCopyExcept((Object)this.config, (String[])new String[]{"password"});
        if (this.config.password != null) {
            redactedConfig.password = "********";
        }
        return redactedConfig;
    }

    public static class Config
    implements FormatParams,
    ParamsWithEncryptedFields,
    IFormatConfig {
        public String password;
        public boolean preserveNumberFormatting;
        public boolean parseDatesToISO;
        public String assumedTz;
        public int skipRowsBeforeHeader;
        public boolean parseHeaderRow;
        public int skipRowsAfterHeader;
        public boolean sheetsToColumn;
        public boolean passwordRequired;
        public RowOverflowStrategy rowOverflowStrategy = RowOverflowStrategy.NEW_SHEET;
        public CellOverflowStrategy cellOverflowStrategy = CellOverflowStrategy.ERROR;
        public InvalidCellStrategy invalidCellStrategy = InvalidCellStrategy.ERROR;
        public String outputSheetName;
        public boolean applyColoring = false;
        @JSON.FileTransient
        public Boolean sheetsToColumnOld;
        public SheetSelectionMode sheetSelectionMode = SheetSelectionMode.NAMES;
        public String sheets;
        public String sheetPattern;
        public String sheetRanges;
        public String cellRange;
        public KeyValueList<String, String> customProperties;

        public Config() {
        }

        public Config(Config that) {
            this.password = that.password;
            this.preserveNumberFormatting = that.preserveNumberFormatting;
            this.parseDatesToISO = that.parseDatesToISO;
            this.assumedTz = that.assumedTz;
            this.skipRowsBeforeHeader = that.skipRowsBeforeHeader;
            this.parseHeaderRow = that.parseHeaderRow;
            this.skipRowsAfterHeader = that.skipRowsAfterHeader;
            this.sheetsToColumn = that.sheetsToColumn;
            this.passwordRequired = that.passwordRequired;
            this.rowOverflowStrategy = that.rowOverflowStrategy;
            this.cellOverflowStrategy = that.cellOverflowStrategy;
            this.invalidCellStrategy = that.invalidCellStrategy;
            this.outputSheetName = that.outputSheetName;
            this.applyColoring = that.applyColoring;
            this.sheetsToColumnOld = that.sheetsToColumnOld;
            this.sheetSelectionMode = that.sheetSelectionMode;
            this.sheets = that.sheets;
            this.sheetPattern = that.sheetPattern;
            this.sheetRanges = that.sheetRanges;
            this.cellRange = that.cellRange;
            this.customProperties = that.customProperties;
        }

        @Override
        public boolean getApplyColoring() {
            return this.applyColoring;
        }

        public boolean addSheetsColumn() {
            return this.sheetsToColumnOld != null && this.sheetsToColumnOld == false && this.sheetsToColumn;
        }

        public boolean removeSheetsColumn() {
            return this.sheetsToColumnOld != null && this.sheetsToColumnOld != false && !this.sheetsToColumn;
        }

        public boolean useExistingFirstColumnForSheets() {
            return (this.sheetsToColumnOld == null || this.sheetsToColumnOld != false) && this.sheetsToColumn;
        }

        @Override
        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.password);
        }

        @Override
        public void decryptFields(PasswordEncryptionService cryptoService) {
            this.password = cryptoService.decryptIfEncrypted(this.password);
        }

        @Override
        public boolean validate() throws FormatConfigException {
            if (this.cellRange != null) {
                try {
                    SheetBasedExcelRange.from(this.cellRange);
                }
                catch (IllegalArgumentException e) {
                    throw new FormatConfigException("Invalid cell range: " + e.getMessage());
                }
            }
            return true;
        }
    }

    public static class CustomProperties {
        public static final String XLSX_STREAMING = "xlsx.streaming";
        public static final String XLSX_STREAMING_STRING_TABLE = "xlsx.streaming.sst";
        public static final String XLS_IGNORE_RECORD_LIMIT = "xls.ignoreRecordLimit";
        private Boolean xlsxReadStreaming;
        private String xlsxStreamingSharedStringTable;
        private Boolean xlsIgnoreRecordLimit;

        public CustomProperties() {
        }

        public CustomProperties(KeyValueList<String, String> customProperties) {
            this.xlsxReadStreaming = KeyValueList.getOptional(customProperties, XLSX_STREAMING).map(String::trim).map(Boolean::parseBoolean).orElse(null);
            this.xlsxStreamingSharedStringTable = KeyValueList.getOptional(customProperties, XLSX_STREAMING_STRING_TABLE).map(String::trim).orElse(null);
            this.xlsIgnoreRecordLimit = KeyValueList.getOptional(customProperties, XLS_IGNORE_RECORD_LIMIT).map(String::trim).map(Boolean::parseBoolean).orElse(null);
        }

        public Optional<Boolean> getXlsxReadStreaming() {
            return Optional.ofNullable(this.xlsxReadStreaming);
        }

        public Optional<String> getXlsxStreamingSharedStringTable() {
            return Optional.ofNullable(this.xlsxStreamingSharedStringTable);
        }

        public Optional<Boolean> getXlsIgnoreRecordLimit() {
            return Optional.ofNullable(this.xlsIgnoreRecordLimit);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SheetSelectionMode implements Labelled
    {
        NAMES{

            @Override
            public String getLabel() {
                return "Sheet names";
            }
        }
        ,
        PATTERN{

            @Override
            public String getLabel() {
                return "Sheet regexp pattern";
            }
        }
        ,
        RANGES{

            @Override
            public String getLabel() {
                return "Sheet ranges";
            }
        }
        ,
        ALL{

            @Override
            public String getLabel() {
                return "All sheets";
            }
        };

    }

    public static enum InvalidCellStrategy {
        ERROR,
        IGNORE;

    }

    public static enum RowOverflowStrategy {
        ERROR,
        TRIM,
        NEW_SHEET;

    }

    public static enum CellOverflowStrategy {
        ERROR,
        TRIM,
        NEW_ROW;

    }
}

