/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.Validate;
import org.springframework.stereotype.Service;

@Service
public class FutureHistoryService {
    private static final int REGISTRY_CLEANUP_PERIOD_MN = 2;
    public static final String REGISTRY_ACCESS_TIMEOUT_KEY = "dku.futureHistoryService.registry.access.timeout.minutes";
    private static final int REGISTRY_ACCESS_TIMEOUT_IN_MINUTES = 5;
    private final int registryAccessTimeout = DKUApp.getParams().getIntParam("dku.futureHistoryService.registry.access.timeout.minutes", Integer.valueOf(5));
    private final ConcurrentSkipListMap<String, FutureHistoryItem> itemsRegistry = new ConcurrentSkipListMap();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.futures.history");

    @PostConstruct
    public void postConstruct() {
        logger.infoV("Scheduling periodic cleanup of Future History Service registry every %d minutes", new Object[]{2});
        DKUExecutors.newNamedSingleDaemonThreadExecutor("FutureHistoryService-cleanup").scheduleWithFixedDelay(this::cleanup, 2L, 2L, TimeUnit.MINUTES);
    }

    void cleanup() {
        try {
            if (this.itemsRegistry.isEmpty()) {
                return;
            }
            logger.infoV("Running cache cleanup on Future History Service registry. Registered futures=%d, access ttl=%d minutes", new Object[]{this.itemsRegistry.size(), this.registryAccessTimeout});
            AtomicInteger removed = new AtomicInteger(0);
            long registryAccessTimeoutInMs = (long)(this.registryAccessTimeout * 60) * 1000L;
            this.itemsRegistry.keySet().forEach(key -> this.itemsRegistry.computeIfPresent((String)key, (name, item) -> {
                long notAccessedFor = System.currentTimeMillis() - item.lastAccessed;
                if (notAccessedFor > registryAccessTimeoutInMs) {
                    item.update();
                    if (item.finished()) {
                        logger.infoV("Removing history item %s not accessed for %d ms", new Object[]{item.name, notAccessedFor});
                        removed.incrementAndGet();
                        return null;
                    }
                }
                return item;
            }));
            logger.infoV("Cache cleanup done on Future History Service registry. Cleaned items=%d, remaining items=%d", new Object[]{removed.get(), this.itemsRegistry.size()});
        }
        catch (Throwable t) {
            logger.warn((Object)"Cleanup on Future History Service registry failed", t);
        }
    }

    public void register(String name, FutureResponse<?> initialResponse, String ... context) {
        this.register(name, initialResponse, false, context);
    }

    public void register(String name, FutureResponse<?> initialResponse, boolean alwaysReplace, String ... context) {
        FutureHistoryItem fhi = new FutureHistoryItem();
        fhi.name = name;
        fhi.jobId = initialResponse.jobId;
        fhi.lastResponse = initialResponse;
        for (int i = 0; i < context.length; i += 2) {
            fhi.context.put(context[i], context[i + 1]);
        }
        this.itemsRegistry.compute(name, (key, existing) -> {
            if (existing != null) {
                existing.update();
                if (!alwaysReplace && !existing.finished()) {
                    throw ErrorContext.iae((String)("A future with history named " + name + " is already in progress (jobId: " + existing.jobId + ")"));
                }
                logger.infoV("Registering future with history: %s -> %s, replacing existing %s item (%s)", new Object[]{name, fhi.jobId, existing.finished() ? "finished" : "running", existing.jobId});
            } else {
                logger.infoV("Registering new future with history: %s -> %s", new Object[]{name, fhi.jobId});
            }
            return fhi;
        });
    }

    public List<FutureHistoryItem> getAllByPrefix(String prefix) {
        Validate.notNull((Object)prefix);
        List<FutureHistoryItem> matching = this.itemsRegistry.subMap((Object)prefix, (Object)(prefix + "\uffff")).values().stream().toList();
        logger.traceV("Found %d items matching prefix %s", new Object[]{matching.size(), prefix});
        for (FutureHistoryItem item : matching) {
            item.lastAccessed = System.currentTimeMillis();
            item.update();
        }
        return matching;
    }

    public FutureHistoryItem getSingleByPrefix(String name) {
        Validate.notNull((Object)name);
        List<FutureHistoryItem> matching = this.getAllByPrefix(name);
        if (matching.isEmpty()) {
            throw ErrorContext.iae((String)("No future matching name " + name));
        }
        if (matching.size() > 1) {
            throw ErrorContext.iae((String)("Multiple futures matching name " + name));
        }
        return matching.get(0);
    }

    public void removeWithPrefix(String prefix) {
        this.itemsRegistry.subMap((Object)prefix, (Object)(prefix + "\uffff")).clear();
    }

    public FutureHistoryItem getExactMatchOrNull(String name) {
        Validate.notNull((Object)name);
        FutureHistoryItem item = this.itemsRegistry.get(name);
        if (item != null) {
            logger.traceV("Found item with name %s", new Object[]{name});
            item.lastAccessed = System.currentTimeMillis();
            item.update();
        }
        return item;
    }

    public void removeExactMatch(String name) {
        this.itemsRegistry.remove(name);
    }

    public <T> FutureResponse<T> waitForFinalResponse(String name) throws Exception {
        FutureHistoryItem fhi;
        int delay = 25;
        do {
            Thread.sleep(delay);
            delay = Math.min(delay + 25, 500);
            fhi = this.getExactMatchOrNull(name);
            if (fhi != null) continue;
            return null;
        } while (!fhi.finished());
        return fhi.lastResponse;
    }

    public static class FutureHistoryItem {
        volatile long lastAccessed = System.currentTimeMillis();
        public Map<String, String> context = new HashMap<String, String>();
        public String name;
        public String jobId;
        public SerializedError storedError;
        public FutureResponse<?> lastResponse;

        public synchronized void update() {
            if (!this.finished()) {
                try {
                    this.lastResponse = ((FutureService)((Object)SpringUtils.getBean(FutureService.class))).getUpdate(this.jobId);
                }
                catch (Throwable t) {
                    this.storedError = new SerializedError(t, true);
                }
            }
        }

        public boolean finished() {
            return this.lastResponse != null && this.lastResponse.hasResult || this.storedError != null;
        }
    }
}

