/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.dataflow.jobrunner.PerJobBackendLoggingAppender;
import com.dataiku.dip.futures.GarbageCollectionMonitor;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.kernels.DSSKernelManagerBase;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.INonImpersonatedKernel;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class FutureKernelHandle
extends DSSKernelBase
implements INonImpersonatedKernel,
DSSKernelManagerBase.KernelHandle {
    private final JobContextLineSubscription jobMetricsContextLogSniffing = new JobContextLineSubscription();
    private JobBackendLoggingContext jobMetricsContext;
    private APITicketService.Ticket ticket;
    private final double memoryCommitRatioKillThreshold = ApplicationConfigurator.getParams().getDoubleParam("dku.futures.kernels.memoryCommitRatioKillThreshold", 1.0);
    private final long memoryCommitAbsoluteKillThresholdMB = ApplicationConfigurator.getParams().getLongParam("dku.futures.kernels.memoryCommitAbsoluteKillThresholdMB", -1L);
    private final int startTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.futures.kernels.start.timeout.ms", Integer.valueOf(600000));
    private final int pingTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.futures.kernels.ping.timeout.ms", Integer.valueOf(30000));
    private final APITicketService apiTicketService;
    private boolean sentenced = false;
    protected LocalPrivilegedIntercomAPIClient apiClient;
    private Long acquired;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.kernels.future");

    public FutureKernelHandle(String fekId, APITicketService apiTicketService) {
        super(fekId);
        this.apiTicketService = apiTicketService;
    }

    private synchronized JobBackendLoggingContext getJobMetricsContext() {
        return this.jobMetricsContext;
    }

    private synchronized void setJobMetricsContext(JobBackendLoggingContext jobMetricsContext) {
        this.jobMetricsContext = jobMetricsContext;
    }

    public synchronized APITicketService.Ticket getTicket() {
        return this.ticket;
    }

    public synchronized void sentence() {
        this.sentenced = true;
    }

    public synchronized boolean isSentenced() {
        return this.sentenced;
    }

    public synchronized LocalPrivilegedIntercomAPIClient getAPIClient() {
        return this.apiClient;
    }

    public synchronized void setAPIClient(LocalPrivilegedIntercomAPIClient apiClient) {
        this.apiClient = apiClient;
    }

    public int getPort() {
        return this.port;
    }

    private synchronized void acquireNow(APITicketService.Ticket ticket) {
        this.acquired = System.currentTimeMillis();
        this.setJobMetricsContext(JobBackendLoggingContext.getCurrentJobContext());
        this.ticket = ticket;
    }

    public void acquire(String jobId, AuthCtx authCtx, String projectKey) {
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(authCtx, "fek:" + this.id + ":job:" + jobId, null);
        this.acquireNow(ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        APITicketService.Ticket ticket;
        FutureKernelHandle futureKernelHandle = this;
        synchronized (futureKernelHandle) {
            ticket = this.ticket;
            this.acquired = null;
            this.setJobMetricsContext(null);
            this.ticket = null;
        }
        if (ticket != null) {
            this.apiTicketService.expireTicket(ticket);
        }
    }

    public void killWithoutMercy() throws IOException, InterruptedException {
        try {
            super.killWithoutMercy();
        }
        finally {
            APITicketService.Ticket ticket = this.getTicket();
            if (ticket != null) {
                this.apiTicketService.expireTicket(ticket);
            }
        }
    }

    public synchronized Long getAcquired() {
        return this.acquired;
    }

    public void start() throws Exception {
        String fekBin = System.getenv("DKUFEKBIN");
        if (fekBin == null) {
            throw new Error("environment variable DKUFEKBIN not defined");
        }
        ArrayList args = Lists.newArrayList((Object[])new String[]{fekBin, this.id});
        ProcessBuilder pb = new ProcessBuilder(args);
        this.logger.info((Object)"Starting future kernel");
        if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(pb.environment());
        }
        SharedSecretUtils.getSharedSecret((boolean)true);
        final File processTmp = DKUApp.getFile((String[])new String[]{"tmp", "feks", this.id});
        DKUFileUtils.mkdirs((File)processTmp);
        pb.environment().put("DKU_JAVA_TMP_DIR", processTmp.getAbsolutePath());
        this.process = new RegularProcess(pb, ApplicationConfigurator.getBaseFolderF());
        this.process.start();
        this.startStandardTailers();
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)this.jobMetricsContextLogSniffing);
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)this.jobMetricsContextLogSniffing);
        this.monitorThread = new DSSKernelBase.KernelMonitorThread(){

            public void onAfterProcessComplete() {
                FutureKernelHandle.this.logger.debug((Object)("Cleaning up FEK temporary folder " + String.valueOf(processTmp)));
                try {
                    DKUFileUtils.forceDelete((File)processTmp);
                }
                catch (IOException e) {
                    FutureKernelHandle.this.logger.warn((Object)("Failed to cleanup FEK temporary folder " + String.valueOf(processTmp)));
                }
                FutureKernelHandle.this.executeOnShutdownRunnables("A shutdown runnable failed while cleaning up resources");
            }
        };
        this.monitorThread.start();
        this.waitForPort();
        this.setAPIClient(new LocalPrivilegedIntercomAPIClient(this.port, EncryptedRPC.enabled()));
    }

    public void ping() throws Exception {
        this.getAPIClient().postObject("/future/ping", this.pingTimeoutMs, JsonObject.class, (Object)new JsonObject());
    }

    public void checkHealthAtEnd() throws Exception {
        LocalPrivilegedIntercomAPIClient client = this.getAPIClient();
        if (client != null) {
            int timeout = 15000;
            GarbageCollectionMonitor.MemoryState health = (GarbageCollectionMonitor.MemoryState)this.apiClient.postObject("/future/check-health", timeout, GarbageCollectionMonitor.MemoryState.class, (Object)new JsonObject());
            if (health == null) {
                throw new Exception("Timeout when fetching");
            }
            this.logger.infoV("FEK state used_mem=%dMB committed_mem=%dMB max_mem=%dMB average_usage=%.3f amortized_avg_gc_efficiency=%.3f gc_time=%.0fms collections=%d", new Object[]{health.usedMem / 0x100000L, health.committedMem / 0x100000L, health.maxMem / 0x100000L, health.memoryUsage, health.gcEfficiency, health.gcDuration, health.collectionCount});
            DSSMetrics.registry().histogram("dku.futures.kernels.usedMemAtRelease").update(health.usedMem);
            DSSMetrics.registry().histogram("dku.futures.kernels.committedMemAtRelease").update(health.committedMem);
            boolean memoryFull = false;
            if (health.collectionCount > 1) {
                memoryFull = health.memoryUsage > 0.98 && health.gcEfficiency < 0.05;
            } else {
                boolean bl = memoryFull = health.memoryUsage > 0.98;
            }
            if (memoryFull) {
                throw new Exception("Kernel memory seems full and cannot be freed.");
            }
            if ((double)health.committedMem > this.memoryCommitRatioKillThreshold * (double)health.maxMem) {
                throw new Exception("Kernel allocated lots of RAM (ratio), killing it to free memory.");
            }
            if (this.memoryCommitAbsoluteKillThresholdMB > 0L && health.committedMem > this.memoryCommitAbsoluteKillThresholdMB * 1024L * 1024L) {
                throw new Exception("Kernel allocated lots of RAM (absolute), killing it to free memory.");
            }
        }
    }

    private void waitForPort() throws Exception {
        try {
            int loops = 0;
            long start = System.nanoTime();
            while (System.nanoTime() - start < (long)this.startTimeoutMs * 1000000L) {
                ++loops;
                Thread.sleep(300L);
                if (this.process == null) {
                    this.logger.error((Object)"Future kernel process died before start");
                    throw new Exception("Future kernel process died before start", this.processExitException);
                }
                try {
                    int foundPort = this.getPort();
                    if (foundPort <= 0) continue;
                    this.logger.info((Object)("Future kernel registered on port : " + this.port));
                    return;
                }
                catch (Exception e) {
                    if (loops % 10 != 5) continue;
                    this.logger.info((Object)"Future kernel is not yet ready: ", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)"FEK startup was interrupted while waiting for port, killing FEK");
            this.killNoWaitNoException(false);
            throw e;
        }
        this.killNoWaitNoException(false);
        throw new Exception("Timeout reached when starting new kernel: " + this.startTimeoutMs + "ms");
    }

    public synchronized void onRegister(int port) {
        this.port = port;
    }

    public class JobContextLineSubscription
    implements DKUtils.LineSubscription {
        public synchronized void handle(String line, boolean replace) {
            JobBackendLoggingContext ctx = FutureKernelHandle.this.getJobMetricsContext();
            if (ctx != null) {
                PerJobBackendLoggingAppender.writeToLogFile(ctx, line + "\n");
            }
        }

        public void close() throws IOException {
        }
    }
}

