/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.containers.exec.ContainerExecConfigTestService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.GarbageCollectionMonitor;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.SingleTicketService;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class FutureKernelServlet
extends HttpServlet {
    @Autowired
    private FutureService futureService;
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SingleTicketService singleTicketService;
    private static final long serialVersionUID = 1L;
    private final String sharedSecret;
    private final GarbageCollectionMonitor gcMonitor;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.futures");

    public FutureKernelServlet(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        this.gcMonitor = new GarbageCollectionMonitor();
    }

    protected void writeJSON(HttpServletResponse resp, Object o) throws IOException {
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(JSON.json((Object)o));
    }

    protected void sendError(HttpServletResponse resp, Throwable error) throws IOException {
        ICodedException ie;
        logger.error((Object)"Call failed", error);
        System.err.flush();
        System.out.flush();
        resp.setStatus(500);
        resp.setContentType("application/json");
        APIError reflectedError = new APIError(error, true);
        if (error instanceof ICodedException && (ie = (ICodedException)error).getCode() != null) {
            reflectedError.withCode(ie.getCode());
        }
        resp.getWriter().write(JSON.json((Object)reflectedError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String receivedSecretKey = req.getHeader("X-DKU-IPythonSharedSecret");
        if (StringUtils.isBlank((String)receivedSecretKey) || !StringUtils.equals((String)this.sharedSecret, (String)receivedSecretKey)) {
            resp.sendError(403);
            return;
        }
        String path = req.getPathInfo();
        long startTime = System.currentTimeMillis();
        if (!path.equals("/ping")) {
            logger.debug((Object)("Received command : " + path));
        }
        try {
            switch (path) {
                case "/ping": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.writeJSON(resp, new JSONObject());
                    return;
                }
                case "/check-health": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    System.gc();
                    GarbageCollectionMonitor.MemoryState gcState = this.gcMonitor.getCurrentState();
                    this.writeJSON(resp, gcState);
                    return;
                }
                case "/start": {
                    String jobId = req.getParameter("jobId");
                    String futureThreadClassName = req.getParameter("futureThreadClassName");
                    String futureThreadDefinition = req.getParameter("futureThreadDefinition");
                    String ticketSecret = req.getParameter("ticketSecret");
                    String scenarioRunStr = req.getParameterMap().containsKey("scenarioRun") ? req.getParameter("scenarioRun") : null;
                    String stepRunStr = req.getParameterMap().containsKey("stepRun") ? req.getParameter("stepRun") : null;
                    FutureThread futureThread = (FutureThread)((Object)JSON.parse((String)futureThreadDefinition, Class.forName(futureThreadClassName)));
                    ScenarioRun scenarioRun = StringUtils.isBlank((String)scenarioRunStr) ? null : (ScenarioRun)JSON.parse((String)scenarioRunStr, ScenarioRun.class);
                    StepRun stepRun = StringUtils.isBlank((String)stepRunStr) ? null : (StepRun)JSON.parse((String)stepRunStr, StepRun.class);
                    futureThread.setScenarioRun(scenarioRun, stepRun, this.scenarioRunContext);
                    SpringUtils.getInstance().autowire((Object)futureThread);
                    futureThread.jobId = jobId;
                    logger.info((Object)("In FEK: Running Future of class " + String.valueOf(((Object)((Object)futureThread)).getClass()) + " on behalf of " + String.valueOf((Object)futureThread.getOwner())));
                    try (Transaction t = this.transactionService.beginRead();){
                        this.impersonationResolverService.setImpersonationConfig(this.generalSettingsDAO.read().impersonation);
                    }
                    this.singleTicketService.setTicket((AuthCtx)futureThread.getOwner(), ticketSecret);
                    this.futureService.safeRunFuture(futureThread, 0L);
                    return;
                }
                case "/abort": {
                    String futureId = req.getParameter("futureId");
                    this.futureService.abort(futureId);
                    this.singleTicketService.clearTicket();
                    return;
                }
                case "/check-abort": {
                    String futureId = req.getParameter("futureId");
                    FutureServiceBase.FutureLiveliness liveliness = this.futureService.getLiveliness(futureId);
                    this.writeJSON(resp, liveliness);
                    return;
                }
                case "/get-status": {
                    String futureId = req.getParameter("futureId");
                    FutureResponse response = this.futureService.getProgress(futureId);
                    this.writeJSON(resp, response);
                    return;
                }
                case "/get-update": {
                    String futureId = req.getParameter("futureId");
                    FutureResponse response = this.futureService.getUpdate(futureId);
                    this.writeJSON(resp, response);
                    return;
                }
                case "/container-test-ping": {
                    String testId = req.getParameter("testId");
                    ContainerExecConfigTestService.removeTest(testId);
                    this.writeJSON(resp, new JSONObject());
                    return;
                }
                default: {
                    throw new Exception("Unknown command " + path);
                }
            }
        }
        catch (Throwable e) {
            this.sendError(resp, e);
            return;
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (!path.equals("/ping")) {
                logger.debug((Object)("Command " + path + " processed in " + (endTime - startTime) + "ms"));
            }
            ((DataService)SpringUtils.getBean(DataService.class)).invalidateAllMemoryCache();
        }
    }
}

