/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.gh;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewsDAO;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelSnippetData;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.core.CustomMetricSuccess;
import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.badges.ProjectBadges;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ProjectBadgesDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsDAO;
import com.dataiku.dip.deployer.apideployer.deployments.EmbeddedModelVersionIdentifier;
import com.dataiku.dip.deployer.apideployer.deployments.PublishedApiServicePackageInfoForGovernIdentification;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsDAO;
import com.dataiku.dip.deployer.projectdeployer.deployments.PublishedProjectBundleInfoForGovernIdentification;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasDAO;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.gh.GovernIntegrationCodes;
import com.dataiku.dip.gh.GovernIntegrationQueueHandler;
import com.dataiku.dip.gh.SingleGovernIntegrationClientHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.DesignBundlesService;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReportSummary;
import com.dataiku.dip.recipes.nlp.classification.model_provided.NLPLLMModelProvidedClassificationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.classification.user_provided.NLPLLMUserProvidedClassificationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.finetuning.FineTuningRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipePayloadParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentConfigChangedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentCreatedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentDeletedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraChangedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraCreatedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerInfraDeletedEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EvaluationCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionChangedEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ModelVersionDeletedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleActivationFinishedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleDeletedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerDeploymentDeletedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerInfraChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerInfraCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeployerInfraDeletedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectTypeBadgesChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.WebAppUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss_gh.api.models.GovernInstanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSAPIDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSAPIDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSDatasetIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSRetrievableKnowledgeIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.dss_gh.api.models.metrics.DSSCustomMetric;
import com.dataiku.dss_gh.api.models.metrics.DSSMetricDatapoint;
import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetricDatapoints;
import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetrics;
import com.dataiku.dss_gh.api.models.sync.DSSAPIDeployerDeployment;
import com.dataiku.dss_gh.api.models.sync.DSSAPIDeployerInfra;
import com.dataiku.dss_gh.api.models.sync.DSSAgentSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSAugmentedSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSBundle;
import com.dataiku.dss_gh.api.models.sync.DSSClusteringSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSDataset;
import com.dataiku.dss_gh.api.models.sync.DSSDeployerItems;
import com.dataiku.dss_gh.api.models.sync.DSSFineTuningSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSPredictionSavedModelVersion;
import com.dataiku.dss_gh.api.models.sync.DSSProject;
import com.dataiku.dss_gh.api.models.sync.DSSProjectDeployerDeployment;
import com.dataiku.dss_gh.api.models.sync.DSSProjectDeployerInfra;
import com.dataiku.dss_gh.api.models.sync.DSSProjectList;
import com.dataiku.dss_gh.api.models.sync.DSSRetrievableKnowledge;
import com.dataiku.dss_gh.api.models.sync.DSSSavedModel;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.directory.api.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernIntegrationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private DesignBundlesService designBundlesService;
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private ClusteringSMMgmtService clusteringSMMgmtService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private ApiNodeInfrasDAO apiNodeInfrasDAO;
    @Autowired
    private AutomationNodeInfrasDAO automationNodeInfrasDAO;
    @Autowired
    private APIServiceDeploymentsDAO apiServiceDeploymentsDAO;
    @Autowired
    private ProjectDeploymentsDAO projectDeploymentsDAO;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private AgentReviewsDAO agentReviewsDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private ProjectBadgesDAO projectBadgesDAO;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    private String currentDeployerAndDesignFullSyncJobId;
    private final GovernIntegrationQueueHandler queueHandler = new GovernIntegrationQueueHandler(){

        @Override
        public void handleQueueEvent(BackendEvent evt) {
            logger.info((Object)("Handling event: " + evt.getClass().getSimpleName()));
            try {
                GovernIntegrationService.checkGovernIntegrationIsEnabledAndProperlyConfigured();
                switch (evt.getName()) {
                    case "object-change": {
                        GovernIntegrationService.this.handleTaggableObjectChangedEvent((TaggableObjectChangedEvent)evt);
                        break;
                    }
                    case "project-bundle-created": {
                        ProjectBundleCreatedEvent pbce = (ProjectBundleCreatedEvent)evt;
                        GovernIntegrationService.this.upsertProjectBundle(pbce.projectKey, pbce.bundleId);
                        break;
                    }
                    case "project-bundle-deleted": {
                        ProjectBundleDeletedEvent pbde = (ProjectBundleDeletedEvent)evt;
                        GovernIntegrationService.this.deleteProjectBundle(pbde.projectKey, pbde.bundleId);
                        break;
                    }
                    case "model-version-created": {
                        ModelVersionCreatedEvent mvce = (ModelVersionCreatedEvent)evt;
                        if (FullModelId.parse((String)mvce.fullModelId).type == FullModelId.Type.SAVED) {
                            GovernIntegrationService.this.upsertSavedModelVersions(mvce.fullModelId);
                        }
                        break;
                    }
                    case "model-version-changed": {
                        ModelVersionChangedEvent mvce = (ModelVersionChangedEvent)evt;
                        if (FullModelId.parse((String)mvce.fullModelId).type == FullModelId.Type.SAVED) {
                            GovernIntegrationService.this.upsertSavedModelVersions(mvce.fullModelId);
                        }
                        break;
                    }
                    case "model-version-deleted": {
                        ModelVersionDeletedEvent mvde = (ModelVersionDeletedEvent)evt;
                        if (FullModelId.parse((String)mvde.fullModelId).type == FullModelId.Type.SAVED) {
                            GovernIntegrationService.this.deleteSavedModelVersion(mvde.fullModelId);
                        }
                        break;
                    }
                    case "evaluation-created": {
                        EvaluationCreatedEvent ece = (EvaluationCreatedEvent)evt;
                        GovernIntegrationService.this.upsertEvaluation(ece.projectKey, ece.modelEvaluationStoreId, ece.evaluationRunId);
                        break;
                    }
                    case "project-bundle-activation-finished": {
                        ProjectBundleActivationFinishedEvent pbafe = (ProjectBundleActivationFinishedEvent)evt;
                        GovernIntegrationService.this.projectFullSync(pbafe.getProjectKey(), true);
                        break;
                    }
                    case "apideployer-infra-created": {
                        APIDeployerInfraCreatedEvent dice = (APIDeployerInfraCreatedEvent)evt;
                        GovernIntegrationService.this.upsertAPIDeploymentInfra(dice.infrastructureId);
                        break;
                    }
                    case "apideployer-infra-changed": {
                        APIDeployerInfraChangedEvent dice = (APIDeployerInfraChangedEvent)evt;
                        GovernIntegrationService.this.upsertAPIDeploymentInfra(dice.infraId);
                        break;
                    }
                    case "apideployer-infra-deleted": {
                        APIDeployerInfraDeletedEvent dide = (APIDeployerInfraDeletedEvent)evt;
                        GovernIntegrationService.this.deleteAPIDeployerInfra(dide.infrastructureId);
                        break;
                    }
                    case "apideployer-deployment-created": {
                        APIDeployerDeploymentCreatedEvent ddce = (APIDeployerDeploymentCreatedEvent)evt;
                        GovernIntegrationService.this.upsertAPIDeployerDeployment(ddce.deploymentId);
                        break;
                    }
                    case "apideployer-deployment-config-changed": {
                        APIDeployerDeploymentConfigChangedEvent ddcce = (APIDeployerDeploymentConfigChangedEvent)evt;
                        GovernIntegrationService.this.upsertAPIDeployerDeployment(ddcce.deploymentId);
                        break;
                    }
                    case "apideployer-deployment-deleted": {
                        APIDeployerDeploymentDeletedEvent ddde = (APIDeployerDeploymentDeletedEvent)evt;
                        GovernIntegrationService.this.deleteAPIDeployerDeployment(ddde.deploymentId);
                        break;
                    }
                    case "projectdeployer-infra-created": {
                        ProjectDeployerInfraCreatedEvent pdice = (ProjectDeployerInfraCreatedEvent)evt;
                        GovernIntegrationService.this.upsertProjectDeployerInfra(pdice.infraId);
                        break;
                    }
                    case "projectdeployer-infra-changed": {
                        ProjectDeployerInfraChangedEvent pdice = (ProjectDeployerInfraChangedEvent)evt;
                        GovernIntegrationService.this.upsertProjectDeployerInfra(pdice.infraId);
                        break;
                    }
                    case "projectdeployer-deployment-infra-deleted": {
                        ProjectDeployerInfraDeletedEvent pdide = (ProjectDeployerInfraDeletedEvent)evt;
                        GovernIntegrationService.this.deleteProjectDeployerInfra(pdide.infraId);
                        break;
                    }
                    case "projectdeployer-deployment-created": {
                        ProjectDeployerDeploymentCreatedEvent pddce = (ProjectDeployerDeploymentCreatedEvent)evt;
                        GovernIntegrationService.this.upsertProjectDeployerDeployment(pddce.deploymentId);
                        break;
                    }
                    case "projectdeployer-deployment-changed": {
                        ProjectDeployerDeploymentChangedEvent pddce = (ProjectDeployerDeploymentChangedEvent)evt;
                        GovernIntegrationService.this.upsertProjectDeployerDeployment(pddce.deploymentId);
                        break;
                    }
                    case "projectdeployer-deployment-deleted": {
                        ProjectDeployerDeploymentDeletedEvent pddde = (ProjectDeployerDeploymentDeletedEvent)evt;
                        GovernIntegrationService.this.deleteProjectDeployerDeployment(pddde.deploymentId);
                        break;
                    }
                    case "project-type-badges-changed-event": {
                        ProjectTypeBadgesChangedEvent pgabce = (ProjectTypeBadgesChangedEvent)evt;
                        GovernIntegrationService.this.upsertProject(pgabce.projectKey);
                        break;
                    }
                    default: {
                        logger.info((Object)("Govern integration encountered an unknown event type: " + evt.getName()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to sync DSS item to Dataiku Govern instance", (Throwable)e);
            }
        }
    };
    private Thread governThread;
    private static final Set<String> llmRecipeTypes = new HashSet<String>(Arrays.asList("nlp_llm_user_provided_classification", "nlp_llm_model_provided_classification", "prompt", "nlp_llm_summarization", "nlp_llm_rag_embedding", "nlp_llm_finetuning"));
    private static final String DATAIKU_ANSWERS_PLUGIN_ID = "document-question-answering";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.govern-integration");

    public GovernIntegrationService() {
        this.initGovernThread();
    }

    private synchronized void initGovernThread() {
        if (this.governThread != null) {
            this.governThread.interrupt();
            this.governThread = null;
        }
        this.governThread = new Thread(this.queueHandler);
        this.governThread.setUncaughtExceptionHandler((thread, throwable) -> {
            logger.error((Object)"Govern integration handler thread caught unhandled throwable", throwable);
            this.initGovernThread();
        });
        this.governThread.start();
    }

    @PostConstruct
    public void init() {
        DSSEventListener<BackendEvent> queueAdder = new DSSEventListener<BackendEvent>(){
            private final AtomicLong lastThrownTimestamp = new AtomicLong(0L);

            public void on(BackendEvent evt) throws Exception {
                block3: {
                    try {
                        if (GovernIntegrationService.enabledWithSanityChecksIfEnabled()) {
                            GovernIntegrationService.this.queueHandler.queue.put(evt);
                            DSSMetrics.settableLongGauge((String)"dku.governIntegrationService.queue.size").setValue((long)GovernIntegrationService.this.queueHandler.queue.size());
                        }
                        this.lastThrownTimestamp.set(0L);
                    }
                    catch (CodedException e) {
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - this.lastThrownTimestamp.get() < 3600000L) break block3;
                        logger.error((Object)"Govern integration failed", (Throwable)e);
                        this.lastThrownTimestamp.set(currentTimeMillis);
                    }
                }
            }
        };
        this.pubSubService.subscribe("object-change", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("project-bundle-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("project-bundle-deleted", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("model-version-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("model-version-changed", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("model-version-deleted", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("evaluation-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("project-bundle-activation-finished", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("apideployer-infra-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("apideployer-infra-changed", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("apideployer-infra-deleted", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("apideployer-deployment-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("apideployer-deployment-config-changed", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("apideployer-deployment-deleted", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("projectdeployer-infra-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("projectdeployer-infra-changed", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("projectdeployer-deployment-infra-deleted", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("projectdeployer-deployment-created", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("projectdeployer-deployment-changed", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("projectdeployer-deployment-deleted", (DSSEventListener)queueAdder);
        this.pubSubService.subscribe("project-type-badges-changed-event", (DSSEventListener)queueAdder);
    }

    public InfoMessage.InfoMessages testGovernIntegration() throws CodedException {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        GeneralSettingsDAO.NodeRef governRef = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef();
        if (governRef.enabled) {
            if (StringUtils.isBlank((CharSequence)DKUApp.getNodeId())) {
                ret.withError((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_NODEID_UNSET, "This instance's nodeid must be set, ask an administrator to setup this instance's nodeid.");
            }
            if (StringUtils.isBlank((CharSequence)governRef.apiKey)) {
                ret.withError((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_APIKEY_UNSET, "The Govern admin API key must be set, ask an administrator to fix the Govern integration settings.");
            } else if (StringUtils.isBlank((CharSequence)governRef.nodeUrl)) {
                ret.withError((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_HOST_UNSET, "The Govern URL must be set, ask an administrator to fix the Govern integration settings.");
            } else {
                try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
                    GovernInstanceStatus governInstanceStatus = handle.getClient().getGovernInstanceStatus();
                    if (!governInstanceStatus.isAdmin) {
                        ret.withError((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_APIKEY_NOADMIN, "Dataiku Govern API Key must be admin, ask an administrator to grant admin rights on the API Key or to change it");
                    } else {
                        ret.withSuccess((InfoMessage.MessageCode)GovernIntegrationCodes.INFO_GOVERN_TEST_OK, "Dataiku Govern Integration test passed successfully");
                    }
                }
                catch (APIError.APIErrorException e) {
                    logger.warnV((Throwable)e, "Dataiku Govern integration Test failed: the Dataiku Govern instance has returned an error: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    ret.withErrorV((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_NODE_ERROR, "The Dataiku Govern instance has returned an error, please try again later or check your configuration settings: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
                catch (IOException e) {
                    logger.warnV((Throwable)e, "Dataiku Govern integration Test failed: the Dataiku Govern instance was unreachable: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    ret.withErrorV((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_UNREACHABLE, "The Dataiku Govern instance is unreachable, please try again later or check your configuration settings: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        } else {
            ret.withError((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_DISABLED, "The Dataiku Govern integration is disabled");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse<GovernSyncReport> checkConcurrentAndFullSync(AuthCtx authCtx, final String auditType, final @Nullable String projectKey) throws Exception {
        GovernIntegrationService governIntegrationService = this;
        synchronized (governIntegrationService) {
            FutureResponse progress;
            if (StringUtils.isNotBlank((CharSequence)this.currentDeployerAndDesignFullSyncJobId) && (progress = this.futureService.getProgress(this.currentDeployerAndDesignFullSyncJobId)) != null && progress.alive) {
                throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_PENDING_SYNC, "DSS is currently syncing to Govern. Please wait for it to complete before starting another sync...");
            }
            FutureResponse<GovernSyncReport> ret = this.futureService.runFuture(new SimpleFutureThread<GovernSyncReport>(authCtx){
                final DKUtils.SmartLogTailBuilder logTailBuilder;
                {
                    super(owner);
                    this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"govern_project_sync", (String)"Synchronize DSS Items on Dataiku Govern");
                }

                @Override
                protected GovernSyncReport compute() throws Exception {
                    try {
                        GovernIntegrationService.checkGovernIntegrationIsEnabledAndProperlyConfigured();
                        GovernSyncReport report = StringUtils.isBlank((CharSequence)projectKey) ? GovernIntegrationService.this.fullSync() : GovernIntegrationService.this.projectFullSync(projectKey, true);
                        AuditTrailService.EmittableAuditObj auditObj = GovernIntegrationService.this.auditTrailService.generic(auditType);
                        if (StringUtils.isNotBlank((CharSequence)projectKey)) {
                            auditObj.with("projectKey", projectKey);
                        }
                        auditObj.emit();
                        return report;
                    }
                    catch (Exception e) {
                        GovernIntegrationService.this.auditTrailService.failure(auditType, (Throwable)e).emit();
                        throw e;
                    }
                }

                public SmartLogTail getLog() {
                    return this.logTailBuilder.get();
                }
            }, 0L, new TypeToken<FutureResponse<GovernSyncReport>>(){});
            this.currentDeployerAndDesignFullSyncJobId = ret.jobId;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse<GovernDeployerSyncReport> checkConcurrentAndDeployerFullSync(AuthCtx authCtx) throws Exception {
        GovernIntegrationService governIntegrationService = this;
        synchronized (governIntegrationService) {
            FutureResponse progress;
            if (StringUtils.isNotBlank((CharSequence)this.currentDeployerAndDesignFullSyncJobId) && (progress = this.futureService.getProgress(this.currentDeployerAndDesignFullSyncJobId)) != null && progress.alive) {
                throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_PENDING_SYNC, "DSS is currently syncing to Govern. Please wait for it to complete before starting another sync...");
            }
            FutureResponse<GovernDeployerSyncReport> ret = this.futureService.runFuture(new SimpleFutureThread<GovernDeployerSyncReport>(authCtx){
                final DKUtils.SmartLogTailBuilder logTailBuilder;
                {
                    this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"govern_deployer_sync", (String)"Synchronize DSS Deployer Items on Dataiku Govern");
                }

                @Override
                protected GovernDeployerSyncReport compute() throws Exception {
                    try {
                        GovernIntegrationService.checkGovernIntegrationIsEnabledAndProperlyConfigured();
                        GovernDeployerSyncReport report = GovernIntegrationService.this.deployerFullSync();
                        GovernIntegrationService.this.auditTrailService.generic("govern-integration-deployer-sync").emit();
                        return report;
                    }
                    catch (Exception e) {
                        GovernIntegrationService.this.auditTrailService.failure("govern-integration-deployer-sync", (Throwable)e).emit();
                        throw e;
                    }
                }

                public SmartLogTail getLog() {
                    return this.logTailBuilder.get();
                }
            }, 0L, new TypeToken<FutureResponse<GovernDeployerSyncReport>>(){});
            this.currentDeployerAndDesignFullSyncJobId = ret.jobId;
            return ret;
        }
    }

    private GovernSyncReport fullSync() throws IOException, CodedException, InterruptedException {
        List<SerializedProject> serializedProjectsList;
        logger.info((Object)"Initiating instance full sync");
        try (Transaction t = this.transactionService.beginRead();){
            serializedProjectsList = this.projectsService.listAllUnsafe();
        }
        LinkedList<String> sortedProjectKeys = new LinkedList<String>();
        for (SerializedProject serializedProject : serializedProjectsList) {
            if (GovernIntegrationService.shouldIgnoreProjectForSync(serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(serializedProject));
                continue;
            }
            if (serializedProject.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
                sortedProjectKeys.addFirst(serializedProject.projectKey);
                continue;
            }
            sortedProjectKeys.addLast(serializedProject.projectKey);
        }
        DSSProjectList dssProjectList = new DSSProjectList();
        dssProjectList.nodeId = GovernIntegrationService.getNodeIdMandatory();
        for (String projectKey : sortedProjectKeys) {
            dssProjectList.projects.add(this.buildDSSProjectIdentifier(projectKey));
        }
        try (SingleGovernIntegrationClientHandle singleGovernIntegrationClientHandle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)"Syncing project list delete diff");
            singleGovernIntegrationClientHandle.getClient().projectListDeleteDiff(dssProjectList);
        }
        GovernSyncReport governSyncReport = GovernSyncReport.buildEmpty();
        for (String projectKey : sortedProjectKeys) {
            if (Thread.currentThread() instanceof SimpleFutureThread && ((SimpleFutureThread)((Object)Thread.currentThread())).isAborted()) break;
            try {
                governSyncReport.mergeWith(this.projectFullSync(projectKey, false));
            }
            catch (Exception e) {
                ++governSyncReport.failedProjects;
                logger.warn((Object)("Project sync failed: " + projectKey), (Throwable)e);
            }
        }
        return governSyncReport;
    }

    private GovernSyncReport projectFullSync(String projectKey, boolean syncProjectTemplate) throws IOException, CodedException, InterruptedException {
        List<ModelEvaluationStore> modelEvaluationStoreList;
        List<SavedModel> savedModelList;
        List retrievableKnowledgeList;
        List<Object> serializedDatasetList;
        ProjectDetails projectDetails;
        logger.info((Object)("Initiating project full sync: " + projectKey));
        Object originTemplateProjectKey = null;
        try (Transaction t = this.transactionService.beginRead();){
            Object candidateToOriginTemplateProjectKey;
            projectDetails = this.getProjectDetails(projectKey);
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                GovernSyncReport governSyncReport = GovernSyncReport.buildEmpty();
                return governSyncReport;
            }
            if (DKUApp.getParams().getBoolParam("dku.govern-integration.disable-dataset-sync", false)) {
                logger.info((Object)"Govern dataset sync has been disabled, ignoring all datasets");
                serializedDatasetList = new ArrayList();
            } else {
                serializedDatasetList = this.datasetAccessService.listUnsafe(projectKey).stream().map(Dataset::getModel).collect(Collectors.toList());
            }
            retrievableKnowledgeList = this.retrievableKnowledgeDAO.listUnsafe(projectKey);
            savedModelList = this.savedModelsCRUDService.listUnsafe(projectKey);
            modelEvaluationStoreList = this.modelEvaluationStoresCRUDService.listUnsafe(projectKey);
            if (syncProjectTemplate && projectDetails.serializedProject.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE && StringUtils.isNotBlank((CharSequence)projectDetails.serializedProject.generatingAppId) && StringUtils.isNotBlank((CharSequence)(candidateToOriginTemplateProjectKey = GovernIntegrationService.getOriginTemplateProjectKeyOrNull(projectDetails.serializedProject.generatingAppId))) && this.projectsService.projectExists((String)candidateToOriginTemplateProjectKey)) {
                originTemplateProjectKey = candidateToOriginTemplateProjectKey;
            }
        }
        if (StringUtils.isNotBlank(originTemplateProjectKey)) {
            this.upsertProject((String)originTemplateProjectKey);
        }
        ArrayList<Object> savedModelFullInfoList = new ArrayList<Object>();
        block16: for (SavedModel savedModel : savedModelList) {
            NavigatorService.SavedModelFullInfo savedModelFullInfo = new NavigatorService.SavedModelFullInfo();
            savedModelFullInfo.model = savedModel;
            if (savedModelFullInfo.model.isPartitioned()) {
                logger.info((Object)("Saved model is partitioned, ignoring it: " + savedModelFullInfo.model.projectKey + "." + savedModelFullInfo.model.id));
                continue;
            }
            switch (savedModelFullInfo.model.getType()) {
                case PREDICTION: {
                    savedModelFullInfo.status = this.predictionSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                    break;
                }
                case CLUSTERING: {
                    savedModelFullInfo.status = this.clusteringSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                    break;
                }
                case LLM_GENERIC_RAW: 
                case LLM_GENERIC_PROMPTABLE_COMPLETION: 
                case LLM_CLASSIFICATION: {
                    savedModelFullInfo.status = LLMSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                    break;
                }
                default: {
                    logger.info((Object)("Saved model is an unknown type: " + String.valueOf((Object)savedModelFullInfo.model.getType()) + ", ignoring it: " + savedModelFullInfo.model.projectKey + "." + savedModelFullInfo.model.id));
                    continue block16;
                }
            }
            savedModelFullInfoList.add(savedModelFullInfo);
        }
        List<CommonBundleUtils.BundleInfoBase> bundleInfoBaseList = Collections.emptyList();
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.DESIGN) {
            bundleInfoBaseList = this.designBundlesService.listAvailable((String)projectKey).bundles.stream().filter(b -> b instanceof CommonBundleUtils.ExportedBundleSummary && ((CommonBundleUtils.ExportedBundleSummary)b).state == CommonBundleUtils.BundleState.BUILT).collect(Collectors.toList());
        }
        HashMap<String, Map> modelEvaluationMap = new HashMap<String, Map>();
        for (ModelEvaluationStore modelEvaluationStore : modelEvaluationStoreList) {
            if (modelEvaluationStore.governSyncOptOut) continue;
            List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader> list = this.modelEvaluationStoresCRUDService.listEvaluations(modelEvaluationStore, null, -1);
            for (ModelEvaluationStoresCRUDService.ModelEvaluationHeader modelEvaluationHeader : list) {
                FullModelId fullModelId;
                if (!modelEvaluationHeader.evaluation.onDSSSavedModel() || (fullModelId = ((TabularModelEvaluation)modelEvaluationHeader.evaluation).modelRef) == null || !Strings.equals((String)projectKey, (String)fullModelId.getProjectKey())) continue;
                String savedModelId = fullModelId.getSavedModelID();
                String fullModelIdStr = fullModelId.toString();
                ((List)modelEvaluationMap.computeIfAbsent(savedModelId, k -> Maps.newHashMap()).computeIfAbsent(fullModelIdStr, k -> Maps.newHashMap()).computeIfAbsent(modelEvaluationStore.getId(), k -> ImmutablePair.of((Object)modelEvaluationStore, (Object)Lists.newArrayList())).getRight()).add(modelEvaluationHeader);
            }
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        for (CommonBundleUtils.BundleInfoBase bundleInfoBase : bundleInfoBaseList) {
            File bundleArchive = this.designBundlesService.getBundleArchive(projectKey, bundleInfoBase.bundleId);
            dssProject.bundles.add(this.buildDSSBundle(bundleInfoBase.bundleId, bundleArchive));
        }
        for (SerializedDataset serializedDataset : serializedDatasetList) {
            dssProject.datasets.add(this.buildDSSDataset(serializedDataset));
        }
        for (RetrievableKnowledge retrievableKnowledge : retrievableKnowledgeList) {
            dssProject.retrievableKnowledges.add(this.buildDSSRetrievableKnowledge(retrievableKnowledge));
        }
        for (NavigatorService.SavedModelFullInfo savedModelFullInfo : savedModelFullInfoList) {
            dssProject.savedModels.add(this.buildDSSSavedModelWithVersions(savedModelFullInfo, (Map)modelEvaluationMap.get(savedModelFullInfo.model.id)));
        }
        GovernSyncReport governSyncReport = GovernSyncReport.build(dssProject);
        try (SingleGovernIntegrationClientHandle singleGovernIntegrationClientHandle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project full sync: " + projectKey));
            singleGovernIntegrationClientHandle.getClient().projectFullSync(dssProject);
        }
        return governSyncReport;
    }

    private GovernDeployerSyncReport deployerFullSync() throws Exception {
        Optional<AbstractDeploymentInfra> infra;
        List apiDeployerDeployments;
        List projectDeployerDeployments;
        List apiDeployerInfras;
        List projectDeployerInfras;
        logger.info((Object)("Initiating deployer sync with node ID: " + GovernIntegrationService.getNodeIdMandatory()));
        try (Transaction t = this.transactionService.beginRead();){
            projectDeployerInfras = this.automationNodeInfrasDAO.listUnsafe();
            apiDeployerInfras = this.apiNodeInfrasDAO.listUnsafe();
            projectDeployerDeployments = this.projectDeploymentsDAO.listUnsafe();
            apiDeployerDeployments = this.apiServiceDeploymentsDAO.listUnsafe();
        }
        DSSDeployerItems deployerItems = new DSSDeployerItems();
        deployerItems.nodeId = GovernIntegrationService.getNodeIdMandatory();
        for (AbstractProjectDeploymentInfra projectDeployerInfra : projectDeployerInfras) {
            deployerItems.projectInfras.add(this.buildDSSProjectDeployerInfra(projectDeployerInfra));
        }
        for (AbstractAPIDeploymentInfra apiDeployerInfra : apiDeployerInfras) {
            deployerItems.apiInfras.add(this.buildDSSAPIDeployerInfra(apiDeployerInfra));
        }
        for (AbstractProjectDeployment projectDeployerDeployment : projectDeployerDeployments) {
            infra = projectDeployerInfras.stream().filter(ifr -> Strings.equals((String)projectDeployerDeployment.infraId, (String)ifr.id)).findFirst();
            infra.ifPresent(abstractProjectDeploymentInfra -> deployerItems.projectDeployments.add(this.buildDSSProjectDeployerDeployment(projectDeployerDeployment, (AbstractProjectDeploymentInfra)abstractProjectDeploymentInfra)));
        }
        for (AbstractAPIServiceDeployment apiDeployerDeployment : apiDeployerDeployments) {
            infra = apiDeployerInfras.stream().filter(ifr -> Strings.equals((String)apiDeployerDeployment.infraId, (String)ifr.id)).findFirst();
            infra.ifPresent(abstractAPIDeploymentInfra -> deployerItems.apiDeployments.add(this.buildDSSAPIDeployerDeployment(apiDeployerDeployment, (AbstractAPIDeploymentInfra)abstractAPIDeploymentInfra)));
        }
        GovernDeployerSyncReport report = GovernDeployerSyncReport.build(deployerItems);
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            handle.getClient().deployerSync(deployerItems);
        }
        return report;
    }

    public DSSItemGovernanceStatusList getDSSItemsGovernanceStatus(DSSItemIdentifierList dssItemIdentifierList) throws CodedException, IOException {
        SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();
        try {
            DSSItemGovernanceStatusList dSSItemGovernanceStatusList = handle.getClient().getDSSItemsGovernanceStatus(dssItemIdentifierList);
            if (handle != null) {
                handle.close();
            }
            return dSSItemGovernanceStatusList;
        }
        catch (Throwable throwable) {
            try {
                if (handle != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_UNREACHABLE, "The Dataiku Govern instance is unreachable, try again later or change the settings", (Throwable)e);
            }
        }
    }

    public DSSProjectIdentifier buildDSSProjectIdentifier(String projectKey) {
        DSSProjectIdentifier dssProjectIdentifier = new DSSProjectIdentifier();
        dssProjectIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssProjectIdentifier.projectKey = projectKey;
        return dssProjectIdentifier;
    }

    public DSSSavedModelVersionIdentifier buildDSSSavedModelVersionIdentifier(FullModelId fmi, @Nullable String nodeId) {
        DSSSavedModelVersionIdentifier dssSavedModelVersionIdentifier = new DSSSavedModelVersionIdentifier();
        dssSavedModelVersionIdentifier.nodeId = nodeId;
        dssSavedModelVersionIdentifier.projectKey = fmi.getProjectKey();
        dssSavedModelVersionIdentifier.savedModelId = fmi.getSavedModelID();
        dssSavedModelVersionIdentifier.fullModelVersionId = fmi.toString();
        return dssSavedModelVersionIdentifier;
    }

    public DSSSavedModelVersionIdentifier buildDSSSavedModelVersionIdentifier(FullModelId fmi) {
        return this.buildDSSSavedModelVersionIdentifier(fmi, GovernIntegrationService.getNodeIdMandatory());
    }

    public DSSBundleIdentifier buildDSSDesignBundleIdentifier(String bundleId, String projectKey) {
        return this.buildDSSBundleIdentifier(bundleId, projectKey, GovernIntegrationService.getNodeIdMandatory());
    }

    public DSSBundleIdentifier buildDSSBundleIdentifier(String bundleId, String projectKey, String nodeId) {
        DSSBundleIdentifier dssBundleIdentifier = new DSSBundleIdentifier();
        dssBundleIdentifier.nodeId = nodeId;
        dssBundleIdentifier.projectKey = projectKey;
        dssBundleIdentifier.bundleId = bundleId;
        return dssBundleIdentifier;
    }

    private void handleTaggableObjectChangedEvent(TaggableObjectChangedEvent evt) throws CodedException, IOException, InterruptedException {
        block0 : switch (evt.action) {
            case PROJECT_CREATE: 
            case PROJECT_DUPLICATE: 
            case PROJECT_GIT_CHECKOUT: 
            case PROJECT_GIT_PULL: {
                this.projectFullSync(evt.projectKey, true);
                break;
            }
            case PROJECT_EDIT: 
            case PROJECT_LOCATION_CHANGE: {
                this.upsertProject(evt.getTaggableObjectRef().projectKey);
                break;
            }
            case PROJECT_DELETE: {
                this.deleteProject(evt.getTaggableObjectRef());
                break;
            }
            case WEB_APP_CREATE: 
            case WEB_APP_EDIT: 
            case WEB_APP_DELETE: {
                this.upsertProject(evt.getTaggableObjectRef().projectKey);
                break;
            }
            case DATASET_CREATE: 
            case DATASET_EDIT: {
                this.upsertDataset(evt.getTaggableObjectRef());
                break;
            }
            case DATASET_RENAME: {
                TaggableObjectsService.TaggableObjectRef oldDataset = new TaggableObjectsService.TaggableObjectRef(evt.projectKey, ITaggingService.TaggableType.DATASET, evt.details.get("oldName").getAsString());
                TaggableObjectsService.TaggableObjectRef newDataset = new TaggableObjectsService.TaggableObjectRef(evt.projectKey, ITaggingService.TaggableType.DATASET, evt.details.get("newName").getAsString());
                this.deleteDataset(oldDataset);
                this.upsertDataset(newDataset);
                break;
            }
            case DATASET_DELETE: {
                this.deleteDataset(evt.getTaggableObjectRef());
                break;
            }
            case RETRIEVABLE_KNOWLEDGE_CREATE: 
            case RETRIEVABLE_KNOWLEDGE_EDIT: 
            case RETRIEVABLE_KNOWLEDGE_RENAME: {
                this.upsertRetrievableKnowledge(evt.getTaggableObjectRef());
                break;
            }
            case RETRIEVABLE_KNOWLEDGE_DELETE: {
                this.deleteRetrievableKnowledge(evt.getTaggableObjectRef());
                break;
            }
            case SAVED_MODEL_CREATE: 
            case SAVED_MODEL_EDIT: 
            case SAVED_MODEL_RENAME: {
                this.upsertSavedModel(evt.getTaggableObjectRef());
                break;
            }
            case SAVED_MODEL_DELETE: {
                this.deleteSavedModel(evt.getTaggableObjectRef());
                break;
            }
            case PROMPT_STUDIO_CREATE: 
            case PROMPT_STUDIO_EDIT: 
            case PROMPT_STUDIO_DELETE: 
            case RECIPE_CREATE: 
            case RECIPE_EDIT: 
            case RECIPE_DELETE: {
                this.upsertProject(evt.getTaggableObjectRef().projectKey);
                break;
            }
            case EDIT_COLLABORATIVE_METADATA: {
                switch (evt.objectType) {
                    case PROJECT: {
                        this.upsertProject(evt.getTaggableObjectRef().projectKey);
                        break block0;
                    }
                    case DATASET: {
                        this.upsertDataset(evt.getTaggableObjectRef());
                        break block0;
                    }
                    case SAVED_MODEL: {
                        this.upsertSavedModel(evt.getTaggableObjectRef());
                        break block0;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        this.upsertRetrievableKnowledge(evt.getTaggableObjectRef());
                        break block0;
                    }
                }
            }
        }
    }

    private void upsertProject(String projectKey) throws IOException, CodedException, InterruptedException {
        ProjectDetails projectDetails;
        logger.info((Object)("Initiating project upsert: " + projectKey));
        try (Transaction t = this.transactionService.beginRead();){
            projectDetails = this.getProjectDetails(projectKey);
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                return;
            }
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project upsert: " + projectKey));
            handle.getClient().projectPartialSync(dssProject);
        }
    }

    private void deleteProject(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating project delete: " + taggableObjectRef.projectKey));
        DSSProjectIdentifier dssProjectIdentifier = new DSSProjectIdentifier();
        dssProjectIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssProjectIdentifier.projectKey = taggableObjectRef.projectKey;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project delete: " + taggableObjectRef.projectKey));
            handle.getClient().deleteDSSItem((DSSItemIdentifier)dssProjectIdentifier);
        }
    }

    private void upsertDataset(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        SerializedDataset serializedDataset;
        ProjectDetails projectDetails;
        if (DKUApp.getParams().getBoolParam("dku.govern-integration.disable-dataset-sync", false)) {
            logger.info((Object)"Govern dataset sync has been disabled, ignoring the dataset");
            return;
        }
        logger.info((Object)("Initiating dataset upsert: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
        try (Transaction t = this.transactionService.beginRead();){
            projectDetails = this.getProjectDetails(taggableObjectRef.projectKey);
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                return;
            }
            serializedDataset = this.datasetAccessService.getMandatoryUnsafe(taggableObjectRef.projectKey, taggableObjectRef.id).getModel();
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        dssProject.datasets.add(this.buildDSSDataset(serializedDataset));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing dataset upsert: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            handle.getClient().projectPartialSync(dssProject);
        }
    }

    private void deleteDataset(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating dataset delete: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
        DSSDatasetIdentifier dssDatasetIdentifier = new DSSDatasetIdentifier();
        dssDatasetIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssDatasetIdentifier.projectKey = taggableObjectRef.projectKey;
        dssDatasetIdentifier.datasetName = taggableObjectRef.id;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing dataset delete: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            handle.getClient().deleteDSSItem((DSSItemIdentifier)dssDatasetIdentifier);
        }
    }

    private void upsertRetrievableKnowledge(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        RetrievableKnowledge retrievableKnowledge;
        ProjectDetails projectDetails;
        logger.info((Object)("Initiating retrievable knowledge upsert: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
        try (Transaction t = this.transactionService.beginRead();){
            projectDetails = this.getProjectDetails(taggableObjectRef.projectKey);
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                return;
            }
            retrievableKnowledge = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(taggableObjectRef.projectKey, taggableObjectRef.id);
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        dssProject.retrievableKnowledges.add(this.buildDSSRetrievableKnowledge(retrievableKnowledge));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing retrievable knowledge upsert: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            handle.getClient().projectPartialSync(dssProject);
        }
    }

    private void deleteRetrievableKnowledge(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating retrievable knowledge delete: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
        DSSRetrievableKnowledgeIdentifier dssRetrievableKnowledgeIdentifier = new DSSRetrievableKnowledgeIdentifier();
        dssRetrievableKnowledgeIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssRetrievableKnowledgeIdentifier.projectKey = taggableObjectRef.projectKey;
        dssRetrievableKnowledgeIdentifier.retrievableKnowledgeId = taggableObjectRef.id;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing retrievable knowledge delete: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            handle.getClient().deleteDSSItem((DSSItemIdentifier)dssRetrievableKnowledgeIdentifier);
        }
    }

    private void upsertProjectBundle(String projectKey, String bundleId) throws Exception {
        ProjectDetails projectDetails;
        logger.info((Object)("Initiating bundle upsert: " + projectKey + "." + bundleId));
        try (Transaction t = this.transactionService.beginRead();){
            projectDetails = this.getProjectDetails(projectKey);
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                return;
            }
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        File bundleArchive = this.designBundlesService.getBundleArchive(projectKey, bundleId);
        dssProject.bundles.add(this.buildDSSBundle(bundleId, bundleArchive));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing bundle upsert: " + projectKey + "." + bundleId));
            handle.getClient().projectPartialSync(dssProject);
        }
    }

    private void deleteProjectBundle(String projectKey, String bundleId) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating bundle delete: " + projectKey + "." + bundleId));
        DSSBundleIdentifier dssBundleIdentifier = new DSSBundleIdentifier();
        dssBundleIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssBundleIdentifier.projectKey = projectKey;
        dssBundleIdentifier.bundleId = bundleId;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing bundle delete: " + projectKey + "." + bundleId));
            handle.getClient().deleteDSSItem((DSSItemIdentifier)dssBundleIdentifier);
        }
    }

    private void upsertSavedModel(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        ProjectDetails projectDetails;
        logger.info((Object)("Initiating saved model upsert: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
        NavigatorService.SavedModelFullInfo savedModelFullInfo = new NavigatorService.SavedModelFullInfo();
        try (Transaction t = this.transactionService.beginRead();){
            projectDetails = this.getProjectDetails(taggableObjectRef.projectKey);
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                return;
            }
            savedModelFullInfo.model = this.savedModelsCRUDService.getMandatoryUnsafe(taggableObjectRef.projectKey, taggableObjectRef.id);
        }
        if (savedModelFullInfo.model.isPartitioned()) {
            logger.info((Object)("Saved model is partitioned, ignoring it: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            return;
        }
        switch (savedModelFullInfo.model.getType()) {
            case PREDICTION: {
                savedModelFullInfo.status = this.predictionSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                break;
            }
            case CLUSTERING: {
                savedModelFullInfo.status = this.clusteringSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                savedModelFullInfo.status = LLMSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                break;
            }
            default: {
                logger.info((Object)("Saved model is an unknown type: " + String.valueOf((Object)savedModelFullInfo.model.getType()) + ", ignoring it: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
                return;
            }
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        dssProject.savedModels.add(this.buildDSSSavedModelWithVersions(savedModelFullInfo, null));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing saved model upsert: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            handle.getClient().projectPartialSync(dssProject);
        }
    }

    private void deleteSavedModel(TaggableObjectsService.TaggableObjectRef taggableObjectRef) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating saved model delete: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
        DSSSavedModelIdentifier dssSavedModelIdentifier = new DSSSavedModelIdentifier();
        dssSavedModelIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssSavedModelIdentifier.projectKey = taggableObjectRef.projectKey;
        dssSavedModelIdentifier.savedModelId = taggableObjectRef.id;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing saved model delete: " + taggableObjectRef.projectKey + "." + taggableObjectRef.id));
            handle.getClient().deleteDSSItem((DSSItemIdentifier)dssSavedModelIdentifier);
        }
    }

    private void upsertSavedModelVersions(String fullModelId) throws IOException, CodedException, InterruptedException {
        ProjectDetails projectDetails;
        logger.info((Object)("Initiating saved model version upsert: " + fullModelId));
        FullModelId fmi = FullModelId.parse(fullModelId);
        NavigatorService.SavedModelFullInfo savedModelFullInfo = new NavigatorService.SavedModelFullInfo();
        try (Transaction t = this.transactionService.beginRead();){
            projectDetails = this.getProjectDetails(fmi.getProjectKey());
            if (GovernIntegrationService.shouldIgnoreProjectForSync(projectDetails.serializedProject)) {
                logger.info((Object)GovernIntegrationService.buildIgnoreMessageForSync(projectDetails.serializedProject));
                return;
            }
            savedModelFullInfo.model = this.savedModelsCRUDService.getMandatoryUnsafe(fmi.getProjectKey(), fmi.getSavedModelID());
        }
        if (savedModelFullInfo.model.isPartitioned()) {
            logger.info((Object)("Saved model version is partitioned, ignoring it: " + fullModelId));
            return;
        }
        switch (savedModelFullInfo.model.getType()) {
            case PREDICTION: {
                savedModelFullInfo.status = this.predictionSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                break;
            }
            case CLUSTERING: {
                savedModelFullInfo.status = this.clusteringSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                savedModelFullInfo.status = LLMSMMgmtService.getStatus_NT(savedModelFullInfo.model);
                break;
            }
            default: {
                logger.info((Object)("Saved model version type is unknown: " + String.valueOf((Object)savedModelFullInfo.model.getType()) + ", ignoring it: " + fullModelId));
                return;
            }
        }
        DSSProject dssProject = this.buildDSSProject(projectDetails);
        dssProject.savedModels.add(this.buildDSSSavedModelWithVersions(savedModelFullInfo, null));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing saved model version upsert: " + fullModelId));
            handle.getClient().projectPartialSync(dssProject);
        }
    }

    private void deleteSavedModelVersion(String fullModelId) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating saved model version delete: " + fullModelId));
        DSSSavedModelVersionIdentifier dssSavedModelVersionIdentifier = new DSSSavedModelVersionIdentifier();
        dssSavedModelVersionIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        FullModelId fmi = FullModelId.parse(fullModelId);
        dssSavedModelVersionIdentifier.projectKey = fmi.getProjectKey();
        dssSavedModelVersionIdentifier.savedModelId = fmi.getSavedModelID();
        dssSavedModelVersionIdentifier.fullModelVersionId = fullModelId;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing saved model version delete: " + fullModelId));
            handle.getClient().deleteDSSItem((DSSItemIdentifier)dssSavedModelVersionIdentifier);
        }
    }

    private void upsertEvaluation(String projectKey, String modelEvaluationStoreId, String evaluationRunId) throws IOException, CodedException, InterruptedException {
        FullModelId fmi;
        ModelEvaluationStoresCRUDService.ModelEvaluationHeader modelEvaluationHeader;
        ModelEvaluationStore modelEvaluationStore;
        logger.info((Object)("Initiating evaluation metrics upsert: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId));
        NavigatorService.SavedModelFullInfo savedModelFullInfo = new NavigatorService.SavedModelFullInfo();
        try (Transaction t = this.transactionService.beginRead();){
            modelEvaluationStore = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, modelEvaluationStoreId);
            if (modelEvaluationStore.governSyncOptOut) {
                logger.info((Object)("Model evaluation store opts out from govern sync, ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId));
                return;
            }
            Optional<ModelEvaluationStoresCRUDService.ModelEvaluationHeader> modelEvaluationHeaderOptional = this.modelEvaluationStoresCRUDService.listEvaluations(modelEvaluationStore, null, -1).stream().filter(meh -> Strings.equals((String)meh.evaluation.ref.evaluationId, (String)evaluationRunId)).findAny();
            if (modelEvaluationHeaderOptional.isEmpty()) {
                logger.info((Object)("Evaluation run is missing from the Model evaluation store, ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId));
                return;
            }
            modelEvaluationHeader = modelEvaluationHeaderOptional.get();
            if (!modelEvaluationHeader.isTabular()) {
                logger.info((Object)"Non tabular Model Evaluations do not have a dss-model, ignoring it.");
                return;
            }
            fmi = ((TabularModelEvaluation)modelEvaluationHeader.evaluation).modelRef;
            if (fmi == null) {
                logger.info((Object)("FullModelId is missing from the evaluation run, ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId));
                return;
            }
            savedModelFullInfo.model = this.savedModelsCRUDService.getMandatoryUnsafe(fmi.getProjectKey(), fmi.getSavedModelID());
        }
        if (savedModelFullInfo.model.isPartitioned()) {
            logger.info((Object)("Associated saved model version is partitioned, ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId + " " + fmi.toString()));
            return;
        }
        switch (savedModelFullInfo.model.getType()) {
            case PREDICTION: {
                break;
            }
            case CLUSTERING: {
                logger.info((Object)("Associated saved model is clustering, ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId + " " + fmi.toString()));
                return;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                logger.info((Object)("Associated saved model is of an LLM type, ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId + " " + fmi.toString()));
                return;
            }
            default: {
                logger.info((Object)("Associated saved model is of an unknown type: " + String.valueOf((Object)savedModelFullInfo.model.getType()) + ", ignoring it: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId + " " + fmi.toString()));
                return;
            }
        }
        DSSSavedModelVersionEvaluationMetrics dssSavedModelVersionEvaluationMetrics = new DSSSavedModelVersionEvaluationMetrics();
        dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier = this.buildDSSSavedModelVersionIdentifier(fmi);
        dssSavedModelVersionEvaluationMetrics.evaluationMetrics.addAll(this.buildDataPoints(Collections.singletonMap(modelEvaluationStore.getId(), ImmutablePair.of((Object)modelEvaluationStore, (Object)Lists.newArrayList((Object[])new ModelEvaluationStoresCRUDService.ModelEvaluationHeader[]{modelEvaluationHeader})))));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing evaluation metrics upsert: " + projectKey + "." + modelEvaluationStoreId + "." + evaluationRunId));
            handle.getClient().modelVersionEvaluationMetricsPartialSync(dssSavedModelVersionEvaluationMetrics);
        }
    }

    private void upsertAPIDeploymentInfra(String infraId) throws IOException, CodedException, InterruptedException {
        AbstractAPIDeploymentInfra infra;
        logger.info((Object)("Initiating API Deployer infrastructure upsert: " + infraId));
        try (Transaction ignored = this.transactionService.beginRead();){
            infra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasDAO.getMandatoryUnsafe(infraId);
        }
        DSSDeployerItems deployerItems = new DSSDeployerItems();
        deployerItems.nodeId = GovernIntegrationService.getNodeIdMandatory();
        deployerItems.apiInfras.add(this.buildDSSAPIDeployerInfra(infra));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing API Deployer infrastructure upsert: " + infraId));
            handle.getClient().deployerPartialSync(deployerItems);
        }
    }

    private void deleteAPIDeployerInfra(String infraId) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating API Deployer infrastructure delete: " + infraId));
        DSSAPIDeployerInfraIdentifier dssAPIInfraIdentifier = new DSSAPIDeployerInfraIdentifier();
        dssAPIInfraIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssAPIInfraIdentifier.infraId = infraId;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing API Deployer infrastructure delete: " + infraId));
            handle.getClient().deleteDeployerItem((DSSItemIdentifier)dssAPIInfraIdentifier);
        }
    }

    private void upsertAPIDeployerDeployment(String deploymentId) throws Exception {
        AbstractAPIDeploymentInfra infra;
        AbstractAPIServiceDeployment deployment;
        logger.info((Object)("Initiating API Deployer deployment upsert: " + deploymentId));
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.apiServiceDeploymentsDAO.getMandatoryUnsafe(deploymentId);
            infra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasDAO.getMandatoryUnsafe(deployment.infraId);
        }
        DSSDeployerItems deployerItems = new DSSDeployerItems();
        deployerItems.nodeId = GovernIntegrationService.getNodeIdMandatory();
        deployerItems.apiInfras.add(this.buildDSSAPIDeployerInfra(infra));
        deployerItems.apiDeployments.add(this.buildDSSAPIDeployerDeployment(deployment, infra));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing API Deployer deployment upsert: " + deploymentId));
            handle.getClient().deployerPartialSync(deployerItems);
        }
    }

    private void deleteAPIDeployerDeployment(String deploymentId) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating API Deployer deployment delete: " + deploymentId));
        DSSAPIDeployerDeploymentIdentifier dssAPIDeployment = new DSSAPIDeployerDeploymentIdentifier();
        dssAPIDeployment.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssAPIDeployment.deploymentId = deploymentId;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing API Deployer deployment delete: " + deploymentId));
            handle.getClient().deleteDeployerItem((DSSItemIdentifier)dssAPIDeployment);
        }
    }

    private void upsertProjectDeployerInfra(String infraId) throws IOException, CodedException, InterruptedException {
        AbstractProjectDeploymentInfra infra;
        logger.info((Object)("Initiating project deployer infrastructure upsert: " + infraId));
        try (Transaction ignored = this.transactionService.beginRead();){
            infra = (AbstractProjectDeploymentInfra)this.automationNodeInfrasDAO.getMandatoryUnsafe(infraId);
        }
        DSSDeployerItems deployerItems = new DSSDeployerItems();
        deployerItems.nodeId = GovernIntegrationService.getNodeIdMandatory();
        deployerItems.projectInfras.add(this.buildDSSProjectDeployerInfra(infra));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project deployer infrastructure upsert: " + infraId));
            handle.getClient().deployerPartialSync(deployerItems);
        }
    }

    private void deleteProjectDeployerInfra(String infraId) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating project deployer infrastructure delete: " + infraId));
        DSSProjectDeployerInfraIdentifier dssProjectInfraIdentifier = new DSSProjectDeployerInfraIdentifier();
        dssProjectInfraIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssProjectInfraIdentifier.infraId = infraId;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project deployer infrastructure delete: " + infraId));
            handle.getClient().deleteDeployerItem((DSSItemIdentifier)dssProjectInfraIdentifier);
        }
    }

    private void upsertProjectDeployerDeployment(String deploymentId) throws Exception {
        AbstractProjectDeploymentInfra infra;
        AbstractProjectDeployment deployment;
        logger.info((Object)("Initiating project deployer deployment upsert: " + deploymentId));
        try (Transaction ignored = this.transactionService.beginRead();){
            deployment = (AbstractProjectDeployment)this.projectDeploymentsDAO.getMandatoryUnsafe(deploymentId);
            infra = (AbstractProjectDeploymentInfra)this.automationNodeInfrasDAO.getMandatoryUnsafe(deployment.infraId);
        }
        DSSDeployerItems deployerItems = new DSSDeployerItems();
        deployerItems.nodeId = GovernIntegrationService.getNodeIdMandatory();
        deployerItems.projectInfras.add(this.buildDSSProjectDeployerInfra(infra));
        deployerItems.projectDeployments.add(this.buildDSSProjectDeployerDeployment(deployment, infra));
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project deployer deployment upsert: " + deploymentId));
            handle.getClient().deployerPartialSync(deployerItems);
        }
    }

    private void deleteProjectDeployerDeployment(String deploymentId) throws IOException, CodedException, InterruptedException {
        logger.info((Object)("Initiating project deployer deployment delete: " + deploymentId));
        DSSProjectDeployerDeploymentIdentifier dssProjectDeploymentIdentifier = new DSSProjectDeployerDeploymentIdentifier();
        dssProjectDeploymentIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssProjectDeploymentIdentifier.deploymentId = deploymentId;
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            logger.info((Object)("Syncing project deployer deployment delete: " + deploymentId));
            handle.getClient().deleteDeployerItem((DSSItemIdentifier)dssProjectDeploymentIdentifier);
        }
    }

    private DSSProject buildDSSProject(ProjectDetails projectDetails) throws IOException {
        String originTemplateProjectKey;
        DSSProject dssProject = new DSSProject();
        dssProject.dssProjectIdentifier = this.buildDSSProjectIdentifier(projectDetails.serializedProject.projectKey);
        if (projectDetails.serializedProject.projectStatus != null) {
            dssProject.details.put("project_status", projectDetails.serializedProject.projectStatus);
        }
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            CommonBundleUtils.BundleDetails activeBundle;
            if (projectDetails.serializedProject.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE) {
                throw ErrorContext.iae((String)("Project application instances are not supported on the automation node: " + projectDetails.serializedProject.projectKey));
            }
            String activeBundleId = null;
            try (Transaction t = this.transactionService.beginRead();){
                if (CommonBundleUtils.hasActiveBundle(projectDetails.serializedProject.projectKey)) {
                    activeBundleId = CommonBundleUtils.getActiveBundleId(projectDetails.serializedProject.projectKey);
                }
            }
            if (StringUtils.isNotBlank(activeBundleId) && (activeBundle = this.automationBundlesService.getBundleDetails(projectDetails.serializedProject.projectKey, activeBundleId)) != null && activeBundle.exportManifest != null) {
                if (StringUtils.isNotBlank((CharSequence)activeBundle.exportManifest.designNodeId)) {
                    dssProject.details.put("original_node_id", activeBundle.exportManifest.designNodeId);
                }
                if (StringUtils.isNotBlank((CharSequence)activeBundle.exportManifest.originalProjectKey)) {
                    dssProject.details.put("original_project_key", activeBundle.exportManifest.originalProjectKey);
                }
            }
        }
        if (projectDetails.serializedProject.projectAppType != null) {
            dssProject.details.put("project_application_type", projectDetails.serializedProject.projectAppType);
        }
        if (projectDetails.serializedProject.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE && StringUtils.isNotBlank((CharSequence)projectDetails.serializedProject.generatingAppId) && StringUtils.isNotBlank((CharSequence)(originTemplateProjectKey = GovernIntegrationService.getOriginTemplateProjectKeyOrNull(projectDetails.serializedProject.generatingAppId)))) {
            dssProject.templateProjectKey = originTemplateProjectKey;
        }
        dssProject.name = projectDetails.serializedProject.name;
        dssProject.projectCreationDate = this.getCreationDateOrBlank(projectDetails.serializedProject);
        this.fillTaggableObjectDetails(projectDetails.serializedProject, dssProject.details);
        this.fillLLMUsageDetails(projectDetails.llmUsage, dssProject.details);
        this.fillGenAIBadgesDetails(projectDetails.projectGenAIBadges, dssProject.details);
        this.fillProjectLocation(projectDetails.projectLocation, dssProject.details);
        return dssProject;
    }

    private DSSBundle buildDSSBundle(String bundleId, File bundleArchive) {
        BundleDetails bundleDetails = new BundleDetails(bundleArchive);
        DSSBundle dssBundle = new DSSBundle();
        dssBundle.bundleId = bundleId;
        if (bundleDetails.exportUserInfo != null && StringUtils.isNotBlank((CharSequence)bundleDetails.exportUserInfo.exportedOn)) {
            long exportedOn = DKUDateUtils.parseISOUTC((String)bundleDetails.exportUserInfo.exportedOn);
            dssBundle.bundleCreationDate = Long.toString(exportedOn);
        } else {
            dssBundle.bundleCreationDate = "";
        }
        if (bundleDetails.exportUserInfo != null && StringUtils.isNotBlank((CharSequence)bundleDetails.exportUserInfo.exportedBy)) {
            dssBundle.details.put("createdBy", bundleDetails.exportUserInfo.exportedBy);
        }
        if (bundleDetails.exportUserInfo != null && StringUtils.isNotBlank((CharSequence)bundleDetails.exportUserInfo.releaseNotes)) {
            dssBundle.details.put("release_notes", bundleDetails.exportUserInfo.releaseNotes);
        }
        this.fillLLMUsageDetails(bundleDetails.llmUsage, dssBundle.details);
        this.fillGenAIBadgesDetails(bundleDetails.projectGenAIBadges, dssBundle.details);
        this.fillProjectStandardsReportDetails(bundleDetails.projectStandardsReport, bundleDetails.projectStandardsReportSummary, dssBundle.details);
        return dssBundle;
    }

    private DSSDataset buildDSSDataset(SerializedDataset serializedDataset) {
        DSSDataset dssDataset = new DSSDataset();
        dssDataset.datasetName = serializedDataset.name;
        dssDataset.datasetCreationDate = this.getCreationDateOrBlank(serializedDataset);
        this.fillTaggableObjectDetails(serializedDataset, dssDataset.details);
        return dssDataset;
    }

    private DSSRetrievableKnowledge buildDSSRetrievableKnowledge(RetrievableKnowledge retrievableKnowledge) {
        DSSRetrievableKnowledge dssRetrievableKnowledge = new DSSRetrievableKnowledge();
        dssRetrievableKnowledge.retrievableKnowledgeId = retrievableKnowledge.id;
        dssRetrievableKnowledge.name = retrievableKnowledge.name;
        dssRetrievableKnowledge.retrievableKnowledgeCreationDate = this.getCreationDateOrBlank(retrievableKnowledge);
        this.fillTaggableObjectDetails(retrievableKnowledge, dssRetrievableKnowledge.details);
        dssRetrievableKnowledge.details.put("vector_store_type", retrievableKnowledge.vectorStoreType);
        return dssRetrievableKnowledge;
    }

    private DSSProjectDeployerInfra buildDSSProjectDeployerInfra(AbstractProjectDeploymentInfra infra) {
        DSSProjectDeployerInfra dssAutomationInfra = new DSSProjectDeployerInfra();
        dssAutomationInfra.dssProjectDeployerInfraIdentifier = new DSSProjectDeployerInfraIdentifier();
        dssAutomationInfra.dssProjectDeployerInfraIdentifier.infraId = infra.id;
        dssAutomationInfra.dssProjectDeployerInfraIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssAutomationInfra.details.put("type", infra.getInfraType());
        dssAutomationInfra.details.put("stage", infra.stage);
        dssAutomationInfra.details.put("govern_check_policy", infra.governCheckPolicy);
        return dssAutomationInfra;
    }

    private DSSAPIDeployerInfra buildDSSAPIDeployerInfra(AbstractAPIDeploymentInfra apiDeployerInfra) {
        DSSAPIDeployerInfra dssAPIDeployerInfra = new DSSAPIDeployerInfra();
        dssAPIDeployerInfra.dssAPIDeployerInfraIdentifier = new DSSAPIDeployerInfraIdentifier();
        dssAPIDeployerInfra.dssAPIDeployerInfraIdentifier.infraId = apiDeployerInfra.id;
        dssAPIDeployerInfra.dssAPIDeployerInfraIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssAPIDeployerInfra.details.put("type", apiDeployerInfra.getInfraType());
        dssAPIDeployerInfra.details.put("stage", apiDeployerInfra.stage);
        dssAPIDeployerInfra.details.put("govern_check_policy", apiDeployerInfra.governCheckPolicy);
        return dssAPIDeployerInfra;
    }

    private DSSProjectDeployerDeployment buildDSSProjectDeployerDeployment(AbstractProjectDeployment projectDeployment, AbstractProjectDeploymentInfra projectDeployerInfra) {
        DSSProjectDeployerDeployment dssProjectDeployerDeployment = new DSSProjectDeployerDeployment();
        dssProjectDeployerDeployment.dssProjectDeployerDeploymentIdentifier = new DSSProjectDeployerDeploymentIdentifier();
        dssProjectDeployerDeployment.dssProjectDeployerDeploymentIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssProjectDeployerDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId = projectDeployment.id;
        dssProjectDeployerDeployment.dssProjectDeployerInfraIdentifier = new DSSProjectDeployerInfraIdentifier();
        dssProjectDeployerDeployment.dssProjectDeployerInfraIdentifier.infraId = projectDeployment.infraId;
        dssProjectDeployerDeployment.dssProjectDeployerInfraIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssProjectDeployerDeployment.details.put("published_project_key", projectDeployment.publishedProjectKey);
        dssProjectDeployerDeployment.details.put("deployed_project_key", projectDeployment.deployedProjectKey);
        dssProjectDeployerDeployment.details.put("project_folder_id", projectDeployment.projectFolderId);
        dssProjectDeployerDeployment.details.put("type", projectDeployerInfra.getInfraType());
        try {
            PublishedProjectBundleInfoForGovernIdentification piGovern = this.publishedProjectsService.getPublishedPackageInfoForGovernIdentification_NT(projectDeployment.getPublishedItemId(), projectDeployment.bundleId);
            dssProjectDeployerDeployment.bundleIdentifier = GovernIntegrationService.buildDSSBundleIdentifier(piGovern);
        }
        catch (Exception e) {
            logger.warn((Object)("Cannot get bundle identifiers for Project Deployer deployment sync, skipping it: " + projectDeployment.id), (Throwable)e);
        }
        return dssProjectDeployerDeployment;
    }

    private DSSAPIDeployerDeployment buildDSSAPIDeployerDeployment(AbstractAPIServiceDeployment apiServiceDeployment, AbstractAPIDeploymentInfra apiDeployerInfra) {
        DSSAPIDeployerDeployment dssAPIDeployerDeployment = new DSSAPIDeployerDeployment();
        dssAPIDeployerDeployment.dssAPIDeployerDeploymentIdentifier = new DSSAPIDeployerDeploymentIdentifier();
        dssAPIDeployerDeployment.dssAPIDeployerInfraIdentifier = new DSSAPIDeployerInfraIdentifier();
        dssAPIDeployerDeployment.dssAPIDeployerDeploymentIdentifier.deploymentId = apiServiceDeployment.id;
        dssAPIDeployerDeployment.dssAPIDeployerDeploymentIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssAPIDeployerDeployment.dssAPIDeployerInfraIdentifier.infraId = apiServiceDeployment.infraId;
        dssAPIDeployerDeployment.dssAPIDeployerInfraIdentifier.nodeId = GovernIntegrationService.getNodeIdMandatory();
        dssAPIDeployerDeployment.details.put("published_service_id", apiServiceDeployment.publishedServiceId);
        dssAPIDeployerDeployment.details.put("deployed_service_id", StringUtils.isNotBlank((CharSequence)apiServiceDeployment.deployedServiceId) ? apiServiceDeployment.deployedServiceId : apiServiceDeployment.publishedServiceId);
        dssAPIDeployerDeployment.details.put("type", apiDeployerInfra.getInfraType());
        ArrayList<String> versionIds = new ArrayList<String>();
        if (apiServiceDeployment.generationsMapping == null) {
            logger.warn((Object)("The deployment does not contain any version for deployment ID: " + apiServiceDeployment.id));
        } else {
            for (GenerationsMapping.MappingEntry mappingEntry : apiServiceDeployment.generationsMapping.getEntries()) {
                versionIds.add(mappingEntry.generation);
            }
        }
        ArrayList<PublishedApiServicePackageInfoForGovernIdentification> publishedPackages = new ArrayList<PublishedApiServicePackageInfoForGovernIdentification>();
        for (String packageId : versionIds) {
            try {
                PublishedApiServicePackageInfoForGovernIdentification piGovern = this.publishedAPIServicesService.getPublishedPackageInfoForGovernIdentification_NT(apiServiceDeployment.getPublishedItemId(), packageId);
                publishedPackages.add(piGovern);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Cannot get a saved model version identifiers for API Deployer deployment sync, skipping it: %s", new Object[]{apiServiceDeployment.id});
            }
        }
        for (PublishedApiServicePackageInfoForGovernIdentification publishedPackage : publishedPackages) {
            dssAPIDeployerDeployment.savedModelVersionIdentifiers.addAll(GovernIntegrationService.buildDSSSavedModelVersionIdentifierList(publishedPackage));
        }
        return dssAPIDeployerDeployment;
    }

    private DSSSavedModel buildDSSSavedModelWithVersions(NavigatorService.SavedModelFullInfo savedModelFullInfo, @Nullable Map<String, Map<String, Pair<ModelEvaluationStore, List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader>>>> modelEvaluationStoreMapByFullModelId) throws IOException {
        DSSSavedModel dssSavedModel = new DSSSavedModel();
        dssSavedModel.savedModelId = savedModelFullInfo.model.id;
        dssSavedModel.savedModelCreationDate = this.getCreationDateOrBlank(savedModelFullInfo.model);
        dssSavedModel.name = savedModelFullInfo.model.name;
        this.fillTaggableObjectDetails(savedModelFullInfo.model, dssSavedModel.details);
        this.fillSavedModelFullInfoForSavedModelAndVersions(savedModelFullInfo, dssSavedModel.details);
        if (StringUtils.isNotBlank((CharSequence)savedModelFullInfo.model.activeVersion)) {
            dssSavedModel.details.put("activeVersion", new FullModelId(savedModelFullInfo.model.projectKey, savedModelFullInfo.model.id, savedModelFullInfo.model.activeVersion).toString());
        }
        switch (savedModelFullInfo.model.getType()) {
            case PREDICTION: {
                PredictionSMMgmtService.PredictionSMStatus predictionSMStatus = (PredictionSMMgmtService.PredictionSMStatus)savedModelFullInfo.status;
                for (PredictionSMMgmtService.PredictionSMVersionHeader predictionSMVersionHeader : predictionSMStatus.versions) {
                    Map<String, Pair<ModelEvaluationStore, List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader>>> modelEvaluationStoreMap = modelEvaluationStoreMapByFullModelId != null ? modelEvaluationStoreMapByFullModelId.get(((PredictionModelSnippetData)predictionSMVersionHeader.snippet).fullModelId) : null;
                    dssSavedModel.savedModelVersions.add(this.buildDSSPredictionSavedModelVersion(predictionSMVersionHeader, savedModelFullInfo, modelEvaluationStoreMap));
                }
                break;
            }
            case CLUSTERING: {
                ClusteringSMMgmtService.ClusteringSMStatus clusteringSMStatus = (ClusteringSMMgmtService.ClusteringSMStatus)savedModelFullInfo.status;
                for (ClusteringSMMgmtService.ClusteringSMVersionHeader clusteringSMVersionHeader : clusteringSMStatus.versions) {
                    dssSavedModel.savedModelVersions.add(this.buildDSSClusteringSavedModelVersion(clusteringSMVersionHeader, savedModelFullInfo));
                }
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                LLMSMMgmtService.LLMSMStatus llmSMStatus = (LLMSMMgmtService.LLMSMStatus)savedModelFullInfo.status;
                for (LLMSMMgmtService.LLMSMVersionHeader llmSMVersionHeader : llmSMStatus.versions) {
                    dssSavedModel.savedModelVersions.add(switch (savedModelFullInfo.model.savedModelType) {
                        case SavedModel.SavedModelType.PYTHON_AGENT, SavedModel.SavedModelType.PLUGIN_AGENT, SavedModel.SavedModelType.TOOLS_USING_AGENT -> this.buildDSSAgentSavedModelVersion(llmSMVersionHeader, savedModelFullInfo);
                        case SavedModel.SavedModelType.LLM_GENERIC -> this.buildDSSFineTuningSavedModelVersion(llmSMVersionHeader, savedModelFullInfo);
                        case SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM -> this.buildDSSAugmentedSavedModelVersion(llmSMVersionHeader, savedModelFullInfo);
                        case SavedModel.SavedModelType.DSS_MANAGED, SavedModel.SavedModelType.PROXY_MODEL, SavedModel.SavedModelType.MLFLOW_PYFUNC -> throw new IllegalArgumentException("Invalid saved model type for an LLM saved model: " + String.valueOf((Object)savedModelFullInfo.model.savedModelType));
                        default -> throw new IllegalArgumentException("Unknown saved model type: " + String.valueOf((Object)savedModelFullInfo.model.savedModelType));
                    });
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown saved model type: " + String.valueOf((Object)savedModelFullInfo.model.getType()));
            }
        }
        return dssSavedModel;
    }

    private DSSPredictionSavedModelVersion buildDSSPredictionSavedModelVersion(PredictionSMMgmtService.PredictionSMVersionHeader predictionSMVersionHeader, NavigatorService.SavedModelFullInfo savedModelFullInfo, @Nullable Map<String, Pair<ModelEvaluationStore, List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader>>> modelEvaluationStoreMap) throws IOException {
        DSSPredictionSavedModelVersion dssSavedModelVersion = new DSSPredictionSavedModelVersion();
        dssSavedModelVersion.fullModelVersionId = ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).fullModelId;
        dssSavedModelVersion.name = ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).userMeta.name;
        switch (((PredictionModelSnippetData)predictionSMVersionHeader.snippet).savedModelType.savedModelHandlingType) {
            case EXTERNAL_MLFLOW: {
                ModelLikeId modelLikeId = ModelLikeId.parse(((PredictionModelSnippetData)predictionSMVersionHeader.snippet).fullModelId, null);
                dssSavedModelVersion.savedModelVersionCreationDate = Long.toString(modelLikeId.getUnderlyingModel().getMLflowImportedModelMetadata().importedOn);
                break;
            }
            case INTERNAL: {
                if (((PredictionModelSnippetData)predictionSMVersionHeader.snippet).trainInfo != null) {
                    dssSavedModelVersion.savedModelVersionCreationDate = Long.toString(((PredictionModelSnippetData)predictionSMVersionHeader.snippet).trainInfo.startTime);
                    break;
                }
                dssSavedModelVersion.savedModelVersionCreationDate = "";
                break;
            }
            case PYTHON_AGENT: 
            case PLUGIN_AGENT: 
            case TOOLS_USING_AGENT: {
                throw new IllegalArgumentException("Agent saved model handling type for prediction saved models is invalid.");
            }
            case LLM_GENERIC: {
                throw new IllegalArgumentException("Fine tuned LLMs saved model handling type for prediction saved models is invalid.");
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                throw new IllegalArgumentException("Retrieval Augmented LLMs saved model handling type for prediction saved models is invalid.");
            }
            default: {
                throw new IllegalArgumentException("Unknown saved model handling type for prediction saved models is invalid.");
            }
        }
        this.fillSavedModelFullInfoForSavedModelAndVersions(savedModelFullInfo, dssSavedModelVersion.details);
        dssSavedModelVersion.details.put("active", predictionSMVersionHeader.active);
        if (((PredictionModelSnippetData)predictionSMVersionHeader.snippet).algorithm != null) {
            dssSavedModelVersion.details.put("algorithm", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).algorithm.name());
        }
        dssSavedModelVersion.details.put("initial_metrics_accuracy", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).accuracy);
        dssSavedModelVersion.details.put("initial_metrics_accuracy_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).accuracystd);
        dssSavedModelVersion.details.put("initial_metrics_precision", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).precision);
        dssSavedModelVersion.details.put("initial_metrics_precision_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).precisionstd);
        dssSavedModelVersion.details.put("initial_metrics_recall", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).recall);
        dssSavedModelVersion.details.put("initial_metrics_recall_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).recallstd);
        dssSavedModelVersion.details.put("initial_metrics_f1", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).f1);
        dssSavedModelVersion.details.put("initial_metrics_f1_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).f1std);
        dssSavedModelVersion.details.put("initial_metrics_auc", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).auc);
        dssSavedModelVersion.details.put("initial_metrics_auc_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).aucstd);
        dssSavedModelVersion.details.put("initial_metrics_logLoss", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).logLoss);
        dssSavedModelVersion.details.put("initial_metrics_logLoss_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).logLossstd);
        dssSavedModelVersion.details.put("initial_metrics_calibrationLoss", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).calibrationLoss);
        dssSavedModelVersion.details.put("initial_metrics_calibrationLoss_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).calibrationLossstd);
        dssSavedModelVersion.details.put("initial_metrics_lift", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).lift);
        dssSavedModelVersion.details.put("initial_metrics_lift_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).liftstd);
        dssSavedModelVersion.details.put("initial_metrics_averagePrecision", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).averagePrecision);
        dssSavedModelVersion.details.put("initial_metrics_averagePrecision_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).averagePrecisionstd);
        dssSavedModelVersion.details.put("initial_metrics_liftPoint", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).liftPoint);
        dssSavedModelVersion.details.put("initial_metrics_costMatrixGain", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).costMatrixGain);
        dssSavedModelVersion.details.put("initial_metrics_costMatrixGain_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).costMatrixGainstd);
        dssSavedModelVersion.details.put("initial_metrics_r2", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).r2);
        dssSavedModelVersion.details.put("initial_metrics_r2_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).r2std);
        dssSavedModelVersion.details.put("initial_metrics_evs", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).evs);
        dssSavedModelVersion.details.put("initial_metrics_evs_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).evsstd);
        dssSavedModelVersion.details.put("initial_metrics_mape", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).mape);
        dssSavedModelVersion.details.put("initial_metrics_mape_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).mapestd);
        dssSavedModelVersion.details.put("initial_metrics_mae", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).mae);
        dssSavedModelVersion.details.put("initial_metrics_mae_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).maestd);
        dssSavedModelVersion.details.put("initial_metrics_mse", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).mse);
        dssSavedModelVersion.details.put("initial_metrics_mse_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).msestd);
        dssSavedModelVersion.details.put("initial_metrics_rmse", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).rmse);
        dssSavedModelVersion.details.put("initial_metrics_rmse_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).rmsestd);
        dssSavedModelVersion.details.put("initial_metrics_rmsle", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).rmsle);
        dssSavedModelVersion.details.put("initial_metrics_rmsle_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).rmslestd);
        dssSavedModelVersion.details.put("initial_metrics_pearson", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).pearson);
        dssSavedModelVersion.details.put("initial_metrics_pearson_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).pearsonstd);
        dssSavedModelVersion.details.put("initial_metrics_averagePrecisionIOU50", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).averagePrecisionIOU50);
        dssSavedModelVersion.details.put("initial_metrics_averagePrecisionIOU75", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).averagePrecisionIOU75);
        dssSavedModelVersion.details.put("initial_metrics_averagePrecisionAllIOU", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).averagePrecisionAllIOU);
        dssSavedModelVersion.details.put("initial_metrics_mase", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).mase);
        dssSavedModelVersion.details.put("initial_metrics_mase_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).masestd);
        dssSavedModelVersion.details.put("initial_metrics_meanAbsoluteQuantileLoss", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).meanAbsoluteQuantileLoss);
        dssSavedModelVersion.details.put("initial_metrics_meanAbsoluteQuantileLoss_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).meanAbsoluteQuantileLossstd);
        dssSavedModelVersion.details.put("initial_metrics_meanWeightedQuantileLoss", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).meanWeightedQuantileLoss);
        dssSavedModelVersion.details.put("initial_metrics_meanWeightedQuantileLoss_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).meanWeightedQuantileLossstd);
        dssSavedModelVersion.details.put("initial_metrics_msis", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).msis);
        dssSavedModelVersion.details.put("initial_metrics_msis_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).msisstd);
        dssSavedModelVersion.details.put("initial_metrics_nd", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).nd);
        dssSavedModelVersion.details.put("initial_metrics_nd_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).ndstd);
        dssSavedModelVersion.details.put("initial_metrics_smape", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).smape);
        dssSavedModelVersion.details.put("initial_metrics_smape_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).smapestd);
        dssSavedModelVersion.details.put("initial_metrics_auuc", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).auuc);
        dssSavedModelVersion.details.put("initial_metrics_qini", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).qini);
        dssSavedModelVersion.details.put("initial_metrics_netUplift", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).netUplift);
        dssSavedModelVersion.details.put("initial_metrics_netUplift_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).netUpliftstd);
        dssSavedModelVersion.details.put("initial_metrics_netUpliftPoint", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).netUpliftPoint);
        dssSavedModelVersion.details.put("initial_metrics_customScore", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).customScore);
        dssSavedModelVersion.details.put("initial_metrics_customScore_std", ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).customScorestd);
        CustomMetricResult[] customMetricsResults = ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).customMetricsResults;
        if (customMetricsResults != null) {
            for (CustomMetricResult customMetricResult : customMetricsResults) {
                if (StringUtils.isBlank((CharSequence)customMetricResult.metric.name)) {
                    logger.warn((Object)("Govern integration: skipping unnamed custom metric: " + ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).fullModelId));
                    continue;
                }
                if (customMetricResult.didSucceed && customMetricResult instanceof CustomMetricSuccess) {
                    dssSavedModelVersion.customMetrics.add(DSSCustomMetric.build((String)customMetricResult.metric.name, (Object)((CustomMetricSuccess)customMetricResult).value, (Object)((CustomMetricSuccess)customMetricResult).valuestd));
                    continue;
                }
                if (!customMetricResult.didSucceed) {
                    dssSavedModelVersion.customMetrics.add(DSSCustomMetric.build((String)customMetricResult.metric.name, null, null));
                    continue;
                }
                logger.warn((Object)("Govern integration: skipping unexpected invalid initial custom metric: " + ((PredictionModelSnippetData)predictionSMVersionHeader.snippet).fullModelId + ", " + customMetricResult.metric.name));
            }
        }
        if (modelEvaluationStoreMap != null) {
            dssSavedModelVersion.evaluationMetrics.addAll(this.buildDataPoints(modelEvaluationStoreMap));
        }
        return dssSavedModelVersion;
    }

    private List<DSSSavedModelVersionEvaluationMetricDatapoints> buildDataPoints(Map<String, Pair<ModelEvaluationStore, List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader>>> modelEvaluationMap) {
        HashMap<Boolean, Map<String, DSSSavedModelVersionEvaluationMetricDatapoints>> datapointsMap = new HashMap<Boolean, Map<String, DSSSavedModelVersionEvaluationMetricDatapoints>>();
        for (Pair<ModelEvaluationStore, List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader>> entry : modelEvaluationMap.values()) {
            List modelEvaluationHeaderList = (List)entry.getRight();
            String governTimestampLabel = ((ModelEvaluationStore)entry.getLeft()).governTimestampLabel;
            if (!CollectionUtils.isNotEmpty((Collection)modelEvaluationHeaderList)) continue;
            for (ModelEvaluationStoresCRUDService.ModelEvaluationHeader modelEvaluationHeader : modelEvaluationHeaderList) {
                long evaluationTimestamp = modelEvaluationHeader.evaluation.created;
                if (StringUtils.isNotBlank((CharSequence)governTimestampLabel)) {
                    Optional<String> labelValue = modelEvaluationHeader.evaluation.userMeta.labels.stream().filter(label -> StringUtils.equals((CharSequence)label.key, (CharSequence)governTimestampLabel)).findFirst().map(label -> label.value);
                    if (labelValue.isEmpty()) {
                        logger.warn((Object)("Govern integration: label not found: " + governTimestampLabel + " for projectKey: " + ((ModelEvaluationStore)entry.getLeft()).getProjectKey() + ", modelEvaluationStoreId: " + ((ModelEvaluationStore)entry.getLeft()).getId() + ", and evaluationId: " + modelEvaluationHeader.evaluation.ref.evaluationId));
                        continue;
                    }
                    try {
                        evaluationTimestamp = Long.parseLong(labelValue.get());
                    }
                    catch (NumberFormatException nfe) {
                        logger.warn((Object)("Govern integration: issue when parsing label " + governTimestampLabel + " with value " + labelValue.get() + " as a timestamp for projectKey: " + ((ModelEvaluationStore)entry.getLeft()).getProjectKey() + ", modelEvaluationStoreId: " + ((ModelEvaluationStore)entry.getLeft()).getId() + ", and evaluationId: " + modelEvaluationHeader.evaluation.ref.evaluationId), (Throwable)nfe);
                        continue;
                    }
                }
                if (modelEvaluationHeader.isTabular()) {
                    PredictionModelPerformanceMetrics metrics = (PredictionModelPerformanceMetrics)modelEvaluationHeader.metrics;
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_dataDrift", evaluationTimestamp, metrics.dataDrift, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_dataDriftPValue", evaluationTimestamp, metrics.dataDriftPValue, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_maxPsi", evaluationTimestamp, metrics.maxPsi, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_minChiSquare", evaluationTimestamp, metrics.minChiSquare, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_minKs", evaluationTimestamp, metrics.minKs, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_predictionDrift_PSI", evaluationTimestamp, metrics.predictionDrift_PSI, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_predictionDrift_ChiSquare", evaluationTimestamp, metrics.predictionDrift_ChiSquare, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_predictionDrift_KS", evaluationTimestamp, metrics.predictionDrift_KS, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_accuracy", evaluationTimestamp, metrics.accuracy, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_precision", evaluationTimestamp, metrics.precision, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_recall", evaluationTimestamp, metrics.recall, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_f1", evaluationTimestamp, metrics.f1, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_auc", evaluationTimestamp, metrics.auc, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_logLoss", evaluationTimestamp, metrics.logLoss, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_calibrationLoss", evaluationTimestamp, metrics.calibrationLoss, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_lift", evaluationTimestamp, metrics.lift, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_averagePrecision", evaluationTimestamp, metrics.averagePrecision, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_liftPoint", evaluationTimestamp, metrics.liftPoint, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_costMatrixGain", evaluationTimestamp, metrics.costMatrixGain, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_r2", evaluationTimestamp, metrics.r2, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_evs", evaluationTimestamp, metrics.evs, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_mape", evaluationTimestamp, metrics.mape, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_mae", evaluationTimestamp, metrics.mae, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_mse", evaluationTimestamp, metrics.mse, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_rmse", evaluationTimestamp, metrics.rmse, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_rmsle", evaluationTimestamp, metrics.rmsle, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_pearson", evaluationTimestamp, metrics.pearson, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_averagePrecisionIOU50", evaluationTimestamp, metrics.averagePrecisionIOU50, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_averagePrecisionIOU75", evaluationTimestamp, metrics.averagePrecisionIOU75, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_averagePrecisionAllIOU", evaluationTimestamp, metrics.averagePrecisionAllIOU, false);
                    this.fillDataPointMap(datapointsMap, "evaluation_metrics_customScore", evaluationTimestamp, metrics.customScore, false);
                    CustomMetricResult[] customMetricsResults = metrics.customMetricsResults;
                    if (customMetricsResults == null) continue;
                    for (CustomMetricResult customMetricsResult : customMetricsResults) {
                        if (!(customMetricsResult instanceof CustomMetricSuccess)) continue;
                        this.fillDataPointMap(datapointsMap, customMetricsResult.metric.name, evaluationTimestamp, ((CustomMetricSuccess)customMetricsResult).value, true);
                    }
                    continue;
                }
                if (!modelEvaluationHeader.isLLM() && !modelEvaluationHeader.isAgent()) continue;
            }
        }
        return datapointsMap.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toList());
    }

    private void fillDataPointMap(Map<Boolean, Map<String, DSSSavedModelVersionEvaluationMetricDatapoints>> datapointsMap, String metricId, long trainEndTime, @Nullable Double value, boolean isCustom) {
        if (value != null) {
            datapointsMap.computeIfAbsent((Boolean)Boolean.valueOf((boolean)isCustom), (Function<Boolean, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fillDataPointMap$13(java.lang.Boolean ), (Ljava/lang/Boolean;)Ljava/util/Map;)()).computeIfAbsent(metricId, (Function<String, DSSSavedModelVersionEvaluationMetricDatapoints>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fillDataPointMap$14(java.lang.String boolean java.lang.String ), (Ljava/lang/String;)Lcom/dataiku/dss_gh/api/models/metrics/DSSSavedModelVersionEvaluationMetricDatapoints;)((String)metricId, (boolean)isCustom)).datapoints.add(DSSMetricDatapoint.build((long)trainEndTime, (Object)value));
        }
    }

    private DSSClusteringSavedModelVersion buildDSSClusteringSavedModelVersion(ClusteringSMMgmtService.ClusteringSMVersionHeader clusteringSMVersionHeader, NavigatorService.SavedModelFullInfo savedModelFullInfo) {
        DSSClusteringSavedModelVersion dssSavedModelVersion = new DSSClusteringSavedModelVersion();
        dssSavedModelVersion.fullModelVersionId = ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).fullModelId;
        dssSavedModelVersion.savedModelVersionCreationDate = ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).trainInfo != null ? Long.toString(((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).trainInfo.startTime) : "";
        dssSavedModelVersion.name = ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).userMeta.name;
        this.fillSavedModelFullInfoForSavedModelAndVersions(savedModelFullInfo, dssSavedModelVersion.details);
        dssSavedModelVersion.details.put("active", clusteringSMVersionHeader.active);
        dssSavedModelVersion.details.put("algorithm", ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).algorithm);
        dssSavedModelVersion.details.put("initial_metrics_nbClusters", ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).nbClusters);
        dssSavedModelVersion.details.put("initial_metrics_silhouette", ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).silhouette);
        dssSavedModelVersion.details.put("initial_metrics_inertia", ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).inertia);
        dssSavedModelVersion.details.put("initial_metrics_ssRatio", ((ClusteringModelSnippetData)clusteringSMVersionHeader.snippet).ssRatio);
        return dssSavedModelVersion;
    }

    private DSSFineTuningSavedModelVersion buildDSSFineTuningSavedModelVersion(LLMSMMgmtService.LLMSMVersionHeader llmSMVersionHeader, NavigatorService.SavedModelFullInfo savedModelFullInfo) {
        DSSFineTuningSavedModelVersion dssSavedModelVersion = new DSSFineTuningSavedModelVersion();
        dssSavedModelVersion.fullModelVersionId = ((LLMModelSnippetData)llmSMVersionHeader.snippet).fullModelId;
        dssSavedModelVersion.savedModelVersionCreationDate = ((LLMModelSnippetData)llmSMVersionHeader.snippet).trainInfo != null ? Long.toString(((LLMModelSnippetData)llmSMVersionHeader.snippet).trainInfo.startTime) : "";
        dssSavedModelVersion.name = ((LLMModelSnippetData)llmSMVersionHeader.snippet).userMeta.name;
        this.fillSavedModelFullInfoForSavedModelAndVersions(savedModelFullInfo, dssSavedModelVersion.details);
        dssSavedModelVersion.details.put("active", llmSMVersionHeader.active);
        if (((LLMModelSnippetData)llmSMVersionHeader.snippet).llmSMInfo != null) {
            dssSavedModelVersion.details.put("llm_type", ((LLMModelSnippetData)llmSMVersionHeader.snippet).llmSMInfo.llmType);
        }
        return dssSavedModelVersion;
    }

    private DSSAgentSavedModelVersion buildDSSAgentSavedModelVersion(LLMSMMgmtService.LLMSMVersionHeader llmSMVersionHeader, NavigatorService.SavedModelFullInfo savedModelFullInfo) {
        DSSAgentSavedModelVersion dssSavedModelVersion = new DSSAgentSavedModelVersion();
        dssSavedModelVersion.fullModelVersionId = ((LLMModelSnippetData)llmSMVersionHeader.snippet).fullModelId;
        dssSavedModelVersion.savedModelVersionCreationDate = ((LLMModelSnippetData)llmSMVersionHeader.snippet).creationTag != null ? Long.toString(((LLMModelSnippetData)llmSMVersionHeader.snippet).creationTag.getLastModifiedOn()) : "";
        dssSavedModelVersion.name = ((LLMModelSnippetData)llmSMVersionHeader.snippet).userMeta.name;
        this.fillSavedModelFullInfoForSavedModelAndVersions(savedModelFullInfo, dssSavedModelVersion.details);
        dssSavedModelVersion.details.put("active", llmSMVersionHeader.active);
        return dssSavedModelVersion;
    }

    private DSSAugmentedSavedModelVersion buildDSSAugmentedSavedModelVersion(LLMSMMgmtService.LLMSMVersionHeader llmSMVersionHeader, NavigatorService.SavedModelFullInfo savedModelFullInfo) {
        DSSAugmentedSavedModelVersion dssSavedModelVersion = new DSSAugmentedSavedModelVersion();
        dssSavedModelVersion.fullModelVersionId = ((LLMModelSnippetData)llmSMVersionHeader.snippet).fullModelId;
        dssSavedModelVersion.savedModelVersionCreationDate = ((LLMModelSnippetData)llmSMVersionHeader.snippet).creationTag != null ? Long.toString(((LLMModelSnippetData)llmSMVersionHeader.snippet).creationTag.getLastModifiedOn()) : "";
        dssSavedModelVersion.name = ((LLMModelSnippetData)llmSMVersionHeader.snippet).userMeta.name;
        this.fillSavedModelFullInfoForSavedModelAndVersions(savedModelFullInfo, dssSavedModelVersion.details);
        dssSavedModelVersion.details.put("active", llmSMVersionHeader.active);
        return dssSavedModelVersion;
    }

    private void fillSavedModelFullInfoForSavedModelAndVersions(NavigatorService.SavedModelFullInfo savedModelFullInfo, Map<String, Object> details) {
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            details.put("automation_node", true);
        }
        details.put("model_type", (Object)savedModelFullInfo.model.getType());
        details.put("saved_model_type", (Object)savedModelFullInfo.model.savedModelType);
        details.put("saved_model_handling_type", (Object)savedModelFullInfo.model.savedModelType.savedModelHandlingType);
    }

    private void fillTaggableObjectDetails(TaggableObjectsService.TaggableObject taggableObject, Map<String, Object> details) {
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            details.put("automation_node", true);
        }
        details.put("description", taggableObject.description);
        details.put("short_description", taggableObject.shortDesc);
        details.put("tags", taggableObject.tags);
        if (taggableObject.creationTag != null) {
            details.put("createdOn", taggableObject.creationTag.getLastModifiedOn());
            details.put("createdBy", taggableObject.creationTag.getLastAuthor());
        }
        if (taggableObject.versionTag != null) {
            details.put("lastModifiedOn", taggableObject.versionTag.getLastModifiedOn());
            details.put("lastModifiedBy", taggableObject.versionTag.getLastAuthor());
        }
        if (taggableObject.customFields != null && taggableObject.customFields.size() > 0) {
            JsonObject customFieldsWrapper = new JsonObject();
            customFieldsWrapper.addProperty("value", JSON.json((Object)taggableObject.customFields));
            details.put("custom_fields", customFieldsWrapper);
        }
    }

    private void fillLLMUsageDetails(LLMUsage llmUsage, Map<String, Object> details) {
        details.put("hosted_llm_reference_count", llmUsage.hostedLLMReferenceCount > 0L ? Long.valueOf(llmUsage.hostedLLMReferenceCount) : null);
        details.put("locally_running_llm_reference_count", llmUsage.locallyRunningLLMReferenceCount > 0L ? Long.valueOf(llmUsage.locallyRunningLLMReferenceCount) : null);
        details.put("hosted_embedding_reference_count", llmUsage.hostedEmbeddingReferenceCount > 0L ? Long.valueOf(llmUsage.hostedEmbeddingReferenceCount) : null);
        details.put("locally_running_embedding_reference_count", llmUsage.locallyRunningEmbeddingReferenceCount > 0L ? Long.valueOf(llmUsage.locallyRunningEmbeddingReferenceCount) : null);
        details.put("use_prompt_studio", llmUsage.hasPromptStudioUsage);
        details.put("use_agent_review", llmUsage.hasAgentReviewUsage);
        details.put("answers_webapps_count", llmUsage.answersWebAppsCount > 0L ? Long.valueOf(llmUsage.answersWebAppsCount) : null);
    }

    private void fillGenAIBadgesDetails(List<TypeBadge> projectBadges, Map<String, Object> details) {
        details.put("ai_types", projectBadges);
    }

    private void fillProjectStandardsReportDetails(@Nullable ProjectStandardsRunReport report, @Nullable ProjectStandardsRunReportSummary reportSummary, Map<String, Object> details) {
        details.put("project_standards_critical", reportSummary != null ? reportSummary.nbOfChecksBySeverity.get(5) : null);
        details.put("project_standards_high", reportSummary != null ? reportSummary.nbOfChecksBySeverity.get(4) : null);
        details.put("project_standards_medium", reportSummary != null ? reportSummary.nbOfChecksBySeverity.get(3) : null);
        details.put("project_standards_low", reportSummary != null ? reportSummary.nbOfChecksBySeverity.get(2) : null);
        details.put("project_standards_lowest", reportSummary != null ? reportSummary.nbOfChecksBySeverity.get(1) : null);
        details.put("project_standards_success", reportSummary != null ? reportSummary.nbOfChecksBySeverity.get(0) : null);
        details.put("project_standards_not_applicable", reportSummary != null ? Long.valueOf(reportSummary.nbOfChecksNotApplicable) : null);
        details.put("project_standards_error", reportSummary != null ? Long.valueOf(reportSummary.nbOfChecksInError) : null);
        JsonObject projectStandardsWrapper = null;
        if (report != null) {
            projectStandardsWrapper = new JsonObject();
            projectStandardsWrapper.addProperty("value", JSON.json((Object)report));
        }
        details.put("project_standards_definition", projectStandardsWrapper);
    }

    private void fillProjectLocation(List<ProjectFolder> projectLocation, Map<String, Object> details) {
        if (projectLocation == null || details == null || projectLocation.isEmpty()) {
            return;
        }
        int size = projectLocation.size();
        ArrayList<String> ids = new ArrayList<String>(size);
        ArrayList<String> names = new ArrayList<String>(size);
        for (ProjectFolder folder : projectLocation) {
            ids.add(folder.id);
            names.add(folder.name);
        }
        details.put("project_location_folder_ids", ids);
        details.put("project_location_folder_names", names);
    }

    private String getCreationDateOrBlank(TaggableObjectsService.TaggableObject taggableObject) {
        TimelineItem timelineItem;
        TimelineItem timelineItem2 = timelineItem = taggableObject.getTaggableType() == ITaggingService.TaggableType.PROJECT ? this.timelinesService.getFirstForObjectNoCache(taggableObject.getTaggableType(), taggableObject.getProjectKey(), taggableObject.getId()) : this.timelinesService.getFirstForObject(taggableObject.getTaggableType(), taggableObject.getProjectKey(), taggableObject.getId());
        if (timelineItem != null) {
            return Long.toString(timelineItem.time);
        }
        if (taggableObject.creationTag != null && taggableObject.creationTag.getLastModifiedOn() > 0L) {
            return Long.toString(taggableObject.creationTag.getLastModifiedOn());
        }
        return "";
    }

    private ProjectDetails getProjectDetails(String projectKey) throws IOException {
        List<Pair<SerializedRecipe, String>> llmRecipesAndPayloads = this.recipesDAO.listUnsafe(projectKey).stream().filter(recipe -> llmRecipeTypes.contains(recipe.getType())).map(recipe -> {
            String payloadOrNull;
            try {
                payloadOrNull = this.recipesDAO.getPayloadOrNull(projectKey, recipe.getId());
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot retrieve the recipe payload", (Throwable)e);
                payloadOrNull = null;
            }
            return ImmutablePair.of((Object)recipe, (Object)payloadOrNull);
        }).collect(Collectors.toList());
        List<RetrievableKnowledge> retrievableKnowledgesWithEmbeddingLLMId = this.retrievableKnowledgeDAO.listUnsafe(projectKey).stream().filter(knowledgeBank -> StringUtils.isNotBlank((CharSequence)knowledgeBank.embeddingLLMId)).collect(Collectors.toList());
        List<SavedModel> augmentedSavedModels = this.savedModelsCRUDService.listUnsafe(projectKey).stream().filter(sm -> sm.savedModelType == SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM).filter(sm -> sm.inlineVersions.stream().anyMatch(iv -> StringUtils.isNotBlank((CharSequence)iv.ragllmSettings.llmId))).collect(Collectors.toList());
        boolean hasPromptStudioUsage = !this.promptStudioDAO.listUnsafe(projectKey).isEmpty();
        boolean hasAgentReviewUsage = !this.agentReviewsDAO.listUnsafe(projectKey).isEmpty();
        long answersWebappsCount = this.webAppsDAO.listUnsafe(projectKey).stream().filter(WebAppUtils::isDataikuAnswers).count();
        List<TypeBadge> projectBadges = this.projectBadgesDAO.read(projectKey).listBadges();
        List<ProjectFolder> projectLocation = this.projectFoldersService.getProjectLocation_Uncheck(projectKey);
        return new ProjectDetails(this.projectsService.getMandatoryUnsafe(projectKey), new LLMUsage(llmRecipesAndPayloads, retrievableKnowledgesWithEmbeddingLLMId, augmentedSavedModels, hasPromptStudioUsage, hasAgentReviewUsage, answersWebappsCount), projectBadges, projectLocation);
    }

    @Nullable
    private static String getOriginTemplateProjectKeyOrNull(String generatingAppId) {
        String originTemplateProjectKey = null;
        try {
            originTemplateProjectKey = AppsService.getProjectKey(generatingAppId);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Cannot retrieve original project key: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return originTemplateProjectKey;
    }

    public static List<DSSSavedModelVersionIdentifier> buildDSSSavedModelVersionIdentifierList(PublishedApiServicePackageInfoForGovernIdentification publishedApiServicePackageInfoForGovernIdentification) {
        ArrayList<DSSSavedModelVersionIdentifier> savedModelVersionIdentifiers = new ArrayList<DSSSavedModelVersionIdentifier>();
        for (EmbeddedModelVersionIdentifier embeddedModelVersionIdentifier : publishedApiServicePackageInfoForGovernIdentification.embeddedModelVersionIdentifiers) {
            DSSSavedModelVersionIdentifier modelVersionIdentifier = new DSSSavedModelVersionIdentifier();
            modelVersionIdentifier.nodeId = publishedApiServicePackageInfoForGovernIdentification.originalNodeId;
            modelVersionIdentifier.projectKey = embeddedModelVersionIdentifier.originalProjectKey;
            modelVersionIdentifier.savedModelId = embeddedModelVersionIdentifier.originalSavedModelId;
            modelVersionIdentifier.fullModelVersionId = embeddedModelVersionIdentifier.originalFullModelId;
            savedModelVersionIdentifiers.add(modelVersionIdentifier);
        }
        return savedModelVersionIdentifiers;
    }

    public static DSSBundleIdentifier buildDSSBundleIdentifier(PublishedProjectBundleInfoForGovernIdentification publishedProjectBundleInfoForGovernIdentification) {
        DSSBundleIdentifier dssBundleIdentifier = new DSSBundleIdentifier();
        dssBundleIdentifier.nodeId = publishedProjectBundleInfoForGovernIdentification.originalNodeId;
        dssBundleIdentifier.projectKey = publishedProjectBundleInfoForGovernIdentification.originalProjectKey;
        dssBundleIdentifier.bundleId = publishedProjectBundleInfoForGovernIdentification.originalBundleId;
        return dssBundleIdentifier;
    }

    private static boolean shouldIgnoreProjectForSync(SerializedProject project) {
        return project != null && (project.isTemporaryAppInstance != null && project.isTemporaryAppInstance != false || AppsService.isTestAppInstance(project));
    }

    private static String buildIgnoreMessageForSync(SerializedProject project) {
        String testOrTemporaryLabel = AppsService.isTestAppInstance(project) ? "test" : "temporary";
        return String.format("Project %s is a %s application instance, ignoring it", project.projectKey, testOrTemporaryLabel);
    }

    private static String getNodeIdMandatory() {
        String nodeId = DKUApp.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            throw new RuntimeException("This instance's nodeid must be set");
        }
        return nodeId;
    }

    private static boolean isGovernIntegrationEnabled(GeneralSettingsDAO.NodeRef governRef) {
        return governRef.enabled;
    }

    private static void checkGovernIntegrationEnabled(GeneralSettingsDAO.NodeRef governRef) throws CodedException {
        if (!GovernIntegrationService.isGovernIntegrationEnabled(governRef)) {
            throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_DISABLED, "Dataiku Govern integration is disabled");
        }
    }

    private static boolean isNodeIdProperlyConfigured() {
        return StringUtils.isNotBlank((CharSequence)DKUApp.getNodeId());
    }

    private static void checkNodeIdProperlyConfigured() throws CodedException {
        if (!GovernIntegrationService.isNodeIdProperlyConfigured()) {
            throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_NODEID_UNSET, "This instance's nodeid must be set, ask your administrator to setup this instance's nodeid.");
        }
    }

    private static boolean isApiKeyProperlyConfigured(GeneralSettingsDAO.NodeRef governRef) {
        return StringUtils.isNotBlank((CharSequence)governRef.apiKey);
    }

    private static void checkApiKeyProperlyConfigured(GeneralSettingsDAO.NodeRef governRef) throws CodedException {
        if (!GovernIntegrationService.isApiKeyProperlyConfigured(governRef)) {
            throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_APIKEY_UNSET, "The Govern admin API key must be set, ask your administrator to fix the Govern integration settings.");
        }
    }

    private static boolean isHostProperlyConfigured(GeneralSettingsDAO.NodeRef governRef) {
        return StringUtils.isNotBlank((CharSequence)governRef.nodeUrl);
    }

    private static void checkHostProperlyConfigured(GeneralSettingsDAO.NodeRef governRef) throws CodedException {
        if (!GovernIntegrationService.isHostProperlyConfigured(governRef)) {
            throw new CodedException((InfoMessage.MessageCode)GovernIntegrationCodes.ERR_GOVERN_HOST_UNSET, "The Govern URL must be set, ask your administrator to fix the Govern integration settings.");
        }
    }

    public static void checkGovernIntegrationIsEnabledAndProperlyConfigured(GeneralSettingsDAO.NodeRef governRef) throws CodedException {
        GovernIntegrationService.checkGovernIntegrationEnabled(governRef);
        GovernIntegrationService.checkNodeIdProperlyConfigured();
        GovernIntegrationService.checkHostProperlyConfigured(governRef);
        GovernIntegrationService.checkApiKeyProperlyConfigured(governRef);
    }

    private static void checkGovernIntegrationIsEnabledAndProperlyConfigured() throws CodedException {
        GovernIntegrationService.checkGovernIntegrationIsEnabledAndProperlyConfigured(ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef());
    }

    public static boolean enabledNoChecks() {
        return GovernIntegrationService.isGovernIntegrationEnabled(ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef());
    }

    public static boolean enabledWithSanityChecksIfEnabled() throws CodedException {
        GeneralSettingsDAO.NodeRef governRef = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef();
        boolean enabled = GovernIntegrationService.isGovernIntegrationEnabled(governRef);
        if (enabled) {
            GovernIntegrationService.checkGovernIntegrationIsEnabledAndProperlyConfigured(governRef);
        }
        return enabled;
    }

    @Nullable
    public static String getNodeExternalUrlOrNullIfDisabled() {
        GeneralSettingsDAO.NodeRef governRef = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef();
        boolean enabled = GovernIntegrationService.isGovernIntegrationEnabled(governRef);
        if (enabled) {
            return governRef.nodeExternalUrl;
        }
        return null;
    }

    private static /* synthetic */ DSSSavedModelVersionEvaluationMetricDatapoints lambda$fillDataPointMap$14(String metricId, boolean isCustom, String k) {
        return DSSSavedModelVersionEvaluationMetricDatapoints.build((String)metricId, (boolean)isCustom);
    }

    private static /* synthetic */ Map lambda$fillDataPointMap$13(Boolean k) {
        return Maps.newHashMap();
    }

    public static class GovernSyncReport {
        public long failedProjects = 0L;
        public long syncedProjects = 0L;
        public long syncedDatasets = 0L;
        public long syncedBundles = 0L;
        public long syncedSavedModels = 0L;
        public long syncedRetrievableKnowledges = 0L;
        public long syncedSavedModelVersions = 0L;

        private GovernSyncReport() {
        }

        public void mergeWith(GovernSyncReport other) {
            this.failedProjects += other.failedProjects;
            this.syncedProjects += other.syncedProjects;
            this.syncedDatasets += other.syncedDatasets;
            this.syncedBundles += other.syncedBundles;
            this.syncedSavedModels += other.syncedSavedModels;
            this.syncedRetrievableKnowledges += other.syncedRetrievableKnowledges;
            this.syncedSavedModelVersions += other.syncedSavedModelVersions;
        }

        public static GovernSyncReport buildEmpty() {
            return new GovernSyncReport();
        }

        public static GovernSyncReport build(DSSProject dssProject) {
            GovernSyncReport result = new GovernSyncReport();
            result.syncedProjects = 1L;
            result.syncedDatasets = dssProject.datasets.size();
            result.syncedBundles = dssProject.bundles.size();
            result.syncedSavedModels = dssProject.savedModels.size();
            result.syncedRetrievableKnowledges = dssProject.retrievableKnowledges.size();
            result.syncedSavedModelVersions = dssProject.savedModels.stream().mapToLong(sm -> sm.savedModelVersions.size()).sum();
            return result;
        }
    }

    private record ProjectDetails(SerializedProject serializedProject, LLMUsage llmUsage, List<TypeBadge> projectGenAIBadges, List<ProjectFolder> projectLocation) {
    }

    public static class GovernDeployerSyncReport {
        public long syncedAPIDeployerInfra = 0L;
        public long syncedProjectDeployerInfra = 0L;
        public long syncedAPIDeployerDeployment = 0L;
        public long syncedProjectDeployerDeployment = 0L;

        private GovernDeployerSyncReport() {
        }

        public static GovernDeployerSyncReport buildEmpty() {
            return new GovernDeployerSyncReport();
        }

        public static GovernDeployerSyncReport build(DSSDeployerItems deployerItems) {
            GovernDeployerSyncReport result = new GovernDeployerSyncReport();
            result.syncedAPIDeployerInfra = deployerItems.apiInfras.size();
            result.syncedProjectDeployerInfra = deployerItems.projectInfras.size();
            result.syncedAPIDeployerDeployment = deployerItems.apiDeployments.size();
            result.syncedProjectDeployerDeployment = deployerItems.projectDeployments.size();
            return result;
        }
    }

    private static class LLMUsage {
        private long locallyRunningLLMReferenceCount;
        private long hostedLLMReferenceCount = 0L;
        private long locallyRunningEmbeddingReferenceCount = 0L;
        private long hostedEmbeddingReferenceCount = 0L;
        private boolean hasPromptStudioUsage = false;
        private boolean hasAgentReviewUsage = false;
        private long answersWebAppsCount = 0L;

        private LLMUsage(List<Pair<SerializedRecipe, String>> llmRecipesAndPayloads, List<RetrievableKnowledge> retrievableKnowledgesWithEmbeddingLLMId, List<SavedModel> augmentedSavedModels, boolean hasPromptStudioUsage, boolean hasAgentReviewUsage, long answersWebAppsCount) {
            HashMap<String, Long> llmCountMap = new HashMap<String, Long>();
            llmRecipesAndPayloads.forEach(recipeAndPayload -> {
                String payload = (String)recipeAndPayload.getRight();
                switch (((SerializedRecipe)recipeAndPayload.getLeft()).getType()) {
                    case "nlp_llm_user_provided_classification": {
                        if (payload == null) break;
                        NLPLLMUserProvidedClassificationRecipePayloadParams nlpUserProvidedClassificationParams = (NLPLLMUserProvidedClassificationRecipePayloadParams)JSON.parse((String)payload, NLPLLMUserProvidedClassificationRecipePayloadParams.class);
                        llmCountMap.merge(nlpUserProvidedClassificationParams.llmId, 1L, Long::sum);
                        break;
                    }
                    case "nlp_llm_model_provided_classification": {
                        if (payload == null) break;
                        NLPLLMModelProvidedClassificationRecipePayloadParams nlpModelProvidedClassificationParams = (NLPLLMModelProvidedClassificationRecipePayloadParams)JSON.parse((String)payload, NLPLLMModelProvidedClassificationRecipePayloadParams.class);
                        llmCountMap.merge(nlpModelProvidedClassificationParams.llmId, 1L, Long::sum);
                        break;
                    }
                    case "prompt": {
                        if (payload == null) break;
                        PromptRecipePayloadParams promptParam = (PromptRecipePayloadParams)JSON.parse((String)payload, PromptRecipePayloadParams.class);
                        llmCountMap.merge(promptParam.llmId, 1L, Long::sum);
                        break;
                    }
                    case "nlp_llm_summarization": {
                        if (payload == null) break;
                        SummarizationRecipePayloadParams summarizationParams = (SummarizationRecipePayloadParams)JSON.parse((String)payload, SummarizationRecipePayloadParams.class);
                        llmCountMap.merge(summarizationParams.llmId, 1L, Long::sum);
                        break;
                    }
                    case "nlp_llm_rag_embedding": {
                        if (payload == null) break;
                        break;
                    }
                    case "nlp_llm_finetuning": {
                        if (payload == null) break;
                        FineTuningRecipePayloadParams fineTuningRecipe = (FineTuningRecipePayloadParams)JSON.parse((String)payload, FineTuningRecipePayloadParams.class);
                        llmCountMap.merge(fineTuningRecipe.llmId, 1L, Long::sum);
                        break;
                    }
                }
            });
            HashMap<String, Long> embeddingCountMap = new HashMap<String, Long>();
            retrievableKnowledgesWithEmbeddingLLMId.forEach(retrievableKnowledge -> {
                if (StringUtils.isNotBlank((CharSequence)retrievableKnowledge.embeddingLLMId)) {
                    embeddingCountMap.merge(retrievableKnowledge.embeddingLLMId, 1L, Long::sum);
                }
            });
            Map<Boolean, Long> llmLocalHosted = LLMUsage.unwrapRetrievalAugmentedUsagesAndSumByLocalHosted(llmCountMap, augmentedSavedModels);
            Map<Boolean, Long> embeddingLocalHosted = LLMUsage.unwrapRetrievalAugmentedUsagesAndSumByLocalHosted(embeddingCountMap, augmentedSavedModels);
            boolean local = true;
            boolean hosted = false;
            if (llmLocalHosted != null) {
                this.locallyRunningLLMReferenceCount = Objects.requireNonNullElse(llmLocalHosted.get(true), 0L);
                this.hostedLLMReferenceCount = Objects.requireNonNullElse(llmLocalHosted.get(false), 0L);
            }
            if (embeddingLocalHosted != null) {
                this.locallyRunningEmbeddingReferenceCount = Objects.requireNonNullElse(embeddingLocalHosted.get(true), 0L);
                this.hostedEmbeddingReferenceCount = Objects.requireNonNullElse(embeddingLocalHosted.get(false), 0L);
            }
            this.hasPromptStudioUsage = hasPromptStudioUsage;
            this.hasAgentReviewUsage = hasAgentReviewUsage;
            this.answersWebAppsCount = answersWebAppsCount;
        }

        private static Map<Boolean, Long> unwrapRetrievalAugmentedUsagesAndSumByLocalHosted(Map<String, Long> refMap, List<SavedModel> augmentedSavedModels) {
            return refMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> Pair.of((Object)LLMStructuredRef.decodeId((String)entry.getKey()), (Object)((Long)entry.getValue()))).map(p -> {
                LLMStructuredRef llmStructuredRef = (LLMStructuredRef)p.getKey();
                if (llmStructuredRef.type == LLMStructuredRef.LLMType.RETRIEVAL_AUGMENTED) {
                    LLMStructuredRef nestedLLM = augmentedSavedModels.stream().filter(sm -> Objects.equals(sm.id, llmStructuredRef.savedModelSmartId)).findAny().flatMap(sm -> sm.inlineVersions.stream().filter(iv -> Objects.equals(iv.versionId, llmStructuredRef.savedModelVersionId) || StringUtils.isBlank((CharSequence)llmStructuredRef.savedModelVersionId) && Objects.equals(iv.versionId, sm.activeVersion)).findAny()).map(iv -> iv.ragllmSettings.llmId).map(LLMStructuredRef::decodeId).orElse(null);
                    return Pair.of((Object)nestedLLM, (Object)((Long)p.getValue()));
                }
                return p;
            }).filter(p -> p.getKey() != null).collect(Collectors.groupingBy(p -> ((LLMStructuredRef)p.getKey()).type == LLMStructuredRef.LLMType.HUGGINGFACE_TRANSFORMER_LOCAL, Collectors.summingLong(Pair::getValue)));
        }
    }

    private static class BundleDetails {
        @Nullable
        private final ExportedProject.ExportUserInfo exportUserInfo;
        private final LLMUsage llmUsage;
        private List<TypeBadge> projectGenAIBadges;
        @Nullable
        private final ProjectStandardsRunReport projectStandardsReport;
        @Nullable
        private final ProjectStandardsRunReportSummary projectStandardsReportSummary;

        private BundleDetails(File bundleArchive) {
            ExportedProject.ExportUserInfo exportUserInfo = null;
            ProjectStandardsRunReport projectStandardsReport = null;
            ArrayList<Pair<SerializedRecipe, String>> llmRecipesAndPayloads = new ArrayList<Pair<SerializedRecipe, String>>();
            ArrayList<RetrievableKnowledge> knowledgeBanksWithEmbeddingLLMId = new ArrayList<RetrievableKnowledge>();
            ArrayList<SavedModel> augmentedSavedModels = new ArrayList<SavedModel>();
            ArrayList<PromptStudio> promptStudios = new ArrayList<PromptStudio>();
            ArrayList<AgentReview> agentReviews = new ArrayList<AgentReview>();
            ArrayList<WebApp> answersWebApps = new ArrayList<WebApp>();
            this.projectGenAIBadges = new ArrayList<TypeBadge>();
            try (ZipFile zipFile = new ZipFile(bundleArchive);){
                ZipEntry projectStandardsReportEntry;
                ExportedProject exportManifest;
                ZipEntry manifestEntry = zipFile.getEntry("export-manifest.json");
                if (manifestEntry != null && (exportManifest = (ExportedProject)JSON.parse((InputStream)zipFile.getInputStream(manifestEntry), ExportedProject.class)) != null && exportManifest.exportUserInfo != null) {
                    exportUserInfo = exportManifest.exportUserInfo;
                }
                if ((projectStandardsReportEntry = zipFile.getEntry("project-standards-bundle-report.json")) != null) {
                    projectStandardsReport = (ProjectStandardsRunReport)JSON.parse((InputStream)zipFile.getInputStream(projectStandardsReportEntry), ProjectStandardsRunReport.class);
                }
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String entryName;
                    ZipEntry entry;
                    block36: {
                        entry = entries.nextElement();
                        entryName = entry.getName();
                        try {
                            if (!entryName.startsWith("project_config/recipes/") || !entryName.endsWith(".json")) break block36;
                            SerializedRecipe recipe = (SerializedRecipe)JSON.parse((InputStream)zipFile.getInputStream(entry), SerializedRecipe.class);
                            recipe.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/recipes/", (String)".json"));
                            if (!llmRecipeTypes.contains(recipe.getType())) break block36;
                            String payloadEntryName = "project_config/recipes/" + recipe.getId() + "." + recipe.getType();
                            ZipEntry payloadZipEntry = null;
                            try {
                                payloadZipEntry = zipFile.getEntry(payloadEntryName);
                            }
                            catch (Exception e) {
                                logger.error((Object)("Cannot retrieve recipe payload from bundle: " + bundleArchive.getAbsolutePath() + " : " + payloadEntryName), (Throwable)e);
                            }
                            if (payloadZipEntry != null) {
                                llmRecipesAndPayloads.add((Pair<SerializedRecipe, String>)ImmutablePair.of((Object)recipe, (Object)IOUtils.toString((InputStream)zipFile.getInputStream(payloadZipEntry), (Charset)StandardCharsets.UTF_8)));
                            } else {
                                llmRecipesAndPayloads.add((Pair<SerializedRecipe, String>)ImmutablePair.of((Object)recipe, null));
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)("Cannot retrieve recipe from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                        }
                    }
                    try {
                        if (entryName.startsWith("project_config/knowledge-banks/") && entryName.endsWith(".json")) {
                            RetrievableKnowledge knowledgeBank = (RetrievableKnowledge)JSON.parse((InputStream)zipFile.getInputStream(entry), RetrievableKnowledge.class);
                            knowledgeBank.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/knowledge-banks/", (String)".json"));
                            if (StringUtils.isNotBlank((CharSequence)knowledgeBank.embeddingLLMId)) {
                                knowledgeBanksWithEmbeddingLLMId.add(knowledgeBank);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot retrieve knowledge bank from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                    }
                    try {
                        if (entryName.startsWith("project_config/saved_models/") && entryName.endsWith(".json")) {
                            SavedModel savedModel = (SavedModel)JSON.parse((InputStream)zipFile.getInputStream(entry), SavedModel.class);
                            savedModel.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/saved_models/", (String)".json"));
                            if (savedModel.savedModelType == SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM && savedModel.inlineVersions.stream().anyMatch(iv -> StringUtils.isNotBlank((CharSequence)iv.ragllmSettings.llmId))) {
                                augmentedSavedModels.add(savedModel);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot retrieve augmented saved model from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                    }
                    try {
                        if (entryName.startsWith("project_config/prompt-studios/") && entryName.endsWith(".json")) {
                            PromptStudio promptStudio = (PromptStudio)JSON.parse((InputStream)zipFile.getInputStream(entry), PromptStudio.class);
                            promptStudio.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/prompt-studios/", (String)".json"));
                            promptStudios.add(promptStudio);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot retrieve prompt studio from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                    }
                    try {
                        if (entryName.startsWith("project_config/agent_reviews/") && entryName.endsWith(".json")) {
                            AgentReview agentReview = (AgentReview)JSON.parse((InputStream)zipFile.getInputStream(entry), AgentReview.class);
                            agentReview.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/agent_reviews/", (String)".json"));
                            agentReviews.add(agentReview);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot retrieve agent review from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                    }
                    try {
                        if (entryName.startsWith("project_config/web_apps/") && entryName.endsWith(".json")) {
                            WebApp webApp = (WebApp)JSON.parse((InputStream)zipFile.getInputStream(entry), WebApp.class);
                            webApp.setId(StringUtils.substringBetween((String)entryName, (String)"project_config/web_apps/", (String)".json"));
                            if (WebAppUtils.isDataikuAnswers(webApp)) {
                                answersWebApps.add(webApp);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot retrieve webapp from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                    }
                    try {
                        if (!entryName.equals("project_config/badges.json")) continue;
                        ProjectBadges projectBadges = (ProjectBadges)JSON.parse((InputStream)zipFile.getInputStream(entry), ProjectBadges.class);
                        this.projectGenAIBadges = projectBadges.listBadges();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot retrieve ai types badges from bundle: " + bundleArchive.getAbsolutePath() + " : " + entryName), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Cannot parse bundle file: " + bundleArchive.getAbsolutePath()), (Throwable)e);
            }
            this.exportUserInfo = exportUserInfo;
            this.llmUsage = new LLMUsage(llmRecipesAndPayloads, knowledgeBanksWithEmbeddingLLMId, augmentedSavedModels, !promptStudios.isEmpty(), !agentReviews.isEmpty(), answersWebApps.size());
            this.projectStandardsReport = projectStandardsReport;
            this.projectStandardsReportSummary = projectStandardsReport == null ? null : new ProjectStandardsRunReportSummary(projectStandardsReport);
        }
    }
}

