/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop;

import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HadoopFlavorUtils {
    private static HadoopFlavorDetails data;

    public static void setFlavorForTest(Flavor flavor, Integer hdpMajor, boolean hiveSupportsMREngine, boolean hive3) {
        data = new HadoopFlavorDetails();
        HadoopFlavorUtils.data.flavor = flavor;
        HadoopFlavorUtils.data.hdpMajor = hdpMajor;
        HadoopFlavorUtils.data.hive3 = hive3;
        HadoopFlavorUtils.data.hiveSupportsMREngine = hiveSupportsMREngine;
    }

    public static boolean hiveSupportsMREngine() {
        return HadoopFlavorUtils.data.hiveSupportsMREngine;
    }

    public static boolean isHive3() {
        return HadoopFlavorUtils.data.hive3;
    }

    public static boolean isHDP3() {
        return HadoopFlavorUtils.data.flavor == Flavor.hdp && HadoopFlavorUtils.data.hdpMajor == 3;
    }

    public static boolean isCDH6() {
        return HadoopFlavorUtils.data.flavor == Flavor.cdh6;
    }

    public static boolean isCDH7() {
        return HadoopFlavorUtils.data.flavor == Flavor.cdh7;
    }

    public static boolean isCDHAtLeast6() {
        return HadoopFlavorUtils.data.flavor == Flavor.cdh6 || HadoopFlavorUtils.data.flavor == Flavor.cdh7;
    }

    public static float getCDHVersion() {
        return HadoopFlavorUtils.data.cdhMajorMinor == null ? Float.NaN : HadoopFlavorUtils.data.cdhMajorMinor.floatValue();
    }

    public static boolean isStandalone() {
        return HadoopFlavorUtils.data.flavor == Flavor.generic;
    }

    private static String getHadoopVersion() {
        try {
            Class<?> versionInfoClazz = HadoopFlavorUtils.class.getClassLoader().loadClass("org.apache.hadoop.util.VersionInfo");
            Method getVersionMethod = versionInfoClazz.getMethod("getVersion", new Class[0]);
            return (String)getVersionMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Logger.getLogger((String)"dip.hadoop").warn((Object)("Unable to sniff version, assuming none: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return null;
        }
    }

    public static boolean isCDH7AtLeast(int ... atLeastParts) {
        String version = HadoopFlavorUtils.getHadoopVersion();
        return version != null && HadoopFlavorUtils.isCDH7() ? HadoopFlavorUtils.isCDH7AtLeast(version, atLeastParts) : false;
    }

    public static boolean isCDH7AtLeast(String version, int ... atLeastParts) {
        String[] parts = version.split("\\.");
        if (parts.length != 7) {
            Logger.getLogger((String)"dip.hadoop").warn((Object)("Unable to sniff Hadoop CDH7 version " + version + ", assuming none"));
            return false;
        }
        int idx = 3;
        for (int atLeastPart : atLeastParts) {
            if (atLeastPart == Integer.parseInt(parts[idx])) {
                ++idx;
                continue;
            }
            return atLeastPart < Integer.parseInt(parts[idx]);
        }
        return true;
    }

    public static boolean isAtLeast(int ... atLeastParts) {
        String version = HadoopFlavorUtils.getHadoopVersion();
        return version != null ? HadoopFlavorUtils.isAtLeast(version, atLeastParts) : false;
    }

    static boolean isAtLeast(String version, int ... atLeastParts) {
        Logger.getLogger((String)"dip.hadoop").warn((Object)("Compare hadoop version '" + version + "' to " + Arrays.toString(atLeastParts)));
        if (version == null) {
            return false;
        }
        for (int atLeastPart : atLeastParts) {
            int versionPart;
            if (version.isEmpty()) {
                if (atLeastPart == 0) continue;
                return false;
            }
            int dotPos = version.indexOf(46);
            int dashPos = version.indexOf(45);
            int underscorePos = version.indexOf(95);
            if (dotPos > 0) {
                try {
                    versionPart = Integer.parseInt(version.substring(0, dotPos));
                }
                catch (Exception e) {
                    versionPart = 0;
                }
                version = version.substring(dotPos + 1);
            } else if (dashPos > 0 || underscorePos > 0) {
                try {
                    int separatorPos = Math.min(dashPos < 0 ? version.length() : dashPos, underscorePos < 0 ? version.length() : underscorePos);
                    versionPart = Integer.parseInt(version.substring(0, separatorPos));
                }
                catch (Exception e) {
                    versionPart = 0;
                }
                version = "";
            } else {
                try {
                    versionPart = Integer.parseInt(version);
                }
                catch (Exception e) {
                    versionPart = 0;
                }
                version = "";
            }
            if (versionPart < atLeastPart) {
                return false;
            }
            if (versionPart <= atLeastPart) continue;
            return true;
        }
        return true;
    }

    static {
        String dataStr = System.getenv("DKU_HADOOP_FLAVOR2");
        if (dataStr == null) {
            data = new HadoopFlavorDetails();
            HadoopFlavorUtils.data.flavor = Flavor.valueOf(StringUtils.defaultIfBlank((String)System.getenv("DKU_HADOOP_FLAVOR"), (String)"generic"));
        } else {
            data = (HadoopFlavorDetails)JSON.parse((String)dataStr, HadoopFlavorDetails.class);
        }
        Logger.getLogger((String)"x").info((Object)("**** Hadoop flavor **** " + JSON.log((Object)data)));
    }

    public static class HadoopFlavorDetails {
        public Flavor flavor;
        public Integer hdpMajor;
        public Float cdhMajorMinor;
        public boolean hiveSupportsMREngine;
        public boolean hive3;
    }

    public static enum Flavor {
        cdh5,
        cdh6,
        cdh7,
        hdp,
        mapr,
        generic;

    }
}

