/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class HiveConfigurator {
    private static Boolean hiveAvailabilityBaseCache = null;
    private static boolean hiveEnabled = "true".equals(System.getenv("DKU_HIVE_ENABLED"));
    private static Logger logger = Logger.getLogger(HiveConfigurator.class);

    public static HiveConnection configureConnectionForDatabase(AuthCtx authCtx, String databaseName, List<SimpleKeyValue> hiveconf, HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService) throws IOException, DKUSecurityException {
        String virtualName = "@virtual(hive-jdbc):" + databaseName;
        HiveConnection conn = new HiveConnection(hiveServer2ConnectionPoolService);
        conn.name = virtualName;
        conn.allowWrite = false;
        conn.allowManagedDatasets = false;
        conn.params.db = databaseName;
        if (hiveconf != null) {
            conn.params.hiveconf.addAll(hiveconf);
        }
        return conn;
    }

    public static void setupFromSettings(String clusterId, HiveConnection.Params connParams, HiveSettings hiveSettings) {
        connParams.useUrl = hiveSettings.useURL;
        connParams.customUrl = hiveSettings.url;
        connParams.customDisplayedUrl = hiveSettings.displayedUrl;
        connParams.customDriver = hiveSettings.driver;
        if (HiveSettings.urlContainsSecret()) {
            connParams.customUrl = ((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class)).decryptIfEncrypted(connParams.customUrl);
        }
        connParams.auxJarsAndUdfs = hiveSettings.auxJarsAndUdfs;
        connParams.host = hiveSettings.hiveServer2Host;
        connParams.port = hiveSettings.hiveServer2Port;
        connParams.principal = hiveSettings.hiveServer2Principal;
        connParams.properties.addAll(hiveSettings.connectionProperties.getAsConnectionProperties());
        connParams.extraUrl = hiveSettings.extraUrl;
    }

    public static boolean isHiveInstalled() {
        return HadoopLoader.hadoopEnabled() && hiveEnabled;
    }

    private static boolean checkHiveAvailabilityBase() {
        if (!HadoopLoader.hadoopEnabled()) {
            logger.trace((Object)"Hive support is disabled (no hadoop)");
            return false;
        }
        if (!hiveEnabled) {
            logger.trace((Object)"Hive support is disabled (no hive installtion)");
            return false;
        }
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
            logger.trace((Object)"Hive JDBC driver loaded");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Missing Hive JDBC driver");
            return false;
        }
    }

    public static synchronized boolean hiveAvailableBase() {
        if (hiveAvailabilityBaseCache == null) {
            hiveAvailabilityBaseCache = HiveConfigurator.checkHiveAvailabilityBase();
        }
        return hiveAvailabilityBaseCache;
    }

    public static boolean hiveAvailableForCharts(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        if (!HiveConfigurator.hiveAvailableBase()) {
            return false;
        }
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getHiveSettings();
        if (hiveSettings == null || !hiveSettings.enabled || !hiveSettings.canChart) {
            logger.info((Object)"Hive chart support is disabled");
            return false;
        }
        return true;
    }

    public static boolean hiveAvailable(AuthCtx authCtx, String projectKey) {
        return HiveConfigurator.hiveAvailableBase();
    }

    private HiveConfigurator() {
    }
}

