/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.catalog;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogPartition;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogTable;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DSSHiveCatalogInternalDB
extends AbstractDSSDBService {
    private static final int SCHEMA_VERSION = 1;
    private static final String DB_NAME = "hive-catalog";
    private static final String TABLES_TABLE = "HIVE_TABLES";
    private static final String PARTITIONS_TABLE = "HIVE_PARTITIONS";
    public static final List<String> TABLES = ImmutableList.of((Object)"HIVE_TABLES", (Object)"HIVE_PARTITIONS");
    private static final String PROJECT_KEY_COLUMN = "PROJECT_KEY";
    private static final String DATASET_NAME_COLUMN = "DATASET_NAME";
    private static final String DB_NAME_COLUMN = "DB_NAME";
    private static final String TABLE_NAME_COLUMN = "TABLE_NAME";
    private static final String STORAGE_DESCRIPTOR_COLUMN = "STORAGE_DESCRIPTOR";
    private static final String PARTITION_KEYS_COLUMN = "PARTITION_KEYS";
    private static final String PARTITION_ID_COLUMN = "PARTITION_ID";
    private static final String HIVE_PARTITION_NAME_COLUMN = "HIVE_PARTITION_NAME";
    private static final String LOCATION_COLUMN = "LOCATION";
    private static final SchemaColumn[] tablesColumns = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("DATASET_NAME", Type.STRING), new SchemaColumn("DB_NAME", Type.STRING), new SchemaColumn("TABLE_NAME", Type.STRING), new SchemaColumn("STORAGE_DESCRIPTOR", Type.STRING), new SchemaColumn("PARTITION_KEYS", Type.STRING)};
    private static final SchemaColumn[] partitionsColumns = new SchemaColumn[]{new SchemaColumn("DB_NAME", Type.STRING), new SchemaColumn("TABLE_NAME", Type.STRING), new SchemaColumn("PARTITION_ID", Type.STRING), new SchemaColumn("HIVE_PARTITION_NAME", Type.STRING), new SchemaColumn("LOCATION", Type.STRING)};
    private final String insertTable = InsertQueryBuilder.insertInto(this.resolveTable("HIVE_TABLES")).addColumns(tablesColumns).toSQL(this.getDialect());
    private final String dropTable = DeleteQueryBuilder.deleteFrom(this.resolveTable("HIVE_TABLES")).withParameterizedEqualWheres("DB_NAME", "TABLE_NAME").toSql(this.getDialect());
    private final String getTable = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("HIVE_TABLES")).wheres("DB_NAME", "TABLE_NAME").toSQL(this.getDialect());
    private final String listTables = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("HIVE_TABLES")).wheres("DB_NAME").toSQL(this.getDialect());
    private final String getPartitionByHivePartitionName = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("HIVE_PARTITIONS")).wheres("DB_NAME", "TABLE_NAME", "HIVE_PARTITION_NAME").toSQL(this.getDialect());
    private final String listPartitions = SimpleSelectQueryBuilder.selectAll().from(this.resolveTable("HIVE_PARTITIONS")).wheres("DB_NAME", "TABLE_NAME").toSQL(this.getDialect());
    private final String getDatabase = SimpleSelectQueryBuilder.select("DB_NAME").distinct().from(this.resolveTable("HIVE_TABLES")).wheres("DB_NAME").toSQL(this.getDialect());
    private final String listDatabases = SimpleSelectQueryBuilder.select("DB_NAME").distinct().from(this.resolveTable("HIVE_TABLES")).toSQL(this.getDialect());
    private final String insertPartition = InsertQueryBuilder.insertInto(this.resolveTable("HIVE_PARTITIONS")).addColumns(partitionsColumns).toSQL(this.getDialect());
    private final String dropTablePartitions = DeleteQueryBuilder.deleteFrom(this.resolveTable("HIVE_PARTITIONS")).withParameterizedEqualWheres("DB_NAME", "TABLE_NAME").toSql(this.getDialect());
    private final String dropPartitionByDSSPartitionId = DeleteQueryBuilder.deleteFrom(this.resolveTable("HIVE_PARTITIONS")).withParameterizedEqualWheres("DB_NAME", "TABLE_NAME", "PARTITION_ID").toSql(this.getDialect());
    private static Logger logger = Logger.getLogger((String)"dku.hive.catalog.db");

    public DSSHiveCatalogInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 1, true);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        if (currentSchemaVersion == 0) {
            try (Statement st2 = conn.createStatement();){
                this.createTable(TABLES_TABLE, tablesColumns, null, st2);
                this.createTable(PARTITIONS_TABLE, partitionsColumns, null, st2);
                this.createAnonymousIndex(TABLES_TABLE, new String[]{DB_NAME_COLUMN}, st2);
                this.createAnonymousIndex(TABLES_TABLE, new String[]{DB_NAME_COLUMN, TABLE_NAME_COLUMN}, st2);
                this.createAnonymousIndex(PARTITIONS_TABLE, new String[]{DB_NAME_COLUMN, TABLE_NAME_COLUMN, PARTITION_ID_COLUMN}, st2);
                this.createAnonymousIndex(PARTITIONS_TABLE, new String[]{DB_NAME_COLUMN, TABLE_NAME_COLUMN, HIVE_PARTITION_NAME_COLUMN}, st2);
            }
        }
    }

    public void createTable(DSSHiveCatalogTable table) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.doInsertTable(table, conn);
            conn.commit();
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void replaceTableWithPartitions(DSSHiveCatalogTable table, List<DSSHiveCatalogPartition> partitions) throws CodedSQLException {
        logger.info((Object)("Replacing table with partitions: " + JSON.log((Object)table) + " parts=" + JSON.log(partitions)));
        try (DSSDBConnection conn = this.acquireConnection();){
            this.doDropTable(table, conn);
            this.doDropPartitions(table, conn);
            this.doInsertTable(table, conn);
            if (partitions != null) {
                PreparedStatement ipPS = this.getPreparedStatement(conn, this.insertPartition);
                for (DSSHiveCatalogPartition partition : partitions) {
                    ipPS.clearParameters();
                    int i = 0;
                    ipPS.setString(++i, table.dbName);
                    ipPS.setString(++i, table.tableName);
                    ipPS.setString(++i, partition.partitionId);
                    ipPS.setString(++i, partition.hivePartitionName);
                    ipPS.setString(++i, partition.location);
                    ipPS.execute();
                }
            }
            conn.commit();
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private void doDropPartitions(DSSHiveCatalogTable table, DSSDBConnection conn) throws SQLException {
        this.doDropPartitions(table.dbName, table.tableName, conn);
    }

    private void doDropPartitions(String dbName, String tableName, DSSDBConnection conn) throws SQLException {
        int i = 0;
        PreparedStatement dtpPS = this.getPreparedStatement(conn, this.dropTablePartitions);
        dtpPS.setString(++i, dbName);
        dtpPS.setString(++i, tableName);
        dtpPS.execute();
    }

    public void dropPartitionByDSSPartitionId(String dbName, String tableName, String partitionId) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement dtpPS = this.getPreparedStatement(conn, this.dropPartitionByDSSPartitionId);
            dtpPS.setString(++i, dbName);
            dtpPS.setString(++i, tableName);
            dtpPS.setString(++i, partitionId);
            dtpPS.execute();
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void dropAllPartitions(String dbName, String tableName) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.doDropPartitions(dbName, tableName, conn);
            conn.commit();
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void updateTableWithPartition(DSSHiveCatalogTable table, DSSHiveCatalogPartition partition) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.doDropTable(table, conn);
            this.doInsertTable(table, conn);
            if (partition != null) {
                this.doDropPartition(table, partition, conn);
                PreparedStatement ipPS = this.getPreparedStatement(conn, this.insertPartition);
                int i = 0;
                ipPS.setString(++i, table.dbName);
                ipPS.setString(++i, table.tableName);
                ipPS.setString(++i, partition.partitionId);
                ipPS.setString(++i, partition.hivePartitionName);
                ipPS.setString(++i, partition.location);
                ipPS.execute();
            }
            conn.commit();
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private void doDropPartition(DSSHiveCatalogTable table, DSSHiveCatalogPartition partition, DSSDBConnection conn) throws SQLException {
        int i = 0;
        PreparedStatement dtpPS = this.getPreparedStatement(conn, this.dropPartitionByDSSPartitionId);
        dtpPS.setString(++i, table.dbName);
        dtpPS.setString(++i, table.tableName);
        dtpPS.setString(++i, partition.partitionId);
        dtpPS.execute();
    }

    private void doInsertTable(DSSHiveCatalogTable table, DSSDBConnection conn) throws SQLException {
        int i = 0;
        PreparedStatement itPS = this.getPreparedStatement(conn, this.insertTable);
        itPS.setString(++i, table.projectKey);
        itPS.setString(++i, table.datasetName);
        itPS.setString(++i, table.dbName);
        itPS.setString(++i, table.tableName);
        itPS.setString(++i, JSON.json((Object)table.sd));
        itPS.setString(++i, JSON.json(table.partitionKeys));
        itPS.execute();
    }

    private void doDropTable(DSSHiveCatalogTable table, DSSDBConnection conn) throws SQLException {
        this.doDropTable(table.dbName, table.tableName, conn);
    }

    private void doDropTable(String dbName, String tableName, DSSDBConnection conn) throws SQLException {
        int i = 0;
        PreparedStatement dtPS = this.getPreparedStatement(conn, this.dropTable);
        dtPS.setString(++i, dbName);
        dtPS.setString(++i, tableName);
        dtPS.execute();
    }

    public void dropTable(String dbName, String tableName) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            this.doDropTable(dbName, tableName, conn);
            conn.commit();
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DSSHiveCatalogTable getTable(String dbName, String tableName) throws CodedSQLException, NotFoundException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getTable);
            ps2.setString(++i, dbName);
            ps2.setString(++i, tableName);
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            if (!rs2.next()) throw new NotFoundException("Table not found: " + dbName + "." + tableName);
            DSSHiveCatalogTable dSSHiveCatalogTable = this.readTable(rs2);
            return dSSHiveCatalogTable;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProjectKeyOfTableOrNull(String dbName, String tableName) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getTable);
            ps2.setString(++i, dbName);
            ps2.setString(++i, tableName);
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            if (rs2.next()) {
                String string2 = rs2.getString(PROJECT_KEY_COLUMN);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public boolean databaseExists(String dbName) throws CodedSQLException {
        boolean bl;
        block9: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDatabase);
                ps2.setString(++i, dbName);
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                bl = rs2.next();
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedSQLException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DSSHiveCatalogPartition getPartitionByHivePartitionName(String dbName, String tableName, String hivePartitionName) throws CodedSQLException, NotFoundException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getPartitionByHivePartitionName);
            ps2.setString(++i, dbName);
            ps2.setString(++i, tableName);
            ps2.setString(++i, hivePartitionName);
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            if (!rs2.next()) throw new NotFoundException("Partition not found: " + dbName + "." + tableName + " " + hivePartitionName);
            DSSHiveCatalogPartition dSSHiveCatalogPartition = this.readPartition(rs2);
            return dSSHiveCatalogPartition;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public List<DSSHiveCatalogTable> listTables(String dbName) throws CodedSQLException {
        ArrayList<DSSHiveCatalogTable> arrayList;
        block10: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.listTables);
                ps2.setString(++i, dbName);
                ps2.execute();
                ArrayList<DSSHiveCatalogTable> ret = new ArrayList<DSSHiveCatalogTable>();
                ResultSet rs2 = ps2.getResultSet();
                while (rs2.next()) {
                    DSSHiveCatalogTable p = this.readTable(rs2);
                    ret.add(p);
                }
                arrayList = ret;
                if (conn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedSQLException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<DSSHiveCatalogPartition> listPartitions(String dbName, String tableName) throws CodedSQLException, NotFoundException {
        ArrayList<DSSHiveCatalogPartition> arrayList;
        block10: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.listPartitions);
                ps2.setString(++i, dbName);
                ps2.setString(++i, tableName);
                ps2.execute();
                ArrayList<DSSHiveCatalogPartition> ret = new ArrayList<DSSHiveCatalogPartition>();
                ResultSet rs2 = ps2.getResultSet();
                while (rs2.next()) {
                    ret.add(this.readPartition(rs2));
                }
                arrayList = ret;
                if (conn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedSQLException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<String> listDatabases() throws CodedSQLException {
        ArrayList<String> arrayList;
        block10: {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.listDatabases);
                ps2.execute();
                ArrayList<String> ret = new ArrayList<String>();
                ResultSet rs2 = ps2.getResultSet();
                while (rs2.next()) {
                    ret.add(rs2.getString(DB_NAME_COLUMN));
                }
                arrayList = ret;
                if (conn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedSQLException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    private DSSHiveCatalogTable readTable(ResultSet rs2) throws SQLException {
        DSSHiveCatalogTable table = new DSSHiveCatalogTable();
        table.projectKey = rs2.getString(PROJECT_KEY_COLUMN);
        table.datasetName = rs2.getString(DATASET_NAME_COLUMN);
        table.dbName = rs2.getString(DB_NAME_COLUMN);
        table.tableName = rs2.getString(TABLE_NAME_COLUMN);
        table.sd = (DSSHiveCatalogTable.DSSHiveCatalogTableStorageDescriptor)JSON.parse((String)rs2.getString(STORAGE_DESCRIPTOR_COLUMN), DSSHiveCatalogTable.DSSHiveCatalogTableStorageDescriptor.class);
        table.partitionKeys = (List)JSON.parse((String)rs2.getString(PARTITION_KEYS_COLUMN), (TypeToken)new TypeToken<List<SchemaColumn>>(){});
        return table;
    }

    private DSSHiveCatalogPartition readPartition(ResultSet rs2) throws SQLException {
        DSSHiveCatalogPartition p = new DSSHiveCatalogPartition();
        p.location = rs2.getString(LOCATION_COLUMN);
        p.partitionId = rs2.getString(PARTITION_ID_COLUMN);
        p.hivePartitionName = rs2.getString(HIVE_PARTITION_NAME_COLUMN);
        return p;
    }
}

