/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.massimport;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MetastoreTableToDatasetResyncer {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ImpersonationResolverService impersonationResolver;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    private final HiveImportabilityChecker checker = new HiveImportabilityChecker();
    private static Logger logger = Logger.getLogger((String)"dku.hive.import");

    public MetastoreTableToDatasetResyncer() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public DatasetHiveTableUpToDateState checkDatasetUpToDateState(AuthCtx authCtx, Dataset dataset, HDFSAbleConnection hdfsConnection) throws Exception {
        DatasetHiveTableUpToDateState datasetHiveTableUpToDateState;
        block17: {
            DatasetHiveTableUpToDateState ret = new DatasetHiveTableUpToDateState();
            HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);
            try {
                SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
                String clusterId = new ClusterSelector().getClusterForProject(dataset.getProjectKey(), Cluster.ClusterArchitecture.HADOOP);
                MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(authCtx, dataset.getProjectKey());
                TableSchema tableSchema = inspector.getTableSchema(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), null, authCtx, dataset.getProjectKey());
                HiveImportabilityChecker checker = new HiveImportabilityChecker();
                HiveImportabilityChecker.PossibleConnection pc = HiveImportabilityChecker.PossibleConnection.hdfsAble(hdfsConnection);
                ret.importability = checker.computeTableImportCandidate(dataset.getProjectKey(), clusterId, authCtx, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), pc, tableSchema, new StringTransmogrifier(), Lists.newArrayList((Object[])new HDFSAbleConnection[]{hdfsConnection}), new HashMap<String, SQLUtils.SQLTable>());
                if (ret.importability.newDataset != null) {
                    ret.schemaIncompatibilities = SchemaComparator.findIncompatibilities(dataset.getSchema(), ret.importability.newDataset.getSchema(), false);
                    if (dataset.getPartitioningSchema() == null || !dataset.getPartitioningSchema().isPartitioned()) {
                        if (ret.importability.newDataset.partitioning != null && ret.importability.newDataset.partitioning.getDimensionNames().size() > 0) {
                            ret.partitioningIncompatibility = String.format("Different partitioning : Hive table has %d partition dimensions", ret.importability.newDataset.partitioning.getDimensionNames().size());
                        }
                    } else if (ret.importability.newDataset.partitioning == null || !dataset.getPartitioningSchema().equals((Object)ret.importability.newDataset.partitioning)) {
                        int importedDimensionCount = ret.importability.newDataset.partitioning == null ? 0 : ret.importability.newDataset.partitioning.getDimensionNames().size();
                        ret.partitioningIncompatibility = String.format("Different partitioning : Hive table has %d partition dimensions instead of %d", importedDimensionCount, dataset.getPartitioningSchema().getDimensionNames().size());
                    }
                    String datasetConnectionName = dataset.getParamsAs(HDFSDatasetHandler.Config.class).connection;
                    String importedConnectionName = ret.importability.newDataset.getParamsAs(HDFSDatasetHandler.Config.class).connection;
                    String datasetPath = dataset.getParamsAs(HDFSDatasetHandler.Config.class).path;
                    String importedPath = ret.importability.newDataset.getParamsAs(HDFSDatasetHandler.Config.class).path;
                    if (!datasetConnectionName.equals(importedConnectionName)) {
                        ret.connectionIncompatibility = String.format("Connections differ : detected connection for Hive table is %s instead of %s", importedConnectionName, datasetConnectionName);
                    } else if (!datasetPath.equals(importedPath)) {
                        ret.pathIncompatibility = String.format("Paths to data differ : detected path for Hive table is %s instead of %s", importedPath, datasetPath);
                    }
                    if (hdfsConnection instanceof HDFSConnection && this.impersonationResolver.isEnabled()) {
                        HDFSConnection importedHdfsConnection = (HDFSConnection)hdfsConnection;
                        ret.connectionIsSubdirSynchronized = importedHdfsConnection != null && importedHdfsConnection.params.aclSynchronizationMode == HDFSConnection.ACLSynchronizationMode.SUBDIRECTORY;
                    }
                }
                datasetHiveTableUpToDateState = ret;
                if (handler == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    logger.error((Object)("Failure while checking hive importability of " + dataset.getFullName()), e);
                    ret.importability = new HiveImportabilityChecker.HiveTableImportCandidate();
                    ret.importability.messages.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_IMPORTABILITY_CHECK_FAILED, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    return ret;
                }
            }
            handler.close();
        }
        return datasetHiveTableUpToDateState;
    }

    public HiveImportabilityChecker.HiveTableImportCandidate prepareResyncTable_NT(AuthCtx authCtx, Dataset dataset) {
        TransactionContext.assertNoAttachedTransaction();
        HiveImportabilityChecker.HiveTableImportCandidate ret = new HiveImportabilityChecker.HiveTableImportCandidate();
        String projectKey = dataset.getProjectKey();
        try {
            SQLUtils.SQLTable tableRef;
            DSSConnection connection = this.connectionsDAO.getMandatoryConnection(authCtx, dataset.getParams().getConnection());
            if (!DatasetInspector.canHDFS(dataset)) {
                ret.messages.withFatalV((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, "Not an HDFS dataset: %s", new Object[]{dataset.getName()});
                return ret;
            }
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                tableRef = handler.getResolvedHiveTableRef(true);
            }
            HDFSAbleConnection hdfsConnection = (HDFSAbleConnection)((Object)connection);
            logger.info((Object)("Importing " + tableRef.getSchemaNullIfBlank() + "." + tableRef.getTable() + " into " + projectKey));
            String clusterId = new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
            TableSchema tableSchema = this.metastoreInspectionService.newInspector(authCtx, projectKey).getTableSchema(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), null, authCtx, projectKey);
            HiveImportabilityChecker.PossibleConnection pc = HiveImportabilityChecker.PossibleConnection.hdfsAble(hdfsConnection);
            ret = this.checker.computeTableImportCandidate(projectKey, clusterId, authCtx, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), pc, tableSchema, new StringTransmogrifier(), Lists.newArrayList((Object[])new HDFSAbleConnection[]{hdfsConnection}), new HashMap<String, SQLUtils.SQLTable>());
        }
        catch (Throwable t) {
            logger.error((Object)"Resync failed", t);
            ret.messages.withFatal((InfoMessage.MessageCode)HiveImportabilityChecker.ImportCodes.ERR_IMPORT_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)t));
        }
        return ret;
    }

    public void saveResyncTable(AuthCtx authCtx, Dataset dataset, HiveImportabilityChecker.HiveTableImportCandidate ret) throws Exception {
        String datasetName = dataset.getName();
        String projectKey = dataset.getProjectKey();
        if (!ret.messages.anyFatal()) {
            dataset.setSchema(ret.newDataset.getSchema());
            if (ret.newDataset.partitioning != null) {
                dataset.setPartitioningScheme(ret.newDataset.partitioning);
            } else {
                dataset.setPartitioningScheme(new PartitioningScheme());
            }
        } else {
            throw new Exception("Impossible to update dataset: " + JSON.log((Object)ret));
        }
        dataset.setParams(ret.newDataset.getParams());
        dataset.setFormatType(ret.newDataset.formatType);
        dataset.setFormatParams(ret.newDataset.getFormatParams());
        ret.newDataset = dataset.serialize();
        logger.info((Object)("Saving dataset " + datasetName));
        this.datasetSaveService.save(projectKey, datasetName, ret.newDataset, authCtx);
    }

    public static class DatasetHiveTableUpToDateState {
        public HiveImportabilityChecker.HiveTableImportCandidate importability;
        public boolean connectionIsSubdirSynchronized;
        public List<String> schemaIncompatibilities;
        public String connectionIncompatibility;
        public String pathIncompatibility;
        public String partitioningIncompatibility;
    }
}

