/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.shims;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.sql.Date;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDateObjectInspector;

public class HiveDefaultDSSDateObjectInspector
extends JavaDateObjectInspector
implements DSSBaseInspector {
    private static final DateTimeFormatter isoParser = ISODateTimeFormat.dateParser().withZone(DateTimeZone.UTC);
    private DSSBaseInspector parent;

    @Override
    public DSSBaseInspector getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }

    public DateWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new DateWritable(HiveDefaultDSSDateObjectInspector.asDateInternal(this, o));
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : HiveDefaultDSSDateObjectInspector.asDateInternal(this, o);
    }

    static Date asDateInternal(DSSBaseInspector asAnotherInspector, Object o) {
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            try {
                LocalDate dt = isoParser.parseLocalDate((String)o);
                return new Date(dt.toDate().getTime());
            }
            catch (IllegalArgumentException e) {
                RuntimeException enhancedException = new RuntimeException("Failed to parse DSS date only. " + e.getMessage(), e);
                throw new DSSInspectionException(asAnotherInspector, (Throwable)enhancedException);
            }
        }
        if (o == null) {
            throw new DSSInspectionException(asAnotherInspector, "Cannot be null here", null);
        }
        throw new RuntimeException("Unsupported convertion from " + o.getClass().getSimpleName() + " to Date, should be a DSS date only", null);
    }
}

