/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.hive.HiveBasicSerDeParser;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.warnings.RecordContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import org.apache.commons.lang.StringUtils;

public class CSVDeserializer {
    private static final DKULogger logger = DKULogger.getLogger(CSVDeserializer.class);
    private static final DateTimeParser[] hiveDateParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").getParser()};
    public static final DateTimeFormatter hiveDateParser = new DateTimeFormatterBuilder().append(null, hiveDateParsers).toFormatter().withZone(DateTimeZone.UTC);
    private static final DateTimeParser[] hiveBareDateParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser()};
    public static final DateTimeFormatter hiveBareDateParser = new DateTimeFormatterBuilder().append(null, hiveBareDateParsers).toFormatter().withZone(DateTimeZone.UTC);
    public static final DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private final CSVFormatConfig conf;
    private RecordContext rc;
    private final Boolean booleanMeaning = new Boolean();
    private WarningsContext wc;

    public CSVDeserializer(CSVFormatConfig conf, WarningsContext wc, RecordContext rc) {
        this.conf = conf;
        this.wc = wc;
        this.rc = rc;
    }

    public String parseDate(String s, SchemaColumn schemaColumn) {
        switch (this.conf.dateSerializationFormat) {
            case HIVE: {
                if (StringUtils.isBlank((String)s)) {
                    s = "";
                } else {
                    try {
                        s = isoFormatter.print((ReadableInstant)hiveDateParser.parseDateTime(s));
                    }
                    catch (IllegalArgumentException e) {
                        s = "";
                    }
                }
                return s;
            }
        }
        return s;
    }

    public String parseBoolean(String s, SchemaColumn col) {
        if (this.conf.normalizeBooleans) {
            java.lang.Boolean b = this.booleanMeaning.parseNoFail(s);
            if (b == null) {
                this.wc.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_BOOLEAN, StorageTypeVerifier.buildWarningMessage(s, col, this.wc, this.rc), logger);
                return null;
            }
            return b.toString();
        }
        return s;
    }

    public String parseDouble(String s, SchemaColumn col) {
        if (this.conf.normalizeDoubles && StringUtils.isNotEmpty((String)s)) {
            Double d = DKUDoubles.tryParse((String)s);
            if (d == null) {
                this.wc.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_FLOAT, StorageTypeVerifier.buildWarningMessage(s, col, this.wc, this.rc), logger);
                return null;
            }
            return d.toString();
        }
        return s;
    }

    public String parseComplex(String s, SchemaColumn col) {
        switch (this.conf.arrayMapFormat) {
            case json: {
                return s;
            }
            case hive: {
                try {
                    char[] separators = new char[this.conf.hiveSeparators.size()];
                    for (int i = 0; i < this.conf.hiveSeparators.size(); ++i) {
                        separators[i] = Params.getAsChar((String)this.conf.hiveSeparators.get(i));
                    }
                    if (this.conf.arrayItemSeparator != null) {
                        separators[0] = this.conf.getArrayItemSeparatorChar();
                    }
                    if (this.conf.mapKeySeparator != null) {
                        separators[1] = this.conf.getMapKeySeparatorChar();
                    }
                    switch (col.getType()) {
                        case OBJECT: {
                            return HiveBasicSerDeParser.parseStruct(s, col, separators, 0).toString();
                        }
                        case ARRAY: {
                            return HiveBasicSerDeParser.parseArray(s, col, separators, 0).toString();
                        }
                        case MAP: {
                            return HiveBasicSerDeParser.parseMap(s, col, separators, 0).toString();
                        }
                    }
                    assert (false);
                }
                catch (Exception e) {
                    logger.warn((Object)"Invalid", (Throwable)e);
                    return "";
                }
                throw new Error("unreachable");
            }
            case delimited: {
                if (col.getType() != Type.ARRAY) {
                    throw ErrorContext.iae((String)"Only ARRAY type can be stored as 'delimited' format");
                }
                try {
                    return HiveBasicSerDeParser.parseArray(s, col, new char[]{this.conf.getArrayItemSeparatorChar()}, 0).toString();
                }
                catch (Exception e) {
                    logger.warn((Object)"Invalid", (Throwable)e);
                    return "";
                }
            }
        }
        throw new Error("unreachable");
    }
}

