/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet.datetime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

public class JulianDateStamp
implements Serializable,
Cloneable {
    protected int integer;
    protected double fraction;

    public int getInteger() {
        return this.integer;
    }

    public double getFraction() {
        return this.fraction;
    }

    public int getJulianDayNumber() {
        if (this.fraction >= 0.5) {
            return this.integer + 1;
        }
        return this.integer;
    }

    public JulianDateStamp() {
    }

    public JulianDateStamp(double jd) {
        this.set(jd);
    }

    public JulianDateStamp(int i, double f) {
        this.set(i, f);
    }

    public JulianDateStamp(BigDecimal bd) {
        double d = bd.doubleValue();
        this.integer = (int)d;
        bd = bd.subtract(new BigDecimal(this.integer));
        this.fraction = bd.doubleValue();
    }

    public double doubleValue() {
        return (double)this.integer + this.fraction;
    }

    public BigDecimal toBigDecimal() {
        BigDecimal bd = new BigDecimal(this.integer);
        return bd.add(new BigDecimal(this.fraction));
    }

    public String toString() {
        String s = Double.toString(this.fraction);
        int i = s.indexOf(46);
        s = s.substring(i);
        return this.integer + s;
    }

    public JulianDateStamp add(JulianDateStamp jds) {
        int i = this.integer + jds.integer;
        double f = this.fraction + jds.fraction;
        this.set(i, f);
        return this;
    }

    public JulianDateStamp add(double delta) {
        this.set(this.integer, this.fraction + delta);
        return this;
    }

    public JulianDateStamp sub(JulianDateStamp jds) {
        int i = this.integer - jds.integer;
        double f = this.fraction - jds.fraction;
        this.set(i, f);
        return this;
    }

    public JulianDateStamp sub(double delta) {
        this.set(this.integer, this.fraction - delta);
        return this;
    }

    public void set(int i, double f) {
        this.integer = i;
        int fi = (int)f;
        f -= (double)fi;
        this.integer += fi;
        if (f < 0.0) {
            f += 1.0;
            --this.integer;
        }
        this.fraction = f;
    }

    public void set(double jd) {
        this.integer = (int)jd;
        this.fraction = jd - (double)this.integer;
    }

    public int daysBetween(JulianDateStamp otherDate) {
        int difference = this.daysSpan(otherDate);
        return difference >= 0 ? difference : -difference;
    }

    public int daysSpan(JulianDateStamp otherDate) {
        int now = this.getJulianDayNumber();
        int then = otherDate.getJulianDayNumber();
        return now - then;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JulianDateStamp)) {
            return false;
        }
        JulianDateStamp stamp = (JulianDateStamp)object;
        return stamp.integer == this.integer && Double.compare(stamp.fraction, this.fraction) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.integer, this.fraction);
    }

    protected JulianDateStamp clone() {
        return new JulianDateStamp(this.integer, this.fraction);
    }

    public JulianDateStamp getReducedJulianDate() {
        return new JulianDateStamp(this.integer - 2400000, this.fraction);
    }

    public void setReducedJulianDate(double rjd) {
        this.set(rjd + 2400000.0);
    }

    public JulianDateStamp getModifiedJulianDate() {
        return new JulianDateStamp(this.integer - 2400000, this.fraction - 0.5);
    }

    public void setModifiedJulianDate(double mjd) {
        this.set(mjd + 2400000.5);
    }

    public JulianDateStamp getTruncatedJulianDate() {
        return new JulianDateStamp(this.integer - 2440000, this.fraction - 0.5);
    }

    public void setTruncatedJulianDate(double tjd) {
        this.set(tjd + 2440000.5);
    }
}

