/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.freetext;

import com.dataiku.dip.labeling.FreeTextLabelingMetrics;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.VerifiedLabel;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.freetext.FreeTextAnnotation;
import com.dataiku.dip.labeling.freetext.FreeTextScore;
import com.dataiku.dip.labeling.score.LabelingScoreComputer;
import java.util.List;
import java.util.stream.Collectors;

public class FreeTextScoreComputer
extends LabelingScoreComputer<FreeTextScore, FreeTextLabelingMetrics> {
    @Override
    public VerifiedLabel.FreeTextVerifiedLabel computeVerifiedLabel(LabelingAnswer answer, VerifiedLabelingAnswer verifiedAnswer) {
        List<String> verifiedTexts = verifiedAnswer.label.annotations.stream().map(a -> ((FreeTextAnnotation)a).text).collect(Collectors.toList());
        return new VerifiedLabel.FreeTextVerifiedLabel(verifiedTexts);
    }

    @Override
    public FreeTextScore score(LabelingAnswer answer) {
        FreeTextScore ret = new FreeTextScore();
        if (answer.verifiedLabel == null) {
            return ret;
        }
        VerifiedLabel.FreeTextVerifiedLabel verifiedLabel = (VerifiedLabel.FreeTextVerifiedLabel)answer.verifiedLabel;
        if (((FreeTextAnnotation)answer.label.annotations.get((int)0)).text.equals(verifiedLabel.verifiedTexts.get(0))) {
            ++ret.numCorrectAnnotations;
        } else {
            ++ret.numIncorrectAnnotations;
        }
        return ret;
    }

    @Override
    public FreeTextLabelingMetrics getMetrics(FreeTextScore score) {
        FreeTextLabelingMetrics metrics = new FreeTextLabelingMetrics();
        if (score.numCorrectAnnotations + score.numIncorrectAnnotations > 0) {
            metrics.accuracy = (double)score.numCorrectAnnotations * 1.0 / (double)(score.numCorrectAnnotations + score.numIncorrectAnnotations);
        }
        return metrics;
    }

    @Override
    public void incrementScore(FreeTextScore originalScore, FreeTextScore newScore) {
        originalScore.numCorrectAnnotations += newScore.numCorrectAnnotations;
        originalScore.numIncorrectAnnotations += newScore.numIncorrectAnnotations;
    }

    @Override
    public FreeTextScore initScore() {
        return new FreeTextScore();
    }
}

