/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.objectdetection;

import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.classification.ClassificationAnnotation;
import com.dataiku.dip.labeling.region.LabelingRegion;
import com.dataiku.dip.labeling.region.RegionElement;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;

@UIModel
public class BoundingBox
extends ClassificationAnnotation {
    public BoxCoordinates bbox;

    public BoundingBox(String category, double x0, double y0, double width, double height) {
        super(category);
        this.bbox = new BoxCoordinates(x0, y0, width, height);
    }

    @Override
    public void validate(LabelingTask task) {
        super.validate(task);
        if (this.bbox.width < 0.0 || this.bbox.height < 0.0) {
            throw ErrorContext.iae((String)"Bounding box height's and width's should be positive");
        }
        if (this.bbox.width == 0.0 && this.bbox.height == 0.0) {
            throw ErrorContext.iae((String)"Bounding box area should be positive");
        }
    }

    public static class BoxCoordinates {
        public double x0;
        public double y0;
        public double width;
        public double height;

        public BoxCoordinates(double x0, double y0, double width, double height) {
            this.x0 = x0;
            this.y0 = y0;
            this.width = width;
            this.height = height;
        }

        public double computeIoUWith(BoxCoordinates bbox) {
            double interX0 = Math.max(this.x0, bbox.x0);
            double interY0 = Math.max(this.y0, bbox.y0);
            double interX1 = Math.min(this.x0 + this.width, bbox.x0 + bbox.width);
            double interY1 = Math.min(this.y0 + this.height, bbox.y0 + bbox.height);
            if (interX1 <= interX0 || interY1 <= interY0) {
                return 0.0;
            }
            double intersection_area = (interX1 - interX0) * (interY1 - interY0);
            double bb1_area = this.width * this.height;
            double bb2_area = bbox.width * bbox.height;
            return intersection_area / (bb1_area + bb2_area - intersection_area);
        }

        public static BoxCoordinates averageBox(LabelingRegion<BoundingBox> region) {
            double x0 = 0.0;
            double y0 = 0.0;
            double width = 0.0;
            double height = 0.0;
            for (RegionElement element : region.elements) {
                x0 += ((BoundingBox)element.annotation).bbox.x0;
                y0 += ((BoundingBox)element.annotation).bbox.y0;
                width += ((BoundingBox)element.annotation).bbox.width;
                height += ((BoundingBox)element.annotation).bbox.height;
            }
            if (region.elements.size() > 1) {
                x0 /= (double)region.elements.size();
                y0 /= (double)region.elements.size();
                width /= (double)region.elements.size();
                height /= (double)region.elements.size();
            }
            return new BoxCoordinates(x0, y0, width, height);
        }
    }
}

