/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.custom;

import com.dataiku.dip.connections.CustomLLMConnection;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.custom.CustomLLMDesc;
import com.dataiku.dip.llm.custom.LoadedLLM;
import com.dataiku.dip.llm.online.AbstractLLMClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.util.HashMap;
import java.util.Map;

public class CustomLLMTypesRegistry {
    private static final Map<String, RegisteredLLMType<? extends CustomLLMDesc, ? extends IElementLoadedDesc>> metas = new HashMap<String, RegisteredLLMType<? extends CustomLLMDesc, ? extends IElementLoadedDesc>>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.custom");

    private CustomLLMTypesRegistry() {
    }

    public static synchronized <Desc extends CustomLLMDesc, LoadedDesc extends IElementLoadedDesc> void register(LoadedLLM<Desc> loaded, AbstractElementService<Desc, LoadedDesc> service) {
        logger.info((Object)("Registering LLM type: " + loaded.getType()));
        RegisteredLLMType<Desc, LoadedDesc> r = new RegisteredLLMType<Desc, LoadedDesc>(loaded, service);
        metas.put(r.getType(), r);
    }

    public static synchronized void deregister(String type) {
        metas.remove(type);
    }

    private static synchronized RegisteredLLMType<? extends CustomLLMDesc, ? extends IElementLoadedDesc> get(String type) {
        RegisteredLLMType<? extends CustomLLMDesc, ? extends IElementLoadedDesc> meta = metas.get(type);
        if (meta == null) {
            throw ErrorContext.iaef((String)"Custom LLM type does not exist: '%s'.", (Object)type, (Object[])new Object[0]);
        }
        return meta;
    }

    public static AbstractLLMClient getClient(AuthCtx authCtx, CustomLLMConnection connection, String projectKey, CustomLLMConnection.LLMModel llmModel, EnrichedLLMStructuredRef enrichedRef, boolean forTest) {
        RegisteredLLMType<? extends CustomLLMDesc, ? extends IElementLoadedDesc> llmType = CustomLLMTypesRegistry.get(llmModel.type);
        return llmType.buildClient(authCtx, connection, projectKey, llmModel, enrichedRef, forTest);
    }

    private record RegisteredLLMType<Desc extends CustomLLMDesc, LoadedDesc extends IElementLoadedDesc>(LoadedLLM<Desc> loaded, AbstractElementService<Desc, LoadedDesc> service) {
        public String getType() {
            return this.loaded.getType();
        }

        public AbstractLLMClient buildClient(AuthCtx authCtx, CustomLLMConnection connection, String projectKey, CustomLLMConnection.LLMModel customModel, EnrichedLLMStructuredRef enrichedRef, boolean forTest) {
            return this.loaded.createLLMClient(authCtx, this.service, connection, projectKey, customModel, enrichedRef, forTest);
        }
    }
}

