/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.evaluation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.llm.evaluation.TestCustomMetricKernelPool;
import com.dataiku.dip.recipes.code.python.PythonRecipeStatusComputerBase;
import com.dataiku.dip.recipes.nlp.evaluation.AbstractGenAIEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationRecipeParams;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.threads.BaseProgressingWorkThread;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.reflect.TypeToken;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomMetricsService {
    private final FutureService futureService;
    private final TestCustomMetricKernelPool testCustomMetricKernelPool;
    private final LicenseEnforcementService licenseEnforcementService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.evaluation.custommetrics.service");

    public CustomMetricsService(@Autowired FutureService futureService, @Autowired TestCustomMetricKernelPool testCustomMetricKernelPool, @Autowired LicenseEnforcementService licenseEnforcementService) {
        this.futureService = futureService;
        this.testCustomMetricKernelPool = testCustomMetricKernelPool;
        this.licenseEnforcementService = licenseEnforcementService;
    }

    public FutureResponse<CustomMetricResult> startTest(DSSAuthCtx owner, final String projectKey, final SerializedRecipe recipe, final AbstractGenAIEvaluationRecipePayloadParams recipeDesc, final int metricIndex, final SerializedDataset serializedInputDataset) throws Exception {
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featuresStatus = this.licenseEnforcementService.getFeaturesStatus();
        if (!featuresStatus.advancedLLMMeshAllowed) {
            throw new LicenseRestrictionException("LLM Evaluation requires Advanced LLM Mesh, which is not enabled in your license.");
        }
        return this.futureService.runFuture(new BaseProgressingWorkThread<CustomMetricResult>(owner){
            CustomMetricResult result;

            public FuturePayload getPayload() {
                FuturePayload payload = FuturePayload.newSimple((String)"custom_metric_test", (String)"Test Custom metric");
                payload.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, recipe.getFullId() + metricIndex, "Custom metric test : " + recipeDesc.customMetrics.get((int)metricIndex).name, null));
                return payload;
            }

            public double getDangerosity() {
                return 0.0;
            }

            public CustomMetricResult getResult() {
                return this.result;
            }

            public void execute() throws Exception {
                try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Custom metric test", (double)100.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    this.percentageProgressState = state;
                    this.result = CustomMetricsService.this.testMetric_NT(this.owner, (FutureProgressState)state, recipe, recipeDesc, metricIndex, serializedInputDataset);
                }
            }
        }, 0L, new TypeToken<FutureResponse<CustomMetricResult>>(){});
    }

    private CustomMetricResult testMetric_NT(DSSAuthCtx owner, FutureProgressState percentageProgressState, SerializedRecipe recipe, AbstractGenAIEvaluationRecipePayloadParams recipeDesc, int metricIndex, SerializedDataset serializedInputDataset) throws Exception {
        GenAIEvaluationRecipeParams recipeParams = recipe.getParamsAs(GenAIEvaluationRecipeParams.class);
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        PythonRecipeStatusComputerBase.checkPythonCompile(messages, recipeDesc.customMetrics.get((int)metricIndex).metricCode, recipeParams.getCodeEnvSelection().envName, recipe.getProjectKey());
        if (messages.anyFatal()) {
            InfoMessage fatalMessage = messages.firstFatal();
            return new CustomMetricSyntaxError(fatalMessage.details, fatalMessage.line, fatalMessage.column);
        }
        percentageProgressState.increment(10.0);
        Dataset inputDataset = Dataset.fromSerialized(serializedInputDataset);
        int timeoutInMinutes = ApplicationConfigurator.getParams().getIntParam("dku.llm.eval.testMetric.timeoutInMinutes", Integer.valueOf(5));
        try {
            return this.testCustomMetricKernelPool.testCustomMetric(owner, recipe, recipeDesc, metricIndex, inputDataset, timeoutInMinutes);
        }
        catch (TimeoutException e) {
            throw new TimeoutException("Timeout: Custom metric did not complete in less than " + timeoutInMinutes + " minutes");
        }
    }

    static class CustomMetricSyntaxError
    extends CustomMetricResult {
        public String error;
        public int line;
        public int column;

        public CustomMetricSyntaxError(String error, int line, int column) {
            this.didSucceed = false;
            this.error = error;
            this.line = line;
            this.column = column;
        }

        public CustomMetricSyntaxError() {
            this.didSucceed = false;
        }
    }
}

