/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.langchain;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.langchain.AbstractAgentLLMClient;
import com.dataiku.dip.llm.langchain.PythonLLMServer;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.savedmodels.agents.LoadedCustomAgent;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class PluginAgentLLMClient
extends AbstractAgentLLMClient {
    private final LoadedCustomAgent desc;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.python");

    public PluginAgentLLMClient(DSSAuthCtx authCtx, String projectKey, SavedModel sm, SavedModel.SavedModelInlineVersion smiv, boolean devKernel) {
        super(authCtx, projectKey, sm, smiv, devKernel);
        CustomAgentMeta meta = AgentTypesRegistry.getMeta(smiv.pluginAgentType);
        this.desc = (LoadedCustomAgent)meta.getLoadedDesc();
    }

    private PluginSettingsResolver.ResolvedSettings getExpandedPluginSettings() throws Exception {
        CustomAgentsService customAgentsService = (CustomAgentsService)SpringUtils.getBean(CustomAgentsService.class);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = customAgentsService.getExpandedPluginSettings(this.desc.getType(), this.authCtx, this.savedModel.projectKey, this.smiv.pluginAgentConfig);
        IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        PluginDesc pluginDesc = pluginsService.getDesc(this.desc.ownerPluginId);
        HashSet<String> passwordParams = new HashSet<String>();
        PluginPasswordFinder finder = new PluginPasswordFinder();
        passwordParams.addAll(finder.findPasswordParams(pluginDesc.params));
        passwordParams.addAll(finder.findPasswordParams(this.desc.getParams()));
        JsonArray jsonPasswordParams = new JsonArray();
        passwordParams.forEach(arg_0 -> ((JsonArray)jsonPasswordParams).add(arg_0));
        expandedPluginSettings.pluginConfig.add("dkuPasswordParams", (JsonElement)jsonPasswordParams);
        return expandedPluginSettings;
    }

    private String getCode() throws Exception {
        IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        File pluginFolder = pluginsService.getActualPluginFolder(this.desc.ownerPluginId);
        File codeFolder = new File(pluginFolder, this.desc.folderName);
        return DKUFileUtils.readFileToStringUTF8((File)new File(codeFolder, "agent.py"));
    }

    private String getLibFolder() {
        CustomAgentsService customAgentsService = (CustomAgentsService)SpringUtils.getBean(CustomAgentsService.class);
        return customAgentsService.getPythonLibFolder(this.desc.getType());
    }

    public PythonLLMServerKernelPool.KernelDesc buildKernelDesc() throws Exception {
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.desc.ownerPluginId);
        String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.savedModel.projectKey, this.smiv.pluginAgentSettings.containerExecSelection);
        String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.savedModel.projectKey).getClusterId();
        String libFolder = this.getLibFolder();
        String code = this.getCode();
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.getExpandedPluginSettings();
        return PythonLLMServerKernelPool.buildKernelDesc(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv, null, code, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, envName, containerConfName, this.desc.ownerPluginId, libFolder, false, clusterId, this.smiv.pluginAgentSettings, this.devKernel, Lists.newArrayList());
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        block7: {
            if (this.serverAPI == null) {
                try {
                    PythonLLMServerKernelPool.KernelDesc kernelDesc = this.buildKernelDesc();
                    PythonLLMServerKernelPool kernelPool = (PythonLLMServerKernelPool)SpringUtils.getBean(PythonLLMServerKernelPool.class);
                    if (this.isDevMode()) {
                        File logBaseDir = DKUApp.getFile((String[])new String[]{"saved_models", this.savedModel.projectKey, this.savedModel.id, "versions", this.smiv.versionId, "logs"});
                        PythonLLMServer server = new PythonLLMServer(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv.versionId, null, kernelDesc.code, kernelDesc.envName, kernelDesc.containerConfName, this.desc.ownerPluginId, kernelDesc.libFolder, logBaseDir, kernelDesc.config, kernelDesc.pluginConfig, true, false, false, Lists.newArrayList());
                        try {
                            server.start();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                            IOUtils.closeQuietly((Closeable)server, null);
                            throw e;
                        }
                        this.serverAPI = server;
                        break block7;
                    }
                    this.serverAPI = kernelPool.getServerAPI(kernelDesc);
                }
                catch (CustomPythonKernelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize Python LLM", e);
                }
            }
        }
    }

    @Override
    public boolean requiresCostLimiting() {
        return true;
    }

    @Override
    public boolean canBeBlockedByCostLimiting() {
        return this.smiv.pluginAgentSettings.canBeBlockedByCostLimiting;
    }

    @Override
    public String getProviderId() {
        return "plugin-agent:" + this.desc.getOwnerPluginId();
    }

    public static class PluginPasswordFinder {
        @Autowired
        private PluginParameterSetsService pluginParameterSetsService;
        @Autowired
        private IPluginsRegistryService pluginsService;
        List<InstalledPluginDesc> pluginDescs;

        public PluginPasswordFinder() {
            SpringUtils.getInstance().autowire((Object)this);
            this.pluginDescs = this.pluginsService.getLoadedPlugins().stream().toList();
        }

        public Set<String> findPasswordParams(List<ParamDesc> params) {
            if (params == null) {
                return new HashSet<String>();
            }
            HashSet<String> passwordParams = new HashSet<String>();
            for (ParamDesc d : params) {
                switch (d.type) {
                    case PASSWORD: {
                        passwordParams.add(d.name);
                        break;
                    }
                    case OBJECT_LIST: {
                        passwordParams.addAll(this.findPasswordParams(d.subParams));
                        break;
                    }
                    case PRESET: {
                        LoadedParameterSet parameterSetDesc = null;
                        for (InstalledPluginDesc installedPluginDesc : this.pluginDescs) {
                            String elementType = "parameter-set-" + installedPluginDesc.desc.id + "-" + d.parameterSetId;
                            parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(elementType);
                            if (parameterSetDesc == null) continue;
                            break;
                        }
                        if (parameterSetDesc == null) {
                            logger.warn((Object)("Unknown parameter set " + d.parameterSetId + ", passwords won't be redacted in Python logs"));
                            break;
                        }
                        if (parameterSetDesc.desc == null) break;
                        passwordParams.addAll(this.findPasswordParams(parameterSetDesc.desc.params));
                        passwordParams.addAll(this.findPasswordParams(parameterSetDesc.desc.pluginParams));
                    }
                }
            }
            return passwordParams;
        }
    }
}

