/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.anthropic.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.anthropic.api.AnthropicChatQuery;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class AnthropicChatQueryAdapter {
    private AnthropicChatQueryAdapter() {
    }

    public static AnthropicChatQuery adaptForStreaming(String model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) {
        AnthropicChatQuery query = AnthropicChatQueryAdapter.adapt(model, messages, ccs);
        query.stream = true;
        return query;
    }

    public static AnthropicChatQuery adapt(String model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) {
        ccs.maxTokens = model.contains("claude-3-haiku") || model.contains("claude-3-5-haiku") ? Objects.requireNonNullElse(ccs.maxTokens, 4096) : Objects.requireNonNullElse(ccs.maxTokens, 32000);
        AnthropicChatQuery query = AnthropicChatQueryAdapter.adapt(messages, ccs);
        query.model = model;
        return query;
    }

    public static AnthropicChatQuery adapt(List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) {
        AnthropicChatQuery query = new AnthropicChatQuery();
        query.messages = AnthropicChatQueryAdapter.adaptMessages(messages);
        query.system = messages.stream().filter(m -> "system".equals(m.role)).map(LLMClient.ChatMessage::getText).collect(Collectors.joining("\n\n"));
        query.stream = false;
        query.maxTokens = ccs.maxTokens;
        if (ccs.temperature != null) {
            query.temperature = ccs.temperature;
        }
        if (ccs.topK != null) {
            query.topK = ccs.topK;
        }
        if (ccs.topP != null) {
            query.topP = ccs.topP;
        }
        if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
            query.stopSequences = ccs.stopSequences;
        }
        if (ccs.toolChoice != null) {
            query.toolChoice = AnthropicChatQueryAdapter.adapt(ccs.toolChoice);
        }
        if (ccs.tools != null && !ccs.tools.isEmpty()) {
            query.tools = ccs.tools.stream().map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
        }
        if (ccs.reasoningEffort != null) {
            query.thinking = new AnthropicChatQuery.Thinking();
            if (ccs.reasoningEffort.equals((Object)LLMClient.ReasoningEffort.OFF)) {
                query.thinking.type = "disabled";
            } else if (ccs.reasoningEffort.equals((Object)LLMClient.ReasoningEffort.STANDARD)) {
                query.thinking.type = "enabled";
                query.thinking.budgetTokens = 3000;
            } else if (ccs.reasoningEffort.equals((Object)LLMClient.ReasoningEffort.CUSTOM)) {
                if (StringUtils.isEmpty((String)ccs.customReasoningEffort)) {
                    throw new IllegalArgumentException(String.format("Custom reasoning effort cannot be null or empty: %s ", ccs.customReasoningEffort));
                }
                try {
                    int budgetTokens = Integer.parseInt(ccs.customReasoningEffort);
                    query.thinking.type = "enabled";
                    query.thinking.budgetTokens = budgetTokens;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Invalid 'customReasoningEffort' for Anthropic: Expected an integer (number of tokens for reasoning), but received '%s'.", ccs.customReasoningEffort));
                }
            } else {
                throw new IllegalArgumentException(String.format("Unsupported Reasoning Effort for Anthropic: expected OFF, STANDARD or CUSTOM but received %s.", new Object[]{ccs.reasoningEffort}));
            }
        }
        return query;
    }

    private static List<AnthropicChatQuery.Message> adaptMessages(List<LLMClient.ChatMessage> messages) {
        ArrayList<AnthropicChatQuery.Message> result = new ArrayList<AnthropicChatQuery.Message>();
        AnthropicChatQuery.ThinkingMessagePart pendingThinkingMessage = null;
        block12: for (LLMClient.ChatMessage message : messages) {
            switch (message.role) {
                case "memoryFragment": {
                    pendingThinkingMessage = AnthropicChatQueryAdapter.adaptThinkingMessagePart(message);
                    continue block12;
                }
                case "system": {
                    continue block12;
                }
                case "user": {
                    result.add(AnthropicChatQueryAdapter.adaptUserMessage(message));
                    continue block12;
                }
                case "assistant": {
                    result.add(AnthropicChatQueryAdapter.adaptAssistantMessage(message, pendingThinkingMessage));
                    pendingThinkingMessage = null;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unsupported chat message role: " + message.role);
        }
        return result;
    }

    private static AnthropicChatQuery.ThinkingMessagePart adaptThinkingMessagePart(LLMClient.ChatMessage message) {
        AnthropicChatQuery.ThinkingMessagePart pendingThinkingMessage;
        if (message.memoryFragment == null || message.memoryFragment.llmReasoning == null) {
            throw new IllegalArgumentException("Invalid thinking message format : the thinking message is null.");
        }
        try {
            pendingThinkingMessage = (AnthropicChatQuery.ThinkingMessagePart)JSON.parse((JsonElement)message.memoryFragment.llmReasoning, AnthropicChatQuery.ThinkingMessagePart.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid thinking message format %s", message.memoryFragment.llmReasoning));
        }
        return pendingThinkingMessage;
    }

    private static AnthropicChatQuery.Message adaptUserMessage(LLMClient.ChatMessage message) {
        AnthropicChatQuery.Message msg = AnthropicChatQueryAdapter.createBaseMessage(message);
        msg.role = AnthropicChatQuery.MessageRole.user;
        if (message.toolOutputs != null) {
            message.toolOutputs.stream().map(AnthropicChatQueryAdapter::adapt).forEach(msg.content::add);
        }
        return msg;
    }

    private static AnthropicChatQuery.Message adaptAssistantMessage(LLMClient.ChatMessage message, AnthropicChatQuery.ThinkingMessagePart thinkingMessage) {
        AnthropicChatQuery.Message msg = AnthropicChatQueryAdapter.createBaseMessage(message);
        msg.role = AnthropicChatQuery.MessageRole.assistant;
        if (thinkingMessage != null) {
            msg.content.add(0, thinkingMessage);
        }
        if (message.toolCalls != null) {
            message.toolCalls.stream().map(AnthropicChatQueryAdapter::adapt).forEach(msg.content::add);
        }
        return msg;
    }

    private static AnthropicChatQuery.Message createBaseMessage(LLMClient.ChatMessage message) {
        AnthropicChatQuery.Message msg = new AnthropicChatQuery.Message();
        msg.content = new ArrayList<AnthropicChatQuery.MessagePart>();
        if (message.isTextOnly()) {
            String text = message.getText();
            if (text != null) {
                AnthropicChatQuery.TextMessagePart tm = new AnthropicChatQuery.TextMessagePart();
                tm.text = text;
                msg.content.add(tm);
            }
        } else {
            List messageParts = message.parts.stream().map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
            msg.content.addAll(messageParts);
        }
        return msg;
    }

    private static AnthropicChatQuery.MessagePart adapt(LLMClient.ChatMessagePart part) {
        switch (part.type) {
            case TEXT: {
                AnthropicChatQuery.TextMessagePart textPart = new AnthropicChatQuery.TextMessagePart();
                textPart.text = part.text;
                return textPart;
            }
            case IMAGE_INLINE: {
                AnthropicChatQuery.Base64ImageSource source = new AnthropicChatQuery.Base64ImageSource();
                source.type = "base64";
                source.mediaType = part.imageMimeType == null ? "image/jpeg" : part.imageMimeType;
                source.data = part.inlineImage;
                AnthropicChatQuery.ImageMessagePart imagePart = new AnthropicChatQuery.ImageMessagePart();
                imagePart.source = source;
                return imagePart;
            }
            case IMAGE_URI: {
                AnthropicChatQuery.UrlImageSource source = new AnthropicChatQuery.UrlImageSource();
                source.type = "url";
                source.url = part.imageUrl;
                AnthropicChatQuery.ImageMessagePart imagePart = new AnthropicChatQuery.ImageMessagePart();
                imagePart.source = source;
                return imagePart;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported assistant message part type: %s", new Object[]{part.type}));
    }

    private static AnthropicChatQuery.ToolUseMessagePart adapt(LLMClient.AbstractToolCall atc) {
        if (atc instanceof LLMClient.FunctionToolCall) {
            LLMClient.FunctionToolCall ftc = (LLMClient.FunctionToolCall)atc;
            AnthropicChatQuery.ToolUseMessagePart tu = new AnthropicChatQuery.ToolUseMessagePart();
            tu.id = ftc.id;
            tu.name = ftc.function.name;
            tu.input = (JsonObject)JSON.parse((String)ftc.function.arguments, JsonObject.class);
            return tu;
        }
        throw new IllegalArgumentException(String.format("Unknown tool call: %s", atc.getClass().getSimpleName()));
    }

    private static AnthropicChatQuery.ToolResultMessagePart adapt(LLMClient.ToolOutput to) {
        AnthropicChatQuery.ToolResultMessagePart tr = new AnthropicChatQuery.ToolResultMessagePart();
        tr.toolUseId = to.callId;
        tr.content = to.output;
        return tr;
    }

    private static AnthropicChatQuery.ToolChoice adapt(LLMClient.ToolChoice choice) {
        if (choice instanceof LLMClient.NoneToolChoice) {
            throw new IllegalArgumentException("The Anthropic Claude API does not support tool choice: \"none\"");
        }
        if (choice instanceof LLMClient.RequiredToolChoice) {
            AnthropicChatQuery.ToolChoice tc = new AnthropicChatQuery.ToolChoice();
            tc.type = AnthropicChatQuery.ToolChoiceType.any;
            return tc;
        }
        if (choice instanceof LLMClient.AutoToolChoice) {
            AnthropicChatQuery.ToolChoice tc = new AnthropicChatQuery.ToolChoice();
            tc.type = AnthropicChatQuery.ToolChoiceType.auto;
            return tc;
        }
        if (choice instanceof LLMClient.NamedToolChoice) {
            LLMClient.NamedToolChoice ntc = (LLMClient.NamedToolChoice)choice;
            AnthropicChatQuery.ToolChoice tc = new AnthropicChatQuery.ToolChoice();
            tc.type = AnthropicChatQuery.ToolChoiceType.tool;
            tc.name = ntc.name;
            return tc;
        }
        throw new IllegalArgumentException(String.format("Unknown tool choice: %s", choice.getClass().getSimpleName()));
    }

    private static AnthropicChatQuery.Tool adapt(LLMClient.AbstractTool tool) {
        if (tool instanceof LLMClient.FunctionTool) {
            LLMClient.FunctionTool fDesc = (LLMClient.FunctionTool)tool;
            AnthropicChatQuery.Tool t = new AnthropicChatQuery.Tool();
            t.name = fDesc.function.name;
            t.description = fDesc.function.description;
            t.inputSchema = fDesc.function.getParameters();
            return t;
        }
        throw new IllegalArgumentException(String.format("Unknown tool: %s", tool.getClass().getSimpleName()));
    }
}

