/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.mistralai.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.mistralai.api.MistralAIChatResponse;
import com.dataiku.dip.utils.DKULogger;
import java.util.stream.Collectors;

public class MistralAIChatResponseAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.mistralai.api");

    private MistralAIChatResponseAdapter() {
    }

    public static LLMClient.SimpleCompletionResponse adapt(MistralAIChatResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty chat response");
        }
        if (response.choices.size() > 1) {
            logger.warn((Object)String.format("The chat response contains %d choices, only using the first one", response.choices.size()));
        }
        MistralAIChatResponse.Choice choice = response.choices.get(0);
        LLMClient.SimpleCompletionResponse resp = new LLMClient.SimpleCompletionResponse();
        resp.text = choice.message.content;
        resp.finishReason = FinishReasonResponseAdapter.adapt(choice.finishReason);
        if (response.usage != null) {
            resp.promptTokens = response.usage.promptTokens;
            resp.completionTokens = response.usage.completionTokens;
        }
        if (choice.message.toolCalls != null && !choice.message.toolCalls.isEmpty()) {
            resp.toolCalls = choice.message.toolCalls.stream().map(MistralAIChatResponseAdapter::adapt).collect(Collectors.toList());
        }
        return resp;
    }

    static LLMClient.AbstractToolCall adapt(MistralAIChatResponse.ToolCall tc) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = tc.function.name;
        function.arguments = tc.function.arguments;
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.id = tc.id;
        ftc.function = function;
        return ftc;
    }
}

