/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api.responses;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class OpenAIResponsesQuery {
    @SerializedName(value="model")
    public String model;
    @Nullable
    @SerializedName(value="store")
    public Boolean store;
    @SerializedName(value="input")
    public List<Input> input = new ArrayList<Input>();
    @SerializedName(value="include")
    public List<String> include = new ArrayList<String>();
    @SerializedName(value="tools")
    public List<ToolSchema> tools = new ArrayList<ToolSchema>();
    @Nullable
    @SerializedName(value="tool_choice")
    public ToolChoice toolChoice;
    @Nullable
    @SerializedName(value="stream")
    public Boolean stream;
    @Nullable
    @SerializedName(value="max_output_tokens")
    public Integer maxOutputTokens;
    @Nullable
    @SerializedName(value="temperature")
    public Double temperature;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    @Nullable
    @SerializedName(value="text")
    public Text text;
    @Nullable
    @SerializedName(value="top_logprobs")
    public Integer topLogProbs;
    @Nullable
    public Reasoning reasoning;

    public static class FunctionToolDesc {
        public String name;
        @Nullable
        public String description;
        @Nullable
        public JsonObject parameters;
    }

    public static class FunctionTool {
        public final String type = "function";
        public FunctionToolDesc function;
    }

    public static class ToolChoiceFunction {
        public String name;
    }

    public static class EnforcedToolChoice
    implements ToolChoice {
        public final String type = "function";
        @SerializedName(value="name")
        public String functionName;
    }

    public static class ToolSchema {
        public String type;
        public String name;
        public String description;
        public JsonElement parameters;
    }

    public static class ToolCallOuput
    extends Input {
        public String type = "function_call_output";
        @SerializedName(value="call_id")
        public String callId;
        public String output;
    }

    public static class ToolCallMessage
    extends Input {
        public String type = "function_call";
        @SerializedName(value="call_id")
        public String callId;
        public String name;
        public String arguments;
    }

    public static class InputImageMessage
    extends MessageContent {
        public String type = "input_image";
        @SerializedName(value="image_url")
        public String imageUrl;
    }

    public static class InputTextMessage
    extends MessageContent {
        public String type = "input_text";
        @SerializedName(value="text")
        public String text;
    }

    public static class MessageContent {
    }

    public static class ReasoningSummaryMessage
    extends Message {
        public String type;
        public String text;
    }

    public static class ReasoningMessage
    extends Message {
        public final String type = "reasoning";
        @SerializedName(value="encrypted_content")
        public String encryptedContent;
        public List<ReasoningSummaryMessage> summary = new ArrayList<ReasoningSummaryMessage>();
    }

    public static class AssistantMessage
    extends Message {
        public final String role = "assistant";
        @Nullable
        public String content;
    }

    public static class CompositeUserMessage
    extends Message {
        public final String role = "user";
        public List<MessageContent> content;
    }

    public static class UserMessage
    extends Message {
        public final String role = "user";
        public String content;
    }

    public static class SystemMessage
    extends Message {
        public final String role = "system";
        public String content;
    }

    public static class Message
    extends Input {
    }

    public static class Input {
    }

    public static class OpenAIResponseFormatJSONSchema
    extends OpenAIResponseFormat {
        @Nullable
        public String description;
        public String name;
        public JsonObject schema;
        @Nullable
        public Boolean strict;
    }

    public static class OpenAIResponseFormatJSONObject
    extends OpenAIResponseFormat {
    }

    public static class OpenAIResponseFormatText
    extends OpenAIResponseFormat {
    }

    @PolyJSON(value={@Mapping(type="text", value=OpenAIResponseFormatText.class), @Mapping(type="json_object", value=OpenAIResponseFormatJSONObject.class), @Mapping(type="json_schema", value=OpenAIResponseFormatJSONSchema.class)})
    public static abstract class OpenAIResponseFormat {
    }

    public static class Text {
        @SerializedName(value="format")
        public OpenAIResponseFormat responseFormat;
    }

    public static interface ToolChoice {
    }

    public static enum ConstantToolChoice implements ToolChoice
    {
        none,
        auto,
        any,
        required;

    }

    public static class Reasoning {
        public String summary;
        public String effort;
    }
}

