/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api.responses;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.openai.api.responses.OpenAIResponsesResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class OpenAIResponsesResponseAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.openai.api");

    @Nullable
    public static String getRefusal(OpenAIResponsesResponse response) {
        if (response == null || response.output == null || response.output.isEmpty()) {
            return null;
        }
        return response.output.stream().filter(item -> item.type.equals("message")).flatMap(message -> message.content.stream()).filter(part -> part.type.equals("refusal")).findFirst().map(part -> part.refusal).orElse(null);
    }

    public static LLMClient.SimpleCompletionResponse adapt(OpenAIResponsesResponse response) {
        LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
        for (OpenAIResponsesResponse.OutputItem outputItem : response.output) {
            if (outputItem.type.equals("message")) {
                if (outputItem.role.equals("assistant")) {
                    OpenAIResponsesResponseAdapter.adaptMessage(outputItem, ret);
                    continue;
                }
                logger.info((Object)("Unrecognized message role for output item: " + outputItem.type));
                continue;
            }
            if (outputItem.type.equals("function_call")) {
                if (ret.toolCalls == null) {
                    ret.toolCalls = new ArrayList<LLMClient.AbstractToolCall>();
                }
                ret.toolCalls.add(OpenAIResponsesResponseAdapter.adaptFunctionCall(outputItem));
                continue;
            }
            if (outputItem.type.equals("reasoning")) {
                LLMClient.Artifact reasoning = new LLMClient.Artifact();
                reasoning.type = "REASONING";
                for (OpenAIResponsesResponse.MessageContentPart part : outputItem.reasoningSummary) {
                    if (part.text.isEmpty()) continue;
                    LLMClient.SourceItem sourceItem = new LLMClient.SourceItem();
                    sourceItem.type = "TEXT";
                    sourceItem.text = part.text;
                    reasoning.parts.add(sourceItem);
                }
                if (!reasoning.parts.isEmpty()) {
                    if (ret.artifacts == null) {
                        ret.artifacts = new ArrayList<LLMClient.Artifact>();
                    }
                    ret.artifacts.add(reasoning);
                }
                if (!StringUtils.isNotEmpty((String)outputItem.encryptedContent)) continue;
                ret.memoryFragment = new LLMClient.MemoryFragment();
                ret.memoryFragment.llmReasoning = JSON.toJsonObject((Object)outputItem, (String[])new String[0]);
                continue;
            }
            logger.info((Object)("Unrecognized output item type: " + outputItem.type));
        }
        ret.finishReason = OpenAIResponsesResponseAdapter.adaptFinishReason(response);
        ret.promptTokens = response.usage.inputTokens;
        ret.completionTokens = response.usage.outputTokens;
        ret.totalTokens = response.usage.totalTokens;
        return ret;
    }

    static LLMClient.FinishReason adaptFinishReason(OpenAIResponsesResponse response) {
        if (response.status.equals("incomplete") && response.incompleteDetails != null && response.incompleteDetails.reason.equals("max_output_tokens")) {
            return LLMClient.FinishReason.LENGTH;
        }
        if (response.output.stream().anyMatch(item -> item.type.equals("function_call"))) {
            return LLMClient.FinishReason.TOOL_CALLS;
        }
        if (response.status.equals("completed") && response.output.stream().anyMatch(item -> item.type.equals("message") && item.role.equals("assistant"))) {
            return LLMClient.FinishReason.STOP;
        }
        return LLMClient.FinishReason.UNKNOWN;
    }

    private static @NotNull LLMClient.FunctionToolCall adaptFunctionCall(OpenAIResponsesResponse.OutputItem outputItem) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = outputItem.name;
        function.arguments = outputItem.arguments.getAsString();
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.id = outputItem.call_id;
        ftc.function = function;
        return ftc;
    }

    private static void adaptMessage(OpenAIResponsesResponse.OutputItem messageItem, LLMClient.SimpleCompletionResponse ret) {
        Object text = "";
        for (OpenAIResponsesResponse.MessageContentPart part : messageItem.content) {
            if (!part.type.equals("output_text")) continue;
            text = (String)text + part.text + "\n\n";
            if (part.logprobs == null || part.logprobs.isEmpty()) continue;
            if (ret.logProbs == null) {
                ret.logProbs = new ArrayList<LLMClient.DetailedLogProb>();
            }
            ret.logProbs.addAll(part.logprobs.stream().filter(lp -> lp != null).map(OpenAIResponsesResponseAdapter::adapt).collect(Collectors.toList()));
        }
        ret.text = ((String)text).trim();
    }

    static LLMClient.DetailedLogProb adapt(OpenAIResponsesResponse.LogProbContent lpc) {
        LLMClient.DetailedLogProb dlp = new LLMClient.DetailedLogProb();
        dlp.token = lpc.token;
        dlp.logProb = lpc.logProb;
        dlp.topLogProbs = lpc.topLogProbs.stream().map(OpenAIResponsesResponseAdapter::adapt).collect(Collectors.toList());
        return dlp;
    }

    private static LLMClient.SimpleLogProb adapt(OpenAIResponsesResponse.TopLogProbContent tlpc) {
        LLMClient.SimpleLogProb slp = new LLMClient.SimpleLogProb();
        slp.token = tlpc.token;
        slp.logProb = tlpc.logProb;
        return slp;
    }
}

