/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class CleanTemporaryFilesTask
implements Job {
    public static final long MAX_AGE = 172800000L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.maint.tmp");

    public CleanTemporaryFilesTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        DKULogger.startCurrentCall();
        try {
            this.cleanOldDirectories(ApplicationConfigurator.getFile((String[])new String[]{"uploads", "tmp_upload_box"}), "temporary upload box");
            this.cleanOldDirectories(ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-import"}), "project-imports");
            this.cleanOldFiles(ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-export"}), "project-exports");
            this.cleanOldFiles(ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-duplicate"}), "project-duplicate");
            this.cleanOldFiles(ApplicationConfigurator.getFile((String[])new String[]{"tmp", "poi-files"}), "poi-files");
        }
        catch (Exception e) {
            throw new JobExecutionException("Clearing temporary files failed", (Throwable)e);
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }

    private void cleanOldFiles(File temporaryDirectory, String directoryContext) throws IOException {
        logger.info((Object)("Clearing " + directoryContext));
        if (temporaryDirectory.isDirectory()) {
            for (File file : Objects.requireNonNull(temporaryDirectory.listFiles())) {
                if (System.currentTimeMillis() - file.lastModified() <= 172800000L) continue;
                logger.info((Object)("Removing " + String.valueOf(file)));
                DKUFileUtils.forceDelete((File)file);
            }
        }
        logger.info((Object)("Done clearing " + directoryContext));
    }

    private void cleanOldDirectories(File temporaryDirectory, String fileContext) throws IOException {
        logger.info((Object)("Clearing " + fileContext));
        if (temporaryDirectory.isDirectory()) {
            for (File file : Objects.requireNonNull(temporaryDirectory.listFiles())) {
                if (!file.isDirectory() || System.currentTimeMillis() - file.lastModified() <= 172800000L) continue;
                logger.info((Object)("Removing " + String.valueOf(file)));
                DKUFileUtils.forceDelete((File)file);
            }
        }
        logger.info((Object)("Done clearing " + fileContext));
    }
}

